/********************************************************************************
 *                               libemu
 *
 *                    - x86 shellcode emulation -
 *
 *
 * Copyright (C) 2007  Paul Baecher & Markus Koetter
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * 
 *             contact nepenthesdev@users.sourceforge.net  
 *
 *******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include <emu/emu.h>
#include <emu/environment/win32/emu_env_w32_dll_export.h>
#include <emu/environment/win32/env_w32_dll_export_kernel32_hooks.h>
#include <emu/environment/win32/env_w32_dll_export_urlmon_hooks.h>
#include <emu/environment/win32/env_w32_dll_export_ws2_32_hooks.h>
#include <emu/environment/win32/env_w32_dll_export_msvcrt_hooks.h>
#include <emu/environment/win32/env_w32_dll_export_shell32_hooks.h>
#include <emu/environment/win32/env_w32_dll_export_shdocvw_hooks.h>
// Added by T.OkamotoLab.
#include <emu/environment/win32/env_w32_dll_export_advapi32_hooks.h>
#include <emu/environment/win32/env_w32_dll_export_hnetcfg_hooks.h>
#include <emu/environment/win32/env_w32_dll_export_ole32_hooks.h>
#include <emu/environment/win32/env_w32_dll_export_user32_hooks.h>

struct emu_env_w32_dll_export kernel32_exports[] = 
{
	{"ActivateActCtx", 0x0000A644, NULL, NULL},
	{"AddAtomA", 0x000354ED, NULL, NULL},
	{"AddAtomW", 0x000326C1, NULL, NULL},
	{"AddConsoleAliasA", 0x00070CBF, NULL, NULL},
	{"AddConsoleAliasW", 0x00070C81, NULL, NULL},
	{"AddLocalAlternateComputerNameA", 0x00058F26, NULL, NULL},
	{"AddLocalAlternateComputerNameW", 0x00058E0A, NULL, NULL},
	{"AddRefActCtx", 0x0002BF01, NULL, NULL},
	{"AddVectoredExceptionHandler", 0x00008F63, NULL, NULL},
	{"AllocConsole", 0x00071311, NULL, NULL},
	{"AllocateUserPhysicalPages", 0x0005E712, NULL, NULL},
	{"AreFileApisANSI", 0x0003594F, NULL, NULL},
	{"AssignProcessToJobObject", 0x0002E44A, NULL, NULL},
	{"AttachConsole", 0x000714F9, NULL, NULL},
	{"BackupRead", 0x00056DDF, NULL, NULL},
	{"BackupSeek", 0x00055EEF, NULL, NULL},
	{"BackupWrite", 0x000573FE, NULL, NULL},
	{"BaseCheckAppcompatCache", 0x000167D7, NULL, NULL},
	{"BaseCleanupAppcompatCache", 0x0006BE06, NULL, NULL},
	{"BaseCleanupAppcompatCacheSupport", 0x0006BE8A, NULL, NULL},
	{"BaseDumpAppcompatCache", 0x0006BCC1, NULL, NULL},
	{"BaseFlushAppcompatCache", 0x0006BC3F, NULL, NULL},
	{"BaseInitAppcompatCache", 0x000164CD, NULL, NULL},
	{"BaseInitAppcompatCacheSupport", 0x0002B38D, NULL, NULL},
	{"BaseProcessInitPostImport", 0x00017443, NULL, NULL},
	{"BaseQueryModuleData", 0x0003835A, NULL, NULL},
	{"BaseUpdateAppcompatCache", 0x00015120, NULL, NULL},
	{"BasepCheckWinSaferRestrictions", 0x00019805, NULL, NULL},
	{"Beep", 0x00037A77, NULL, NULL},
	{"BeginUpdateResourceA", 0x0006FC7B, NULL, NULL},
	{"BeginUpdateResourceW", 0x0006FAD8, NULL, NULL},
	{"BindIoCompletionCallback", 0x0002C02C, NULL, NULL},
	{"BuildCommDCBA", 0x0006AEED, NULL, NULL},
	{"BuildCommDCBAndTimeoutsA", 0x0006AEBF, NULL, NULL},
	{"BuildCommDCBAndTimeoutsW", 0x0006AF1F, NULL, NULL},
	{"BuildCommDCBW", 0x0006AF79, NULL, NULL},
	{"CallNamedPipeA", 0x0005FDCE, NULL, NULL},
	{"CallNamedPipeW", 0x0005FB7F, NULL, NULL},
	{"CancelDeviceWakeupRequest", 0x00060B97, NULL, NULL},
	{"CancelIo", 0x000300DA, NULL, NULL},
	{"CancelTimerQueueTimer", 0x00062DF0, NULL, NULL},
	{"CancelWaitableTimer", 0x0002CC09, NULL, NULL},
	{"ChangeTimerQueueTimer", 0x00012723, NULL, NULL},
	{"CheckNameLegalDOS8Dot3A", 0x00060A51, NULL, NULL},
	{"CheckNameLegalDOS8Dot3W", 0x00060811, NULL, NULL},
	{"CheckRemoteDebuggerPresent", 0x00059B1E, NULL, NULL},
	{"ClearCommBreak", 0x00066CF1, NULL, NULL},
	{"ClearCommError", 0x0006557C, NULL, NULL},
	{"CloseConsoleHandle", 0x0001DC7E, NULL, NULL},
	{"CloseHandle", 0x00009B47, env_w32_hook_CloseHandle, NULL},
	{"CloseProfileUserMapping", 0x0002C86D, NULL, NULL},
	{"CmdBatNotification", 0x0002F609, NULL, NULL},
	{"CommConfigDialogA", 0x00066871, NULL, NULL},
	{"CommConfigDialogW", 0x0006677D, NULL, NULL},
	{"CompareFileTime", 0x00010AD9, NULL, NULL},
	{"CompareStringA", 0x0000D077, NULL, NULL},
	{"CompareStringW", 0x0000A35E, NULL, NULL},
	{"ConnectNamedPipe", 0x0003145B, NULL, NULL},
	{"ConsoleMenuControl", 0x00071FBF, NULL, NULL},
	{"ContinueDebugEvent", 0x0005A565, NULL, NULL},
	{"ConvertDefaultLocale", 0x000383CF, NULL, NULL},
	{"ConvertFiberToThread", 0x0002FED7, NULL, NULL},
	{"ConvertThreadToFiber", 0x0002FF16, NULL, NULL},
	{"CopyFileA", 0x000286EE, NULL, NULL},
	{"CopyFileExA", 0x0005E3C4, NULL, NULL},
	{"CopyFileExW", 0x00027B32, NULL, NULL},
	{"CopyFileW", 0x0002F873, NULL, NULL},
	{"CopyLZFile", 0x000593AE, NULL, NULL},
	{"CreateActCtxA", 0x0006B7A5, NULL, NULL},
	{"CreateActCtxW", 0x0001545C, NULL, NULL},
	{"CreateConsoleScreenBuffer", 0x00073068, NULL, NULL},
	{"CreateDirectoryA", 0x000217AC, NULL, NULL},
	{"CreateDirectoryExA", 0x0005B23B, NULL, NULL},
	{"CreateDirectoryExW", 0x0005A5F2, NULL, NULL},
	{"CreateDirectoryW", 0x000323D2, NULL, NULL},
	{"CreateEventA", 0x000308AD, NULL, NULL},
	{"CreateEventW", 0x0000A6A9, NULL, NULL},
	{"CreateFiber", 0x0002FFAF, NULL, NULL},
	{"CreateFiberEx", 0x0002FFCF, NULL, NULL},
	{"CreateFileA", 0x00001A24, env_w32_hook_CreateFileA, NULL},
	{"CreateFileMappingA", 0x0000945C, env_w32_hook_CreateFileMapping, NULL},
	{"CreateFileMappingW", 0x0000938E, NULL, NULL},
	{"CreateFileW", 0x00010760, NULL, NULL},
	{"CreateHardLinkA", 0x0006B629, NULL, NULL},
	{"CreateHardLinkW", 0x0006B46C, NULL, NULL},
	{"CreateIoCompletionPort", 0x00031385, NULL, NULL},
	{"CreateJobObjectA", 0x0006B38C, NULL, NULL},
	{"CreateJobObjectW", 0x0002CB03, NULL, NULL},
	{"CreateJobSet", 0x0006B35E, NULL, NULL},
	{"CreateMailslotA", 0x0002CC8B, NULL, NULL},
	{"CreateMailslotW", 0x0002CCDC, NULL, NULL},
	{"CreateMemoryResourceNotification", 0x0003965A, NULL, NULL},
	{"CreateMutexA", 0x0000E93F, NULL, NULL},
	{"CreateMutexW", 0x0000E8B7, NULL, NULL},
	{"CreateNamedPipeA", 0x0005FC74, NULL, NULL},
	{"CreateNamedPipeW", 0x0002F0D4, NULL, NULL},
	{"CreateNlsSecurityDescriptor", 0x0002AC6C, NULL, NULL},
	{"CreatePipe", 0x0001E0C7, NULL, NULL},
	{"CreateProcessA", 0x00002367, env_w32_hook_CreateProcessA, NULL},
	{"CreateProcessInternalA", 0x0001DDD6, env_w32_hook_CreateProcessInternalA, NULL},
	{"CreateProcessInternalW", 0x00019513, NULL, NULL},
	{"CreateProcessInternalWSecure", 0x0007F1FC, NULL, NULL},
	{"CreateProcessW", 0x00002332, NULL, NULL},
	{"CreateRemoteThread", 0x0001042C, NULL, NULL},
	{"CreateSemaphoreA", 0x00012E1D, NULL, NULL},
	{"CreateSemaphoreW", 0x00010086, NULL, NULL},
	{"CreateSocketHandle", 0x0006B694, NULL, NULL},
	{"CreateTapePartition", 0x0006B14E, NULL, NULL},
	{"CreateThread", 0x00010637, NULL, NULL},
	{"CreateTimerQueue", 0x0002BFD6, NULL, NULL},
	{"CreateTimerQueueTimer", 0x0002117D, NULL, NULL},
	{"CreateToolhelp32Snapshot", 0x00064B47, NULL, NULL},
	{"CreateVirtualBuffer", 0x00034932, NULL, NULL},
	{"CreateWaitableTimerA", 0x00061A81, NULL, NULL},
	{"CreateWaitableTimerW", 0x0002FB52, NULL, NULL},
	{"DeactivateActCtx", 0x0000A675, NULL, NULL},
	{"DebugActiveProcess", 0x0005A123, NULL, NULL},
	{"DebugActiveProcessStop", 0x0005A5A9, NULL, NULL},
	{"DebugBreak", 0x00059B72, NULL, NULL},
	{"DebugBreakProcess", 0x0005A176, NULL, NULL},
	{"DebugSetProcessKillOnExit", 0x0005A19D, NULL, NULL},
	{"DecodePointer", 0x00008F88, NULL, NULL},
	{"DecodeSystemPointer", 0x00008F9F, NULL, NULL},
	{"DefineDosDeviceA", 0x0005C2C5, NULL, NULL},
	{"DefineDosDeviceW", 0x00021F1E, NULL, NULL},
	{"DelayLoadFailureHook", 0x0007DEAD, NULL, NULL},
	{"DeleteAtom", 0x00032695, NULL, NULL},
	{"DeleteCriticalSection", 0x00008FBC, NULL, NULL},
	{"DeleteFiber", 0x0002FE84, NULL, NULL},
	{"DeleteFileA", 0x00031EAB, env_w32_hook_DeleteFileA },
	{"DeleteFileW", 0x00031F31, NULL, NULL},
	{"DeleteTimerQueue", 0x00062DC3, NULL, NULL},
	{"DeleteTimerQueueEx", 0x00062D7C, NULL, NULL},
	{"DeleteTimerQueueTimer", 0x00021130, NULL, NULL},
	{"DeleteVolumeMountPointA", 0x0006A0DE, NULL, NULL},
	{"DeleteVolumeMountPointW", 0x00069930, NULL, NULL},
	{"DeviceIoControl", 0x00001625, NULL, NULL},
	{"DisableThreadLibraryCalls", 0x00011296, NULL, NULL},
	{"DisconnectNamedPipe", 0x0001269F, NULL, NULL},
	{"DnsHostnameToComputerNameA", 0x000585CF, NULL, NULL},
	{"DnsHostnameToComputerNameW", 0x0002CEB2, NULL, NULL},
	{"DosDateTimeToFileTime", 0x0003214E, NULL, NULL},
	{"DosPathToSessionPathA", 0x00061799, NULL, NULL},
	{"DosPathToSessionPathW", 0x0002C1E7, NULL, NULL},
	{"DuplicateConsoleHandle", 0x0001DD4D, NULL, NULL},
	{"DuplicateHandle", 0x0000DDFE, NULL, NULL},
	{"EncodePointer", 0x00008FDB, NULL, NULL},
	{"EncodeSystemPointer", 0x00008FF2, NULL, NULL},
	{"EndUpdateResourceA", 0x0006F949, NULL, NULL},
	{"EndUpdateResourceW", 0x0006F774, NULL, NULL},
	{"EnterCriticalSection", 0x0000900F, NULL, NULL},
	{"EnumCalendarInfoA", 0x00038211, NULL, NULL},
	{"EnumCalendarInfoExA", 0x00075749, NULL, NULL},
	{"EnumCalendarInfoExW", 0x0007877D, NULL, NULL},
	{"EnumCalendarInfoW", 0x0007875A, NULL, NULL},
	{"EnumDateFormatsA", 0x0007578A, NULL, NULL},
	{"EnumDateFormatsExA", 0x000757AA, NULL, NULL},
	{"EnumDateFormatsExW", 0x000787A0, NULL, NULL},
	{"EnumDateFormatsW", 0x000387E1, NULL, NULL},
	{"EnumLanguageGroupLocalesA", 0x000757E8, NULL, NULL},
	{"EnumLanguageGroupLocalesW", 0x00078703, NULL, NULL},
	{"EnumResourceLanguagesA", 0x0002E000, NULL, NULL},
	{"EnumResourceLanguagesW", 0x0005F631, NULL, NULL},
	{"EnumResourceNamesA", 0x0005F229, NULL, NULL},
	{"EnumResourceNamesW", 0x00055709, NULL, NULL},
	{"EnumResourceTypesA", 0x0005F03C, NULL, NULL},
	{"EnumResourceTypesW", 0x0005F449, NULL, NULL},
	{"EnumSystemCodePagesA", 0x00075827, NULL, NULL},
	{"EnumSystemCodePagesW", 0x0007873F, NULL, NULL},
	{"EnumSystemGeoID", 0x00078BD9, NULL, NULL},
	{"EnumSystemLanguageGroupsA", 0x000757CA, NULL, NULL},
	{"EnumSystemLanguageGroupsW", 0x000786E5, NULL, NULL},
	{"EnumSystemLocalesA", 0x00037CE1, NULL, NULL},
	{"EnumSystemLocalesW", 0x00078724, NULL, NULL},
	{"EnumTimeFormatsA", 0x0007576C, NULL, NULL},
	{"EnumTimeFormatsW", 0x000388BE, NULL, NULL},
	{"EnumUILanguagesA", 0x00075809, NULL, NULL},
	{"EnumUILanguagesW", 0x0002A8DC, NULL, NULL},
	{"EnumerateLocalComputerNamesA", 0x00058523, NULL, NULL},
	{"EnumerateLocalComputerNamesW", 0x000583A3, NULL, NULL},
	{"EraseTape", 0x0006B11B, NULL, NULL},
	{"EscapeCommFunction", 0x0006578E, NULL, NULL},
	{"ExitProcess", 0x0001CDDA, env_w32_hook_ExitProcess, NULL},
	{"ExitThread", 0x0000C058, env_w32_hook_ExitThread, NULL},
	{"ExitVDM", 0x00067695, NULL, NULL},
	{"ExpandEnvironmentStringsA", 0x000329D9, NULL, NULL},
	{"ExpandEnvironmentStringsW", 0x000305F6, NULL, NULL},
	{"ExpungeConsoleCommandHistoryA", 0x00070627, NULL, NULL},
	{"ExpungeConsoleCommandHistoryW", 0x0007060F, NULL, NULL},
	{"ExtendVirtualBuffer", 0x0005EBF4, NULL, NULL},
	{"FatalAppExitA", 0x00060CF8, NULL, NULL},
	{"FatalAppExitW", 0x00060CAA, NULL, NULL},
	{"FatalExit", 0x00060D46, NULL, NULL},
	{"FileTimeToDosDateTime", 0x0003065D, NULL, NULL},
	{"FileTimeToLocalFileTime", 0x0000E866, NULL, NULL},
	{"FileTimeToSystemTime", 0x0000E7EC, NULL, NULL},
	{"FillConsoleOutputAttribute", 0x00073044, NULL, NULL},
	{"FillConsoleOutputCharacterA", 0x00072FF9, NULL, NULL},
	{"FillConsoleOutputCharacterW", 0x00073020, NULL, NULL},
	{"FindActCtxSectionGuid", 0x00030F21, NULL, NULL},
	{"FindActCtxSectionStringA", 0x0006BB0F, NULL, NULL},
	{"FindActCtxSectionStringW", 0x0002FD4C, NULL, NULL},
	{"FindAtomA", 0x00030CFE, NULL, NULL},
	{"FindAtomW", 0x0002F827, NULL, NULL},
	{"FindClose", 0x0000EDD7, NULL, NULL},
	{"FindCloseChangeNotification", 0x000357D5, NULL, NULL},
	{"FindFirstChangeNotificationA", 0x0005C4AB, NULL, NULL},
	{"FindFirstChangeNotificationW", 0x00034BEF, NULL, NULL},
	{"FindFirstFileA", 0x000137D9, NULL, NULL},
	{"FindFirstFileExA", 0x0005C512, NULL, NULL},
	{"FindFirstFileExW", 0x0000EA7D, NULL, NULL},
	{"FindFirstFileW", 0x0000EEE1, NULL, NULL},
	{"FindFirstVolumeA", 0x0006A259, NULL, NULL},
	{"FindFirstVolumeMountPointA", 0x00069D19, NULL, NULL},
	{"FindFirstVolumeMountPointW", 0x00068DB1, NULL, NULL},
	{"FindFirstVolumeW", 0x0002D2AF, NULL, NULL},
	{"FindNextChangeNotification", 0x00032113, NULL, NULL},
	{"FindNextFileA", 0x00034EB1, NULL, NULL},
	{"FindNextFileW", 0x0000EF3A, NULL, NULL},
	{"FindNextVolumeA", 0x00069BFF, NULL, NULL},
	{"FindNextVolumeMountPointA", 0x00069E49, NULL, NULL},
	{"FindNextVolumeMountPointW", 0x0006905D, NULL, NULL},
	{"FindNextVolumeW", 0x0002CF9B, NULL, NULL},
	{"FindResourceA", 0x0000BE89, NULL, NULL},
	{"FindResourceExA", 0x00035F78, NULL, NULL},
	{"FindResourceExW", 0x0000AC88, NULL, NULL},
	{"FindResourceW", 0x0000BBCE, NULL, NULL},
	{"FindVolumeClose", 0x0002CF60, NULL, NULL},
	{"FindVolumeMountPointClose", 0x000357D5, NULL, NULL},
	{"FlushConsoleInputBuffer", 0x00073B1C, NULL, NULL},
	{"FlushFileBuffers", 0x00012641, NULL, NULL},
	{"FlushInstructionCache", 0x000355BC, NULL, NULL},
	{"FlushViewOfFile", 0x00035971, NULL, NULL},
	{"FoldStringA", 0x00075EB1, NULL, NULL},
	{"FoldStringW", 0x00079636, NULL, NULL},
	{"FormatMessageA", 0x0002F7A0, NULL, NULL},
	{"FormatMessageW", 0x00034B8F, NULL, NULL},
	{"FreeConsole", 0x0007108D, NULL, NULL},
	{"FreeEnvironmentStringsA", 0x0001DF77, NULL, NULL},
	{"FreeEnvironmentStringsW", 0x00014AE7, NULL, NULL},
	{"FreeLibrary", 0x0000ABDE, NULL, NULL},
	{"FreeLibraryAndExitThread", 0x0000C170, NULL, NULL},
	{"FreeResource", 0x000260C2, NULL, NULL},
	{"FreeUserPhysicalPages", 0x0005E740, NULL, NULL},
	{"FreeVirtualBuffer", 0x00034B69, NULL, NULL},
	{"GenerateConsoleCtrlEvent", 0x00073A21, NULL, NULL},
	{"GetACP", 0x00009915, NULL, NULL},
	{"GetAtomNameA", 0x0005B2AB, NULL, NULL},
	{"GetAtomNameW", 0x000330E7, NULL, NULL},
	{"GetBinaryType", 0x0006802B, NULL, NULL},
	{"GetBinaryTypeA", 0x0006802B, NULL, NULL},
	{"GetBinaryTypeW", 0x00067BCC, NULL, NULL},
	{"GetCPFileNameFromRegistry", 0x000384DB, NULL, NULL},
	{"GetCPInfo", 0x00012E76, NULL, NULL},
	{"GetCPInfoExA", 0x00076047, NULL, NULL},
	{"GetCPInfoExW", 0x0007A1CD, NULL, NULL},
	{"GetCalendarInfoA", 0x0007596B, NULL, NULL},
	{"GetCalendarInfoW", 0x00039020, NULL, NULL},
	{"GetComPlusPackageInstallStatus", 0x0006BBA2, NULL, NULL},
	{"GetCommConfig", 0x00066D09, NULL, NULL},
	{"GetCommMask", 0x0006588A, NULL, NULL},
	{"GetCommModemStatus", 0x00065913, NULL, NULL},
	{"GetCommProperties", 0x0006599C, NULL, NULL},
	{"GetCommState", 0x00065A54, NULL, NULL},
	{"GetCommTimeouts", 0x00022128, NULL, NULL},
	{"GetCommandLineA", 0x00012F1D, NULL, NULL},
	{"GetCommandLineW", 0x00016F83, NULL, NULL},
	{"GetCompressedFileSizeA", 0x0005D499, NULL, NULL},
	{"GetCompressedFileSizeW", 0x0005D371, NULL, NULL},
	{"GetComputerNameA", 0x000216A4, NULL, NULL},
	{"GetComputerNameExA", 0x000582A7, NULL, NULL},
	{"GetComputerNameExW", 0x000201F1, NULL, NULL},
	{"GetComputerNameW", 0x000316C7, NULL, NULL},
	{"GetConsoleAliasA", 0x000700B2, NULL, NULL},
	{"GetConsoleAliasExesA", 0x0007054C, NULL, NULL},
	{"GetConsoleAliasExesLengthA", 0x00070252, NULL, NULL},
	{"GetConsoleAliasExesLengthW", 0x00070245, NULL, NULL},
	{"GetConsoleAliasExesW", 0x00070531, NULL, NULL},
	{"GetConsoleAliasW", 0x00070086, NULL, NULL},
	{"GetConsoleAliasesA", 0x000703E7, NULL, NULL},
	{"GetConsoleAliasesLengthA", 0x000701B9, NULL, NULL},
	{"GetConsoleAliasesLengthW", 0x000701A1, NULL, NULL},
	{"GetConsoleAliasesW", 0x000703C9, NULL, NULL},
	{"GetConsoleCP", 0x000740D3, NULL, NULL},
	{"GetConsoleCharType", 0x000751A3, NULL, NULL},
	{"GetConsoleCommandHistoryA", 0x000709A7, NULL, NULL},
	{"GetConsoleCommandHistoryLengthA", 0x00070805, NULL, NULL},
	{"GetConsoleCommandHistoryLengthW", 0x000707ED, NULL, NULL},
	{"GetConsoleCommandHistoryW", 0x00070989, NULL, NULL},
	{"GetConsoleCursorInfo", 0x00073561, NULL, NULL},
	{"GetConsoleCursorMode", 0x000747FF, NULL, NULL},
	{"GetConsoleDisplayMode", 0x00037C53, NULL, NULL},
	{"GetConsoleFontInfo", 0x00073799, NULL, NULL},
	{"GetConsoleFontSize", 0x000738C1, NULL, NULL},
	{"GetConsoleHardwareState", 0x00071C19, NULL, NULL},
	{"GetConsoleInputExeNameA", 0x00070CFC, NULL, NULL},
	{"GetConsoleInputExeNameW", 0x00070AD1, NULL, NULL},
	{"GetConsoleInputWaitHandle", 0x000715F9, NULL, NULL},
	{"GetConsoleKeyboardLayoutNameA", 0x00074329, NULL, NULL},
	{"GetConsoleKeyboardLayoutNameW", 0x00074341, NULL, NULL},
	{"GetConsoleMode", 0x0001AF14, NULL, NULL},
	{"GetConsoleNlsMode", 0x00074F87, NULL, NULL},
	{"GetConsoleOutputCP", 0x0001B18F, NULL, NULL},
	{"GetConsoleProcessList", 0x000743C5, NULL, NULL},
	{"GetConsoleScreenBufferInfo", 0x0001BC2B, NULL, NULL},
	{"GetConsoleSelectionInfo", 0x00073629, NULL, NULL},
	{"GetConsoleTitleA", 0x00070A39, NULL, NULL},
	{"GetConsoleTitleW", 0x0001BA3C, NULL, NULL},
	{"GetConsoleWindow", 0x00074359, NULL, NULL},
	{"GetCurrencyFormatA", 0x00075B79, NULL, NULL},
	{"GetCurrencyFormatW", 0x0007B6CA, NULL, NULL},
	{"GetCurrentActCtx", 0x000300A9, NULL, NULL},
	{"GetCurrentConsoleFont", 0x0007394F, NULL, NULL},
	{"GetCurrentDirectoryA", 0x00034FFE, NULL, NULL},
	{"GetCurrentDirectoryW", 0x0000B877, NULL, NULL},
	{"GetCurrentProcess", 0x0000DDF5, NULL, NULL},
	{"GetCurrentProcessId", 0x00009920, NULL, NULL},
	{"GetCurrentThread", 0x000098EB, NULL, NULL},
	{"GetCurrentThreadId", 0x00009728, NULL, NULL},
	{"GetDateFormatA", 0x000361EE, NULL, NULL},
	{"GetDateFormatW", 0x00033775, NULL, NULL},
	{"GetDefaultCommConfigA", 0x00066A41, NULL, NULL},
	{"GetDefaultCommConfigW", 0x00066949, NULL, NULL},
	{"GetDefaultSortkeySize", 0x0007AA41, NULL, NULL},
	{"GetDevicePowerState", 0x00060B1C, NULL, NULL},
	{"GetDiskFreeSpaceA", 0x000302ED, NULL, NULL},
	{"GetDiskFreeSpaceExA", 0x0003039B, NULL, NULL},
	{"GetDiskFreeSpaceExW", 0x00012803, NULL, NULL},
	{"GetDiskFreeSpaceW", 0x000301AF, NULL, NULL},
	{"GetDllDirectoryA", 0x0005EF47, NULL, NULL},
	{"GetDllDirectoryW", 0x0005EDD7, NULL, NULL},
	{"GetDriveTypeA", 0x000214E3, NULL, NULL},
	{"GetDriveTypeW", 0x0000B2D0, NULL, NULL},
	{"GetEnvironmentStrings", 0x0001CF5B, NULL, NULL},
	{"GetEnvironmentStringsA", 0x0001CF5B, NULL, NULL},
	{"GetEnvironmentStringsW", 0x00012F08, NULL, NULL},
	{"GetEnvironmentVariableA", 0x00014AF2, NULL, NULL},
	{"GetEnvironmentVariableW", 0x0000F0F4, NULL, NULL},
	{"GetExitCodeProcess", 0x0001AE17, NULL, NULL},
	{"GetExitCodeThread", 0x00021435, NULL, NULL},
	{"GetExpandedNameA", 0x00064BCF, NULL, NULL},
	{"GetExpandedNameW", 0x00064C7C, NULL, NULL},
	{"GetFileAttributesA", 0x0001153C, NULL, NULL},
	{"GetFileAttributesExA", 0x000137B1, NULL, NULL},
	{"GetFileAttributesExW", 0x000110F5, NULL, NULL},
	{"GetFileAttributesW", 0x0000B74C, NULL, NULL},
	{"GetFileInformationByHandle", 0x00010C6D, NULL, NULL},
	{"GetFileSize", 0x00010A77, env_w32_hook_GetFileSize, NULL},
	{"GetFileSizeEx", 0x00010A09, NULL, NULL},
	{"GetFileTime", 0x00031C45, NULL, NULL},
	{"GetFileType", 0x00010E51, NULL, NULL},
	{"GetFirmwareEnvironmentVariableA", 0x0005E534, NULL, NULL},
	{"GetFirmwareEnvironmentVariableW", 0x0005E41D, NULL, NULL},
	{"GetFullPathNameA", 0x000138FC, NULL, NULL},
	{"GetFullPathNameW", 0x0000B852, NULL, NULL},
	{"GetGeoInfoA", 0x00075842, NULL, NULL},
	{"GetGeoInfoW", 0x00078847, NULL, NULL},
	{"GetHandleContext", 0x0006B683, NULL, NULL},
	{"GetHandleInformation", 0x0002BDB5, NULL, NULL},
	{"GetLargestConsoleWindowSize", 0x00074631, NULL, NULL},
	{"GetLastError", 0x0000902D, NULL, NULL},
	{"GetLinguistLangSize", 0x0007AA6B, NULL, NULL},
	{"GetLocalTime", 0x0000A7D4, NULL, NULL},
	{"GetLocaleInfoA", 0x0000D262, NULL, NULL},
	{"GetLocaleInfoW", 0x00011562, NULL, NULL},
	{"GetLogicalDriveStringsA", 0x0002C2D3, NULL, NULL},
	{"GetLogicalDriveStringsW", 0x000603CF, NULL, NULL},
	{"GetLogicalDrives", 0x00030B14, NULL, NULL},
	{"GetLongPathNameA", 0x00068586, NULL, NULL},
	{"GetLongPathNameW", 0x00013353, NULL, NULL},
	{"GetMailslotInfo", 0x0005EB58, NULL, NULL},
	{"GetModuleFileNameA", 0x0000B4CF, NULL, NULL},
	{"GetModuleFileNameW", 0x0000B3D5, NULL, NULL},
	{"GetModuleHandleA", 0x0000B6A1, env_w32_hook_GetModuleHandleA, NULL},
	{"GetModuleHandleExA", 0x0005EFE6, NULL, NULL},
	{"GetModuleHandleExW", 0x0001FCC1, NULL, NULL},
	{"GetModuleHandleW", 0x0000E43D, NULL, NULL},
	{"GetNamedPipeHandleStateA", 0x0005FCEB, NULL, NULL},
	{"GetNamedPipeHandleStateW", 0x0005FA85, NULL, NULL},
	{"GetNamedPipeInfo", 0x0005F88A, NULL, NULL},
	{"GetNativeSystemInfo", 0x00037945, NULL, NULL},
	{"GetNextVDMCommand", 0x00066F43, NULL, NULL},
	{"GetNlsSectionName", 0x00017F7D, NULL, NULL},
	{"GetNumaAvailableMemory", 0x0005FFC4, NULL, NULL},
	{"GetNumaAvailableMemoryNode", 0x0006000A, NULL, NULL},
	{"GetNumaHighestNodeNumber", 0x0005FE41, NULL, NULL},
	{"GetNumaNodeProcessorMask", 0x0005FF19, NULL, NULL},
	{"GetNumaProcessorMap", 0x0005FF7E, NULL, NULL},
	{"GetNumaProcessorNode", 0x0005FE8C, NULL, NULL},
	{"GetNumberFormatA", 0x0002EC56, NULL, NULL},
	{"GetNumberFormatW", 0x000344BC, NULL, NULL},
	{"GetNumberOfConsoleFonts", 0x00074501, NULL, NULL},
	{"GetNumberOfConsoleInputEvents", 0x0007456D, NULL, NULL},
	{"GetNumberOfConsoleMouseButtons", 0x000736E1, NULL, NULL},
	{"GetOEMCP", 0x000127A7, NULL, NULL},
	{"GetOverlappedResult", 0x000315C4, NULL, NULL},
	{"GetPriorityClass", 0x00060E13, NULL, NULL},
	{"GetPrivateProfileIntA", 0x00036434, NULL, NULL},
	{"GetPrivateProfileIntW", 0x00032730, NULL, NULL},
	{"GetPrivateProfileSectionA", 0x00035F21, NULL, NULL},
	{"GetPrivateProfileSectionNamesA", 0x00032DA7, NULL, NULL},
	{"GetPrivateProfileSectionNamesW", 0x0005BB0A, NULL, NULL},
	{"GetPrivateProfileSectionW", 0x0001EDBD, NULL, NULL},
	{"GetPrivateProfileStringA", 0x00032B56, NULL, NULL},
	{"GetPrivateProfileStringW", 0x0000F95D, NULL, NULL},
	{"GetPrivateProfileStructA", 0x0005BB2B, NULL, NULL},
	{"GetPrivateProfileStructW", 0x0005BC95, NULL, NULL},
	{"GetProcAddress", 0x0000ADA0, env_w32_hook_GetProcAddress, NULL},
	{"GetProcessAffinityMask", 0x00021765, NULL, NULL},
	{"GetProcessHandleCount", 0x00061186, NULL, NULL},
	{"GetProcessHeap", 0x0000ABC1, NULL, NULL},
	{"GetProcessHeaps", 0x0005E9DB, NULL, NULL},
	{"GetProcessId", 0x00060C75, NULL, NULL},
	{"GetProcessIoCounters", 0x00061155, NULL, NULL},
	{"GetProcessPriorityBoost", 0x0006111B, NULL, NULL},
	{"GetProcessShutdownParameters", 0x00060E79, NULL, NULL},
	{"GetProcessTimes", 0x000352D9, NULL, NULL},
	{"GetProcessVersion", 0x00012C23, NULL, NULL},
	{"GetProcessWorkingSetSize", 0x00061068, NULL, NULL},
	{"GetProfileIntA", 0x000364A9, NULL, NULL},
	{"GetProfileIntW", 0x0002F89A, NULL, NULL},
	{"GetProfileSectionA", 0x0005C0D7, NULL, NULL},
	{"GetProfileSectionW", 0x0005C110, NULL, NULL},
	{"GetProfileStringA", 0x00021495, NULL, NULL},
	{"GetProfileStringW", 0x000213F8, NULL, NULL},
	{"GetQueuedCompletionStatus", 0x0000A71D, NULL, NULL},
	{"GetShortPathNameA", 0x00035BB0, NULL, NULL},
	{"GetShortPathNameW", 0x0001F26E, NULL, NULL},
	{"GetStartupInfoA", 0x00001EEE, NULL, NULL},
	{"GetStartupInfoW", 0x00001E50, NULL, NULL},
	{"GetStdHandle", 0x00012F39, NULL, NULL},
	{"GetStringTypeA", 0x00038A0C, NULL, NULL},
	{"GetStringTypeExA", 0x000760CF, NULL, NULL},
	{"GetStringTypeExW", 0x0000BFEF, NULL, NULL},
	{"GetStringTypeW", 0x0000A490, NULL, NULL},
	{"GetSystemDefaultLCID", 0x0000BF3D, NULL, NULL},
	{"GetSystemDefaultLangID", 0x000127B2, NULL, NULL},
	{"GetSystemDefaultUILanguage", 0x00013038, NULL, NULL},
	{"GetSystemDirectoryA", 0x00014EEA, env_w32_hook_GetSystemDirectoryA },
	{"GetSystemDirectoryW", 0x00031DB9, NULL, NULL},
	{"GetSystemInfo", 0x00012D56, NULL, NULL},
	{"GetSystemPowerStatus", 0x00035340, NULL, NULL},
	{"GetSystemRegistryQuota", 0x000611C0, NULL, NULL},
	{"GetSystemTime", 0x0000176B, NULL, NULL},
	{"GetSystemTimeAdjustment", 0x0002D36F, NULL, NULL},
	{"GetSystemTimeAsFileTime", 0x000017E5, NULL, NULL},
	{"GetSystemTimes", 0x00060F22, NULL, NULL},
	{"GetSystemWindowsDirectoryA", 0x000212F1, NULL, NULL},
	{"GetSystemWindowsDirectoryW", 0x0000AD29, NULL, NULL},
	{"GetSystemWow64DirectoryA", 0x0002146C, NULL, NULL},
	{"GetSystemWow64DirectoryW", 0x0002146C, NULL, NULL},
	{"GetTapeParameters", 0x0006B1C2, NULL, NULL},
	{"GetTapePosition", 0x0006B08C, NULL, NULL},
	{"GetTapeStatus", 0x0006B25F, NULL, NULL},
	{"GetTempFileNameA", 0x000608FF, NULL, NULL},
	{"GetTempFileNameW", 0x000359B7, NULL, NULL},
	{"GetTempPathA", 0x00035DCA, env_w32_hook_GetTempPathA, NULL},
	{"GetTempPathW", 0x00030789, NULL, NULL},
	{"GetThreadContext", 0x0003970D, NULL, NULL},
	{"GetThreadIOPendingFlag", 0x00062D09, NULL, NULL},
	{"GetThreadLocale", 0x0000A415, NULL, NULL},
	{"GetThreadPriority", 0x0000A793, NULL, NULL},
	{"GetThreadPriorityBoost", 0x00062A6B, NULL, NULL},
	{"GetThreadSelectorEntry", 0x0005A1E8, NULL, NULL},
	{"GetThreadTimes", 0x00062C9C, NULL, NULL},
	{"GetTickCount", 0x0000929C, env_w32_hook_GetTickCount, NULL},
	{"GetTimeFormatA", 0x0003632D, NULL, NULL},
	{"GetTimeFormatW", 0x00033FD3, NULL, NULL},
	{"GetTimeZoneInformation", 0x000350BF, NULL, NULL},
	{"GetUserDefaultLCID", 0x00009F10, NULL, NULL},
	{"GetUserDefaultLangID", 0x0000BF64, NULL, NULL},
	{"GetUserDefaultUILanguage", 0x00013070, NULL, NULL},
	{"GetUserGeoID", 0x0003798E, NULL, NULL},
	{"GetVDMCurrentDirectories", 0x00067849, NULL, NULL},
	{"GetVersion", 0x000111DA, env_w32_hook_GetVersion, NULL},
	{"GetVersionExA", 0x00012ADE, NULL, NULL},
	{"GetVersionExW", 0x0000AE65, NULL, NULL},
	{"GetVolumeInformationA", 0x00021BA5, NULL, NULL},
	{"GetVolumeInformationW", 0x0000F9E5, NULL, NULL},
	{"GetVolumeNameForVolumeMountPointA", 0x00069F61, NULL, NULL},
	{"GetVolumeNameForVolumeMountPointW", 0x0001FB88, NULL, NULL},
	{"GetVolumePathNameA", 0x0002E8B2, NULL, NULL},
	{"GetVolumePathNameW", 0x0002E61C, NULL, NULL},
	{"GetVolumePathNamesForVolumeNameA", 0x0006A100, NULL, NULL},
	{"GetVolumePathNamesForVolumeNameW", 0x00020D14, NULL, NULL},
	{"GetWindowsDirectoryA", 0x00021363, NULL, NULL},
	{"GetWindowsDirectoryW", 0x0000AD7B, NULL, NULL},
	{"GetWriteWatch", 0x0005E7CA, NULL, NULL},
	{"GlobalAddAtomA", 0x000360A9, NULL, NULL},
	{"GlobalAddAtomW", 0x0001006C, NULL, NULL},
	{"GlobalAlloc", 0x0000FD2D, NULL, NULL},
	{"GlobalCompact", 0x0005E670, NULL, NULL},
	{"GlobalDeleteAtom", 0x00030BBB, NULL, NULL},
	{"GlobalFindAtomA", 0x000360C3, NULL, NULL},
	{"GlobalFindAtomW", 0x00034E97, NULL, NULL},
	{"GlobalFix", 0x0005E686, NULL, NULL},
	{"GlobalFlags", 0x00036772, NULL, NULL},
	{"GlobalFree", 0x0000FC2F, NULL, NULL},
	{"GlobalGetAtomNameA", 0x0005B28B, NULL, NULL},
	{"GlobalGetAtomNameW", 0x0002C3BE, NULL, NULL},
	{"GlobalHandle", 0x00034CB9, NULL, NULL},
	{"GlobalLock", 0x0000FF19, NULL, NULL},
	{"GlobalMemoryStatus", 0x000310F2, NULL, NULL},
	{"GlobalMemoryStatusEx", 0x0001F992, NULL, NULL},
	{"GlobalReAlloc", 0x000123B9, NULL, NULL},
	{"GlobalSize", 0x00034DA1, NULL, NULL},
	{"GlobalUnWire", 0x0005E6CA, NULL, NULL},
	{"GlobalUnfix", 0x0005E6A0, NULL, NULL},
	{"GlobalUnlock", 0x0000FE82, NULL, NULL},
	{"GlobalWire", 0x0005E6BA, NULL, NULL},
	{"Heap32First", 0x00063ADE, NULL, NULL},
	{"Heap32ListFirst", 0x00063999, NULL, NULL},
	{"Heap32ListNext", 0x00063A47, NULL, NULL},
	{"Heap32Next", 0x00063BF8, NULL, NULL},
	{"HeapAlloc", 0x00009048, NULL, NULL},
	{"HeapCompact", 0x0003611E, NULL, NULL},
	{"HeapCreate", 0x00012BB6, NULL, NULL},
	{"HeapCreateTagsW", 0x0005E8C9, NULL, NULL},
	{"HeapDestroy", 0x00010EF8, NULL, NULL},
	{"HeapExtend", 0x0005E898, NULL, NULL},
	{"HeapFree", 0x0000905E, NULL, NULL},
	{"HeapLock", 0x0005E9EC, NULL, NULL},
	{"HeapQueryInformation", 0x0005EB25, NULL, NULL},
	{"HeapQueryTagW", 0x0005E8DA, NULL, NULL},
	{"HeapReAlloc", 0x00009070, NULL, NULL},
	{"HeapSetInformation", 0x00039469, NULL, NULL},
	{"HeapSize", 0x00009088, NULL, NULL},
	{"HeapSummary", 0x0005E8EB, NULL, NULL},
	{"HeapUnlock", 0x0005EA06, NULL, NULL},
	{"HeapUsage", 0x0005E947, NULL, NULL},
	{"HeapValidate", 0x0005E9BB, NULL, NULL},
	{"HeapWalk", 0x0005EA20, NULL, NULL},
	{"InitAtomTable", 0x0002AF8F, NULL, NULL},
	{"InitializeCriticalSection", 0x00009EF1, NULL, NULL},
	{"InitializeCriticalSectionAndSpinCount", 0x0000B829, NULL, NULL},
	{"InitializeSListHead", 0x0000909A, NULL, NULL},
	{"InterlockedCompareExchange", 0x000097A2, NULL, NULL},
	{"InterlockedDecrement", 0x0000977A, NULL, NULL},
	{"InterlockedExchange", 0x0000978E, NULL, NULL},
	{"InterlockedExchangeAdd", 0x000097B6, NULL, NULL},
	{"InterlockedFlushSList", 0x000090B7, NULL, NULL},
	{"InterlockedIncrement", 0x00009766, NULL, NULL},
	{"InterlockedPopEntrySList", 0x000090D6, NULL, NULL},
	{"InterlockedPushEntrySList", 0x000090F8, NULL, NULL},
	{"InvalidateConsoleDIBits", 0x00073215, NULL, NULL},
	{"IsBadCodePtr", 0x0000BCCF, NULL, NULL},
	{"IsBadHugeReadPtr", 0x0003593F, NULL, NULL},
	{"IsBadHugeWritePtr", 0x0000BF9D, NULL, NULL},
	{"IsBadReadPtr", 0x00009E01, NULL, NULL},
	{"IsBadStringPtrA", 0x00032259, NULL, NULL},
	{"IsBadStringPtrW", 0x0000A5DC, NULL, NULL},
	{"IsBadWritePtr", 0x00009E79, NULL, NULL},
	{"IsDBCSLeadByte", 0x0000B7DC, NULL, NULL},
	{"IsDBCSLeadByteEx", 0x0007A4CE, NULL, NULL},
	{"IsDebuggerPresent", 0x00013093, NULL, NULL},
	{"IsProcessInJob", 0x0006B324, NULL, NULL},
	{"IsProcessorFeaturePresent", 0x0000AE2A, NULL, NULL},
	{"IsSystemResumeAutomatic", 0x00060B60, NULL, NULL},
	{"IsValidCodePage", 0x000110CB, NULL, NULL},
	{"IsValidLanguageGroup", 0x000763EF, NULL, NULL},
	{"IsValidLocale", 0x0001C48B, NULL, NULL},
	{"IsValidUILanguage", 0x000764FB, NULL, NULL},
	{"IsWow64Process", 0x00015199, NULL, NULL},
	{"LCMapStringA", 0x00038DE8, NULL, NULL},
	{"LCMapStringW", 0x0000CCA8, NULL, NULL},
	{"LZClose", 0x000654BB, NULL, NULL},
	{"LZCloseFile", 0x00065444, NULL, NULL},
	{"LZCopy", 0x000592F8, NULL, NULL},
	{"LZCreateFileW", 0x00064F85, NULL, NULL},
	{"LZDone", 0x0007F1FC, NULL, NULL},
	{"LZInit", 0x00064E2A, NULL, NULL},
	{"LZOpenFileA", 0x00065053, NULL, NULL},
	{"LZOpenFileW", 0x00065114, NULL, NULL},
	{"LZRead", 0x00065236, NULL, NULL},
	{"LZSeek", 0x000651AB, NULL, NULL},
	{"LZStart", 0x0007E9E7, NULL, NULL},
	{"LeaveCriticalSection", 0x0000911B, NULL, NULL},
	{"LoadLibraryA", 0x00001D77, env_w32_hook_LoadLibrayA, NULL},
	{"LoadLibraryExA", 0x00001D4F, NULL, NULL},
	{"LoadLibraryExW", 0x00001AF1, NULL, NULL},
	{"LoadLibraryW", 0x0000AE4B, NULL, NULL},
	{"LoadModule", 0x0006147E, NULL, NULL},
	{"LoadResource", 0x00009FB5, NULL, NULL},
	{"LocalAlloc", 0x0000998D, NULL, NULL},
	{"LocalCompact", 0x0005E670, NULL, NULL},
	{"LocalFileTimeToFileTime", 0x00035524, NULL, NULL},
	{"LocalFlags", 0x00055A0E, NULL, NULL},
	{"LocalFree", 0x0000992F, NULL, NULL},
	{"LocalHandle", 0x00055B09, NULL, NULL},
	{"LocalLock", 0x00032E1D, NULL, NULL},
	{"LocalReAlloc", 0x00030927, NULL, NULL},
	{"LocalShrink", 0x0005E882, NULL, NULL},
	{"LocalSize", 0x000325BC, NULL, NULL},
	{"LocalUnlock", 0x00032EB1, NULL, NULL},
	{"LockFile", 0x00032361, NULL, NULL},
	{"LockFileEx", 0x0002F569, NULL, NULL},
	{"LockResource", 0x0000CC97, NULL, NULL},
	{"MapUserPhysicalPages", 0x0005E76E, NULL, NULL},
	{"MapUserPhysicalPagesScatter", 0x0005E79C, NULL, NULL},
	{"MapViewOfFile", 0x0000B905, env_w32_hook_MapViewOfFile, NULL},
	{"MapViewOfFileEx", 0x0000B896, NULL, NULL},
	{"Module32First", 0x00064268, NULL, NULL},
	{"Module32FirstW", 0x000641AF, NULL, NULL},
	{"Module32Next", 0x000643ED, NULL, NULL},
	{"Module32NextW", 0x0006434C, NULL, NULL},
	{"MoveFileA", 0x00035E8F, NULL, NULL},
	{"MoveFileExA", 0x0005D4C3, NULL, NULL},
	{"MoveFileExW", 0x0003565B, NULL, NULL},
	{"MoveFileW", 0x00021261, NULL, NULL},
	{"MoveFileWithProgressA", 0x00035EAE, NULL, NULL},
	{"MoveFileWithProgressW", 0x0001F72E, NULL, NULL},
	{"MulDiv", 0x000097C6, NULL, NULL},
	{"MultiByteToWideChar", 0x00009BF8, NULL, NULL},
	{"NlsConvertIntegerToString", 0x00014F5C, NULL, NULL},
	{"NlsGetCacheUpdateCount", 0x00035819, NULL, NULL},
	{"NlsResetProcessLocale", 0x000763C9, NULL, NULL},
	{"NumaVirtualQueryNode", 0x000600D2, NULL, NULL},
	{"OpenConsoleW", 0x00010FE1, NULL, NULL},
	{"OpenDataFile", 0x0002AD98, NULL, NULL},
	{"OpenEventA", 0x0001320C, NULL, NULL},
	{"OpenEventW", 0x00013140, NULL, NULL},
	{"OpenFile", 0x00021982, NULL, NULL},
	{"OpenFileMappingA", 0x0000BB76, NULL, NULL},
	{"OpenFileMappingW", 0x0000BADA, NULL, NULL},
	{"OpenJobObjectA", 0x0006B3F8, NULL, NULL},
	{"OpenJobObjectW", 0x0006B280, NULL, NULL},
	{"OpenMutexA", 0x0000EA1B, NULL, NULL},
	{"OpenMutexW", 0x0000E995, NULL, NULL},
	{"OpenProcess", 0x000309E1, NULL, NULL},
	{"OpenProfileUserMapping", 0x0003331F, NULL, NULL},
	{"OpenSemaphoreA", 0x0002CA47, NULL, NULL},
	{"OpenSemaphoreW", 0x0002E30F, NULL, NULL},
	{"OpenThread", 0x0002FC00, NULL, NULL},
	{"OpenWaitableTimerA", 0x00061AF0, NULL, NULL},
	{"OpenWaitableTimerW", 0x00061985, NULL, NULL},
	{"OutputDebugStringA", 0x00059D78, NULL, NULL},
	{"OutputDebugStringW", 0x0005A42D, NULL, NULL},
	{"PeekConsoleInputA", 0x0007348D, NULL, NULL},
	{"PeekConsoleInputW", 0x000734B0, NULL, NULL},
	{"PeekNamedPipe", 0x0005F90F, NULL, NULL},
	{"PostQueuedCompletionStatus", 0x000126F2, NULL, NULL},
	{"PrepareTape", 0x0006B0E8, NULL, NULL},
	{"PrivCopyFileExW", 0x0002005F, NULL, NULL},
	{"PrivMoveFileIdentityW", 0x0005D0E9, NULL, NULL},
	{"Process32First", 0x00063E1D, NULL, NULL},
	{"Process32FirstW", 0x00063D64, NULL, NULL},
	{"Process32Next", 0x00063F90, NULL, NULL},
	{"Process32NextW", 0x00063EEF, NULL, NULL},
	{"ProcessIdToSessionId", 0x00012F89, NULL, NULL},
	{"PulseEvent", 0x0002C05E, NULL, NULL},
	{"PurgeComm", 0x00065D02, NULL, NULL},
	{"QueryActCtxW", 0x000162DB, NULL, NULL},
	{"QueryDepthSList", 0x00009139, NULL, NULL},
	{"QueryDosDeviceA", 0x0005C36C, NULL, NULL},
	{"QueryDosDeviceW", 0x00021D8D, NULL, NULL},
	{"QueryInformationJobObject", 0x0002AFC9, NULL, NULL},
	{"QueryMemoryResourceNotification", 0x000395D8, NULL, NULL},
	{"QueryPerformanceCounter", 0x0000A427, NULL, NULL},
	{"QueryPerformanceFrequency", 0x0002FA46, NULL, NULL},
	{"QueryWin31IniFilesMappedToRegistry", 0x0005B71C, NULL, NULL},
	{"QueueUserAPC", 0x0002C082, NULL, NULL},
	{"QueueUserWorkItem", 0x00030A62, NULL, NULL},
	{"RaiseException", 0x00012A09, NULL, NULL},
	{"ReadConsoleA", 0x00071A1D, NULL, NULL},
	{"ReadConsoleInputA", 0x000734D3, NULL, NULL},
	{"ReadConsoleInputExA", 0x00073519, NULL, NULL},
	{"ReadConsoleInputExW", 0x0007353D, NULL, NULL},
	{"ReadConsoleInputW", 0x000734F6, NULL, NULL},
	{"ReadConsoleOutputA", 0x00072805, NULL, NULL},
	{"ReadConsoleOutputAttribute", 0x00072D25, NULL, NULL},
	{"ReadConsoleOutputCharacterA", 0x00072CD9, NULL, NULL},
	{"ReadConsoleOutputCharacterW", 0x00072CFF, NULL, NULL},
	{"ReadConsoleOutputW", 0x000727E1, NULL, NULL},
	{"ReadConsoleW", 0x00071A6C, NULL, NULL},
	{"ReadDirectoryChangesW", 0x0003162F, NULL, NULL},
	{"ReadFile", 0x0000180E, NULL, NULL},
	{"ReadFileEx", 0x0002BCFB, NULL, NULL},
	{"ReadFileScatter", 0x0002DE51, NULL, NULL},
	{"ReadProcessMemory", 0x000021CC, NULL, NULL},
	{"RegisterConsoleIME", 0x00074AB9, NULL, NULL},
	{"RegisterConsoleOS2", 0x000748C9, NULL, NULL},
	{"RegisterConsoleVDM", 0x00071AC2, NULL, NULL},
	{"RegisterWaitForInputIdle", 0x00016F8E, NULL, NULL},
	{"RegisterWaitForSingleObject", 0x000211CD, NULL, NULL},
	{"RegisterWaitForSingleObjectEx", 0x0002B086, NULL, NULL},
	{"RegisterWowBaseHandlers", 0x0005E65A, NULL, NULL},
	{"RegisterWowExec", 0x000679A9, NULL, NULL},
	{"ReleaseActCtx", 0x0001305F, NULL, NULL},
	{"ReleaseMutex", 0x000024A7, NULL, NULL},
	{"ReleaseSemaphore", 0x0000BFAD, NULL, NULL},
	{"RemoveDirectoryA", 0x0005B219, NULL, NULL},
	{"RemoveDirectoryW", 0x00036F5B, NULL, NULL},
	{"RemoveLocalAlternateComputerNameA", 0x00059050, NULL, NULL},
	{"RemoveLocalAlternateComputerNameW", 0x00058F6F, NULL, NULL},
	{"RemoveVectoredExceptionHandler", 0x00009152, NULL, NULL},
	{"ReplaceFile", 0x00036C3C, NULL, NULL},
	{"ReplaceFileA", 0x0005E307, NULL, NULL},
	{"ReplaceFileW", 0x00036C3C, NULL, NULL},
	{"RequestDeviceWakeup", 0x00060B6F, NULL, NULL},
	{"RequestWakeupLatency", 0x00060AF4, NULL, NULL},
	{"ResetEvent", 0x0000A03B, NULL, NULL},
	{"ResetWriteWatch", 0x0005E803, NULL, NULL},
	{"RestoreLastError", 0x0000917A, NULL, NULL},
	{"ResumeThread", 0x000328F7, NULL, NULL},
	{"RtlCaptureContext", 0x00009199, NULL, NULL},
	{"RtlCaptureStackBackTrace", 0x000091B1, NULL, NULL},
	{"RtlFillMemory", 0x000091D0, NULL, NULL},
	{"RtlMoveMemory", 0x000091E4, NULL, NULL},
	{"RtlUnwind", 0x000091F8, NULL, NULL},
	{"RtlZeroMemory", 0x00009208, NULL, NULL},
	{"ScrollConsoleScreenBufferA", 0x00073F21, NULL, NULL},
	{"ScrollConsoleScreenBufferW", 0x00073F45, NULL, NULL},
	{"SearchPathA", 0x000217EA, NULL, NULL},
	{"SearchPathW", 0x0000E6DC, NULL, NULL},
	{"SetCPGlobal", 0x000797C3, NULL, NULL},
	{"SetCalendarInfoA", 0x00075AD6, NULL, NULL},
	{"SetCalendarInfoW", 0x00076D1B, NULL, NULL},
	{"SetClientTimeZoneInformation", 0x00059A31, NULL, NULL},
	{"SetComPlusPackageInstallStatus", 0x0006BB65, NULL, NULL},
	{"SetCommBreak", 0x00065D8C, NULL, NULL},
	{"SetCommConfig", 0x00066EAB, NULL, NULL},
	{"SetCommMask", 0x00065DA4, NULL, NULL},
	{"SetCommState", 0x00065E43, NULL, NULL},
	{"SetCommTimeouts", 0x0006614B, NULL, NULL},
	{"SetComputerNameA", 0x00058234, NULL, NULL},
	{"SetComputerNameExA", 0x0005834C, NULL, NULL},
	{"SetComputerNameExW", 0x000581B3, NULL, NULL},
	{"SetComputerNameW", 0x0005808D, NULL, NULL},
	{"SetConsoleActiveScreenBuffer", 0x00073AA8, NULL, NULL},
	{"SetConsoleCP", 0x00074143, NULL, NULL},
	{"SetConsoleCommandHistoryMode", 0x000709C5, NULL, NULL},
	{"SetConsoleCtrlHandler", 0x0001B58B, NULL, NULL},
	{"SetConsoleCursor", 0x00071EEA, NULL, NULL},
	{"SetConsoleCursorInfo", 0x00073C84, NULL, NULL},
	{"SetConsoleCursorMode", 0x0007477F, NULL, NULL},
	{"SetConsoleCursorPosition", 0x00073C0A, NULL, NULL},
	{"SetConsoleDisplayMode", 0x000720A0, NULL, NULL},
	{"SetConsoleFont", 0x00073FE5, NULL, NULL},
	{"SetConsoleHardwareState", 0x00071CE9, NULL, NULL},
	{"SetConsoleIcon", 0x0007405F, NULL, NULL},
	{"SetConsoleInputExeNameA", 0x00070DA8, NULL, NULL},
	{"SetConsoleInputExeNameW", 0x0001B355, NULL, NULL},
	{"SetConsoleKeyShortcuts", 0x00071D69, NULL, NULL},
	{"SetConsoleLocalEUDC", 0x000746B9, NULL, NULL},
	{"SetConsoleMaximumWindowSize", 0x0007F215, NULL, NULL},
	{"SetConsoleMenuClose", 0x00071E30, NULL, NULL},
	{"SetConsoleMode", 0x0001B1F0, NULL, NULL},
	{"SetConsoleNlsMode", 0x000750D9, NULL, NULL},
	{"SetConsoleNumberOfCommandsA", 0x00070725, NULL, NULL},
	{"SetConsoleNumberOfCommandsW", 0x0007070A, NULL, NULL},
	{"SetConsoleOS2OemFormat", 0x0007493D, NULL, NULL},
	{"SetConsoleOutputCP", 0x00074261, NULL, NULL},
	{"SetConsolePalette", 0x000721C9, NULL, NULL},
	{"SetConsoleScreenBufferSize", 0x00073B90, NULL, NULL},
	{"SetConsoleTextAttribute", 0x00073F69, NULL, NULL},
	{"SetConsoleTitleA", 0x00070A61, NULL, NULL},
	{"SetConsoleTitleW", 0x0002D9BD, NULL, NULL},
	{"SetConsoleWindowInfo", 0x00073D51, NULL, NULL},
	{"SetCriticalSectionSpinCount", 0x0000921C, NULL, NULL},
	{"SetCurrentDirectoryA", 0x000360DD, NULL, NULL},
	{"SetCurrentDirectoryW", 0x0000F2EE, NULL, NULL},
	{"SetDefaultCommConfigA", 0x00066C11, NULL, NULL},
	{"SetDefaultCommConfigW", 0x00066B19, NULL, NULL},
	{"SetDllDirectoryA", 0x0005ED46, NULL, NULL},
	{"SetDllDirectoryW", 0x0005ECB0, NULL, NULL},
	{"SetEndOfFile", 0x00032044, NULL, NULL},
	{"SetEnvironmentVariableA", 0x00033478, NULL, NULL},
	{"SetEnvironmentVariableW", 0x000101BE, NULL, NULL},
	{"SetErrorMode", 0x0000AC0F, NULL, NULL},
	{"SetEvent", 0x0000A017, NULL, NULL},
	{"SetFileApisToANSI", 0x000365F6, NULL, NULL},
	{"SetFileApisToOEM", 0x0001D07E, NULL, NULL},
	{"SetFileAttributesA", 0x00012782, NULL, NULL},
	{"SetFileAttributesW", 0x000314D5, NULL, NULL},
	{"SetFilePointer", 0x00010B8E, env_w32_hook_SetFilePointer, NULL},
	{"SetFilePointerEx", 0x00021057, NULL, NULL},
	{"SetFileShortNameA", 0x0005C8C4, NULL, NULL},
	{"SetFileShortNameW", 0x0005C7F7, NULL, NULL},
	{"SetFileTime", 0x00031CB8, NULL, NULL},
	{"SetFileValidData", 0x0005C7A1, NULL, NULL},
	{"SetFirmwareEnvironmentVariableA", 0x0005E5C7, NULL, NULL},
	{"SetFirmwareEnvironmentVariableW", 0x0005E4AC, NULL, NULL},
	{"SetHandleContext", 0x0002146C, NULL, NULL},
	{"SetHandleCount", 0x0000CC97, NULL, NULL},
	{"SetHandleInformation", 0x0002E18C, NULL, NULL},
	{"SetInformationJobObject", 0x0002CA9F, NULL, NULL},
	{"SetLastConsoleEventActive", 0x000754D3, NULL, NULL},
	{"SetLastError", 0x00009241, NULL, NULL},
	{"SetLocalPrimaryComputerNameA", 0x000592AF, NULL, NULL},
	{"SetLocalPrimaryComputerNameW", 0x00059099, NULL, NULL},
	{"SetLocalTime", 0x00055921, NULL, NULL},
	{"SetLocaleInfoA", 0x000758CB, NULL, NULL},
	{"SetLocaleInfoW", 0x00076E73, NULL, NULL},
	{"SetMailslotInfo", 0x0002CDD8, NULL, NULL},
	{"SetMessageWaitingIndicator", 0x00060BBF, NULL, NULL},
	{"SetNamedPipeHandleState", 0x000313EC, NULL, NULL},
	{"SetPriorityClass", 0x0002C338, NULL, NULL},
	{"SetProcessAffinityMask", 0x000610B0, NULL, NULL},
	{"SetProcessPriorityBoost", 0x000610E0, NULL, NULL},
	{"SetProcessShutdownParameters", 0x0002C8ED, NULL, NULL},
	{"SetProcessWorkingSetSize", 0x000303D0, NULL, NULL},
	{"SetStdHandle", 0x0001DC03, NULL, NULL},
	{"SetSystemPowerState", 0x00060AAB, NULL, NULL},
	{"SetSystemTime", 0x000593BE, NULL, NULL},
	{"SetSystemTimeAdjustment", 0x00059584, NULL, NULL},
	{"SetTapeParameters", 0x0006B21E, NULL, NULL},
	{"SetTapePosition", 0x0006B046, NULL, NULL},
	{"SetTermsrvAppInstallMode", 0x00061BA2, NULL, NULL},
	{"SetThreadAffinityMask", 0x0002FA7A, NULL, NULL},
	{"SetThreadContext", 0x00062AA5, NULL, NULL},
	{"SetThreadExecutionState", 0x000392B5, NULL, NULL},
	{"SetThreadIdealProcessor", 0x00062D48, NULL, NULL},
	{"SetThreadLocale", 0x0001BBBA, NULL, NULL},
	{"SetThreadPriority", 0x0000C108, NULL, NULL},
	{"SetThreadPriorityBoost", 0x00062A30, NULL, NULL},
	{"SetThreadUILanguage", 0x0001B258, NULL, NULL},
	{"SetTimeZoneInformation", 0x0005945E, NULL, NULL},
	{"SetTimerQueueTimer", 0x0002B26E, NULL, NULL},
	{"SetUnhandledExceptionFilter", 0x0004479D, env_w32_hook_SetUnhandledExceptionFilter, NULL},
	{"SetUserGeoID", 0x00078C5C, NULL, NULL},
	{"SetVDMCurrentDirectories", 0x00067714, NULL, NULL},
	{"SetVolumeLabelA", 0x000609ED, NULL, NULL},
	{"SetVolumeLabelW", 0x00060499, NULL, NULL},
	{"SetVolumeMountPointA", 0x0006A091, NULL, NULL},
	{"SetVolumeMountPointW", 0x00069395, NULL, NULL},
	{"SetWaitableTimer", 0x000095F9, NULL, NULL},
	{"SetupComm", 0x000656C7, NULL, NULL},
	{"ShowConsoleCursor", 0x00071F64, NULL, NULL},
	{"SignalObjectAndWait", 0x00036696, NULL, NULL},
	{"SizeofResource", 0x0000BC69, NULL, NULL},
	{"Sleep", 0x00002442, env_w32_hook_Sleep, NULL},
	{"SleepEx", 0x0000239C, NULL, NULL},
	{"SuspendThread", 0x00039732, NULL, NULL},
	{"SwitchToFiber", 0x00010672, NULL, NULL},
	{"SwitchToThread", 0x00032992, NULL, NULL},
	{"SystemTimeToFileTime", 0x00010B1C, NULL, NULL},
	{"SystemTimeToTzSpecificLocalTime", 0x0002E9C1, NULL, NULL},
	{"TerminateJobObject", 0x0006B2F7, NULL, NULL},
	{"TerminateProcess", 0x00001E16, NULL, NULL},
	{"TerminateThread", 0x0001CE03, env_w32_hook_TerminateThread, NULL},
	{"TermsrvAppInstallMode", 0x0001EFCE, NULL, NULL},
	{"Thread32First", 0x00064062, NULL, NULL},
	{"Thread32Next", 0x00064116, NULL, NULL},
	{"TlsAlloc", 0x00012D9F, NULL, NULL},
	{"TlsFree", 0x000136D7, NULL, NULL},
	{"TlsGetValue", 0x00009740, NULL, NULL},
	{"TlsSetValue", 0x00009BC5, NULL, NULL},
	{"Toolhelp32ReadProcessMemory", 0x00063D24, NULL, NULL},
	{"TransactNamedPipe", 0x000312E5, NULL, NULL},
	{"TransmitCommChar", 0x000661F6, NULL, NULL},
	{"TrimVirtualBuffer", 0x0005EC4E, NULL, NULL},
	{"TryEnterCriticalSection", 0x0000925C, NULL, NULL},
	{"TzSpecificLocalTimeToSystemTime", 0x000595C1, NULL, NULL},
	{"UTRegister", 0x0005EEF0, NULL, NULL},
	{"UTUnRegister", 0x0007E98D, NULL, NULL},
	{"UnhandledExceptionFilter", 0x00062E62, NULL, NULL},
	{"UnlockFile", 0x000322BC, NULL, NULL},
	{"UnlockFileEx", 0x000322FB, NULL, NULL},
	{"UnmapViewOfFile", 0x0000B974, env_w32_hook_UnmapViewOfFile, NULL},
	{"UnregisterConsoleIME", 0x00074B86, NULL, NULL},
	{"UnregisterWait", 0x0002BFF8, NULL, NULL},
	{"UnregisterWaitEx", 0x00030062, NULL, NULL},
	{"UpdateResourceA", 0x0006F6AA, NULL, NULL},
	{"UpdateResourceW", 0x0006F5A3, NULL, NULL},
	{"VDMConsoleOperation", 0x000754E4, NULL, NULL},
	{"VDMOperationStarted", 0x00067E19, NULL, NULL},
	{"ValidateLCType", 0x0007AA95, NULL, NULL},
	{"ValidateLocale", 0x000397F8, NULL, NULL},
	{"VerLanguageNameA", 0x0002EFB9, NULL, NULL},
	{"VerLanguageNameW", 0x0002F041, NULL, NULL},
	{"VerSetConditionMask", 0x0000927D, NULL, NULL},
	{"VerifyConsoleIoHandle", 0x0001AEAA, NULL, NULL},
	{"VerifyVersionInfoA", 0x0005EE46, NULL, NULL},
	{"VerifyVersionInfoW", 0x0001FB26, NULL, NULL},
	{"VirtualAlloc", 0x00009A51, env_w32_hook_VirtualAlloc, NULL}, // Modified by T.OkamotoLab.
	{"VirtualAllocEx", 0x00009A72, NULL, NULL},
	{"VirtualBufferExceptionHandler", 0x0005EC71, NULL, NULL},
	{"VirtualFree", 0x00009AE4, NULL, NULL},
	{"VirtualFreeEx", 0x00009B02, NULL, NULL},
	{"VirtualLock", 0x0002B13F, NULL, NULL},
	{"VirtualProtect", 0x00001AD0, env_w32_hook_VirtualProtect, NULL},
	{"VirtualProtectEx", 0x00001A5D, env_w32_hook_VirtualProtectEx, NULL},
	{"VirtualQuery", 0x0000B9D1, NULL, NULL},
	{"VirtualQueryEx", 0x0000B9A0, NULL, NULL},
	{"VirtualUnlock", 0x0005E6DA, NULL, NULL},
	{"WTSGetActiveConsoleSessionId", 0x000132EE, NULL, NULL},
	{"WaitCommEvent", 0x00066280, NULL, NULL},
	{"WaitForDebugEvent", 0x0005A480, NULL, NULL},
	{"WaitForMultipleObjects", 0x0000A05D, NULL, NULL},
	{"WaitForMultipleObjectsEx", 0x0000952A, NULL, NULL},
	{"WaitForSingleObject", 0x00002520, env_w32_hook_WaitForSingleObject, NULL},
	{"WaitForSingleObjectEx", 0x00002540, NULL, NULL},
	{"WaitNamedPipeA", 0x0005FC39, NULL, NULL},
	{"WaitNamedPipeW", 0x0002C664, NULL, NULL},
	{"WideCharToMultiByte", 0x0000A0D4, NULL, NULL},
	{"WinExec", 0x0006136D, env_w32_hook_WinExec, NULL},
	{"WriteConsoleA", 0x0001CF25, NULL, NULL},
	{"WriteConsoleInputA", 0x000723C5, NULL, NULL},
	{"WriteConsoleInputVDMA", 0x00071EA4, NULL, NULL},
	{"WriteConsoleInputVDMW", 0x00071EC7, NULL, NULL},
	{"WriteConsoleInputW", 0x000723E8, NULL, NULL},
	{"WriteConsoleOutputA", 0x00072B45, NULL, NULL},
	{"WriteConsoleOutputAttribute", 0x00072EF1, NULL, NULL},
	{"WriteConsoleOutputCharacterA", 0x00072EA5, NULL, NULL},
	{"WriteConsoleOutputCharacterW", 0x00072ECB, NULL, NULL},
	{"WriteConsoleOutputW", 0x00072B21, NULL, NULL},
	{"WriteConsoleW", 0x00035484, NULL, NULL},
	{"WriteFile", 0x00010D87, env_w32_hook_WriteFile, NULL},
	{"WriteFileEx", 0x0005C701, NULL, NULL},
	{"WriteFileGather", 0x0002DDA5, NULL, NULL},
	{"WritePrivateProfileSectionA", 0x0005BA7C, NULL, NULL},
	{"WritePrivateProfileSectionW", 0x0005BAC3, NULL, NULL},
	{"WritePrivateProfileStringA", 0x00035D54, NULL, NULL},
	{"WritePrivateProfileStringW", 0x0001EE4C, NULL, NULL},
	{"WritePrivateProfileStructA", 0x0005BE23, NULL, NULL},
	{"WritePrivateProfileStructW", 0x0005BF65, NULL, NULL},
	{"WriteProcessMemory", 0x0000220F, NULL, NULL},
	{"WriteProfileSectionA", 0x0005C0F5, NULL, NULL},
	{"WriteProfileSectionW", 0x0005C12E, NULL, NULL},
	{"WriteProfileStringA", 0x0005C0B9, NULL, NULL},
	{"WriteProfileStringW", 0x000332B1, NULL, NULL},
	{"WriteTapemark", 0x0006B188, NULL, NULL},
	{"ZombifyActCtx", 0x0006B6FB, NULL, NULL},
	{"_hread", 0x000353CE, NULL, NULL},
	{"_hwrite", 0x00038AE7, env_w32_hook__hwrite, NULL},
	{"_lclose", 0x00034E64, env_w32_hook__lclose, NULL},
	{"_lcreat", 0x000365A5, env_w32_hook__lcreat, NULL},
	{"_llseek", 0x00035406, NULL, NULL},
	{"_lopen", 0x0005E830, NULL, NULL},
	{"_lread", 0x000353CE, NULL, NULL},
	{"_lwrite", 0x00038AE7, env_w32_hook__lwrite, NULL},
	{"lstrcat", 0x00034D41, NULL, NULL},
	{"lstrcatA", 0x00034D41, NULL, NULL},
	{"lstrcatW", 0x00010F32, NULL, NULL},
	{"lstrcmp", 0x00030D74, NULL, NULL},
	{"lstrcmpA", 0x00030D74, NULL, NULL},
	{"lstrcmpW", 0x0000A9CC, NULL, NULL},
	{"lstrcmpi", 0x0000BAA1, NULL, NULL},
	{"lstrcmpiA", 0x0000BAA1, NULL, NULL},
	{"lstrcmpiW", 0x0000A996, NULL, NULL},
	{"lstrcpy", 0x0000BE01, NULL, NULL},
	{"lstrcpyA", 0x0000BE01, NULL, NULL},
	{"lstrcpyW", 0x0000BA64, NULL, NULL},
	{"lstrcpyn", 0x00010111, NULL, NULL},
	{"lstrcpynA", 0x00010111, NULL, NULL},
	{"lstrcpynW", 0x0000B9EF, NULL, NULL},
	{"lstrlen", 0x0000BDB6, NULL, NULL},
	{"lstrlenA", 0x0000BDB6, NULL, NULL},
	{"lstrlenW", 0x00009A09, NULL, NULL},
	{0,0,NULL},
};

struct emu_env_w32_dll_export ws2_32_exports[] = 
{
	{"accept", 0x00011028, env_w32_hook_accept, NULL},
	{"bind", 0x00003E00, env_w32_hook_bind, NULL},
	{"closesocket", 0x00009639, env_w32_hook_closesocket, NULL},
	{"connect", 0x0000406A, env_w32_hook_connect, NULL},
	{"getpeername", 0x00010B50, NULL, NULL},
	{"getsockname", 0x0000951E, NULL, NULL},
	{"getsockopt", 0x000046C9, NULL, NULL},
	{"htonl", 0x00002BC0, NULL, NULL},
	{"htons", 0x00002B66, NULL, NULL},
	{"ioctlsocket", 0x00004519, env_w32_hook_ioctlsocket, NULL}, // Modified by T.OkamotoLab.
	{"inet_addr", 0x00002BF4, NULL, NULL},
	{"inet_ntoa", 0x00003F41, NULL, NULL},
	{"listen", 0x000088D3, env_w32_hook_listen, NULL},
	{"ntohl", 0x00002BC0, NULL, NULL},
	{"ntohs", 0x00002B66, NULL, NULL},
	{"recv", 0x0000615A, env_w32_hook_recv, NULL},
	{"recvfrom", 0x00002D0F, NULL, NULL},
	{"select", 0x00002DC0, NULL, NULL},
	{"send", 0x0000428A, env_w32_hook_send, NULL},
	{"sendto", 0x00002C69, env_w32_hook_sendto, NULL},
	{"setsockopt", 0x00003EA1, env_w32_hook_setsockopt, NULL}, // Modified by T.OkamotoLab.
	{"shutdown", 0x00010BDE, NULL, NULL},
	{"socket", 0x00003B91, env_w32_hook_socket, NULL},
	{"GetAddrInfoW", 0x00002899, NULL, NULL},
	{"GetNameInfoW", 0x0000C4EC, NULL, NULL},
	{"WSApSetPostRoutine", 0x00011EC9, NULL, NULL},
	{"FreeAddrInfoW", 0x00002B0B, NULL, NULL},
	{"WPUCompleteOverlappedRequest", 0x00011CA7, NULL, NULL},
	{"WSAAccept", 0x00010DA9, NULL, NULL},
	{"WSAAddressToStringA", 0x000091F6, NULL, NULL},
	{"WSAAddressToStringW", 0x000062B2, NULL, NULL},
	{"WSACloseEvent", 0x00004682, NULL, NULL},
	{"WSAConnect", 0x00010C69, NULL, NULL},
	{"WSACreateEvent", 0x000045F7, NULL, NULL},
	{"WSADuplicateSocketA", 0x0000DB82, NULL, NULL},
	{"WSADuplicateSocketW", 0x0000DAF4, NULL, NULL},
	{"WSAEnumNameSpaceProvidersA", 0x0000F9C9, NULL, NULL},
	{"WSAEnumNameSpaceProvidersW", 0x0000FA29, NULL, NULL},
	{"WSAEnumNetworkEvents", 0x00004617, NULL, NULL},
	{"WSAEnumProtocolsA", 0x0000DC47, NULL, NULL},
	{"WSAEnumProtocolsW", 0x0000848C, NULL, NULL},
	{"WSAEventSelect", 0x00004573, NULL, NULL},
	{"WSAGetOverlappedResult", 0x00010D03, NULL, NULL},
	{"WSAGetQOSByName", 0x0000F458, NULL, NULL},
	{"WSAGetServiceClassInfoA", 0x00010428, NULL, NULL},
	{"WSAGetServiceClassInfoW", 0x00010141, NULL, NULL},
	{"WSAGetServiceClassNameByClassIdA", 0x0000FD87, NULL, NULL},
	{"WSAGetServiceClassNameByClassIdW", 0x0000FF69, NULL, NULL},
	{"WSAHtonl", 0x0000BCC9, NULL, NULL},
	{"WSAHtons", 0x0000BDB1, NULL, NULL},
	{"gethostbyaddr", 0x0000E479, NULL, NULL},
        {"gethostbyname", 0x00004FD4, env_w32_hook_gethostbyname, NULL}, // Modified by T.OkamotoLab.
	{"getprotobyname", 0x0000E176, NULL, NULL},
	{"getprotobynumber", 0x0000E0B4, NULL, NULL},
	{"getservbyname", 0x0000E6EB, NULL, NULL},
	{"getservbyport", 0x0000E59D, NULL, NULL},
	{"gethostname", 0x000050C8, NULL, NULL},
	{"WSAInstallServiceClassA", 0x000103A9, NULL, NULL},
	{"WSAInstallServiceClassW", 0x0000FBB1, NULL, NULL},
	{"WSAIoctl", 0x00004489, NULL, NULL},
	{"WSAJoinLeaf", 0x00010F58, NULL, NULL},
	{"WSALookupServiceBeginA", 0x000052AA, NULL, NULL},
	{"WSALookupServiceBeginW", 0x00003307, NULL, NULL},
	{"WSALookupServiceEnd", 0x00003226, NULL, NULL},
	{"WSALookupServiceNextA", 0x0000570E, NULL, NULL},
	{"WSALookupServiceNextW", 0x00002E99, NULL, NULL},
	{"WSANSPIoctl", 0x00004D06, NULL, NULL},
	{"WSANtohl", 0x0000BCC9, NULL, NULL},
	{"WSANtohs", 0x0000BDB1, NULL, NULL},
	{"WSAProviderConfigChange", 0x0000881F, NULL, NULL},
	{"WSARecv", 0x00004318, NULL, NULL},
	{"WSARecvDisconnect", 0x0000F5D6, NULL, NULL},
	{"WSARecvFrom", 0x0000F652, NULL, NULL},
	{"WSARemoveServiceClass", 0x0000FC9C, NULL, NULL},
	{"WSAResetEvent", 0x0000949F, NULL, NULL},
	{"WSASend", 0x00006233, NULL, NULL},
	{"WSASendDisconnect", 0x00010A0A, NULL, NULL},
	{"WSASendTo", 0x00010A95, NULL, NULL},
	{"WSASetEvent", 0x000094B0, NULL, NULL},
	{"WSASetServiceA", 0x000104BA, NULL, NULL},
	{"WSASetServiceW", 0x00010269, NULL, NULL},
	{"WSASocketA", 0x00008769, env_w32_hook_WSASocketA, NULL},
	{"WSASocketW", 0x000039CB, NULL, NULL},
	{"WSAStringToAddressA", 0x000090D8, NULL, NULL},
	{"WSAStringToAddressW", 0x0000281E, NULL, NULL},
	{"WSAWaitForMultipleEvents", 0x0000948E, NULL, NULL},
	{"WSCDeinstallProvider", 0x000119B1, NULL, NULL},
	{"WSCEnableNSProvider", 0x0000EE41, NULL, NULL},
	{"WSCEnumProtocols", 0x00007761, NULL, NULL},
	{"WSCGetProviderPath", 0x00008A27, NULL, NULL},
	{"WSCInstallNameSpace", 0x0000F135, NULL, NULL},
	{"WSCInstallProvider", 0x0001164D, NULL, NULL},
	{"WSCUnInstallNameSpace", 0x0000F301, NULL, NULL},
	{"WSCUpdateProvider", 0x00011279, NULL, NULL},
	{"WSCWriteNameSpaceOrder", 0x0000F001, NULL, NULL},
	{"WSCWriteProviderOrder", 0x00011519, NULL, NULL},
	{"freeaddrinfo", 0x00002B0B, NULL, NULL},
	{"getaddrinfo", 0x00002A6F, NULL, NULL},
	{"getnameinfo", 0x0000C671, NULL, NULL},
	{"WSAAsyncSelect", 0x00010979, NULL, NULL},
	{"WSAAsyncGetHostByAddr", 0x0000EA2B, NULL, NULL},
	{"WSAAsyncGetHostByName", 0x0000E985, NULL, NULL},
	{"WSAAsyncGetProtoByNumber", 0x0000E2AB, NULL, NULL},
	{"WSAAsyncGetProtoByName", 0x0000EAD5, NULL, NULL},
	{"WSAAsyncGetServByPort", 0x0000E8FB, NULL, NULL},
	{"WSAAsyncGetServByName", 0x0000E84F, NULL, NULL},
	{"WSACancelAsyncRequest", 0x0000E32F, NULL, NULL},
	{"WSASetBlockingHook", 0x0000D494, NULL, NULL},
	{"WSAUnhookBlockingHook", 0x0000D4F0, NULL, NULL},
	{"WSAGetLastError", 0x000094DC, NULL, NULL},
	{"WSASetLastError", 0x00002A5E, NULL, NULL},
	{"WSACancelBlockingCall", 0x0000D3F2, NULL, NULL},
	{"WSAIsBlocking", 0x0000D441, NULL, NULL},
	{"WSAStartup", 0x0000664D, env_w32_hook_WSAStartup, NULL},
	{"WSACleanup", 0x00004428, NULL, NULL},
	{"__WSAFDIsSet", 0x00004544, NULL, NULL},
	{"WEP", 0x00012105, NULL, NULL},
	{0,0,NULL},
};

struct emu_env_w32_dll_export wininet_exports[] = 
{
	{"CommitUrlCacheEntryA", 0x00021B82, NULL, NULL},
	{"CommitUrlCacheEntryW", 0x0006F7E3, NULL, NULL},
	{"CreateMD5SSOHash", 0x000487B7, NULL, NULL},
	{"CreateUrlCacheContainerA", 0x0006EA79, NULL, NULL},
	{"CreateUrlCacheContainerW", 0x00070346, NULL, NULL},
	{"CreateUrlCacheEntryA", 0x0006EB0B, NULL, NULL},
	{"CreateUrlCacheEntryW", 0x0006F607, NULL, NULL},
	{"CreateUrlCacheGroup", 0x00070C66, NULL, NULL},
	{"DeleteIE3Cache", 0x00071F68, NULL, NULL},
	{"DeleteUrlCacheContainerA", 0x0006EAC7, NULL, NULL},
	{"DeleteUrlCacheContainerW", 0x000705A4, NULL, NULL},
	{"DeleteUrlCacheEntry", 0x000279AA, NULL, NULL},
	{"DeleteUrlCacheEntryA", 0x000279AA, NULL, NULL},
	{"DeleteUrlCacheEntryW", 0x00070091, NULL, NULL},
	{"DeleteUrlCacheGroup", 0x00070CB1, NULL, NULL},
	{"DetectAutoProxyUrl", 0x0001FA6E, NULL, NULL},
	{"DllInstall", 0x00044D99, NULL, NULL},
	{"FindCloseUrlCache", 0x000216DD, NULL, NULL},
	{"FindFirstUrlCacheContainerA", 0x00021C8F, NULL, NULL},
	{"FindFirstUrlCacheContainerW", 0x00070676, NULL, NULL},
	{"FindFirstUrlCacheEntryA", 0x000052B6, NULL, NULL},
	{"FindFirstUrlCacheEntryExA", 0x0006EDED, NULL, NULL},
	{"FindFirstUrlCacheEntryExW", 0x0006FE59, NULL, NULL},
	{"FindFirstUrlCacheEntryW", 0x00070AFD, NULL, NULL},
	{"FindFirstUrlCacheGroup", 0x00070CF9, NULL, NULL},
	{"FindNextUrlCacheContainerA", 0x00021CDE, NULL, NULL},
	{"FindNextUrlCacheContainerW", 0x00070719, NULL, NULL},
	{"FindNextUrlCacheEntryA", 0x0002186A, NULL, NULL},
	{"FindNextUrlCacheEntryExA", 0x0006EE72, NULL, NULL},
	{"FindNextUrlCacheEntryExW", 0x0006FE8F, NULL, NULL},
	{"FindNextUrlCacheEntryW", 0x00070B27, NULL, NULL},
	{"FindNextUrlCacheGroup", 0x00070D60, NULL, NULL},
	{"ForceNexusLookup", 0x0004878B, NULL, NULL},
	{"ForceNexusLookupExW", 0x0004874C, NULL, NULL},
	{"FreeUrlCacheSpaceA", 0x0006EEDD, NULL, NULL},
	{"FreeUrlCacheSpaceW", 0x0006FECC, NULL, NULL},
	{"FtpCommandA", 0x00053505, NULL, NULL},
	{"FtpCommandW", 0x00054E73, NULL, NULL},
	{"FtpCreateDirectoryA", 0x00052E41, NULL, NULL},
	{"FtpCreateDirectoryW", 0x00054BE0, NULL, NULL},
	{"FtpDeleteFileA", 0x00052AA1, NULL, NULL},
	{"FtpDeleteFileW", 0x000549B6, NULL, NULL},
	{"FtpFindFirstFileA", 0x0005454D, NULL, NULL},
	{"FtpFindFirstFileW", 0x000548BD, NULL, NULL},
	{"FtpGetCurrentDirectoryA", 0x0005335C, NULL, NULL},
	{"FtpGetCurrentDirectoryW", 0x00054D8D, NULL, NULL},
	{"FtpGetFileA", 0x00051DD1, NULL, NULL},
	{"FtpGetFileEx", 0x0005558F, NULL, NULL},
	{"FtpGetFileSize", 0x0005372C, NULL, NULL},
	{"FtpGetFileW", 0x00054F21, NULL, NULL},
	{"FtpOpenFileA", 0x00054573, NULL, NULL},
	{"FtpOpenFileW", 0x00054B49, NULL, NULL},
	{"FtpPutFileA", 0x00051EE7, NULL, NULL},
	{"FtpPutFileEx", 0x0005560D, NULL, NULL},
	{"FtpPutFileW", 0x00055249, NULL, NULL},
	{"FtpRemoveDirectoryA", 0x00053005, NULL, NULL},
	{"FtpRemoveDirectoryW", 0x00054C71, NULL, NULL},
	{"FtpRenameFileA", 0x00052C5B, NULL, NULL},
	{"FtpRenameFileW", 0x00054A47, NULL, NULL},
	{"FtpSetCurrentDirectoryA", 0x000531A7, NULL, NULL},
	{"FtpSetCurrentDirectoryW", 0x00054CFF, NULL, NULL},
	{"GetUrlCacheConfigInfoA", 0x000720B2, NULL, NULL},
	{"GetUrlCacheConfigInfoW", 0x0006F55D, NULL, NULL},
	{"GetUrlCacheEntryInfoA", 0x00021AF9, NULL, NULL},
	{"GetUrlCacheEntryInfoExA", 0x000064BE, NULL, NULL},
	{"GetUrlCacheEntryInfoExW", 0x0002688D, NULL, NULL},
	{"GetUrlCacheEntryInfoW", 0x0006FBD0, NULL, NULL},
	{"GetUrlCacheGroupAttributeA", 0x0006EF9E, NULL, NULL},
	{"GetUrlCacheGroupAttributeW", 0x0006F314, NULL, NULL},
	{"GetUrlCacheHeaderData", 0x000075B2, NULL, NULL},
	{"GopherCreateLocatorA", 0x00058F21, NULL, NULL},
	{"GopherCreateLocatorW", 0x0005A224, NULL, NULL},
	{"GopherFindFirstFileA", 0x0005989F, NULL, NULL},
	{"GopherFindFirstFileW", 0x0005A456, NULL, NULL},
	{"GopherGetAttributeA", 0x0005A212, NULL, NULL},
	{"GopherGetAttributeW", 0x0005A212, NULL, NULL},
	{"GopherGetLocatorTypeA", 0x0005914D, NULL, NULL},
	{"GopherGetLocatorTypeW", 0x0005A3DA, NULL, NULL},
	{"GopherOpenFileA", 0x00059DD4, NULL, NULL},
	{"GopherOpenFileW", 0x0005A60D, NULL, NULL},
	{"HttpAddRequestHeadersA", 0x000140B2, NULL, NULL},
	{"HttpAddRequestHeadersW", 0x0001EEF5, NULL, NULL},
	{"HttpCheckDavCompliance", 0x0006189D, NULL, NULL},
	{"HttpEndRequestA", 0x00061E8F, NULL, NULL},
	{"HttpEndRequestW", 0x00061EC1, NULL, NULL},
	{"HttpOpenRequestA", 0x000136AD, NULL, NULL},
	{"HttpOpenRequestW", 0x0001F3F9, NULL, NULL},
	{"HttpQueryInfoA", 0x0001780A, NULL, NULL},
	{"HttpQueryInfoW", 0x00025FCA, NULL, NULL},
	{"HttpSendRequestA", 0x00016249, NULL, NULL},
	{"HttpSendRequestExA", 0x00061E29, NULL, NULL},
	{"HttpSendRequestExW", 0x0001E9C1, NULL, NULL},
	{"HttpSendRequestW", 0x00061D24, NULL, NULL},
	{"IncrementUrlCacheHeaderData", 0x00070BAE, NULL, NULL},
	{"InternetAlgIdToStringA", 0x0007A4E4, NULL, NULL},
	{"InternetAlgIdToStringW", 0x00049995, NULL, NULL},
	{"InternetAttemptConnect", 0x00047684, NULL, NULL},
	{"InternetAutodial", 0x000429F8, NULL, NULL},
	{"InternetAutodialCallback", 0x00042E89, NULL, NULL},
	{"InternetAutodialHangup", 0x00042D5B, NULL, NULL},
	{"InternetCanonicalizeUrlA", 0x0001302F, NULL, NULL},
	{"InternetCanonicalizeUrlW", 0x00021922, NULL, NULL},
	{"InternetCheckConnectionA", 0x000482FA, NULL, NULL},
	{"InternetCheckConnectionW", 0x000497D2, NULL, NULL},
	{"InternetClearAllPerSiteCookieDecisions", 0x00062BE2, NULL, NULL},
	{"InternetCloseHandle", 0x00014D6C, NULL, NULL},
	{"InternetCombineUrlA", 0x000242E0, NULL, NULL},
	{"InternetCombineUrlW", 0x00048B07, NULL, NULL},
	{"InternetConfirmZoneCrossing", 0x0007C751, NULL, NULL},
	{"InternetConfirmZoneCrossingA", 0x0007C751, NULL, NULL},
	{"InternetConfirmZoneCrossingW", 0x0007C79D, NULL, NULL},
	{"InternetConnectA", 0x000130C3, NULL, NULL},
	{"InternetConnectW", 0x0001EE00, NULL, NULL},
	{"InternetCrackUrlA", 0x000173DC, NULL, NULL},
	{"InternetCrackUrlW", 0x00048CCE, NULL, NULL},
	{"InternetCreateUrlA", 0x0001256F, NULL, NULL},
	{"InternetCreateUrlW", 0x0004900B, NULL, NULL},
	{"InternetDial", 0x0004286A, NULL, NULL},
	{"InternetDialA", 0x0004286A, NULL, NULL},
	{"InternetDialW", 0x00042317, NULL, NULL},
	{"InternetEnumPerSiteCookieDecisionA", 0x00062AC0, NULL, NULL},
	{"InternetEnumPerSiteCookieDecisionW", 0x00062B39, NULL, NULL},
	{"InternetErrorDlg", 0x0007C34D, NULL, NULL},
	{"InternetFindNextFileA", 0x00047E88, NULL, NULL},
	{"InternetFindNextFileW", 0x00048BB2, NULL, NULL},
	{"InternetFortezzaCommand", 0x0004D5B6, NULL, NULL},
	{"InternetGetCertByURL", 0x000473FC, NULL, NULL},
	{"InternetGetCertByURLA", 0x000473FC, NULL, NULL},
	{"InternetGetConnectedState", 0x00025C2E, NULL, NULL},
	{"InternetGetConnectedStateEx", 0x0002721D, NULL, NULL},
	{"InternetGetConnectedStateExA", 0x0002721D, NULL, NULL},
	{"InternetGetConnectedStateExW", 0x0002363E, NULL, NULL},
	{"InternetGetCookieA", 0x00064BA9, NULL, NULL},
	{"InternetGetCookieExA", 0x00029506, NULL, NULL},
	{"InternetGetCookieExW", 0x0002941B, NULL, NULL},
	{"InternetGetCookieW", 0x000271FA, NULL, NULL},
	{"InternetGetLastResponseInfoA", 0x000474DC, NULL, NULL},
	{"InternetGetLastResponseInfoW", 0x00049723, NULL, NULL},
	{"InternetGetPerSiteCookieDecisionA", 0x0006296E, NULL, NULL},
	{"InternetGetPerSiteCookieDecisionW", 0x000629BF, NULL, NULL},
	{"InternetGoOnline", 0x000431EA, NULL, NULL},
	{"InternetGoOnlineA", 0x000431EA, NULL, NULL},
	{"InternetGoOnlineW", 0x000430B1, NULL, NULL},
	{"InternetHangUp", 0x000428ED, NULL, NULL},
	{"InternetInitializeAutoProxyDll", 0x0005D45B, NULL, NULL},
	{"InternetLockRequestFile", 0x0001C624, NULL, NULL},
	{"InternetOpenA", 0x000158BA, NULL, NULL},
	{"InternetOpenUrlA", 0x00015B6D, NULL, NULL},
	{"InternetOpenUrlW", 0x00025B52, NULL, NULL},
	{"InternetOpenW", 0x0000AEFD, NULL, NULL},
	{"InternetQueryDataAvailable", 0x00028A17, NULL, NULL},
	{"InternetQueryFortezzaStatus", 0x0004D555, NULL, NULL},
	{"InternetQueryOptionA", 0x00007138, NULL, NULL},
	{"InternetQueryOptionW", 0x00025A3F, NULL, NULL},
	{"InternetReadFile", 0x000180F4, NULL, NULL},
	{"InternetReadFileExA", 0x00048160, NULL, NULL},
	{"InternetReadFileExW", 0x00047459, NULL, NULL},
	{"InternetSecurityProtocolToStringA", 0x0007A588, NULL, NULL},
	{"InternetSecurityProtocolToStringW", 0x00049A6B, NULL, NULL},
	{"InternetSetCookieA", 0x00064D8F, NULL, NULL},
	{"InternetSetCookieExA", 0x000650D3, NULL, NULL},
	{"InternetSetCookieExW", 0x00064DBA, NULL, NULL},
	{"InternetSetCookieW", 0x00065136, NULL, NULL},
	{"InternetSetDialState", 0x000420C3, NULL, NULL},
	{"InternetSetDialStateA", 0x000420C3, NULL, NULL},
	{"InternetSetDialStateW", 0x000420E6, NULL, NULL},
	{"InternetSetFilePointer", 0x0004746B, NULL, NULL},
	{"InternetSetOptionA", 0x0000B1A5, NULL, NULL},
	{"InternetSetOptionExA", 0x00049CA8, NULL, NULL},
	{"InternetSetOptionExW", 0x00049CD9, NULL, NULL},
	{"InternetSetOptionW", 0x0000BBED, NULL, NULL},
	{"InternetSetPerSiteCookieDecisionA", 0x00062806, NULL, NULL},
	{"InternetSetPerSiteCookieDecisionW", 0x00062880, NULL, NULL},
	{"InternetSetStatusCallback", 0x00029084, NULL, NULL},
	{"InternetSetStatusCallbackA", 0x00029084, NULL, NULL},
	{"InternetSetStatusCallbackW", 0x00048CB3, NULL, NULL},
	{"InternetShowSecurityInfoByURL", 0x0004799D, NULL, NULL},
	{"InternetShowSecurityInfoByURLA", 0x0004799D, NULL, NULL},
	{"InternetShowSecurityInfoByURLW", 0x000498B5, NULL, NULL},
	{"InternetTimeFromSystemTime", 0x00029D18, NULL, NULL},
	{"InternetTimeFromSystemTimeA", 0x00029D18, NULL, NULL},
	{"InternetTimeFromSystemTimeW", 0x0006547A, NULL, NULL},
	{"InternetTimeToSystemTime", 0x0006542B, NULL, NULL},
	{"InternetTimeToSystemTimeA", 0x0006542B, NULL, NULL},
	{"InternetTimeToSystemTimeW", 0x00065517, NULL, NULL},
	{"InternetUnlockRequestFile", 0x0001B9CE, NULL, NULL},
	{"InternetWriteFile", 0x00047C19, NULL, NULL},
	{"InternetWriteFileExA", 0x00047459, NULL, NULL},
	{"InternetWriteFileExW", 0x00047459, NULL, NULL},
	{"IsHostInProxyBypassList", 0x00023350, NULL, NULL},
	{"IsUrlCacheEntryExpiredA", 0x0006F07A, NULL, NULL},
	{"IsUrlCacheEntryExpiredW", 0x00070170, NULL, NULL},
	{"LoadUrlCacheContent", 0x00070BDE, NULL, NULL},
	{"ParseX509EncodedCertificateForListBoxEntry", 0x0007A686, NULL, NULL},
	{"PrivacyGetZonePreferenceW", 0x00061077, NULL, NULL},
	{"PrivacySetZonePreferenceW", 0x00060EFB, NULL, NULL},
	{"ReadUrlCacheEntryStream", 0x0002986B, NULL, NULL},
	{"RegisterUrlCacheNotification", 0x00070DB3, NULL, NULL},
	{"ResumeSuspendedDownload", 0x0004C656, NULL, NULL},
	{"RetrieveUrlCacheEntryFileA", 0x0006EB8B, NULL, NULL},
	{"RetrieveUrlCacheEntryFileW", 0x000708F9, NULL, NULL},
	{"RetrieveUrlCacheEntryStreamA", 0x0006EC05, NULL, NULL},
	{"RetrieveUrlCacheEntryStreamW", 0x0007091C, NULL, NULL},
	{"RunOnceUrlCache", 0x0007111D, NULL, NULL},
	{"SetUrlCacheConfigInfoA", 0x00072FB8, NULL, NULL},
	{"SetUrlCacheConfigInfoW", 0x0006F5F5, NULL, NULL},
	{"SetUrlCacheEntryGroup", 0x0006EF25, NULL, NULL},
	{"SetUrlCacheEntryGroupA", 0x0006EF25, NULL, NULL},
	{"SetUrlCacheEntryGroupW", 0x00070255, NULL, NULL},
	{"SetUrlCacheEntryInfoA", 0x0006ED82, NULL, NULL},
	{"SetUrlCacheEntryInfoW", 0x0006FBF2, NULL, NULL},
	{"SetUrlCacheGroupAttributeA", 0x0006F018, NULL, NULL},
	{"SetUrlCacheGroupAttributeW", 0x0006F3C9, NULL, NULL},
	{"SetUrlCacheHeaderData", 0x00070B7E, NULL, NULL},
	{"ShowCertificate", 0x0007A66E, NULL, NULL},
	{"ShowClientAuthCerts", 0x0007A67B, NULL, NULL},
	{"ShowSecurityInfo", 0x0007B135, NULL, NULL},
	{"ShowX509EncodedCertificate", 0x0007BACB, NULL, NULL},
	{"UnlockUrlCacheEntryFile", 0x00027D5C, NULL, NULL},
	{"UnlockUrlCacheEntryFileA", 0x00027D5C, NULL, NULL},
	{"UnlockUrlCacheEntryFileW", 0x0006FFAF, NULL, NULL},
	{"UnlockUrlCacheEntryStream", 0x00027CC2, NULL, NULL},
	{"UpdateUrlCacheContentPath", 0x00070C50, NULL, NULL},
	{"UrlZonesDetach", 0x00069802, NULL, NULL},
	{"_GetFileExtensionFromUrl", 0x0004DE5F, NULL, NULL},
	{0,0,NULL},
};

struct emu_env_w32_dll_export msvcrt_exports[] = 
{

	{"??0__non_rtti_object@@QAE@ABV0@@Z", 0x0001164B, NULL, NULL},
	{"??0__non_rtti_object@@QAE@PBD@Z", 0x00011629, NULL, NULL},
	{"??0bad_cast@@AAE@PBQBD@Z", 0x000115C2, NULL, NULL},
	{"??0bad_cast@@QAE@ABQBD@Z", 0x000115C2, NULL, NULL},
	{"??0bad_cast@@QAE@ABV0@@Z", 0x00011590, NULL, NULL},
	{"??0bad_cast@@QAE@PBD@Z", 0x0001156D, NULL, NULL},
	{"??0bad_typeid@@QAE@ABV0@@Z", 0x00011607, NULL, NULL},
	{"??0bad_typeid@@QAE@PBD@Z", 0x000115E4, NULL, NULL},
	{"??0exception@@QAE@ABQBD@Z", 0x00011498, NULL, NULL},
	{"??0exception@@QAE@ABV0@@Z", 0x000114E7, NULL, NULL},
	{"??0exception@@QAE@XZ", 0x00011482, NULL, NULL},
	{"??1__non_rtti_object@@UAE@XZ", 0x0001166D, NULL, NULL},
	{"??1bad_cast@@UAE@XZ", 0x000115B2, NULL, NULL},
	{"??1bad_typeid@@UAE@XZ", 0x0001166D, NULL, NULL},
	{"??1exception@@UAE@XZ", 0x00011540, NULL, NULL},
	{"??1type_info@@UAE@XZ", 0x00011868, NULL, NULL},
	{"??2@YAPAXI@Z", 0x00019CC5, NULL, NULL},
	{"??3@YAXPAX@Z", 0x00019CDD, NULL, NULL},
	{"??4__non_rtti_object@@QAEAAV0@ABV0@@Z", 0x0001184C, NULL, NULL},
	{"??4bad_cast@@QAEAAV0@ABV0@@Z", 0x00011830, NULL, NULL},
	{"??4bad_typeid@@QAEAAV0@ABV0@@Z", 0x00011830, NULL, NULL},
	{"??4exception@@QAEAAV0@ABV0@@Z", 0x00011808, NULL, NULL},
	{"??8type_info@@QBEHABV0@@Z", 0x00011898, NULL, NULL},
	{"??9type_info@@QBEHABV0@@Z", 0x000118E1, NULL, NULL},
	{"??_7__non_rtti_object@@6B@", 0x000013F8, NULL, NULL},
	{"??_7bad_cast@@6B@", 0x000013E0, NULL, NULL},
	{"??_7bad_typeid@@6B@", 0x000013EC, NULL, NULL},
	{"??_7exception@@6B@", 0x000013C0, NULL, NULL},
	{"??_E__non_rtti_object@@UAEPAXI@Z", 0x0001178F, NULL, NULL},
	{"??_Ebad_cast@@UAEPAXI@Z", 0x0001172C, NULL, NULL},
	{"??_Ebad_typeid@@UAEPAXI@Z", 0x0001178F, NULL, NULL},
	{"??_Eexception@@UAEPAXI@Z", 0x000116A3, NULL, NULL},
	{"??_Fbad_cast@@QAEXXZ", 0x000116F6, NULL, NULL},
	{"??_Fbad_typeid@@QAEXXZ", 0x0001177F, NULL, NULL},
	{"??_G__non_rtti_object@@UAEPAXI@Z", 0x000117E2, NULL, NULL},
	{"??_Gbad_cast@@UAEPAXI@Z", 0x00011706, NULL, NULL},
	{"??_Gbad_typeid@@UAEPAXI@Z", 0x000117E2, NULL, NULL},
	{"??_Gexception@@UAEPAXI@Z", 0x0001167D, NULL, NULL},
	{"??_U@YAPAXI@Z", 0x00019CED, NULL, NULL},
	{"??_V@YAXPAX@Z", 0x00019CFD, NULL, NULL},
	{"__uncaught_exception", 0x00011BB1, NULL, NULL},
	{"?_query_new_handler@@YAP6AHI@ZXZ", 0x00019D3B, NULL, NULL},
	{"?_query_new_mode@@YAHXZ", 0x00019D94, NULL, NULL},
	{"?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z", 0x00019D0D, NULL, NULL},
	{"?_set_new_mode@@YAHH@Z", 0x00019D6C, NULL, NULL},
	{"?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z", 0x000125AD, NULL, NULL},
	{"?before@type_info@@QBEHABV1@@Z", 0x0001192A, NULL, NULL},
	{"?name@type_info@@QBEPBDXZ", 0x000125D0, NULL, NULL},
	{"?raw_name@type_info@@QBEPBDXZ", 0x00011973, NULL, NULL},
	{"?set_new_handler@@YAP6AXXZP6AXXZ@Z", 0x00019D9F, NULL, NULL},
	{"?set_terminate@@YAP6AXXZP6AXXZ@Z", 0x00012567, NULL, NULL},
	{"?set_unexpected@@YAP6AXXZP6AXXZ@Z", 0x0001258A, NULL, NULL},
	{"?terminate@@YAXXZ", 0x0001266D, NULL, NULL},
	{"?unexpected@@YAXXZ", 0x000126A7, NULL, NULL},
	{"?what@exception@@UBEPBDXZ", 0x0001155B, NULL, NULL},
	{"$I10_OUTPUT", 0x0003B2ED, NULL, NULL},
	{"_CIacos", 0x0003CA40, NULL, NULL},
	{"_CIasin", 0x0003CB10, NULL, NULL},
	{"_CIatan", 0x0003CC20, NULL, NULL},
	{"_CIatan2", 0x0003CD0A, NULL, NULL},
	{"_CIcos", 0x0003CD20, NULL, NULL},
	{"_CIcosh", 0x0003CE02, NULL, NULL},
	{"_CIexp", 0x0003CE5C, NULL, NULL},
	{"_CIfmod", 0x0003CEBA, NULL, NULL},
	{"_CIlog", 0x0003CF20, NULL, NULL},
	{"_CIlog10", 0x0003D080, NULL, NULL},
	{"_CIpow", 0x0003D1E0, NULL, NULL},
	{"_CIsin", 0x0003D430, NULL, NULL},
	{"_CIsinh", 0x0003CDF8, NULL, NULL},
	{"_CIsqrt", 0x0003D4F0, NULL, NULL},
	{"_CItan", 0x0003D5B0, NULL, NULL},
	{"_CItanh", 0x0003CE09, NULL, NULL},
	{"_CxxThrowException", 0x000126F6, NULL, NULL},
	{"_EH_prolog", 0x00012738, NULL, NULL},
	{"_Getdays", 0x00038450, NULL, NULL},
	{"_Getmonths", 0x00038509, NULL, NULL},
	{"_Gettnames", 0x000385C7, NULL, NULL},
	{"_HUGE", 0x000504F0, NULL, NULL},
	{"_Strftime", 0x00039094, NULL, NULL},
	{"_XcptFilter", 0x00022DAE, NULL, NULL},
	{"__CxxCallUnwindDtor", 0x00011D1D, NULL, NULL},
	{"__CxxDetectRethrow", 0x00011C33, NULL, NULL},
	{"__CxxExceptionFilter", 0x0001207D, NULL, NULL},
	{"__CxxFrameHandler", 0x000127FA, NULL, NULL},
	{"__CxxLongjmpUnwind", 0x00012837, NULL, NULL},
	{"__CxxQueryExceptionSize", 0x00011D14, NULL, NULL},
	{"__CxxRegisterExceptionObject", 0x00011BC9, NULL, NULL},
	{"__CxxUnregisterExceptionObject", 0x00011C8B, NULL, NULL},
	{"__DestructExceptionObject", 0x00011B41, NULL, NULL},
	{"__RTCastToVoid", 0x00012D19, NULL, NULL},
	{"__RTDynamicCast", 0x00013079, NULL, NULL},
	{"__RTtypeid", 0x00012BBA, NULL, NULL},
	{"__STRINGTOLD", 0x0003B9CE, NULL, NULL},
	{"___lc_codepage_func", 0x000230F4, NULL, NULL},
	{"___lc_handle_func", 0x00023112, NULL, NULL},
	{"___mb_cur_max_func", 0x000230E9, NULL, NULL},
	{"___setlc_active_func", 0x00023130, NULL, NULL},
	{"___unguarded_readlc_active_add_func", 0x0002313B, NULL, NULL},
	{"__argc", 0x00051A28, NULL, NULL},
	{"__argv", 0x00051A2C, NULL, NULL},
	{"__badioinfo", 0x0004F310, NULL, NULL},
	{"__crtCompareStringA", 0x00023DA5, NULL, NULL},
	{"__crtCompareStringW", 0x00024157, NULL, NULL},
	{"__crtGetLocaleInfoW", 0x000243AE, NULL, NULL},
	{"__crtGetStringTypeW", 0x000244E3, NULL, NULL},
	{"__crtLCMapStringA", 0x00024715, NULL, NULL},
	{"__crtLCMapStringW", 0x00024AE6, NULL, NULL},
	{"__dllonexit", 0x00024E51, NULL, NULL},
	{"__doserrno", 0x0000F2CA, NULL, NULL},
	{"__fpecode", 0x00024FB8, NULL, NULL},
	{"__getmainargs", 0x0000EEEB, NULL, NULL},
	{"__initenv", 0x00051A38, NULL, NULL},
	{"__iob_func", 0x0000F207, NULL, NULL},
	{"__isascii", 0x0000BE0A, NULL, NULL},
	{"__iscsym", 0x0000BE57, NULL, NULL},
	{"__iscsymf", 0x0000BE33, NULL, NULL},
	{"__lc_codepage", 0x000518B4, NULL, NULL},
	{"__lc_collate_cp", 0x000518B8, NULL, NULL},
	{"__lc_handle", 0x0005189C, NULL, NULL},
	{"__lconv_init", 0x0002530B, NULL, NULL},
	{"__mb_cur_max", 0x0004F97C, NULL, NULL},
	{"__p___argc", 0x0000F183, NULL, NULL},
	{"__p___argv", 0x0000F18E, NULL, NULL},
	{"__p___initenv", 0x0000F1F1, NULL, NULL},
	{"__p___mb_cur_max", 0x0000F228, NULL, NULL},
	{"__p___wargv", 0x0000F199, NULL, NULL},
	{"__p___winitenv", 0x0000F1FC, NULL, NULL},
	{"__p__acmdln", 0x0000F162, NULL, NULL},
	{"__p__amblksiz", 0x0000F178, NULL, NULL},
	{"__p__commode", 0x0000F1A4, NULL, NULL},
	{"__p__daylight", 0x0000F1AF, NULL, NULL},
	{"__p__dstbias", 0x0000F1BA, NULL, NULL},
	{"__p__environ", 0x0000F1C5, NULL, NULL},
	{"__p__fileinfo", 0x0000F1E6, NULL, NULL},
	{"__p__fmode", 0x0000F1DB, NULL, NULL},
	{"__p__iob", 0x0000F207, NULL, NULL},
	{"__p__mbcasemap", 0x0000F21D, NULL, NULL},
	{"__p__mbctype", 0x0000F212, NULL, NULL},
	{"__p__osver", 0x0000F233, NULL, NULL},
	{"__p__pctype", 0x0000F23E, NULL, NULL},
	{"__p__pgmptr", 0x0000F254, NULL, NULL},
	{"__p__pwctype", 0x0000F249, NULL, NULL},
	{"__p__timezone", 0x0000F26A, NULL, NULL},
	{"__p__tzname", 0x0000F275, NULL, NULL},
	{"__p__wcmdln", 0x0000F16D, NULL, NULL},
	{"__p__wenviron", 0x0000F1D0, NULL, NULL},
	{"__p__winmajor", 0x0000F280, NULL, NULL},
	{"__p__winminor", 0x0000F28B, NULL, NULL},
	{"__p__winver", 0x0000F296, NULL, NULL},
	{"__p__wpgmptr", 0x0000F25F, NULL, NULL},
	{"__pctype_func", 0x0002533D, NULL, NULL},
	{"__pioinfo", 0x00052440, NULL, NULL},
	{"__pxcptinfoptrs", 0x00024FC6, NULL, NULL},
	{"__set_app_type", 0x0002537C, NULL, NULL},
	{"__setlc_active", 0x0005278C, NULL, NULL},
	{"__setusermatherr", 0x0003D675, NULL, NULL},
	{"__threadhandle", 0x0002A11A, NULL, NULL},
	{"__threadid", 0x0002A10F, NULL, NULL},
	{"__toascii", 0x0000BE21, NULL, NULL},
	{"__unDName", 0x00017897, NULL, NULL},
	{"__unDNameEx", 0x0001793C, NULL, NULL},
	{"__unguarded_readlc_active", 0x00052790, NULL, NULL},
	{"__wargv", 0x00051A30, NULL, NULL},
	{"__wcserror", 0x00025390, NULL, NULL},
	{"__wgetmainargs", 0x0000EE8A, NULL, NULL},
	{"__winitenv", 0x00051A40, NULL, NULL},
	{"_abnormal_termination", 0x00025517, NULL, NULL},
	{"_access", 0x0000F355, NULL, NULL},
	{"_acmdln", 0x000517AC, NULL, NULL},
	{"_adj_fdiv_m16i", 0x0003DD24, NULL, NULL},
	{"_adj_fdiv_m32", 0x0003DC8C, NULL, NULL},
	{"_adj_fdiv_m32i", 0x0003DD58, NULL, NULL},
	{"_adj_fdiv_m64", 0x0003DCD8, NULL, NULL},
	{"_adj_fdiv_r", 0x0003D7C7, NULL, NULL},
	{"_adj_fdivr_m16i", 0x0003DE24, NULL, NULL},
	{"_adj_fdivr_m32", 0x0003DD8C, NULL, NULL},
	{"_adj_fdivr_m32i", 0x0003DE58, NULL, NULL},
	{"_adj_fdivr_m64", 0x0003DDD8, NULL, NULL},
	{"_adj_fpatan", 0x0003E435, NULL, NULL},
	{"_adj_fprem", 0x0003E0BC, NULL, NULL},
	{"_adj_fprem1", 0x0003E374, NULL, NULL},
	{"_adj_fptan", 0x0003E438, NULL, NULL},
	{"_adjust_fdiv", 0x000523D8, NULL, NULL},
	{"_aexit_rtn", 0x0004D000, NULL, NULL},
	{"_aligned_free", 0x00019E33, NULL, NULL},
	{"_aligned_malloc", 0x00019E52, NULL, NULL},
	{"_aligned_offset_malloc", 0x00019DAF, NULL, NULL},
	{"_aligned_offset_realloc", 0x00019E6E, NULL, NULL},
	{"_aligned_realloc", 0x00019FC6, NULL, NULL},
	{"_amsg_exit", 0x0000F125, NULL, NULL},
	{"_assert", 0x00025566, NULL, NULL},
	{"_atodbl", 0x0003BE70, NULL, NULL},
	{"_atoi64", 0x0000BF28, NULL, NULL},
	{"_atoldbl", 0x0003BEB8, NULL, NULL},
	{"_beep", 0x0000E10A, NULL, NULL},
	{"_beginthread", 0x0002A26E, NULL, NULL},
	{"_beginthreadex", 0x0002A3DB, NULL, NULL},
	{"_c_exit", 0x00029ECE, NULL, NULL},
	{"_cabs", 0x0003E6E8, NULL, NULL},
	{"_callnewh", 0x00019D46, NULL, NULL},
	{"_cexit", 0x00029EB6, NULL, NULL},
	{"_cgets", 0x0001CAB0, NULL, NULL},
	{"_cgetws", 0x0001CB91, NULL, NULL},
	{"_chdir", 0x0000F3A5, NULL, NULL},
	{"_chdrive", 0x0000F4AC, NULL, NULL},
	{"_chgsign", 0x0003E736, NULL, NULL},
	{"_chkesp", 0x00025BBC, NULL, NULL},
	{"_chmod", 0x0000F53F, NULL, NULL},
	{"_chsize", 0x0001CFAE, NULL, NULL},
	{"_clearfp", 0x0003EDDA, NULL, NULL},
	{"_close", 0x0001D0D7, NULL, NULL},
	{"_commit", 0x0001D177, NULL, NULL},
	{"_commode", 0x000521FC, NULL, NULL},
	{"_control87", 0x0003EDF5, NULL, NULL},
	{"_controlfp", 0x0003EE2F, NULL, NULL},
	{"_copysign", 0x0003E70E, NULL, NULL},
	{"_cprintf", 0x0002C388, NULL, NULL},
	{"_cputs", 0x0001D238, NULL, NULL},
	{"_cputws", 0x0001D35D, NULL, NULL},
	{"_creat", 0x0001D40F, NULL, NULL},
	{"_cscanf", 0x0002D0BB, NULL, NULL},
	{"_ctime64", 0x000390EF, NULL, NULL},
	{"_ctype", 0x000028A0, NULL, NULL},
	{"_cwait", 0x000181BD, NULL, NULL},
	{"_cwprintf", 0x0002DB3B, NULL, NULL},
	{"_cwscanf", 0x0002E94F, NULL, NULL},
	{"_daylight", 0x0004FFD4, NULL, NULL},
	{"_dstbias", 0x0004FFD8, NULL, NULL},
	{"_dup", 0x0001D4F4, NULL, NULL},
	{"_dup2", 0x0001D70D, NULL, NULL},
	{"_ecvt", 0x0000C0A2, NULL, NULL},
	{"_endthread", 0x0002A194, NULL, NULL},
	{"_endthreadex", 0x0002A307, NULL, NULL},
	{"_environ", 0x00051A34, NULL, NULL},
	{"_eof", 0x0001D7DD, NULL, NULL},
	{"_errno", 0x0000F2BC, NULL, NULL},
	{"_except_handler2", 0x00025BDC, NULL, NULL},
	{"_except_handler3", 0x00025C94, NULL, NULL},
	{"_execl", 0x00018253, NULL, NULL},
	{"_execle", 0x00018270, NULL, NULL},
	{"_execlp", 0x00018299, NULL, NULL},
	{"_execlpe", 0x000182B3, NULL, NULL},
	{"_execv", 0x000182DC, env_w32_hook__execv, NULL},
	{"_execve", 0x00018351, NULL, NULL},
	{"_execvp", 0x000184DF, NULL, NULL},
	{"_execvpe", 0x000184FB, NULL, NULL},
	{"_exit", 0x00029E9A, NULL, NULL},
	{"_expand", 0x00019FE5, NULL, NULL},
	{"_fcloseall", 0x0002E968, NULL, NULL},
	{"_fcvt", 0x0000C054, NULL, NULL},
	{"_fdopen", 0x0002EA08, NULL, NULL},
	{"_fgetchar", 0x0002EB2A, NULL, NULL},
	{"_fgetwchar", 0x0002EB45, NULL, NULL},
	{"_filbuf", 0x0002EB60, NULL, NULL},
	{"_fileinfo", 0x0004D2A0, NULL, NULL},
	{"_filelength", 0x0001D8E2, NULL, NULL},
	{"_filelengthi64", 0x0001D9BB, NULL, NULL},
	{"_fileno", 0x0002EC4B, NULL, NULL},
	{"_findclose", 0x0000E122, NULL, NULL},
	{"_findfirst", 0x0000E1B8, NULL, NULL},
	{"_findfirst64", 0x0000E3F8, NULL, NULL},
	{"_findfirsti64", 0x0000E61B, NULL, NULL},
	{"_findnext", 0x0000E2A4, NULL, NULL},
	{"_findnext64", 0x0000E50C, NULL, NULL},
	{"_findnexti64", 0x0000E726, NULL, NULL},
	{"_finite", 0x0003EB1E, NULL, NULL},
	{"_flsbuf", 0x0002EC5D, NULL, NULL},
	{"_flushall", 0x0002EF4B, NULL, NULL},
	{"_fmode", 0x0005185C, NULL, NULL},
	{"_fpclass", 0x0003EB74, NULL, NULL},
	{"_fpieee_flt", 0x0003F38E, NULL, NULL},
	{"_fpreset", 0x0003EC17, NULL, NULL},
	{"_fputchar", 0x0002EF59, NULL, NULL},
	{"_fputwchar", 0x0002EF84, NULL, NULL},
	{"_fsopen", 0x0002EFAF, NULL, NULL},
	{"_fstat", 0x0001DAB4, NULL, NULL},
	{"_fstat64", 0x0001DD75, NULL, NULL},
	{"_fstati64", 0x0001E07A, NULL, NULL},
	{"_ftime", 0x00039113, NULL, NULL},
	{"_ftime64", 0x00039224, NULL, NULL},
	{"_ftol", 0x0003FA10, NULL, NULL},
	{"_fullpath", 0x0000F589, NULL, NULL},
	{"_futime", 0x00039351, NULL, NULL},
	{"_futime64", 0x000394DE, NULL, NULL},
	{"_gcvt", 0x0000C0FA, NULL, NULL},
	{"_get_heap_handle", 0x0001A401, NULL, NULL},
	{"_get_osfhandle", 0x0001E468, NULL, NULL},
	{"_get_sbh_threshold", 0x0001A40C, NULL, NULL},
	{"_getch", 0x0001EAA1, NULL, NULL},
	{"_getche", 0x0001EAC4, NULL, NULL},
	{"_getcwd", 0x0000F785, NULL, NULL},
	{"_getdcwd", 0x0000F7D0, NULL, NULL},
	{"_getdiskfree", 0x0000E82C, NULL, NULL},
	{"_getdllprocaddr", 0x000186B2, NULL, NULL},
	{"_getdrive", 0x0000F452, NULL, NULL},
	{"_getdrives", 0x0000E885, NULL, NULL},
	{"_getmaxstdio", 0x0002F12C, NULL, NULL},
	{"_getmbcp", 0x00020838, NULL, NULL},
	{"_getpid", 0x0000F81C, NULL, NULL},
	{"_getsystime", 0x00039671, NULL, NULL},
	{"_getw", 0x0002F137, NULL, NULL},
	{"_getwch", 0x0001ECF6, NULL, NULL},
	{"_getwche", 0x0001ED1A, NULL, NULL},
	{"_getws", 0x0002F1B9, NULL, NULL},
	{"_global_unwind2", 0x0002544C, NULL, NULL},
	{"_gmtime64", 0x00039743, NULL, NULL},
	{"_heapadd", 0x0001BC9F, NULL, NULL},
	{"_heapchk", 0x0001BCB3, NULL, NULL},
	{"_heapmin", 0x0001BD8C, NULL, NULL},
	{"_heapset", 0x0001BD82, NULL, NULL},
	{"_heapused", 0x0001BE3A, NULL, NULL},
	{"_heapwalk", 0x0001BE4D, NULL, NULL},
	{"_hypot", 0x0003E6C2, NULL, NULL},
	{"_i64toa", 0x0000C2E1, NULL, NULL},
	{"_i64tow", 0x0000C489, NULL, NULL},
	{"_initterm", 0x00029D67, NULL, NULL},
	{"_inp", 0x0001ED70, NULL, NULL},
	{"_inpd", 0x0001ED81, NULL, NULL},
	{"_inpw", 0x0001ED79, NULL, NULL},
	{"_iob", 0x0004FC80, NULL, NULL},
	{"_isatty", 0x0001ED8D, NULL, NULL},
	{"_isctype", 0x0000C561, NULL, NULL},
	{"_ismbbalnum", 0x00020A3C, NULL, NULL},
	{"_ismbbalpha", 0x00020A5A, NULL, NULL},
	{"_ismbbgraph", 0x00020A78, NULL, NULL},
	{"_ismbbkalnum", 0x000209EB, NULL, NULL},
	{"_ismbbkana", 0x00020B05, NULL, NULL},
	{"_ismbbkprint", 0x00020A06, NULL, NULL},
	{"_ismbbkpunct", 0x00020A21, NULL, NULL},
	{"_ismbblead", 0x00020ACF, NULL, NULL},
	{"_ismbbprint", 0x00020A96, NULL, NULL},
	{"_ismbbpunct", 0x00020AB4, NULL, NULL},
	{"_ismbbtrail", 0x00020AEA, NULL, NULL},
	{"_ismbcalnum", 0x00020B37, NULL, NULL},
	{"_ismbcalpha", 0x00020BD1, NULL, NULL},
	{"_ismbcdigit", 0x00020C6B, NULL, NULL},
	{"_ismbcgraph", 0x00020CF6, NULL, NULL},
	{"_ismbchira", 0x00020D90, NULL, NULL},
	{"_ismbckata", 0x00020DC1, NULL, NULL},
	{"_ismbcl0", 0x00020E35, NULL, NULL},
	{"_ismbcl1", 0x00020E8A, NULL, NULL},
	{"_ismbcl2", 0x00020EE7, NULL, NULL},
	{"_ismbclegal", 0x00020F44, NULL, NULL},
	{"_ismbclower", 0x00020F87, NULL, NULL},
	{"_ismbcprint", 0x00021018, NULL, NULL},
	{"_ismbcpunct", 0x000210B2, NULL, NULL},
	{"_ismbcspace", 0x00021148, NULL, NULL},
	{"_ismbcsymbol", 0x00020DFB, NULL, NULL},
	{"_ismbcupper", 0x000211D3, NULL, NULL},
	{"_ismbslead", 0x000212A8, NULL, NULL},
	{"_ismbstrail", 0x000212D8, NULL, NULL},
	{"_isnan", 0x0003EB3D, NULL, NULL},
	{"_itoa", 0x0000C1F3, NULL, NULL},
	{"_itow", 0x0000C392, NULL, NULL},
	{"_j0", 0x0003FA90, NULL, NULL},
	{"_j1", 0x0003FB8A, NULL, NULL},
	{"_jn", 0x0003FCA4, NULL, NULL},
	{"_kbhit", 0x0001EAE7, NULL, NULL},
	{"_lfind", 0x00025D9A, NULL, NULL},
	{"_loaddll", 0x000186E8, NULL, NULL},
	{"_local_unwind2", 0x000254A7, NULL, NULL},
	{"_localtime64", 0x0003996F, NULL, NULL},
	{"_lock", 0x0002A5BB, NULL, NULL},
	{"_locking", 0x0001EE84, NULL, NULL},
	{"_logb", 0x0003E782, NULL, NULL},
	{"_longjmpex", 0x00025DD4, NULL, NULL},
	{"_lrotl", 0x00025DDE, NULL, NULL},
	{"_lrotr", 0x00025E02, NULL, NULL},
	{"_lsearch", 0x00025E26, NULL, NULL},
	{"_lseek", 0x0001EFB0, NULL, NULL},
	{"_lseeki64", 0x0001F0EA, NULL, NULL},
	{"_ltoa", 0x0000C222, NULL, NULL},
	{"_ltow", 0x0000C3C1, NULL, NULL},
	{"_makepath", 0x00025E76, NULL, NULL},
	{"_mbbtombc", 0x0002132C, NULL, NULL},
	{"_mbbtype", 0x0002146F, NULL, NULL},
	{"_mbcasemap", 0x00052680, NULL, NULL},
	{"_mbccpy", 0x0002149F, NULL, NULL},
	{"_mbcjistojms", 0x000214C7, NULL, NULL},
	{"_mbcjmstojis", 0x00021534, NULL, NULL},
	{"_mbclen", 0x000215E8, NULL, NULL},
	{"_mbctohira", 0x00021608, NULL, NULL},
	{"_mbctokata", 0x00021644, NULL, NULL},
	{"_mbctolower", 0x00021671, NULL, NULL},
	{"_mbctombb", 0x0002139E, NULL, NULL},
	{"_mbctoupper", 0x000216FD, NULL, NULL},
	{"_mbctype", 0x00052560, NULL, NULL},
	{"_mbsbtype", 0x000217CF, NULL, NULL},
	{"_mbscat", 0x00036040, NULL, NULL},
	{"_mbschr", 0x000217FF, NULL, NULL},
	{"_mbscmp", 0x00021881, NULL, NULL},
	{"_mbscoll", 0x00021944, NULL, NULL},
	{"_mbscpy", 0x00036030, NULL, NULL},
	{"_mbscspn", 0x00021A0B, NULL, NULL},
	{"_mbsdec", 0x00021A3B, NULL, NULL},
	{"_mbsdup", 0x00036125, NULL, NULL},
	{"_mbsicmp", 0x00021AA3, NULL, NULL},
	{"_mbsicoll", 0x00021BF5, NULL, NULL},
	{"_mbsinc", 0x00021C3E, NULL, NULL},
	{"_mbslen", 0x00021C5F, NULL, NULL},
	{"_mbslwr", 0x00021CBA, NULL, NULL},
	{"_mbsnbcat", 0x00021D46, NULL, NULL},
	{"_mbsnbcmp", 0x00021E1D, NULL, NULL},
	{"_mbsnbcnt", 0x00021F38, NULL, NULL},
	{"_mbsnbcoll", 0x00021F68, NULL, NULL},
	{"_mbsnbcpy", 0x00021FBD, NULL, NULL},
	{"_mbsnbicmp", 0x00022057, NULL, NULL},
	{"_mbsnbicoll", 0x000221CD, NULL, NULL},
	{"_mbsnbset", 0x00022222, NULL, NULL},
	{"_mbsncat", 0x0002229D, NULL, NULL},
	{"_mbsnccnt", 0x00022360, NULL, NULL},
	{"_mbsncmp", 0x000223B7, NULL, NULL},
	{"_mbsncoll", 0x00022463, NULL, NULL},
	{"_mbsncpy", 0x000224D4, NULL, NULL},
	{"_mbsnextc", 0x00022563, NULL, NULL},
	{"_mbsnicmp", 0x0002258B, NULL, NULL},
	{"_mbsnicoll", 0x000226D8, NULL, NULL},
	{"_mbsninc", 0x00022749, NULL, NULL},
	{"_mbsnset", 0x0002276F, NULL, NULL},
	{"_mbspbrk", 0x000228D3, NULL, NULL},
	{"_mbsrchr", 0x00022903, NULL, NULL},
	{"_mbsrev", 0x00022975, NULL, NULL},
	{"_mbsset", 0x000229E8, NULL, NULL},
	{"_mbsspn", 0x00022AC4, NULL, NULL},
	{"_mbsspnp", 0x00022B80, NULL, NULL},
	{"_mbsstr", 0x00022BB0, NULL, NULL},
	{"_mbstok", 0x00022C70, NULL, NULL},
	{"_mbstrlen", 0x0000C591, NULL, NULL},
	{"_mbsupr", 0x00022D22, NULL, NULL},
	{"_memccpy", 0x00036170, NULL, NULL},
	{"_memicmp", 0x000361C8, NULL, NULL},
	{"_mkdir", 0x0000F827, NULL, NULL},
	{"_mktemp", 0x0001F1AD, NULL, NULL},
	{"_mktime64", 0x00039DCE, NULL, NULL},
	{"_msize", 0x0001BF6C, NULL, NULL},
	{"_nextafter", 0x0003E874, NULL, NULL},
	{"_onexit", 0x00024DF8, NULL, NULL},
	{"_open", 0x0001F566, NULL, NULL},
	{"_open_osfhandle", 0x0001E6B2, NULL, NULL},
	{"_osplatform", 0x00051A14, NULL, NULL},
	{"_osver", 0x00051A18, NULL, NULL},
	{"_outp", 0x0001F620, NULL, NULL},
	{"_outpd", 0x0001F63A, NULL, NULL},
	{"_outpw", 0x0001F62D, NULL, NULL},
	{"_pclose", 0x0002F6DD, NULL, NULL},
	{"_pctype", 0x0004F988, NULL, NULL},
	{"_pgmptr", 0x00051A44, NULL, NULL},
	{"_pipe", 0x0001F64A, NULL, NULL},
	{"_popen", 0x0002F290, NULL, NULL},
	{"_purecall", 0x00025F0D, NULL, NULL},
	{"_putch", 0x0001F894, NULL, NULL},
	{"_putenv", 0x00025FCC, NULL, NULL},
	{"_putw", 0x0002F771, NULL, NULL},
	{"_putwch", 0x0001D3CA, NULL, NULL},
	{"_putws", 0x0002F7F6, NULL, NULL},
	{"_pwctype", 0x0004F98C, NULL, NULL},
	{"_read", 0x0001FAA3, NULL, NULL},
	{"_resetstkoflw", 0x0001C03F, NULL, NULL},
	{"_rmdir", 0x0000F85E, NULL, NULL},
	{"_rmtmp", 0x0002F88A, NULL, NULL},
	{"_rotl", 0x00025DDE, NULL, NULL},
	{"_rotr", 0x00025E02, NULL, NULL},
	{"_safe_fdiv", 0x0003DE8C, NULL, NULL},
	{"_safe_fdivr", 0x0003DEA1, NULL, NULL},
	{"_safe_fprem", 0x0003E429, NULL, NULL},
	{"_safe_fprem1", 0x0003E42F, NULL, NULL},
	{"_scalb", 0x0003E763, NULL, NULL},
	{"_scprintf", 0x0002F990, NULL, NULL},
	{"_scwprintf", 0x0002FA3E, NULL, NULL},
	{"_searchenv", 0x00026010, NULL, NULL},
	{"_seh_longjmp_unwind", 0x00025D7A, NULL, NULL},
	{"_set_SSE2_enable", 0x00040265, NULL, NULL},
	{"_set_error_mode", 0x00025348, NULL, NULL},
	{"_set_sbh_threshold", 0x0001B6E0, NULL, NULL},
	{"_seterrormode", 0x0000E890, NULL, NULL},
	{"_setjmp", 0x0002615C, NULL, NULL},
	{"_setjmp3", 0x0002619C, NULL, NULL},
	{"_setmaxstdio", 0x0002F02C, NULL, NULL},
	{"_setmbcp", 0x0002084D, NULL, NULL},
	{"_setmode", 0x0001FBC7, NULL, NULL},
	{"_setsystime", 0x000396D3, NULL, NULL},
	{"_sleep", 0x0000E0E8, NULL, NULL},
	{"_snprintf", 0x0002FA76, NULL, NULL},
	{"_snscanf", 0x0002FAD4, NULL, NULL},
	{"_snwprintf", 0x0002FB0C, NULL, NULL},
	{"_snwscanf", 0x0002FB83, NULL, NULL},
	{"_sopen", 0x0001F5C0, NULL, NULL},
	{"_spawnl", 0x0001871F, NULL, NULL},
	{"_spawnle", 0x0001873F, NULL, NULL},
	{"_spawnlp", 0x0001876B, NULL, NULL},
	{"_spawnlpe", 0x00018789, NULL, NULL},
	{"_spawnv", 0x000187B5, NULL, NULL},
	{"_spawnve", 0x0001882E, NULL, NULL},
	{"_spawnvp", 0x000189C5, NULL, NULL},
	{"_spawnvpe", 0x000189E4, NULL, NULL},
	{"_splitpath", 0x0002621C, NULL, NULL},
	{"_stat", 0x0000F959, NULL, NULL},
	{"_stat64", 0x0000FCA2, NULL, NULL},
	{"_stati64", 0x000100A8, NULL, NULL},
	{"_statusfp", 0x0003EDC0, NULL, NULL},
	{"_strcmpi", 0x0003624E, NULL, NULL},
	{"_strdate", 0x00039DE5, NULL, NULL},
	{"_strdup", 0x00036125, NULL, NULL},
	{"_strerror", 0x00026372, NULL, NULL},
	{"_stricmp", 0x0003624E, NULL, NULL},
	{"_stricoll", 0x000362BE, NULL, NULL},
	{"_strlwr", 0x00036320, NULL, NULL},
	{"_strncoll", 0x0003643F, NULL, NULL},
	{"_strnicmp", 0x000364BF, NULL, NULL},
	{"_strnicoll", 0x00036545, NULL, NULL},
	{"_strnset", 0x000365D0, NULL, NULL},
	{"_strrev", 0x00036600, NULL, NULL},
	{"_strset", 0x00036640, NULL, NULL},
	{"_strtime", 0x00039E5C, NULL, NULL},
	{"_strtoi64", 0x0000C877, NULL, NULL},
	{"_strtoui64", 0x0000C896, NULL, NULL},
	{"_strupr", 0x00036665, NULL, NULL},
	{"_swab", 0x0000C8B5, NULL, NULL},
	{"_sys_errlist", 0x0004F9D8, NULL, NULL},
	{"_sys_nerr", 0x0004FA88, NULL, NULL},
	{"_tell", 0x0001FC63, NULL, NULL},
	{"_telli64", 0x0001FC7E, NULL, NULL},
	{"_tempnam", 0x0002FC13, NULL, NULL},
	{"_time64", 0x00039ECA, NULL, NULL},
	{"_timezone", 0x0004FFD0, NULL, NULL},
	{"_tolower", 0x0000C8E8, NULL, NULL},
	{"_toupper", 0x0000C9F5, NULL, NULL},
	{"_tzname", 0x00050060, NULL, NULL},
	{"_tzset", 0x0003A541, NULL, NULL},
	{"_ui64toa", 0x0000C319, NULL, NULL},
	{"_ui64tow", 0x0000C4C1, NULL, NULL},
	{"_ultoa", 0x0000C24E, NULL, NULL},
	{"_ultow", 0x0000C3ED, NULL, NULL},
	{"_umask", 0x0002645B, NULL, NULL},
	{"_ungetch", 0x0001EA76, NULL, NULL},
	{"_ungetwch", 0x0001ED3E, NULL, NULL},
	{"_unlink", 0x0001043E, NULL, NULL},
	{"_unloaddll", 0x000186FD, NULL, NULL},
	{"_unlock", 0x0002A519, NULL, NULL},
	{"_utime", 0x0003949E, NULL, NULL},
	{"_utime64", 0x00039631, NULL, NULL},
	{"_vscprintf", 0x0002FEA7, NULL, NULL},
	{"_vscwprintf", 0x0002FF53, NULL, NULL},
	{"_vsnprintf", 0x0002FF8A, NULL, NULL},
	{"_vsnwprintf", 0x0002FFE7, NULL, NULL},
	{"_waccess", 0x0001044E, NULL, NULL},
	{"_wasctime", 0x0003A5A9, NULL, NULL},
	{"_wchdir", 0x0001049E, NULL, NULL},
	{"_wchmod", 0x00010544, NULL, NULL},
	{"_wcmdln", 0x000517A8, NULL, NULL},
	{"_wcreat", 0x0001FC9B, NULL, NULL},
	{"_wcsdup", 0x00036784, NULL, NULL},
	{"_wcserror", 0x0002647B, NULL, NULL},
	{"_wcsicmp", 0x000367BD, NULL, NULL},
	{"_wcsicoll", 0x00036871, NULL, NULL},
	{"_wcslwr", 0x00036917, NULL, NULL},
	{"_wcsncoll", 0x00036A3B, NULL, NULL},
	{"_wcsnicmp", 0x00036ABB, NULL, NULL},
	{"_wcsnicoll", 0x00036B82, NULL, NULL},
	{"_wcsnset", 0x00036C46, NULL, NULL},
	{"_wcsrev", 0x00036C76, NULL, NULL},
	{"_wcsset", 0x00036CB2, NULL, NULL},
	{"_wcstoi64", 0x0000CD5D, NULL, NULL},
	{"_wcstoui64", 0x0000CD7C, NULL, NULL},
	{"_wcsupr", 0x00036CD4, NULL, NULL},
	{"_wctime", 0x0003A690, NULL, NULL},
	{"_wctime64", 0x0003A6B4, NULL, NULL},
	{"_wenviron", 0x00051A3C, NULL, NULL},
	{"_wexecl", 0x00018BA8, NULL, NULL},
	{"_wexecle", 0x00018BC5, NULL, NULL},
	{"_wexeclp", 0x00018BEE, NULL, NULL},
	{"_wexeclpe", 0x00018C08, NULL, NULL},
	{"_wexecv", 0x00018C31, NULL, NULL},
	{"_wexecve", 0x00018CA6, NULL, NULL},
	{"_wexecvp", 0x00018DEA, NULL, NULL},
	{"_wexecvpe", 0x00018E06, NULL, NULL},
	{"_wfdopen", 0x0003005D, NULL, NULL},
	{"_wfindfirst", 0x0000E8A5, NULL, NULL},
	{"_wfindfirst64", 0x0000EA6A, NULL, NULL},
	{"_wfindfirsti64", 0x0000EC83, NULL, NULL},
	{"_wfindnext", 0x0000E98A, NULL, NULL},
	{"_wfindnext64", 0x0000EB79, NULL, NULL},
	{"_wfindnexti64", 0x0000ED89, NULL, NULL},
	{"_wfopen", 0x000301E7, NULL, NULL},
	{"_wfreopen", 0x00030203, NULL, NULL},
	{"_wfsopen", 0x00030186, NULL, NULL},
	{"_wfullpath", 0x0001058E, NULL, NULL},
	{"_wgetcwd", 0x00010740, NULL, NULL},
	{"_wgetdcwd", 0x0001078B, NULL, NULL},
	{"_wgetenv", 0x0002655C, NULL, NULL},
	{"_winmajor", 0x00051A20, NULL, NULL},
	{"_winminor", 0x00051A24, NULL, NULL},
	{"_winver", 0x00051A1C, NULL, NULL},
	{"_wmakepath", 0x000265A0, NULL, NULL},
	{"_wmkdir", 0x000107D7, NULL, NULL},
	{"_wmktemp", 0x0001FCBA, NULL, NULL},
	{"_wopen", 0x00020055, NULL, NULL},
	{"_wperror", 0x00026658, NULL, NULL},
	{"_wpgmptr", 0x00051A48, NULL, NULL},
	{"_wpopen", 0x0003026E, NULL, NULL},
	{"_wputenv", 0x00026811, NULL, NULL},
	{"_wremove", 0x0001080E, NULL, NULL},
	{"_wrename", 0x00010853, NULL, NULL},
	{"_write", 0x00020303, NULL, NULL},
	{"_wrmdir", 0x0001088B, NULL, NULL},
	{"_wsearchenv", 0x00026855, NULL, NULL},
	{"_wsetlocale", 0x00026990, NULL, NULL},
	{"_wsopen", 0x000200AF, NULL, NULL},
	{"_wspawnl", 0x00018F5E, NULL, NULL},
	{"_wspawnle", 0x00018F7E, NULL, NULL},
	{"_wspawnlp", 0x00018FAA, NULL, NULL},
	{"_wspawnlpe", 0x00018FC8, NULL, NULL},
	{"_wspawnv", 0x00018FF4, NULL, NULL},
	{"_wspawnve", 0x0001906D, NULL, NULL},
	{"_wspawnvp", 0x000191B7, NULL, NULL},
	{"_wspawnvpe", 0x000191D6, NULL, NULL},
	{"_wsplitpath", 0x00026A51, NULL, NULL},
	{"_wstat", 0x0001098C, NULL, NULL},
	{"_wstat64", 0x00010D65, NULL, NULL},
	{"_wstati64", 0x000110EB, NULL, NULL},
	{"_wstrdate", 0x0003A6D8, NULL, NULL},
	{"_wstrtime", 0x0003A75C, NULL, NULL},
	{"_wsystem", 0x0001931E, NULL, NULL},
	{"_wtempnam", 0x00030697, NULL, NULL},
	{"_wtmpnam", 0x00030931, NULL, NULL},
	{"_wtof", 0x0000CD9B, NULL, NULL},
	{"_wtoi", 0x0000CEE3, NULL, NULL},
	{"_wtoi64", 0x0000CEF3, NULL, NULL},
	{"_wtol", 0x0000CE77, NULL, NULL},
	{"_wunlink", 0x00010843, NULL, NULL},
	{"_wutime", 0x0003A7DA, NULL, NULL},
	{"_wutime64", 0x0003A81A, NULL, NULL},
	{"_y0", 0x0003FE69, NULL, NULL},
	{"_y1", 0x0003FF9C, NULL, NULL},
	{"_yn", 0x000400DF, NULL, NULL},
	{"abort", 0x00026BB3, NULL, NULL},
	{"abs", 0x00026BD0, NULL, NULL},
	{"acos", 0x0003CA54, NULL, NULL},
	{"asctime", 0x0003A85A, NULL, NULL},
	{"asin", 0x0003CB24, NULL, NULL},
	{"atan", 0x0003CBE0, NULL, NULL},
	{"atan2", 0x0003CD00, NULL, NULL},
	{"atexit", 0x00024E35, NULL, NULL},
	{"atof", 0x0000CF90, NULL, NULL},
	{"atoi", 0x0000BF18, NULL, NULL},
	{"atol", 0x0000BE7B, NULL, NULL},
	{"bsearch", 0x00026BE5, NULL, NULL},
	{"calloc", 0x0001C0C3, NULL, NULL},
	{"ceil", 0x00040290, NULL, NULL},
	{"clearerr", 0x000309F1, NULL, NULL},
	{"clock", 0x0003A969, NULL, NULL},
	{"cos", 0x0003CD34, NULL, NULL},
	{"cosh", 0x0003CDEA, NULL, NULL},
	{"ctime", 0x0003A9F1, NULL, NULL},
	{"difftime", 0x0003AA15, NULL, NULL},
	{"div", 0x00026D46, NULL, NULL},
	{"exit", 0x00029E7E, NULL, NULL},
	{"exp", 0x0003CE20, NULL, NULL},
	{"fabs", 0x000403B2, NULL, NULL},
	{"fclose", 0x00030AB1, env_w32_hook_fclose, NULL},
	{"feof", 0x00030B07, NULL, NULL},
	{"ferror", 0x00030B1C, NULL, NULL},
	{"fflush", 0x0002EEF6, NULL, NULL},
	{"fgetc", 0x00030B31, NULL, NULL},
	{"fgetpos", 0x00030B86, NULL, NULL},
	{"fgets", 0x00030BB1, NULL, NULL},
	{"fgetwc", 0x00030D37, NULL, NULL},
	{"fgetws", 0x00030D8E, NULL, NULL},
	{"floor", 0x00040470, NULL, NULL},
	{"fmod", 0x0003CEB0, NULL, NULL},
	{"fopen", 0x0002F010, env_w32_hook_fopen, NULL},
	{"fprintf", 0x00030E13, NULL, NULL},
	{"fputc", 0x00030E76, NULL, NULL},
	{"fputs", 0x00030ED3, NULL, NULL},
	{"fputwc", 0x0003102C, NULL, NULL},
	{"fputws", 0x00031089, NULL, NULL},
	{"fread", 0x000311FB, NULL, NULL},
	{"free", 0x0001C21B, NULL, NULL},
	{"freopen", 0x0003124C, NULL, NULL},
	{"frexp", 0x00040596, NULL, NULL},
	{"fscanf", 0x000312B7, NULL, NULL},
	{"fseek", 0x0003139C, NULL, NULL},
	{"fsetpos", 0x000313EA, NULL, NULL},
	{"ftell", 0x00031574, NULL, NULL},
	{"fwprintf", 0x000315BA, NULL, NULL},
	{"fwrite", 0x0003173B, env_w32_hook_fwrite, NULL},
	{"fwscanf", 0x0003178C, NULL, NULL},
	{"getc", 0x00030B31, NULL, NULL},
	{"getchar", 0x0002EB3B, NULL, NULL},
	{"getenv", 0x00026D02, NULL, NULL},
	{"gets", 0x000317DB, NULL, NULL},
	{"getwc", 0x00030D7E, NULL, NULL},
	{"getwchar", 0x0002EB56, NULL, NULL},
	{"gmtime", 0x0003AA2D, NULL, NULL},
	{"is_wctype", 0x0000D090, NULL, NULL},
	{"isalnum", 0x0000BCEB, NULL, NULL},
	{"isalpha", 0x0000BB05, NULL, NULL},
	{"iscntrl", 0x0000BDC6, NULL, NULL},
	{"isdigit", 0x0000BBD6, NULL, NULL},
	{"isgraph", 0x0000BD7D, NULL, NULL},
	{"isleadbyte", 0x0000D0A0, NULL, NULL},
	{"islower", 0x0000BB92, NULL, NULL},
	{"isprint", 0x0000BD34, NULL, NULL},
	{"ispunct", 0x0000BCA7, NULL, NULL},
	{"isspace", 0x0000BC63, NULL, NULL},
	{"isupper", 0x0000BB4E, NULL, NULL},
	{"iswalnum", 0x0000D16D, NULL, NULL},
	{"iswalpha", 0x0000D0BF, NULL, NULL},
	{"iswascii", 0x0000D1D6, NULL, NULL},
	{"iswcntrl", 0x0000D1BE, NULL, NULL},
	{"iswctype", 0x0000D036, NULL, NULL},
	{"iswdigit", 0x0000D10A, NULL, NULL},
	{"iswgraph", 0x0000D1A3, NULL, NULL},
	{"iswlower", 0x0000D0F2, NULL, NULL},
	{"iswprint", 0x0000D188, NULL, NULL},
	{"iswpunct", 0x0000D155, NULL, NULL},
	{"iswspace", 0x0000D13D, NULL, NULL},
	{"iswupper", 0x0000D0DA, NULL, NULL},
	{"iswxdigit", 0x0000D122, NULL, NULL},
	{"isxdigit", 0x0000BC1A, NULL, NULL},
	{"labs", 0x00026BD0, NULL, NULL},
	{"ldexp", 0x00040649, NULL, NULL},
	{"ldiv", 0x00026D46, NULL, NULL},
	{"localeconv", 0x00026D67, NULL, NULL},
	{"localtime", 0x0003AB3D, NULL, NULL},
	{"log", 0x0003CEE0, NULL, NULL},
	{"log10", 0x0003D040, NULL, NULL},
	{"longjmp", 0x00026D74, NULL, NULL},
	{"malloc", 0x0001C407, env_w32_hook_malloc, NULL},
	{"mblen", 0x0000D1EC, NULL, NULL},
	{"mbstowcs", 0x0000D380, NULL, NULL},
	{"mbtowc", 0x0000D47A, NULL, NULL},
	{"memchr", 0x00036E00, NULL, NULL},
	{"memcmp", 0x00036EB0, NULL, NULL},
	{"memcpy", 0x00036F70, NULL, NULL},
	{"memmove", 0x000372B0, NULL, NULL},
	{"memset", 0x000375F0, env_w32_hook_memset, NULL},
	{"mktime", 0x0003AE8C, NULL, NULL},
	{"modf", 0x00040840, NULL, NULL},
	{"perror", 0x00026DF2, NULL, NULL},
	{"pow", 0x0003D1A0, NULL, NULL},
	{"printf", 0x0003186A, NULL, NULL},
	{"putc", 0x00030E76, NULL, NULL},
	{"putchar", 0x0002EF74, NULL, NULL},
	{"puts", 0x000318D5, NULL, NULL},
	{"putwc", 0x00031079, NULL, NULL},
	{"putwchar", 0x0002EF9F, NULL, NULL},
	{"qsort", 0x00026F50, NULL, NULL},
	{"raise", 0x0002518D, NULL, NULL},
	{"rand", 0x000271D3, NULL, NULL},
	{"realloc", 0x0001C437, NULL, NULL},
	{"remove", 0x00010409, NULL, NULL},
	{"rename", 0x0001144A, NULL, NULL},
	{"rewind", 0x00031983, NULL, NULL},
	{"scanf", 0x00031A11, NULL, NULL},
	{"setbuf", 0x00031A6A, NULL, NULL},
	{"setlocale", 0x00023C31, NULL, NULL},
	{"setvbuf", 0x00031A97, NULL, NULL},
	{"signal", 0x00024FD4, NULL, NULL},
	{"sin", 0x0003D444, NULL, NULL},
	{"sinh", 0x0003CDE0, NULL, NULL},
	{"sprintf", 0x0002F931, NULL, NULL},
	{"sqrt", 0x0003D504, NULL, NULL},
	{"srand", 0x000271BC, NULL, NULL},
	{"sscanf", 0x00031B72, NULL, NULL},
	{"strcat", 0x00036040, NULL, NULL},
	{"strchr", 0x00037660, NULL, NULL},
	{"strcmp", 0x00037730, NULL, NULL},
	{"strcoll", 0x000377B9, NULL, NULL},
	{"strcpy", 0x00036030, NULL, NULL},
	{"strcspn", 0x00037850, NULL, NULL},
	{"strerror", 0x000271FA, NULL, NULL},
	{"strftime", 0x000390CD, NULL, NULL},
	{"strlen", 0x000378A0, NULL, NULL},
	{"strncat", 0x00037920, NULL, NULL},
	{"strncmp", 0x00037A50, NULL, NULL},
	{"strncpy", 0x00037A90, NULL, NULL},
	{"strpbrk", 0x00037BA0, NULL, NULL},
	{"strrchr", 0x00037BE0, NULL, NULL},
	{"strspn", 0x00037C10, NULL, NULL},
	{"strstr", 0x00037C60, NULL, NULL},
	{"strtod", 0x0000D4AD, NULL, NULL},
	{"strtok", 0x00037CE5, NULL, NULL},
	{"strtol", 0x0000D711, NULL, NULL},
	{"strtoul", 0x0000D730, NULL, NULL},
	{"strxfrm", 0x00037DA7, NULL, NULL},
	{"swprintf", 0x0002F9C8, NULL, NULL},
	{"swscanf", 0x00031BB3, NULL, NULL},
	{"system", 0x000193C7, NULL, NULL},
	{"tan", 0x0003D5C4, NULL, NULL},
	{"tanh", 0x0003CDF1, NULL, NULL},
	{"time", 0x0003AEA3, NULL, NULL},
	{"tmpfile", 0x00031D8F, NULL, NULL},
	{"tmpnam", 0x00031CBF, NULL, NULL},
	{"tolower", 0x0000C9C9, NULL, NULL},
	{"toupper", 0x0000CAD7, NULL, NULL},
	{"towlower", 0x0000D7B7, NULL, NULL},
	{"towupper", 0x0000D877, NULL, NULL},
	{"ungetc", 0x00031F23, NULL, NULL},
	{"ungetwc", 0x00032084, NULL, NULL},
	{"vfprintf", 0x000320CF, NULL, NULL},
	{"vfwprintf", 0x00032131, NULL, NULL},
	{"vprintf", 0x00032193, NULL, NULL},
	{"vsprintf", 0x0002FE49, NULL, NULL},
	{"vswprintf", 0x0002FEDE, NULL, NULL},
	{"vwprintf", 0x000321F7, NULL, NULL},
	{"wcscat", 0x00037E61, NULL, NULL},
	{"wcschr", 0x00037EB8, NULL, NULL},
	{"wcscmp", 0x00037EE3, NULL, NULL},
	{"wcscoll", 0x00037F1F, NULL, NULL},
	{"wcscpy", 0x00037E94, NULL, NULL},
	{"wcscspn", 0x00037F81, NULL, NULL},
	{"wcsftime", 0x0003AEE3, NULL, NULL},
	{"wcslen", 0x00037FCC, NULL, NULL},
	{"wcsncat", 0x00037FEB, NULL, NULL},
	{"wcsncmp", 0x0003802F, NULL, NULL},
	{"wcsncpy", 0x0003806B, NULL, NULL},
	{"wcspbrk", 0x000380B0, NULL, NULL},
	{"wcsrchr", 0x000380F9, NULL, NULL},
	{"wcsspn", 0x00038132, NULL, NULL},
	{"wcsstr", 0x00038180, NULL, NULL},
	{"wcstod", 0x0000D8C5, NULL, NULL},
	{"wcstok", 0x000381E6, NULL, NULL},
	{"wcstol", 0x0000DC2B, NULL, NULL},
	{"wcstombs", 0x0000DE16, NULL, NULL},
	{"wcstoul", 0x0000DC4A, NULL, NULL},
	{"wcsxfrm", 0x00038292, NULL, NULL},
	{"wctomb", 0x0000DEB0, NULL, NULL},
	{"wprintf", 0x0003225B, NULL, NULL},
	{"wscanf", 0x000322C6, NULL, NULL},
	{0, 0, NULL}
};


struct emu_env_w32_dll_export urlmon_exports[] = 
{
	{ "AsyncGetClassBits", 0x0003DF95, NULL, NULL},
	{ "AsyncInstallDistributionUnit", 0x0003DA19, NULL, NULL},
	{ "BindAsyncMoniker", 0x0002C9CF, NULL, NULL},
	{ "CDLGetLongPathNameA", 0x0003E4A5, NULL, NULL},
	{ "CDLGetLongPathNameW", 0x0003E4D0, NULL, NULL},
	{ "CoGetClassObjectFromURL", 0x0003DBF3, NULL, NULL},
	{ "CoInstall", 0x0003C747, NULL, NULL},
	{ "CoInternetCombineUrl", 0x00016459, NULL, NULL},
	{ "CoInternetCompareUrl", 0x0002E83F, NULL, NULL},
	{ "CoInternetCreateSecurityManager", 0x000030E7, NULL, NULL},
	{ "CoInternetCreateZoneManager", 0x00009BE7, NULL, NULL},
	{ "CoInternetFeatureSettingsChanged", 0x0005DFEF, NULL, NULL},
	{ "CoInternetGetProtocolFlags", 0x00054F4C, NULL, NULL},
	{ "CoInternetGetSecurityUrl", 0x0000455E, NULL, NULL},
	{ "CoInternetGetSession", 0x0000CB90, NULL, NULL},
	{ "CoInternetIsFeatureEnabled", 0x000027C0, NULL, NULL},
	{ "CoInternetIsFeatureEnabledForUrl", 0x0000BB5E, NULL, NULL},
	{ "CoInternetIsFeatureZoneElevationEnabled", 0x0002F48F, NULL, NULL},
	{ "CoInternetParseUrl", 0x0000CEAC, NULL, NULL},
	{ "CoInternetQueryInfo", 0x00015DEF, NULL, NULL},
	{ "CoInternetSetFeatureEnabled", 0x0002F5ED, NULL, NULL},
	{ "CompareSecurityIds", 0x00033BD0, NULL, NULL},
	{ "CompatFlagsFromClsid", 0x00016BB3, NULL, NULL},
	{ "CopyBindInfo", 0x000107E4, NULL, NULL},
	{ "CopyStgMedium", 0x000108A7, NULL, NULL},
	{ "CreateAsyncBindCtx", 0x00019C24, NULL, NULL},
	{ "CreateAsyncBindCtxEx", 0x00015D58, NULL, NULL},
	{ "CreateFormatEnumerator", 0x00018353, NULL, NULL},
	{ "CreateURLMoniker", 0x0000D381, NULL, NULL},
	{ "CreateURLMonikerEx", 0x0000D39F, NULL, NULL},
	{ "DllCanUnloadNow", 0x00002EEC, NULL, NULL},
	{ "DllGetClassObject", 0x00006042, NULL, NULL},
	{ "DllInstall", 0x0002CE5C, NULL, NULL},
	{ "DllRegisterServer", 0x0002CB45, NULL, NULL},
	{ "DllRegisterServerEx", 0x0002CE51, NULL, NULL},
	{ "DllUnregisterServer", 0x0002CCDD, NULL, NULL},
	{ "Extract", 0x0003EAC5, NULL, NULL},
	{ "FaultInIEFeature", 0x00017648, NULL, NULL},
	{ "FindMediaType", 0x00012AEB, NULL, NULL},
	{ "FindMediaTypeClass", 0x000182D9, NULL, NULL},
	{ "FindMimeFromData", 0x0002E810, NULL, NULL},
	{ "GetClassFileOrMime", 0x0002EED3, NULL, NULL},
	{ "GetClassURL", 0x000369FD, NULL, NULL},
	{ "GetComponentIDFromCLSSPEC", 0x0003F2DF, NULL, NULL},
	{ "GetMarkOfTheWeb", 0x0005F3DD, NULL, NULL},
	{ "GetSoftwareUpdateInfo", 0x00043A4A, NULL, NULL},
	{ "HlinkGoBack", 0x0005927C, NULL, NULL},
	{ "HlinkGoForward", 0x000592FA, NULL, NULL},
	{ "HlinkNavigateMoniker", 0x00059B99, NULL, NULL},
	{ "HlinkNavigateString", 0x00059C1D, NULL, NULL},
	{ "HlinkSimpleNavigateToMoniker", 0x00059641, NULL, NULL},
	{ "HlinkSimpleNavigateToString", 0x00059BBA, NULL, NULL},
	{ "InstallFlash", 0x0002CF6E, NULL, NULL},
	{ "IsAsyncMoniker", 0x00015324, NULL, NULL},
	{ "IsJITInProgress", 0x0003F269, NULL, NULL},
	{ "IsLoggingEnabledA", 0x0005B442, NULL, NULL},
	{ "IsLoggingEnabledW", 0x0005B563, NULL, NULL},
	{ "IsValidURL", 0x0001960A, NULL, NULL},
	{ "MkParseDisplayNameEx", 0x0002C834, NULL, NULL},
	{ "ObtainUserAgentString", 0x0003402E, NULL, NULL},
	{ "PrivateCoInstall", 0x0003DB11, NULL, NULL},
	{ "RegisterBindStatusCallback", 0x00015B6F, NULL, NULL},
	{ "RegisterFormatEnumerator", 0x00015BE6, NULL, NULL},
	{ "RegisterMediaTypeClass", 0x0002C772, NULL, NULL},
	{ "RegisterMediaTypes", 0x0002C71A, NULL, NULL},
	{ "ReleaseBindInfo", 0x0000D7B7, NULL, NULL},
	{ "RevokeBindStatusCallback", 0x00015A5E, NULL, NULL},
	{ "RevokeFormatEnumerator", 0x0002C80F, NULL, NULL},
	{ "SetSoftwareUpdateAdvertisementState", 0x00043AAE, NULL, NULL},
	{ "URLDownloadA", 0x0002F0DD, NULL, NULL},
	{ "URLDownloadToCacheFileA", 0x0005B1C1, NULL, NULL},
	{ "URLDownloadToCacheFileW", 0x0005ADA4, NULL, NULL},
	{ "URLDownloadToFileA", 0x0005B0BB, env_w32_hook_URLDownloadToFileA, NULL},
	{ "URLDownloadToFileW", 0x0005AD3E, NULL, NULL},
	{ "URLDownloadW", 0x0002E66E, NULL, NULL},
	{ "URLOpenBlockingStreamA", 0x0005B305, NULL, NULL},
	{ "URLOpenBlockingStreamW", 0x0005AF4D, NULL, NULL},
	{ "URLOpenPullStreamA", 0x0005B024, NULL, NULL},
	{ "URLOpenPullStreamW", 0x0005ACF4, NULL, NULL},
	{ "URLOpenStreamA", 0x0005B3AB, NULL, NULL},
	{ "URLOpenStreamW", 0x0005AFDA, NULL, NULL},
	{ "UrlMkBuildVersion", 0x0002CE6C, NULL, NULL},
	{ "UrlMkGetSessionOption", 0x000149A9, NULL, NULL},
	{ "UrlMkSetSessionOption", 0x0002E4EF, NULL, NULL},
	{ "WriteHitLogging", 0x0005B4AA, NULL, NULL},
	{ "ZonesReInit", 0x0005F38C, NULL, NULL},
	{ 0, 0, NULL, NULL},
};

//dzzie 1-26-11
struct emu_env_w32_dll_export user32_exports[] =
{
	{"ActivateKeyboardLayout", 0x00018673, NULL, NULL},
	{"AdjustWindowRect", 0x00021140, NULL, NULL},
	{"AdjustWindowRectEx", 0x0001E7EA, NULL, NULL},
	{"AlignRects", 0x0005D4E0, NULL, NULL},
	{"AllowForegroundActivation", 0x00046414, NULL, NULL},
	{"AllowSetForegroundWindow", 0x00011E40, NULL, NULL},
	{"AnimateWindow", 0x00012156, NULL, NULL},
	{"AnyPopup", 0x00059C27, NULL, NULL},
	{"AppendMenuA", 0x00021B0E, NULL, NULL},
	{"AppendMenuW", 0x000132BA, NULL, NULL},
	{"ArrangeIconicWindows", 0x00045F46, NULL, NULL},
	{"AttachThreadInput", 0x00021E52, NULL, NULL},
	{"BeginDeferWindowPos", 0x0001AFB9, NULL, NULL},
	{"BeginPaint", 0x00018FE9, NULL, NULL},
	{"BlockInput", 0x0005CA7E, NULL, NULL},
	{"BringWindowToTop", 0x000203A8, NULL, NULL},
	{"BroadcastSystemMessage", 0x0005AEBE, NULL, NULL},
	{"BroadcastSystemMessageA", 0x0005AEBE, NULL, NULL},
	{"BroadcastSystemMessageExA", 0x0005AE97, NULL, NULL},
	{"BroadcastSystemMessageExW", 0x00013654, NULL, NULL},
	{"BroadcastSystemMessageW", 0x0000E666, NULL, NULL},
	{"BuildReasonArray", 0x00057DF6, NULL, NULL},
	{"CalcMenuBar", 0x0001C5E4, NULL, NULL},
	{"CallMsgFilter", 0x0005B216, NULL, NULL},
	{"CallMsgFilterA", 0x0005B216, NULL, NULL},
	{"CallMsgFilterW", 0x0001750E, NULL, NULL},
	{"CallNextHookEx", 0x0001B3C6, NULL, NULL},
	{"CallWindowProcA", 0x0001A97D, NULL, NULL},
	{"CallWindowProcW", 0x0001A01E, NULL, NULL},
	{"CascadeChildWindows", 0x00045F5E, NULL, NULL},
	{"CascadeWindows", 0x00055039, NULL, NULL},
	{"ChangeClipboardChain", 0x00020487, NULL, NULL},
	{"ChangeDisplaySettingsA", 0x0005B400, NULL, NULL},
	{"ChangeDisplaySettingsExA", 0x0001384E, NULL, NULL},
	{"ChangeDisplaySettingsExW", 0x000495BD, NULL, NULL},
	{"ChangeDisplaySettingsW", 0x00049623, NULL, NULL},
	{"ChangeMenuA", 0x0003F298, NULL, NULL},
	{"ChangeMenuW", 0x0005525E, NULL, NULL},
	{"CharLowerA", 0x00018717, NULL, NULL},
	{"CharLowerBuffA", 0x00018845, NULL, NULL},
	{"CharLowerBuffW", 0x00009E57, NULL, NULL},
	{"CharLowerW", 0x0001B24C, NULL, NULL},
	{"CharNextA", 0x0001C8B0, NULL, NULL},
	{"CharNextExA", 0x0005984E, NULL, NULL},
	{"CharNextW", 0x0001B1B0, NULL, NULL},
	{"CharPrevA", 0x0001C8DA, NULL, NULL},
	{"CharPrevExA", 0x00059882, NULL, NULL},
	{"CharPrevW", 0x0001D607, NULL, NULL},
	{"CharToOemA", 0x0000AEF1, NULL, NULL},
	{"CharToOemBuffA", 0x00021626, NULL, NULL},
	{"CharToOemBuffW", 0x00056E31, NULL, NULL},
	{"CharToOemW", 0x00013467, NULL, NULL},
	{"CharUpperA", 0x00008D2B, NULL, NULL},
	{"CharUpperBuffA", 0x0000AE3F, NULL, NULL},
	{"CharUpperBuffW", 0x00009216, NULL, NULL},
	{"CharUpperW", 0x000090D2, NULL, NULL},
	{"CheckDlgButton", 0x00014DCA, NULL, NULL},
	{"CheckMenuItem", 0x00021ABD, NULL, NULL},
	{"CheckMenuRadioItem", 0x000553A2, NULL, NULL},
	{"CheckRadioButton", 0x0004BDE1, NULL, NULL},
	{"ChildWindowFromPoint", 0x0001201F, NULL, NULL},
	{"ChildWindowFromPointEx", 0x0001200B, NULL, NULL},
	{"CliImmSetHotKey", 0x00043C33, NULL, NULL},
	{"ClientThreadSetup", 0x0000A00A, NULL, NULL},
	{"ClientToScreen", 0x00019B60, NULL, NULL},
	{"ClipCursor", 0x0002FDC5, NULL, NULL},
	{"CloseClipboard", 0x00020265, NULL, NULL},
	{"CloseDesktop", 0x0001812F, NULL, NULL},
	{"CloseWindow", 0x00045F7F, NULL, NULL},
	{"CloseWindowStation", 0x00017D18, NULL, NULL},
	{"CopyAcceleratorTableA", 0x00046C91, NULL, NULL},
	{"CopyAcceleratorTableW", 0x0003FC5E, NULL, NULL},
	{"CopyIcon", 0x0000DE72, NULL, NULL},
	{"CopyImage", 0x0001DC14, NULL, NULL},
	{"CopyRect", 0x0001A042, NULL, NULL},
	{"CountClipboardFormats", 0x0002167F, NULL, NULL},
	{"CreateAcceleratorTableA", 0x00043497, NULL, NULL},
	{"CreateAcceleratorTableW", 0x0000D9BB, NULL, NULL},
	{"CreateCaret", 0x0001A94E, NULL, NULL},
	{"CreateCursor", 0x00047059, NULL, NULL},
	{"CreateDesktopA", 0x00045E37, NULL, NULL},
	{"CreateDesktopW", 0x0001162A, NULL, NULL},
	{"CreateDialogIndirectParamA", 0x00029B28, NULL, NULL},
	{"CreateDialogIndirectParamAorW", 0x0001680B, NULL, NULL},
	{"CreateDialogIndirectParamW", 0x0002F01F, NULL, NULL},
	{"CreateDialogParamA", 0x0002C7DB, NULL, NULL},
	{"CreateDialogParamW", 0x0000EA3B, NULL, NULL},
	{"CreateIcon", 0x000470BC, NULL, NULL},
	{"CreateIconFromResource", 0x00047134, NULL, NULL},
	{"CreateIconFromResourceEx", 0x0000D354, NULL, NULL},
	{"CreateIconIndirect", 0x0000C86C, NULL, NULL},
	{"CreateMDIWindowA", 0x0003FDC0, NULL, NULL},
	{"CreateMDIWindowW", 0x0002F810, NULL, NULL},
	{"CreateMenu", 0x0001F306, NULL, NULL},
	{"CreatePopupMenu", 0x0000F601, NULL, NULL},
	{"CreateSystemThreads", 0x000216E8, NULL, NULL},
	{"CreateWindowExA", 0x0001E4A9, NULL, NULL},
	{"CreateWindowExW", 0x0001D0A3, NULL, NULL},
	{"CreateWindowStationA", 0x0004642E, NULL, NULL},
	{"CreateWindowStationW", 0x000113DD, NULL, NULL},
	{"CsrBroadcastSystemMessageExW", 0x0001367B, NULL, NULL},
	{"CtxInitUser32", 0x0000E9E2, NULL, NULL},
	{"DdeAbandonTransaction", 0x0005AD84, NULL, NULL},
	{"DdeAccessData", 0x00051309, NULL, NULL},
	{"DdeAddData", 0x000510D1, NULL, NULL},
	{"DdeClientTransaction", 0x0005A6A2, NULL, NULL},
	{"DdeCmpStringHandles", 0x00051D8D, NULL, NULL},
	{"DdeConnect", 0x000481C3, NULL, NULL},
	{"DdeConnectList", 0x000484DE, NULL, NULL},
	{"DdeCreateDataHandle", 0x00051769, NULL, NULL},
	{"DdeCreateStringHandleA", 0x00051E43, NULL, NULL},
	{"DdeCreateStringHandleW", 0x00010447, NULL, NULL},
	{"DdeDisconnect", 0x000483C4, NULL, NULL},
	{"DdeDisconnectList", 0x0004843B, NULL, NULL},
	{"DdeEnableCallback", 0x00045212, NULL, NULL},
	{"DdeFreeDataHandle", 0x000518E2, NULL, NULL},
	{"DdeFreeStringHandle", 0x00051F70, NULL, NULL},
	{"DdeGetData", 0x000511F1, NULL, NULL},
	{"DdeGetLastError", 0x0004A853, NULL, NULL},
	{"DdeGetQualityOfService", 0x0005CAA6, NULL, NULL},
	{"DdeImpersonateClient", 0x0004A894, NULL, NULL},
	{"DdeInitializeA", 0x0004A8F6, NULL, NULL},
	{"DdeInitializeW", 0x000106D7, NULL, NULL},
	{"DdeKeepStringHandle", 0x0005200A, NULL, NULL},
	{"DdeNameService", 0x0001085E, NULL, NULL},
	{"DdePostAdvise", 0x0005A3A5, NULL, NULL},
	{"DdeQueryConvInfo", 0x0005ABA6, NULL, NULL},
	{"DdeQueryNextServer", 0x000479AC, NULL, NULL},
	{"DdeQueryStringA", 0x00052096, NULL, NULL},
	{"DdeQueryStringW", 0x000520B3, NULL, NULL},
	{"DdeReconnect", 0x0004826B, NULL, NULL},
	{"DdeSetQualityOfService", 0x0005CABA, NULL, NULL},
	{"DdeSetUserHandle", 0x0005AD29, NULL, NULL},
	{"DdeUnaccessData", 0x0005137B, NULL, NULL},
	{"DdeUninitialize", 0x0004A732, NULL, NULL},
	{"DefDlgProcA", 0x0002E577, NULL, NULL},
	{"DefDlgProcW", 0x00013D3A, NULL, NULL},
	{"DefFrameProcA", 0x0003F965, NULL, NULL},
	{"DefFrameProcW", 0x00020833, NULL, NULL},
	{"DefMDIChildProcA", 0x0003F9B4, NULL, NULL},
	{"DefMDIChildProcW", 0x00020A47, NULL, NULL},
	{"DefRawInputProc", 0x000468DD, NULL, NULL},
	{"DefWindowProcA", 0x0001C17E, NULL, NULL},
	{"DefWindowProcW", 0x00018D20, NULL, NULL},
	{"DeferWindowPos", 0x0001AFDB, NULL, NULL},
	{"DeleteMenu", 0x0001CED3, NULL, NULL},
	{"DeregisterShellHookWindow", 0x000302C0, NULL, NULL},
	{"DestroyAcceleratorTable", 0x0002FE8D, NULL, NULL},
	{"DestroyCaret", 0x00019C0E, NULL, NULL},
	{"DestroyCursor", 0x0001D312, NULL, NULL},
	{"DestroyIcon", 0x0001D312, NULL, NULL},
	{"DestroyMenu", 0x0001D39D, NULL, NULL},
	{"DestroyReasons", 0x00057ED8, NULL, NULL},
	{"DestroyWindow", 0x0001B19C, NULL, NULL},
	{"DeviceEventWorker", 0x0004A0F8, NULL, NULL},
	{"DialogBoxIndirectParamA", 0x00046D7D, NULL, NULL},
	{"DialogBoxIndirectParamAorW", 0x000149D0, NULL, NULL},
	{"DialogBoxIndirectParamW", 0x00022072, NULL, NULL},
	{"DialogBoxParamA", 0x0002B144, NULL, NULL},
	{"DialogBoxParamW", 0x000147AB, NULL, NULL},
	{"DisableProcessWindowsGhosting", 0x00046421, NULL, NULL},
	{"DispatchMessageA", 0x000096B8, NULL, NULL},
	{"DispatchMessageW", 0x00008A01, NULL, NULL},
	{"DisplayExitWindowsWarnings", 0x00049F91, NULL, NULL},
	{"DlgDirListA", 0x000538DF, NULL, NULL},
	{"DlgDirListComboBoxA", 0x00047599, NULL, NULL},
	{"DlgDirListComboBoxW", 0x00047626, NULL, NULL},
	{"DlgDirListW", 0x0005396D, NULL, NULL},
	{"DlgDirSelectComboBoxExA", 0x00047657, NULL, NULL},
	{"DlgDirSelectComboBoxExW", 0x00047543, NULL, NULL},
	{"DlgDirSelectExA", 0x00053AFE, NULL, NULL},
	{"DlgDirSelectExW", 0x00053B64, NULL, NULL},
	{"DragDetect", 0x0005CACE, NULL, NULL},
	{"DragObject", 0x0005CAE2, NULL, NULL},
	{"DrawAnimatedRects", 0x0005CAF6, NULL, NULL},
	{"DrawCaption", 0x00056D9F, NULL, NULL},
	{"DrawCaptionTempA", 0x0005B2D0, NULL, NULL},
	{"DrawCaptionTempW", 0x0003F339, NULL, NULL},
	{"DrawEdge", 0x0001FBF6, NULL, NULL},
	{"DrawFocusRect", 0x0001F94F, NULL, NULL},
	{"DrawFrame", 0x000229C4, NULL, NULL},
	{"DrawFrameControl", 0x0002E940, NULL, NULL},
	{"DrawIcon", 0x0002D06C, NULL, NULL},
	{"DrawIconEx", 0x0001CB84, NULL, NULL},
	{"DrawMenuBar", 0x0003F69C, NULL, NULL},
	{"DrawMenuBarTemp", 0x0005536D, NULL, NULL},
	{"DrawStateA", 0x0003F100, NULL, NULL},
	{"DrawStateW", 0x000145BB, NULL, NULL},
	{"DrawTextA", 0x0002C702, NULL, NULL},
	{"DrawTextExA", 0x0002C739, NULL, NULL},
	{"DrawTextExW", 0x0001B415, NULL, NULL},
	{"DrawTextW", 0x0001D7E2, NULL, NULL},
	{"EditWndProc", 0x00023000, NULL, NULL},
	{"EmptyClipboard", 0x00020D96, NULL, NULL},
	{"EnableMenuItem", 0x0001D2C4, NULL, NULL},
	{"EnableScrollBar", 0x00058005, NULL, NULL},
	{"EnableWindow", 0x00019849, NULL, NULL},
	{"EndDeferWindowPos", 0x0001AF8D, NULL, NULL},
	{"EndDialog", 0x00014A4E, NULL, NULL},
	{"EndMenu", 0x0005CB5A, NULL, NULL},
	{"EndPaint", 0x00018FFD, NULL, NULL},
	{"EndTask", 0x0004A0A5, NULL, NULL},
	{"EnterReaderModeHelper", 0x0005769F, NULL, NULL},
	{"EnumChildWindows", 0x0001B0F0, NULL, NULL},
	{"EnumClipboardFormats", 0x0002E53D, NULL, NULL},
	{"EnumDesktopWindows", 0x0001851A, NULL, NULL},
	{"EnumDesktopsA", 0x0002234B, NULL, NULL},
	{"EnumDesktopsW", 0x0001853B, NULL, NULL},
	{"EnumDisplayDevicesA", 0x00018A74, NULL, NULL},
	{"EnumDisplayDevicesW", 0x0000E03C, NULL, NULL},
	{"EnumDisplayMonitors", 0x0001A77B, NULL, NULL},
	{"EnumDisplaySettingsA", 0x00013A67, NULL, NULL},
	{"EnumDisplaySettingsExA", 0x000138F3, NULL, NULL},
	{"EnumDisplaySettingsExW", 0x00013563, NULL, NULL},
	{"EnumDisplaySettingsW", 0x0001362A, NULL, NULL},
	{"EnumPropsA", 0x000455D9, NULL, NULL},
	{"EnumPropsExA", 0x00045613, NULL, NULL},
	{"EnumPropsExW", 0x00045631, NULL, NULL},
	{"EnumPropsW", 0x000455F6, NULL, NULL},
	{"EnumThreadWindows", 0x0001F539, NULL, NULL},
	{"EnumWindowStationsA", 0x0002232E, NULL, NULL},
	{"EnumWindowStationsW", 0x0004564F, NULL, NULL},
	{"EnumWindows", 0x0001A5AE, NULL, NULL},
	{"EqualRect", 0x00019E81, NULL, NULL},
	{"ExcludeUpdateRgn", 0x00020251, NULL, NULL},
	{"ExitWindowsEx", 0x0004A275, NULL, NULL},
	{"FillRect", 0x00019C2F, NULL, NULL},
	{"FindWindowA", 0x000182E1, NULL, NULL},
	{"FindWindowExA", 0x0002214A, NULL, NULL},
	{"FindWindowExW", 0x0000E0E3, NULL, NULL},
	{"FindWindowW", 0x0001C9C3, NULL, NULL},
	{"FlashWindow", 0x00045FC4, NULL, NULL},
	{"FlashWindowEx", 0x0005CB80, NULL, NULL},
	{"FrameRect", 0x0001F92A, NULL, NULL},
	{"FreeDDElParam", 0x0004BA77, NULL, NULL},
	{"GetActiveWindow", 0x0001C2E8, NULL, NULL},
	{"GetAltTabInfo", 0x0005B3DC, NULL, NULL},
	{"GetAltTabInfoA", 0x0005B3DC, NULL, NULL},
	{"GetAltTabInfoW", 0x00020D09, NULL, NULL},
	{"GetAncestor", 0x0001AF79, NULL, NULL},
	{"GetAppCompatFlags", 0x00008ED6, NULL, NULL},
	{"GetAppCompatFlags2", 0x0001CDD4, NULL, NULL},
	{"GetAsyncKeyState", 0x0001A78F, NULL, NULL},
	{"GetCapture", 0x000094DA, NULL, NULL},
	{"GetCaretBlinkTime", 0x0001A928, NULL, NULL},
	{"GetCaretPos", 0x0001F6A1, NULL, NULL},
	{"GetClassInfoA", 0x0002EBFF, NULL, NULL},
	{"GetClassInfoExA", 0x0000DD58, NULL, NULL},
	{"GetClassInfoExW", 0x0000DEBC, NULL, NULL},
	{"GetClassInfoW", 0x0001E81E, NULL, NULL},
	{"GetClassLongA", 0x0001F4F1, NULL, NULL},
	{"GetClassLongW", 0x00019AE9, NULL, NULL},
	{"GetClassNameA", 0x0001F45F, NULL, NULL},
	{"GetClassNameW", 0x00019D12, NULL, NULL},
	{"GetClassWord", 0x0004535C, NULL, NULL},
	{"GetClientRect", 0x0001908E, NULL, NULL},
	{"GetClipCursor", 0x0005CBA6, NULL, NULL},
	{"GetClipboardData", 0x00020DBA, NULL, NULL},
	{"GetClipboardFormatNameA", 0x00021290, NULL, NULL},
	{"GetClipboardFormatNameW", 0x0004957F, NULL, NULL},
	{"GetClipboardOwner", 0x00020DA8, NULL, NULL},
	{"GetClipboardSequenceNumber", 0x0001F17A, NULL, NULL},
	{"GetClipboardViewer", 0x0005CB94, NULL, NULL},
	{"GetComboBoxInfo", 0x0005CBBA, NULL, NULL},
	{"GetCursor", 0x0001A91B, NULL, NULL},
	{"GetCursorFrameInfo", 0x000147F8, NULL, NULL},
	{"GetCursorInfo", 0x0005CBCE, NULL, NULL},
	{"GetCursorPos", 0x0001974E, NULL, NULL},
	{"GetDC", 0x000086C7, NULL, NULL},
	{"GetDCEx", 0x0001C595, NULL, NULL},
	{"GetDesktopWindow", 0x0001D1D2, NULL, NULL},
	{"GetDialogBaseUnits", 0x00046003, NULL, NULL},
	{"GetDlgCtrlID", 0x0001AF1B, NULL, NULL},
	{"GetDlgItem", 0x0001436E, NULL, NULL},
	{"GetDlgItemInt", 0x0004BC8B, NULL, NULL},
	{"GetDlgItemTextA", 0x0005B05E, NULL, NULL},
	{"GetDlgItemTextW", 0x00014305, NULL, NULL},
	{"GetDoubleClickTime", 0x0001D86B, NULL, NULL},
	{"GetFocus", 0x000198C8, NULL, NULL},
	{"GetForegroundWindow", 0x00019823, NULL, NULL},
	{"GetGUIThreadInfo", 0x00017F28, NULL, NULL},
	{"GetGuiResources", 0x0005CBE2, NULL, NULL},
	{"GetIconInfo", 0x0001D427, NULL, NULL},
	{"GetInputDesktop", 0x00046022, NULL, NULL},
	{"GetInputState", 0x0001F64E, NULL, NULL},
	{"GetInternalWindowPos", 0x0005CC0A, NULL, NULL},
	{"GetKBCodePage", 0x000521A8, NULL, NULL},
	{"GetKeyNameTextA", 0x0003F6B4, NULL, NULL},
	{"GetKeyNameTextW", 0x0004958F, NULL, NULL},
	{"GetKeyState", 0x00019ED9, NULL, NULL},
	{"GetKeyboardLayout", 0x00019BF6, NULL, NULL},
	{"GetKeyboardLayoutList", 0x00019C1B, NULL, NULL},
	{"GetKeyboardLayoutNameA", 0x00043631, NULL, NULL},
	{"GetKeyboardLayoutNameW", 0x00021481, NULL, NULL},
	{"GetKeyboardState", 0x0001D226, NULL, NULL},
	{"GetKeyboardType", 0x000211DB, NULL, NULL},
	{"GetLastActivePopup", 0x0002157A, NULL, NULL},
	{"GetLastInputInfo", 0x000094F4, NULL, NULL},
	{"GetLayeredWindowAttributes", 0x0005CFC6, NULL, NULL},
	{"GetListBoxInfo", 0x0005CC32, NULL, NULL},
	{"GetMenu", 0x000214BA, NULL, NULL},
	{"GetMenuBarInfo", 0x0005CC46, NULL, NULL},
	{"GetMenuCheckMarkDimensions", 0x000402F9, NULL, NULL},
	{"GetMenuContextHelpId", 0x000552FF, NULL, NULL},
	{"GetMenuDefaultItem", 0x0000F667, NULL, NULL},
	{"GetMenuInfo", 0x00046725, NULL, NULL},
	{"GetMenuItemCount", 0x0001EF1C, NULL, NULL},
	{"GetMenuItemID", 0x0003F1C8, NULL, NULL},
	{"GetMenuItemInfoA", 0x0001F0AD, NULL, NULL},
	{"GetMenuItemInfoW", 0x0000F72A, NULL, NULL},
	{"GetMenuItemRect", 0x0005CC6E, NULL, NULL},
	{"GetMenuState", 0x0000F967, NULL, NULL},
	{"GetMenuStringA", 0x0003F24E, NULL, NULL},
	{"GetMenuStringW", 0x000464E4, NULL, NULL},
	{"GetMessageA", 0x0001772B, NULL, NULL},
	{"GetMessageExtraInfo", 0x000468B8, NULL, NULL},
	{"GetMessagePos", 0x0001996C, NULL, NULL},
	{"GetMessageTime", 0x00019DE0, NULL, NULL},
	{"GetMessageW", 0x000091C6, NULL, NULL},
	{"GetMonitorInfoA", 0x0001A84A, NULL, NULL},
	{"GetMonitorInfoW", 0x0001A6D9, NULL, NULL},
	{"GetMouseMovePointsEx", 0x0005CC82, NULL, NULL},
	{"GetNextDlgGroupItem", 0x0004BF27, NULL, NULL},
	{"GetNextDlgTabItem", 0x000137C3, NULL, NULL},
	{"GetOpenClipboardWindow", 0x00021691, NULL, NULL},
	{"GetParent", 0x0001910F, NULL, NULL},
	{"GetPriorityClipboardFormat", 0x0005CC96, NULL, NULL},
	{"GetProcessDefaultLayout", 0x000463E4, NULL, NULL},
	{"GetProcessWindowStation", 0x00009195, NULL, NULL},
	{"GetProgmanWindow", 0x0004612D, NULL, NULL},
	{"GetPropA", 0x00020042, NULL, NULL},
	{"GetPropW", 0x000194B3, NULL, NULL},
	{"GetQueueStatus", 0x0001AE46, NULL, NULL},
	{"GetRawInputBuffer", 0x00050DCD, NULL, NULL},
	{"GetRawInputData", 0x0005CCBE, NULL, NULL},
	{"GetRawInputDeviceInfoA", 0x0005AF0D, NULL, NULL},
	{"GetRawInputDeviceInfoW", 0x00046558, NULL, NULL},
	{"GetRawInputDeviceList", 0x0005CCE6, NULL, NULL},
	{"GetReasonTitleFromReasonCode", 0x00057F24, NULL, NULL},
	{"GetRegisteredRawInputDevices", 0x0005CCFA, NULL, NULL},
	{"GetScrollBarInfo", 0x0001DFB4, NULL, NULL},
	{"GetScrollInfo", 0x0001DFE2, NULL, NULL},
	{"GetScrollPos", 0x0001F704, NULL, NULL},
	{"GetScrollRange", 0x0001F787, NULL, NULL},
	{"GetShellWindow", 0x00009252, NULL, NULL},
	{"GetSubMenu", 0x0001D896, NULL, NULL},
	{"GetSysColor", 0x00008E78, NULL, NULL},
	{"GetSysColorBrush", 0x00008EAB, NULL, NULL},
	{"GetSystemMenu", 0x0001B222, NULL, NULL},
	{"GetSystemMetrics", 0x00008F9C, NULL, NULL},
	{"GetTabbedTextExtentA", 0x0004A6A1, NULL, NULL},
	{"GetTabbedTextExtentW", 0x0004A677, NULL, NULL},
	{"GetTaskmanWindow", 0x0004370D, NULL, NULL},
	{"GetThreadDesktop", 0x00009A51, NULL, NULL},
	{"GetTitleBarInfo", 0x0001C581, NULL, NULL},
	{"GetTopWindow", 0x0001F25B, NULL, NULL},
	{"GetUpdateRect", 0x0001A8C9, NULL, NULL},
	{"GetUpdateRgn", 0x0001F5EC, NULL, NULL},
	{"GetUserObjectInformationA", 0x00021300, NULL, NULL},
	{"GetUserObjectInformationW", 0x00008D17, NULL, NULL},
	{"GetUserObjectSecurity", 0x00045B65, NULL, NULL},
	{"GetWinStationInfo", 0x00045B9B, NULL, NULL},
	{"GetWindow", 0x00019655, NULL, NULL},
	{"GetWindowContextHelpId", 0x00046180, NULL, NULL},
	{"GetWindowDC", 0x00009021, NULL, NULL},
	{"GetWindowInfo", 0x0001C49C, NULL, NULL},
	{"GetWindowLongA", 0x0000945D, NULL, NULL},
	{"GetWindowLongW", 0x000088A6, NULL, NULL},
	{"GetWindowModuleFileName", 0x0005AEE4, NULL, NULL},
	{"GetWindowModuleFileNameA", 0x0005AEE4, NULL, NULL},
	{"GetWindowModuleFileNameW", 0x0004652F, NULL, NULL},
	{"GetWindowPlacement", 0x000203C7, NULL, NULL},
	{"GetWindowRect", 0x000190B4, NULL, NULL},
	{"GetWindowRgn", 0x0000E443, NULL, NULL},
	{"GetWindowRgnBox", 0x0001D007, NULL, NULL},
	{"GetWindowTextA", 0x0002216B, NULL, NULL},
	{"GetWindowTextLengthA", 0x0003F18B, NULL, NULL},
	{"GetWindowTextLengthW", 0x00017836, NULL, NULL},
	{"GetWindowTextW", 0x0001A5CD, NULL, NULL},
	{"GetWindowThreadProcessId", 0x00008A80, NULL, NULL},
	{"GetWindowWord", 0x0002030C, NULL, NULL},
	{"GrayStringA", 0x00045B05, NULL, NULL},
	{"GrayStringW", 0x00045B35, NULL, NULL},
	{"HideCaret", 0x0001B086, NULL, NULL},
	{"HiliteMenuItem", 0x0005CD22, NULL, NULL},
	{"IMPGetIMEA", 0x0005B4C0, NULL, NULL},
	{"IMPGetIMEW", 0x0005B4AF, NULL, NULL},
	{"IMPQueryIMEA", 0x0005B4E2, NULL, NULL},
	{"IMPQueryIMEW", 0x0005B4D1, NULL, NULL},
	{"IMPSetIMEA", 0x0005B504, NULL, NULL},
	{"IMPSetIMEW", 0x0005B4F3, NULL, NULL},
	{"ImpersonateDdeClientWindow", 0x0005CD36, NULL, NULL},
	{"InSendMessage", 0x00017296, NULL, NULL},
	{"InSendMessageEx", 0x0001AE83, NULL, NULL},
	{"InflateRect", 0x000198D5, NULL, NULL},
	{"InitializeLpkHooks", 0x00046646, NULL, NULL},
	{"InitializeWin32EntryTable", 0x00056FC7, NULL, NULL},
	{"InsertMenuA", 0x0002ED26, NULL, NULL},
	{"InsertMenuItemA", 0x0003F710, NULL, NULL},
	{"InsertMenuItemW", 0x0000F5C8, NULL, NULL},
	{"InsertMenuW", 0x0000F60E, NULL, NULL},
	{"InternalGetWindowText", 0x0001C5A9, NULL, NULL},
	{"IntersectRect", 0x00018F1F, NULL, NULL},
	{"InvalidateRect", 0x00018FD5, NULL, NULL},
	{"InvalidateRgn", 0x0001CDFE, NULL, NULL},
	{"InvertRect", 0x0003FC72, NULL, NULL},
	{"IsCharAlphaA", 0x0002E5E6, NULL, NULL},
	{"IsCharAlphaNumericA", 0x0003F469, NULL, NULL},
	{"IsCharAlphaNumericW", 0x00011AC2, NULL, NULL},
	{"IsCharAlphaW", 0x0001D683, NULL, NULL},
	{"IsCharLowerA", 0x0002B889, NULL, NULL},
	{"IsCharLowerW", 0x0003F3B2, NULL, NULL},
	{"IsCharUpperA", 0x0002707E, NULL, NULL},
	{"IsCharUpperW", 0x0005A1DF, NULL, NULL},
	{"IsChild", 0x0000970E, NULL, NULL},
	{"IsClipboardFormatAvailable", 0x0001F166, NULL, NULL},
	{"IsDialogMessage", 0x0002C689, NULL, NULL},
	{"IsDialogMessageA", 0x0002C689, NULL, NULL},
	{"IsDialogMessageW", 0x00017424, NULL, NULL},
	{"IsDlgButtonChecked", 0x00014DFA, NULL, NULL},
	{"IsGUIThread", 0x0005A19F, NULL, NULL},
	{"IsHungAppWindow", 0x00059C61, NULL, NULL},
	{"IsIconic", 0x000197FF, NULL, NULL},
	{"IsMenu", 0x00021368, NULL, NULL},
	{"IsRectEmpty", 0x000198FE, NULL, NULL},
	{"IsServerSideWindow", 0x0001B0CF, NULL, NULL},
	{"IsWinEventHookInstalled", 0x0000B1A5, NULL, NULL},
	{"IsWindow", 0x00019313, NULL, NULL},
	{"IsWindowEnabled", 0x0001977A, NULL, NULL},
	{"IsWindowInDestroy", 0x0001B126, NULL, NULL},
	{"IsWindowUnicode", 0x00019F72, NULL, NULL},
	{"IsWindowVisible", 0x00019E3D, NULL, NULL},
	{"IsZoomed", 0x00019C8A, NULL, NULL},
	{"KillSystemTimer", 0x000460CC, NULL, NULL},
	{"KillTimer", 0x00008C42, NULL, NULL},
	{"LoadAcceleratorsA", 0x00021553, NULL, NULL},
	{"LoadAcceleratorsW", 0x0001EE76, NULL, NULL},
	{"LoadBitmapA", 0x0001473C, NULL, NULL},
	{"LoadBitmapW", 0x00010242, NULL, NULL},
	{"LoadCursorA", 0x0001D33E, NULL, NULL},
	{"LoadCursorFromFileA", 0x00043CCB, NULL, NULL},
	{"LoadCursorFromFileW", 0x00043CAC, NULL, NULL},
	{"LoadCursorW", 0x00009D69, NULL, NULL},
	{"LoadIconA", 0x0001E8F6, NULL, NULL},
	{"LoadIconW", 0x0001E8BC, NULL, NULL},
	{"LoadImageA", 0x00017C08, NULL, NULL},
	{"LoadImageW", 0x00017B97, NULL, NULL},
	{"LoadKeyboardLayoutA", 0x00046262, NULL, NULL},
	{"LoadKeyboardLayoutEx", 0x0004623A, NULL, NULL},
	{"LoadKeyboardLayoutW", 0x00021464, NULL, NULL},
	{"LoadLocalFonts", 0x0000EDD8, NULL, NULL},
	{"LoadMenuA", 0x0003FA83, NULL, NULL},
	{"LoadMenuIndirectA", 0x0001EBBF, NULL, NULL},
	{"LoadMenuIndirectW", 0x0001EBBF, NULL, NULL},
	{"LoadMenuW", 0x0001EB48, NULL, NULL},
	{"LoadRemoteFonts", 0x0000ECB7, NULL, NULL},
	{"LoadStringA", 0x0001C908, NULL, NULL},
	{"LoadStringW", 0x00009E36, NULL, NULL},
	{"LockSetForegroundWindow", 0x0000DE5A, NULL, NULL},
	{"LockWindowStation", 0x0000F3C4, NULL, NULL},
	{"LockWindowUpdate", 0x00029636, NULL, NULL},
	{"LockWorkStation", 0x0005CD5E, NULL, NULL},
	{"LookupIconIdFromDirectory", 0x00047116, NULL, NULL},
	{"LookupIconIdFromDirectoryEx", 0x0000C4DA, NULL, NULL},
	{"MBToWCSEx", 0x0000ADAD, NULL, NULL},
	{"MB_GetString", 0x00055D55, NULL, NULL},
	{"MapDialogRect", 0x0004BE4C, NULL, NULL},
	{"MapVirtualKeyA", 0x0001FEEA, NULL, NULL},
	{"MapVirtualKeyExA", 0x0005B097, NULL, NULL},
	{"MapVirtualKeyExW", 0x0004959F, NULL, NULL},
	{"MapVirtualKeyW", 0x0004029E, NULL, NULL},
	{"MapWindowPoints", 0x00019507, NULL, NULL},
	{"MenuItemFromPoint", 0x0005CD70, NULL, NULL},
	{"MenuWindowProcA", 0x00046873, NULL, NULL},
	{"MenuWindowProcW", 0x0004682E, NULL, NULL},
	{"MessageBeep", 0x00021F7B, NULL, NULL},
        {"MessageBoxA", 0x000407EA, env_hook_MessageBoxA, NULL}, // Modified by T.OkamotoLab.
	{"MessageBoxExA", 0x0004085C, NULL, NULL},
	{"MessageBoxExW", 0x00040838, NULL, NULL},
	{"MessageBoxIndirectA", 0x0002A082, NULL, NULL},
	{"MessageBoxIndirectW", 0x000564D5, NULL, NULL},
	{"MessageBoxTimeoutA", 0x00056406, NULL, NULL},
	{"MessageBoxTimeoutW", 0x00056383, NULL, NULL},
	{"MessageBoxW", 0x00056534, NULL, NULL},
	{"ModifyMenuA", 0x0003F20B, NULL, NULL},
	{"ModifyMenuW", 0x0000F51F, NULL, NULL},
	{"MonitorFromPoint", 0x0001ABF5, NULL, NULL},
	{"MonitorFromRect", 0x0001C713, NULL, NULL},
	{"MonitorFromWindow", 0x0001A679, NULL, NULL},
	{"MoveWindow", 0x0001B29E, NULL, NULL},
	{"MsgWaitForMultipleObjects", 0x00009689, NULL, NULL},
	{"MsgWaitForMultipleObjectsEx", 0x00009645, NULL, NULL},
	{"NotifyWinEvent", 0x000199CB, NULL, NULL},
	{"OemKeyScan", 0x0004023C, NULL, NULL},
	{"OemToCharA", 0x000200D7, NULL, NULL},
	{"OemToCharBuffA", 0x00020116, NULL, NULL},
	{"OemToCharBuffW", 0x000402BB, NULL, NULL},
	{"OemToCharW", 0x00056E76, NULL, NULL},
	{"OffsetRect", 0x00019011, NULL, NULL},
	{"OpenClipboard", 0x00020277, NULL, NULL},
	{"OpenDesktopA", 0x00022369, NULL, NULL},
	{"OpenDesktopW", 0x00018559, NULL, NULL},
	{"OpenIcon", 0x000460E7, NULL, NULL},
	{"OpenInputDesktop", 0x0000ECA3, NULL, NULL},
	{"OpenWindowStationA", 0x000221E1, NULL, NULL},
	{"OpenWindowStationW", 0x00045E0B, NULL, NULL},
	{"PackDDElParam", 0x0004B961, NULL, NULL},
	{"PaintDesktop", 0x0001864B, NULL, NULL},
	{"PaintMenuBar", 0x0002151E, NULL, NULL},
	{"PeekMessageA", 0x0001A340, NULL, NULL},
	{"PeekMessageW", 0x0000929B, NULL, NULL},
	{"PostMessageA", 0x0001AAFD, NULL, NULL},
	{"PostMessageW", 0x00008CCB, NULL, NULL},
	{"PostQuitMessage", 0x0001CA5A, NULL, NULL},
	{"PostThreadMessageA", 0x000177C5, NULL, NULL},
	{"PostThreadMessageW", 0x000177B8, NULL, NULL},
	{"PrintWindow", 0x00013810, NULL, NULL},
	{"PrivateExtractIconExA", 0x00050A09, NULL, NULL},
	{"PrivateExtractIconExW", 0x0000D3C3, NULL, NULL},
	{"PrivateExtractIconsA", 0x000509AF, NULL, NULL},
	{"PrivateExtractIconsW", 0x0000CCFC, NULL, NULL},
	{"PrivateSetDbgTag", 0x0005CE72, NULL, NULL},
	{"PrivateSetRipFlags", 0x0005CEFE, NULL, NULL},
	{"PtInRect", 0x00019719, NULL, NULL},
	{"QuerySendMessage", 0x0005CDBE, NULL, NULL},
	{"QueryUserCounters", 0x0005CDD2, NULL, NULL},
	{"RealChildWindowFromPoint", 0x0005CDE6, NULL, NULL},
	{"RealGetWindowClass", 0x0005B36B, NULL, NULL},
	{"RealGetWindowClassA", 0x0005B36B, NULL, NULL},
	{"RealGetWindowClassW", 0x000495F6, NULL, NULL},
	{"ReasonCodeNeedsBugID", 0x00057716, NULL, NULL},
	{"ReasonCodeNeedsComment", 0x000576FF, NULL, NULL},
	{"RecordShutdownReason", 0x000496FD, NULL, NULL},
	{"RedrawWindow", 0x00019944, NULL, NULL},
	{"RegisterClassA", 0x0001EA5E, NULL, NULL},
	{"RegisterClassExA", 0x00017C39, NULL, NULL},
	{"RegisterClassExW", 0x0000AF7F, NULL, NULL},
	{"RegisterClassW", 0x0000A39A, NULL, NULL},
	{"RegisterClipboardFormatA", 0x00008E28, NULL, NULL},
	{"RegisterClipboardFormatW", 0x0000AF34, NULL, NULL},
	{"RegisterDeviceNotificationA", 0x00011B3B, NULL, NULL},
	{"RegisterDeviceNotificationW", 0x0000E8B9, NULL, NULL},
	{"RegisterHotKey", 0x0000EBB3, NULL, NULL},
	{"RegisterLogonProcess", 0x00012B73, NULL, NULL},
	{"RegisterMessagePumpHook", 0x00011EFC, NULL, NULL},
	{"RegisterRawInputDevices", 0x0005CE0E, NULL, NULL},
	{"RegisterServicesProcess", 0x00011FAE, NULL, NULL},
	{"RegisterShellHookWindow", 0x0000E104, NULL, NULL},
	{"RegisterSystemThread", 0x00046198, NULL, NULL},
	{"RegisterTasklist", 0x0005CE22, NULL, NULL},
	{"RegisterUserApiHook", 0x00011CFF, NULL, NULL},
	{"RegisterWindowMessageA", 0x00008E28, NULL, NULL},
	{"RegisterWindowMessageW", 0x0000AF34, NULL, NULL},
	{"ReleaseCapture", 0x0001C37A, NULL, NULL},
	{"ReleaseDC", 0x0000869D, NULL, NULL},
	{"RemoveMenu", 0x0000F716, NULL, NULL},
	{"RemovePropA", 0x00020094, NULL, NULL},
	{"RemovePropW", 0x0001C076, NULL, NULL},
	{"ReplyMessage", 0x000186F8, NULL, NULL},
	{"ResolveDesktopForWOW", 0x0005CE36, NULL, NULL},
	{"ReuseDDElParam", 0x0004BADB, NULL, NULL},
	{"ScreenToClient", 0x000197A0, NULL, NULL},
	{"ScrollChildren", 0x00054DFC, NULL, NULL},
	{"ScrollDC", 0x0000B1DD, NULL, NULL},
	{"ScrollWindow", 0x0001FF39, NULL, NULL},
	{"ScrollWindowEx", 0x00020187, NULL, NULL},
	{"SendDlgItemMessageA", 0x0002C2E7, NULL, NULL},
	{"SendDlgItemMessageW", 0x000173CC, NULL, NULL},
	{"SendIMEMessageExA", 0x0005B49E, NULL, NULL},
	{"SendIMEMessageExW", 0x0005B48D, NULL, NULL},
	{"SendInput", 0x0001F140, NULL, NULL},
	{"SendMessageA", 0x0001F3C2, NULL, NULL},
	{"SendMessageCallbackA", 0x0005B129, NULL, NULL},
	{"SendMessageCallbackW", 0x0001D6DB, NULL, NULL},
	{"SendMessageTimeoutA", 0x0001FB6B, NULL, NULL},
	{"SendMessageTimeoutW", 0x0001CDAA, NULL, NULL},
	{"SendMessageW", 0x0001929A, NULL, NULL},
	{"SendNotifyMessageA", 0x00043948, NULL, NULL},
	{"SendNotifyMessageW", 0x0001D64F, NULL, NULL},
	{"SetActiveWindow", 0x00017822, NULL, NULL},
	{"SetCapture", 0x0001C35E, NULL, NULL},
	{"SetCaretBlinkTime", 0x00021174, NULL, NULL},
	{"SetCaretPos", 0x0001A962, NULL, NULL},
	{"SetClassLongA", 0x0001FE71, NULL, NULL},
	{"SetClassLongW", 0x0000E14B, NULL, NULL},
	{"SetClassWord", 0x0005CE4A, NULL, NULL},
	{"SetClipboardData", 0x00020F9E, NULL, NULL},
	{"SetClipboardViewer", 0x00020473, NULL, NULL},
	{"SetConsoleReserveKeys", 0x0001865F, NULL, NULL},
	{"SetCursor", 0x00019930, NULL, NULL},
	{"SetCursorContents", 0x0005CE5E, NULL, NULL},
	{"SetCursorPos", 0x000461B3, NULL, NULL},
	{"SetDebugErrorLevel", 0x000462EB, NULL, NULL},
	{"SetDeskWallpaper", 0x00045705, NULL, NULL},
	{"SetDlgItemInt", 0x0004BC09, NULL, NULL},
	{"SetDlgItemTextA", 0x0002C972, NULL, NULL},
	{"SetDlgItemTextW", 0x0001736C, NULL, NULL},
	{"SetDoubleClickTime", 0x000461CE, NULL, NULL},
	{"SetFocus", 0x0001B112, NULL, NULL},
	{"SetForegroundWindow", 0x000142ED, NULL, NULL},
	{"SetInternalWindowPos", 0x0005CE9A, NULL, NULL},
	{"SetKeyboardState", 0x000202B5, NULL, NULL},
	{"SetLastErrorEx", 0x00056FB0, NULL, NULL},
	{"SetLayeredWindowAttributes", 0x0001CE12, NULL, NULL},
	{"SetLogonNotifyWindow", 0x00011FEF, NULL, NULL},
	{"SetMenu", 0x0003F3F6, NULL, NULL},
	{"SetMenuContextHelpId", 0x0005CEC2, NULL, NULL},
	{"SetMenuDefaultItem", 0x0000F5B4, NULL, NULL},
	{"SetMenuInfo", 0x0005523C, NULL, NULL},
	{"SetMenuItemBitmaps", 0x0003FAB2, NULL, NULL},
	{"SetMenuItemInfoA", 0x0005AE5E, NULL, NULL},
	{"SetMenuItemInfoW", 0x00013281, NULL, NULL},
	{"SetMessageExtraInfo", 0x000468C5, NULL, NULL},
	{"SetMessageQueue", 0x0002E1EB, NULL, NULL},
	{"SetParent", 0x0001C7F9, NULL, NULL},
	{"SetProcessDefaultLayout", 0x000463FC, NULL, NULL},
	{"SetProcessWindowStation", 0x00017D40, NULL, NULL},
	{"SetProgmanWindow", 0x00046168, NULL, NULL},
	{"SetPropA", 0x00020000, NULL, NULL},
	{"SetPropW", 0x0001C0B9, NULL, NULL},
	{"SetRect", 0x00018FA6, NULL, NULL},
	{"SetRectEmpty", 0x00019CBA, NULL, NULL},
	{"SetScrollInfo", 0x00009056, NULL, NULL},
	{"SetScrollPos", 0x0001F750, NULL, NULL},
	{"SetScrollRange", 0x0001F99B, NULL, NULL},
	{"SetShellWindow", 0x00046114, NULL, NULL},
	{"SetShellWindowEx", 0x0000FF92, NULL, NULL},
	{"SetSysColors", 0x00056582, NULL, NULL},
	{"SetSysColorsTemp", 0x00056EBE, NULL, NULL},
	{"SetSystemCursor", 0x0005670B, NULL, NULL},
	{"SetSystemMenu", 0x0002F9E3, NULL, NULL},
	{"SetSystemTimer", 0x0005CF3A, NULL, NULL},
	{"SetTaskmanWindow", 0x00010260, NULL, NULL},
	{"SetThreadDesktop", 0x00017D2C, NULL, NULL},
	{"SetTimer", 0x00008C2E, NULL, NULL},
	{"SetUserObjectInformationA", 0x0005CEEA, NULL, NULL},
	{"SetUserObjectInformationW", 0x0005CEEA, NULL, NULL},
	{"SetUserObjectSecurity", 0x000113B3, NULL, NULL},
	{"SetWinEventHook", 0x000217F7, NULL, NULL},
	{"SetWindowContextHelpId", 0x0002FDD9, NULL, NULL},
	{"SetWindowLongA", 0x0001C29D, NULL, NULL},
	{"SetWindowLongW", 0x0001C2BB, NULL, NULL},
	{"SetWindowPlacement", 0x0000DE46, NULL, NULL},
	{"SetWindowPos", 0x000199F3, NULL, NULL},
	{"SetWindowRgn", 0x0001E528, NULL, NULL},
	{"SetWindowStationUser", 0x0000F338, NULL, NULL},
	{"SetWindowTextA", 0x0001F56B, NULL, NULL},
	{"SetWindowTextW", 0x0001960E, NULL, NULL},
	{"SetWindowWord", 0x000203DB, NULL, NULL},
	{"SetWindowsHookA", 0x0002ED69, NULL, NULL},
	{"SetWindowsHookExA", 0x00021211, NULL, NULL},
	{"SetWindowsHookExW", 0x0001820F, NULL, NULL},
	{"SetWindowsHookW", 0x00011B8A, NULL, NULL},
	{"ShowCaret", 0x0001B09A, NULL, NULL},
	{"ShowCursor", 0x0001FA6E, NULL, NULL},
	{"ShowOwnedPopups", 0x000461E6, NULL, NULL},
	{"ShowScrollBar", 0x0001F2F2, NULL, NULL},
	{"ShowStartGlass", 0x00040101, NULL, NULL},
	{"ShowWindow", 0x0001AF56, NULL, NULL},
	{"ShowWindowAsync", 0x0001337D, NULL, NULL},
	{"SoftModalMessageBox", 0x0002A2DF, NULL, NULL},
	{"SubtractRect", 0x00010138, NULL, NULL},
	{"SwapMouseButton", 0x00046201, NULL, NULL},
	{"SwitchDesktop", 0x0000FE6E, NULL, NULL},
	{"SwitchToThisWindow", 0x0004581C, NULL, NULL},
	{"SystemParametersInfoA", 0x0001DEB2, NULL, NULL},
	{"SystemParametersInfoW", 0x00009F06, NULL, NULL},
	{"TabbedTextOutA", 0x0004A5E5, NULL, NULL},
	{"TabbedTextOutW", 0x0004A5B6, NULL, NULL},
	{"TileChildWindows", 0x00046219, NULL, NULL},
	{"TileWindows", 0x00055215, NULL, NULL},
	{"ToAscii", 0x00045721, NULL, NULL},
	{"ToAsciiEx", 0x0004577E, NULL, NULL},
	{"ToUnicode", 0x000566A8, NULL, NULL},
	{"ToUnicodeEx", 0x000566D9, NULL, NULL},
	{"TrackMouseEvent", 0x0001C80D, NULL, NULL},
	{"TrackPopupMenu", 0x0005531E, NULL, NULL},
	{"TrackPopupMenuEx", 0x0005CF62, NULL, NULL},
	{"TranslateAccelerator", 0x0001FAC4, NULL, NULL},
	{"TranslateAcceleratorA", 0x0001FAC4, NULL, NULL},
	{"TranslateAcceleratorW", 0x0000941E, NULL, NULL},
	{"TranslateMDISysAccel", 0x0001FB2F, NULL, NULL},
	{"TranslateMessage", 0x00008BF6, NULL, NULL},
	{"TranslateMessageEx", 0x00008A19, NULL, NULL},
	{"UnhookWinEvent", 0x000218AC, NULL, NULL},
	{"UnhookWindowsHook", 0x00011BA5, NULL, NULL},
	{"UnhookWindowsHookEx", 0x0001D5F3, NULL, NULL},
	{"UnionRect", 0x0001A0F1, NULL, NULL},
	{"UnloadKeyboardLayout", 0x000462C0, NULL, NULL},
	{"UnlockWindowStation", 0x0000DCD9, NULL, NULL},
	{"UnpackDDElParam", 0x0004B9C5, NULL, NULL},
	{"UnregisterClassA", 0x000189A3, NULL, NULL},
	{"UnregisterClassW", 0x00009AA4, NULL, NULL},
	{"UnregisterDeviceNotification", 0x0000E8D7, NULL, NULL},
	{"UnregisterHotKey", 0x0005CF8A, NULL, NULL},
	{"UnregisterMessagePumpHook", 0x0000FE08, NULL, NULL},
	{"UnregisterUserApiHook", 0x0000EDFB, NULL, NULL},
	{"UpdateLayeredWindow", 0x0001ACF3, NULL, NULL},
	{"UpdatePerUserSystemParameters", 0x000119C8, NULL, NULL},
	{"UpdateWindow", 0x0001AEAB, NULL, NULL},
	{"User32InitializeImmEntryTable", 0x0002D395, NULL, NULL},
	{"UserClientDllInitialize", 0x0000B217, NULL, NULL},
	{"UserHandleGrantAccess", 0x0005CFDA, NULL, NULL},
	{"UserLpkPSMTextOut", 0x0001BC25, NULL, NULL},
	{"UserLpkTabbedTextOut", 0x0004A3FB, NULL, NULL},
	{"UserRealizePalette", 0x0001FA56, NULL, NULL},
	{"UserRegisterWowHandlers", 0x00043748, NULL, NULL},
	{"VRipOutput", 0x0005B427, NULL, NULL},
	{"VTagOutput", 0x0005B427, NULL, NULL},
	{"ValidateRect", 0x0001FBBD, NULL, NULL},
	{"ValidateRgn", 0x0001F67E, NULL, NULL},
	{"VkKeyScanA", 0x0002E4C0, NULL, NULL},
	{"VkKeyScanExA", 0x0005B18B, NULL, NULL},
	{"VkKeyScanExW", 0x0001F1BC, NULL, NULL},
	{"VkKeyScanW", 0x0002E1F6, NULL, NULL},
	{"WCSToMBEx", 0x0001D446, NULL, NULL},
	{"WINNLSEnableIME", 0x0005B46B, NULL, NULL},
	{"WINNLSGetEnableStatus", 0x0005B47C, NULL, NULL},
	{"WINNLSGetIMEHotkey", 0x00023785, NULL, NULL},
	{"WaitForInputIdle", 0x0003FAF5, NULL, NULL},
	{"WaitMessage", 0x0000940C, NULL, NULL},
	{"Win32PoolAllocationStats", 0x0005D002, NULL, NULL},
	{"WinHelpA", 0x0002EE5D, NULL, NULL},
	{"WinHelpW", 0x00051BD4, NULL, NULL},
	{"WindowFromDC", 0x0001FA3E, NULL, NULL},
	{"WindowFromPoint", 0x00019766, NULL, NULL},
	{"keybd_event", 0x00056783, NULL, NULL},
	{"mouse_event", 0x0005673F, NULL, NULL},
	{"wsprintfA", 0x0000A8AD, NULL, NULL},
	{"wsprintfW", 0x0000A9B6, NULL, NULL},
	{"wvsprintfA", 0x0000A610, NULL, NULL},
	{"wvsprintfW", 0x0000A9D1, NULL, NULL},
	{0,0,NULL},
};

struct emu_env_w32_dll_export shell32_exports[] =
{
	{"SHChangeNotifyRegister", 0x0003EB0B, NULL, NULL},
	{"SHDefExtractIconA", 0x000F4E4E, NULL, NULL},
	{"SHChangeNotifyDeregister", 0x000349CA, NULL, NULL},
	{"SHDefExtractIconW", 0x000456B1, NULL, NULL},
	{"PifMgr_OpenProperties", 0x000C4045, NULL, NULL},
	{"PifMgr_GetProperties", 0x000C32C8, NULL, NULL},
	{"PifMgr_SetProperties", 0x000C3B47, NULL, NULL},
	{"PifMgr_CloseProperties", 0x000C2BAC, NULL, NULL},
	{"SHStartNetConnectionDialogW", 0x00111C25, NULL, NULL},
	{"ILFindLastID", 0x0002CE2C, NULL, NULL},
	{"ILRemoveLastID", 0x0002C667, NULL, NULL},
	{"ILClone", 0x0002B2A5, NULL, NULL},
	{"ILCloneFirst", 0x0002B514, NULL, NULL},
	{"ILIsEqual", 0x000311EB, NULL, NULL},
	{"DAD_DragEnterEx2", 0x000EEBAF, NULL, NULL},
	{"ILIsParent", 0x00031408, NULL, NULL},
	{"ILFindChild", 0x000314C8, NULL, NULL},
	{"ILCombine", 0x0002B5C5, NULL, NULL},
	{"ILLoadFromStream", 0x0004D37F, NULL, NULL},
	{"ILSaveToStream", 0x0006F484, NULL, NULL},
	{"SHILCreateFromPath", 0x0002E5F0, NULL, NULL},
	{"IsLFNDriveA", 0x000B519A, NULL, NULL},
	{"IsLFNDriveW", 0x00037851, NULL, NULL},
	{"PathIsExe", 0x0003755E, NULL, NULL},
	{"OpenAs_RunDLL", 0x000CE101, NULL, NULL},
	{"PathMakeUniqueName", 0x000B55CC, NULL, NULL},
	{"PathQualify", 0x000B51E4, NULL, NULL},
	{"PathResolve", 0x000494B2, NULL, NULL},
	{"RestartDialog", 0x000B8D55, NULL, NULL},
	{"PickIconDlg", 0x000B6467, NULL, NULL},
	{"GetFileNameFromBrowse", 0x000F751B, NULL, NULL},
	{"DriveType", 0x00030EAA, NULL, NULL},
	{"IsNetDrive", 0x00030618, NULL, NULL},
	{"Shell_MergeMenus", 0x0003F204, NULL, NULL},
	{"SHGetSetSettings", 0x0002C860, NULL, NULL},
	{"Shell_GetImageLists", 0x00033B8E, NULL, NULL},
	{"Shell_GetCachedImageIndex", 0x00033E68, NULL, NULL},
	{"SHShellFolderView_Message", 0x0010AD28, NULL, NULL},
	{"SHCreateStdEnumFmtEtc", 0x000A6ECA, NULL, NULL},
	{"PathYetAnotherMakeUniqueName", 0x000708E1, NULL, NULL},
	{"SHMapPIDLToSystemImageListIndex", 0x00043A54, NULL, NULL},
	{"SHOpenPropSheetW", 0x000B9711, NULL, NULL},
	{"OpenAs_RunDLLA", 0x000CE101, NULL, NULL},
	{"OpenRegStream", 0x0004C4F6, NULL, NULL},
	{"SHDoDragDrop", 0x000EED9D, NULL, NULL},
	{"SHCloneSpecialIDList", 0x00037053, NULL, NULL},
	{"SHFindFiles", 0x0010E52A, NULL, NULL},
	{"PathGetShortPath", 0x000B501E, NULL, NULL},
	{"SHGetRealIDL", 0x00078E09, NULL, NULL},
	{"SHRestricted", 0x0002C509, NULL, NULL},
	{"OpenAs_RunDLLW", 0x000CE1BB, NULL, NULL},
	{"SHCoCreateInstance", 0x0002B042, NULL, NULL},
	{"SignalFileOpen", 0x000F5BC8, NULL, NULL},
	{"Activate_RunDLL", 0x000CF1B4, NULL, NULL},
	{"AppCompat_RunDLLW", 0x000D8C1F, NULL, NULL},
	{"CheckEscapesA", 0x000BB421, NULL, NULL},
	{"CheckEscapesW", 0x000BB378, NULL, NULL},
	{"CommandLineToArgvW", 0x000813A0, NULL, NULL},
	{"Control_FillCache_RunDLL", 0x000B1710, NULL, NULL},
	{"Control_FillCache_RunDLLA", 0x000B1710, NULL, NULL},
	{"Control_FillCache_RunDLLW", 0x000B1805, NULL, NULL},
	{"Control_RunDLL", 0x000B23E8, NULL, NULL},
	{"Control_RunDLLA", 0x000B23E8, NULL, NULL},
	{"Control_RunDLLAsUserW", 0x000B249A, NULL, NULL},
	{"Control_RunDLLW", 0x000B2441, NULL, NULL},
	{"DllCanUnloadNow", 0x0006A2CD, NULL, NULL},
	{"DllGetClassObject", 0x00032899, NULL, NULL},
	{"DllGetVersion", 0x0004641B, NULL, NULL},
	{"IsLFNDrive", 0x00037851, NULL, NULL},
	{"DllInstall", 0x000F1DCC, NULL, NULL},
	{"SHFlushClipboard", 0x000B3F6C, NULL, NULL},
	{"DllRegisterServer", 0x00039B79, NULL, NULL},
	{"DllUnregisterServer", 0x00039B79, NULL, NULL},
	{"DAD_AutoScroll", 0x000E5770, NULL, NULL},
	{"DAD_DragEnterEx", 0x000EEC08, NULL, NULL},
	{"DAD_DragLeave", 0x000EED3C, NULL, NULL},
	{"DoEnvironmentSubstA", 0x000B375A, NULL, NULL},
	{"DAD_DragMove", 0x000EEC61, NULL, NULL},
	{"DoEnvironmentSubstW", 0x00080DB7, NULL, NULL},
	{"DAD_SetDragImage", 0x000EECA1, NULL, NULL},
	{"DAD_ShowDragImage", 0x0004F6E4, NULL, NULL},
	{"DragAcceptFiles", 0x0006B201, NULL, NULL},
	{"DragFinish", 0x000B7CE5, NULL, NULL},
	{"DragQueryFile", 0x000B7CF6, NULL, NULL},
	{"DragQueryFileA", 0x000B7CF6, NULL, NULL},
	{"DragQueryFileAorW", 0x00058339, NULL, NULL},
	{"DragQueryFileW", 0x00058316, NULL, NULL},
	{"DragQueryPoint", 0x000B7C88, NULL, NULL},
	{"SHCLSIDFromString", 0x0002CC63, NULL, NULL},
	{"SHMapIDListToImageListIndexAsync", 0x00042D74, NULL, NULL},
	{"SHFind_InitMenuPopup", 0x0010CEFE, NULL, NULL},
	{"DuplicateIcon", 0x000B2AFF, NULL, NULL},
	{"SHLoadOLE", 0x0002ACD1, NULL, NULL},
	{"ILGetSize", 0x0002B240, NULL, NULL},
	{"ILGetNext", 0x000744C7, NULL, NULL},
	{"ILAppendID", 0x000F78F9, NULL, NULL},
	{"ILFree", 0x0002AB7C, NULL, NULL},
	{"ILCreateFromPath", 0x0002E78F, NULL, NULL},
	{"SHRunControlPanel", 0x000B23CD, NULL, NULL},
	{"SHSimpleIDListFromPath", 0x0002B1B9, NULL, NULL},
	{"Win32DeleteFile", 0x0007051D, NULL, NULL},
	{"SHCreateDirectory", 0x000AA975, NULL, NULL},
	{"CallCPLEntry16", 0x000BD7E2, NULL, NULL},
	{"SHAddFromPropSheetExtArray", 0x000B78E3, NULL, NULL},
	{"SHCreatePropSheetExtArray", 0x000B7B13, NULL, NULL},
	{"SHDestroyPropSheetExtArray", 0x000B78AC, NULL, NULL},
	{"SHReplaceFromPropSheetExtArray", 0x000B793B, NULL, NULL},
	{"PathCleanupSpec", 0x00070AC4, NULL, NULL},
	{"SHValidateUNC", 0x000F5418, NULL, NULL},
	{"SHCreateShellFolderViewEx", 0x0010B1B4, NULL, NULL},
	{"SHSetInstanceExplorer", 0x001042A0, NULL, NULL},
	{"SHObjectProperties", 0x000B3A8A, NULL, NULL},
	{"SHGetNewLinkInfoA", 0x0010290F, NULL, NULL},
	{"SHGetNewLinkInfoW", 0x00070B62, NULL, NULL},
	{"ShellMessageBoxW", 0x001DCD3A, NULL, NULL},
	{"ShellMessageBoxA", 0x000B3E9E, NULL, NULL},
	{"ILCreateFromPathA", 0x000F7B58, NULL, NULL},
	{"ILCreateFromPathW", 0x0002E78F, NULL, NULL},
	{"SHUpdateImageA", 0x000FB7A5, NULL, NULL},
	{"SHUpdateImageW", 0x000FB666, NULL, NULL},
	{"SHHandleUpdateImage", 0x000FAFBE, NULL, NULL},
	{"SHFree", 0x0002A97A, NULL, NULL},
	{"SHAlloc", 0x0002B210, NULL, NULL},
	{"ExtractAssociatedIconA", 0x000B3615, NULL, NULL},
	{"ExtractAssociatedIconExA", 0x000B3356, NULL, NULL},
	{"ExtractAssociatedIconExW", 0x000B318B, NULL, NULL},
	{"ExtractAssociatedIconW", 0x000B3449, NULL, NULL},
	{"ExtractIconA", 0x000B34A7, NULL, NULL},
	{"ExtractIconEx", 0x000B2AEE, NULL, NULL},
	{"ExtractIconExA", 0x000B2AEE, NULL, NULL},
	{"ExtractIconExW", 0x00036CBF, NULL, NULL},
	{"ExtractIconResInfoA", 0x000B311F, NULL, NULL},
	{"ExtractIconResInfoW", 0x000B2C16, NULL, NULL},
	{"ExtractIconW", 0x00071896, NULL, NULL},
	{"ExtractVersionResource16W", 0x00069681, NULL, NULL},
	{"FindExeDlgProc", 0x0013890D, NULL, NULL},
	{"FindExecutableA", 0x0007FA54, NULL, NULL},
	{"FindExecutableW", 0x0007FAE6, NULL, NULL},
	{"FreeIconList", 0x000B2BB5, NULL, NULL},
	{"InternalExtractIconListA", 0x00062369, NULL, NULL},
	{"InternalExtractIconListW", 0x000B350B, NULL, NULL},
	{"Options_RunDLL", 0x0019C862, NULL, NULL},
	{"PathIsSlowW", 0x00031291, NULL, NULL},
	{"PathIsSlowA", 0x000B4C21, NULL, NULL},
	{"SHTestTokenMembership", 0x0004BF97, NULL, NULL},
	{"Options_RunDLLA", 0x0019C862, NULL, NULL},
	{"SHCreateShellFolderView", 0x0004086A, NULL, NULL},
	{"Options_RunDLLW", 0x0019C88E, NULL, NULL},
	{"PrintersGetCommand_RunDLL", 0x000B7440, NULL, NULL},
	{"PrintersGetCommand_RunDLLA", 0x000B7440, NULL, NULL},
	{"PrintersGetCommand_RunDLLW", 0x000B74C5, NULL, NULL},
	{"RealShellExecuteA", 0x000F5E02, NULL, NULL},
	{"RealShellExecuteExA", 0x000F5CB0, NULL, NULL},
	{"RealShellExecuteExW", 0x000F5D59, NULL, NULL},
	{"RealShellExecuteW", 0x000F5E35, NULL, NULL},
	{"RegenerateUserEnvironment", 0x000BD3B6, NULL, NULL},
	{"SHAddToRecentDocs", 0x0006FD7A, NULL, NULL},
	{"SHAppBarMessage", 0x0010410F, NULL, NULL},
	{"SHBindToParent", 0x00033D18, NULL, NULL},
	{"SHBrowseForFolder", 0x0010734B, NULL, NULL},
	{"SHBrowseForFolderA", 0x0010734B, NULL, NULL},
	{"SHBrowseForFolderW", 0x00107251, NULL, NULL},
	{"SHChangeNotify", 0x000383C9, NULL, NULL},
	{"SHChangeNotifySuspendResume", 0x000FB585, NULL, NULL},
	{"SHCreateDirectoryExA", 0x000AA990, NULL, NULL},
	{"SHCreateDirectoryExW", 0x00051C92, NULL, NULL},
	{"SHCreateLocalServerRunDll", 0x0019E7FA, NULL, NULL},
	{"SHCreateProcessAsUserW", 0x00109644, NULL, NULL},
	{"SHCreateQueryCancelAutoPlayMoniker", 0x00081FCE, NULL, NULL},
	{"SHCreateShellItem", 0x00102D66, NULL, NULL},
	{"SHEmptyRecycleBinA", 0x000A6D6B, NULL, NULL},
	{"SHEmptyRecycleBinW", 0x000A6D01, NULL, NULL},
	{"SHEnableServiceObject", 0x0010427F, NULL, NULL},
	{"SHEnumerateUnreadMailAccountsW", 0x000D26EA, NULL, NULL},
	{"SHExtractIconsW", 0x00045762, NULL, NULL},
	{"SHFileOperation", 0x000B0BCC, NULL, NULL},
	{"SHFileOperationA", 0x000B0BCC, NULL, NULL},
	{"SHFileOperationW", 0x000B08E4, NULL, NULL},
	{"SHFormatDrive", 0x000D84D5, NULL, NULL},
	{"SHFreeNameMappings", 0x000A9171, NULL, NULL},
	{"SHGetDataFromIDListA", 0x00102690, NULL, NULL},
	{"SHGetDataFromIDListW", 0x0006AB11, NULL, NULL},
	{"SHGetDesktopFolder", 0x0002BC18, NULL, NULL},
	{"SHGetDiskFreeSpaceA", 0x000B3850, NULL, NULL},
	{"SHGetDiskFreeSpaceExA", 0x000B3850, NULL, NULL},
	{"SHGetDiskFreeSpaceExW", 0x00039B81, NULL, NULL},
	{"SHGetFileInfo", 0x000715A9, NULL, NULL},
	{"SHGetFileInfoA", 0x000715A9, NULL, NULL},
	{"SHGetFileInfoW", 0x0006B04B, NULL, NULL},
	{"SHGetFolderLocation", 0x0002F711, NULL, NULL},
	{"SHGetFolderPathA", 0x0006AC69, NULL, NULL},
	{"SHGetFolderPathAndSubDirA", 0x000F9C9C, NULL, NULL},
	{"SHGetFolderPathAndSubDirW", 0x00051C10, NULL, NULL},
	{"SHGetFolderPathW", 0x0002F226, NULL, NULL},
	{"SHGetIconOverlayIndexA", 0x00113CA6, NULL, NULL},
	{"SHGetIconOverlayIndexW", 0x00113BCE, NULL, NULL},
	{"SHGetInstanceExplorer", 0x001042B6, NULL, NULL},
	{"SHGetMalloc", 0x0006B3ED, NULL, NULL},
	{"SHGetNewLinkInfo", 0x0010290F, NULL, NULL},
	{"SHGetPathFromIDList", 0x00074C89, NULL, NULL},
	{"SHGetPathFromIDListA", 0x00074C89, NULL, NULL},
	{"SHGetPathFromIDListW", 0x00031000, NULL, NULL},
	{"SHGetSettings", 0x0007FC05, NULL, NULL},
	{"SHGetSpecialFolderLocation", 0x0002F793, NULL, NULL},
	{"SHGetSpecialFolderPathA", 0x000F9C6E, env_hook_SHGetSpecialFolderPathA, NULL},
	{"SHGetSpecialFolderPathW", 0x0002B1D8, NULL, NULL},
	{"SHGetUnreadMailCountW", 0x000D4ED8, NULL, NULL},
	{"SHHelpShortcuts_RunDLL", 0x000B3A1F, NULL, NULL},
	{"SHHelpShortcuts_RunDLLA", 0x000B3A1F, NULL, NULL},
	{"SHHelpShortcuts_RunDLLW", 0x000B3A7A, NULL, NULL},
	{"SHInvokePrinterCommandA", 0x000B72B3, NULL, NULL},
	{"SHInvokePrinterCommandW", 0x000B727E, NULL, NULL},
	{"SHIsFileAvailableOffline", 0x000D2300, NULL, NULL},
	{"SHLoadInProc", 0x00104267, NULL, NULL},
	{"SHLoadNonloadedIconOverlayIdentifiers", 0x00116D97, NULL, NULL},
	{"SHOpenFolderAndSelectItems", 0x00102CCE, NULL, NULL},
	{"SHParseDisplayName", 0x0002E020, NULL, NULL},
	{"SHPathPrepareForWriteA", 0x000D4BBC, NULL, NULL},
	{"SHPathPrepareForWriteW", 0x000809F2, NULL, NULL},
	{"SHQueryRecycleBinA", 0x000A6A02, NULL, NULL},
	{"SHQueryRecycleBinW", 0x000A6970, NULL, NULL},
	{"SHSetLocalizedName", 0x0006808C, NULL, NULL},
	{"SHSetUnreadMailCountW", 0x000D50EC, NULL, NULL},
	{"SHUpdateRecycleBinIcon", 0x00052728, NULL, NULL},
	{"SheChangeDirA", 0x000BBCAA, NULL, NULL},
	{"SheChangeDirExA", 0x000BC265, NULL, NULL},
	{"SheChangeDirExW", 0x000BBFE1, NULL, NULL},
	{"SheChangeDirW", 0x000BBAC6, NULL, NULL},
	{"SheConvertPathW", 0x000CC6AE, NULL, NULL},
	{"SheFullPathA", 0x000BBD7A, NULL, NULL},
	{"SheFullPathW", 0x000BBE2C, NULL, NULL},
	{"SheGetCurDrive", 0x000BBD03, NULL, NULL},
	{"SheGetDirA", 0x000BBA5C, NULL, NULL},
	{"SheGetDirExW", 0x000BBEE4, NULL, NULL},
	{"SheGetDirW", 0x000BB9BA, NULL, NULL},
	{"SheGetPathOffsetW", 0x000BB940, NULL, NULL},
	{"SheRemoveQuotesA", 0x000CC08F, NULL, NULL},
	{"SheRemoveQuotesW", 0x000CC053, NULL, NULL},
	{"SheSetCurDrive", 0x000BBD29, NULL, NULL},
	{"SheShortenPathA", 0x000CC2F9, NULL, NULL},
	{"SheShortenPathW", 0x000CC146, NULL, NULL},
	{"ShellAboutA", 0x000A2F5E, NULL, NULL},
	{"ShellAboutW", 0x000A2F0F, NULL, NULL},
	{"ShellExec_RunDLL", 0x00108A1E, NULL, NULL},
	{"ShellExec_RunDLLA", 0x00108A1E, NULL, NULL},
	{"ShellExec_RunDLLW", 0x00108A84, NULL, NULL},
	{"ShellExecuteA", 0x000811A8, NULL, NULL},
	{"ShellExecuteEx", 0x00080E7D, NULL, NULL},
	{"ShellExecuteExA", 0x00080E7D, NULL, NULL},
	{"ShellExecuteExW", 0x0004991B, NULL, NULL},
	{"ShellExecuteW", 0x000F5E68, NULL, NULL},
	{"ShellHookProc", 0x00062369, NULL, NULL},
	{"Shell_NotifyIcon", 0x00068C16, NULL, NULL},
	{"Shell_NotifyIconA", 0x00068C16, NULL, NULL},
	{"Shell_NotifyIconW", 0x0006A587, NULL, NULL},
	{"StrChrA", 0x001DCD45, NULL, NULL},
	{"StrChrIA", 0x001DCD50, NULL, NULL},
	{"StrChrIW", 0x001DCD5B, NULL, NULL},
	{"StrChrW", 0x001DCD66, NULL, NULL},
	{"StrCmpNA", 0x001DCD71, NULL, NULL},
	{"StrCmpNIA", 0x001DCD7C, NULL, NULL},
	{"StrCmpNIW", 0x001DCD87, NULL, NULL},
	{"StrCmpNW", 0x001DCD92, NULL, NULL},
	{"StrCpyNA", 0x000BB557, NULL, NULL},
	{"StrCpyNW", 0x000BB516, NULL, NULL},
	{"StrNCmpA", 0x000BB619, NULL, NULL},
	{"StrNCmpIA", 0x000BB6FE, NULL, NULL},
	{"StrNCmpIW", 0x000BB691, NULL, NULL},
	{"StrNCmpW", 0x000BB593, NULL, NULL},
	{"StrNCpyA", 0x000BB7C1, NULL, NULL},
	{"StrNCpyW", 0x000BB776, NULL, NULL},
	{"StrRChrA", 0x001DCD9D, NULL, NULL},
	{"StrRChrIA", 0x001DCDA8, NULL, NULL},
	{"StrRChrIW", 0x001DCDB3, NULL, NULL},
	{"StrRChrW", 0x001DCDBE, NULL, NULL},
	{"StrRStrA", 0x000BB87E, NULL, NULL},
	{"StrRStrIA", 0x001DCDC9, NULL, NULL},
	{"StrRStrIW", 0x001DCDD4, NULL, NULL},
	{"StrRStrW", 0x000BB811, NULL, NULL},
	{"StrStrA", 0x001DCDDF, NULL, NULL},
	{"StrStrIA", 0x001DCDEA, NULL, NULL},
	{"StrStrIW", 0x000711BF, NULL, NULL},
	{"StrStrW", 0x001DCDF5, NULL, NULL},
	{"WOWShellExecute", 0x00108888, NULL, NULL},
	{"SHAllocShared", 0x0002A59E, NULL, NULL},
	{"SHLockShared", 0x0002A5C9, NULL, NULL},
	{"SHUnlockShared", 0x0002A5DE, NULL, NULL},
	{"SHFreeShared", 0x0002A5B4, NULL, NULL},
	{"RealDriveType", 0x00030E72, NULL, NULL},
	{"SHFlushSFCache", 0x000681BE, NULL, NULL},
	{"SHChangeNotification_Lock", 0x00069325, NULL, NULL},
	{"SHChangeNotification_Unlock", 0x00037ED0, NULL, NULL},
	{"WriteCabinetState", 0x000A71AF, NULL, NULL},
	{"PathProcessCommand", 0x00054ED3, NULL, NULL},
	{"ReadCabinetState", 0x0007482C, NULL, NULL},
	{"IsUserAnAdmin", 0x000545A3, NULL, NULL},
	{"SHPropStgCreate", 0x00114816, NULL, NULL},
	{"SHPropStgReadMultiple", 0x00077AB9, NULL, NULL},
	{"SHPropStgWriteMultiple", 0x00115476, NULL, NULL},
	{"CDefFolderMenu_Create", 0x000DA34E, NULL, NULL},
	{"CDefFolderMenu_Create2", 0x000DA3ED, NULL, NULL},
	{"SHGetSetFolderCustomSettingsW", 0x0006460D, NULL, NULL},
	{"SHMultiFileProperties", 0x001165F0, NULL, NULL},
	{"SHGetImageList", 0x00046941, NULL, NULL},
	{"RestartDialogEx", 0x000B8465, NULL, NULL},
	{"SHCreateFileExtractIconW", 0x00102ED2, NULL, NULL},
	{"SHLimitInputEdit", 0x0011614A, NULL, NULL},
	{"SHGetShellStyleHInstance", 0x000D5574, NULL, NULL},
	{"SHGetAttributesFromDataObject", 0x000D2B61, NULL, NULL},
	{0,0,NULL},
};

struct emu_env_w32_dll_export ntdll_exports[] = 
{
	{"PropertyLengthAsVariant", 0x00059D2B, NULL, NULL},
	{"RtlConvertPropertyToVariant", 0x00059C93, NULL, NULL},
	{"RtlConvertVariantToProperty", 0x00059BF5, NULL, NULL},
	{"RtlInterlockedPushListSList", 0x00002AD0, NULL, NULL},
	{"RtlUlongByteSwap", 0x00002B30, NULL, NULL},
	{"RtlUlonglongByteSwap", 0x00002B40, NULL, NULL},
	{"RtlUshortByteSwap", 0x00002B20, NULL, NULL},
	{"CsrAllocateCaptureBuffer", 0x0001EB78, NULL, NULL},
	{"CsrAllocateMessagePointer", 0x0001EBD9, NULL, NULL},
	{"CsrCaptureMessageBuffer", 0x0001E3CF, NULL, NULL},
	{"CsrCaptureMessageMultiUnicodeStringsInPlace", 0x0002064D, NULL, NULL},
	{"CsrCaptureMessageString", 0x0002070E, NULL, NULL},
	{"CsrCaptureTimeout", 0x00051C6A, NULL, NULL},
	{"CsrClientCallServer", 0x00012D91, NULL, NULL},
	{"CsrClientConnectToServer", 0x00021207, NULL, NULL},
	{"CsrFreeCaptureBuffer", 0x0001EB1F, NULL, NULL},
	{"CsrGetProcessId", 0x00051C5F, NULL, NULL},
	{"CsrIdentifyAlertableThread", 0x00051BDA, NULL, NULL},
	{"CsrNewThread", 0x0001B0AA, NULL, NULL},
	{"CsrProbeForRead", 0x00051CEB, NULL, NULL},
	{"CsrProbeForWrite", 0x00051C9D, NULL, NULL},
	{"CsrSetPriorityClass", 0x00051C16, NULL, NULL},
	{"DbgBreakPoint", 0x0000120E, NULL, NULL},
	{"DbgPrint", 0x0002FB6F, NULL, NULL},
	{"DbgPrintEx", 0x0001EAF5, NULL, NULL},
	{"DbgPrintReturnControlC", 0x00059EB2, NULL, NULL},
	{"DbgPrompt", 0x00059FA1, NULL, NULL},
	{"DbgQueryDebugFilterState", 0x00059FE7, NULL, NULL},
	{"DbgSetDebugFilterState", 0x00059FF7, NULL, NULL},
	{"DbgUiConnectToDbg", 0x00051D21, NULL, NULL},
	{"DbgUiContinue", 0x00051DCC, NULL, NULL},
	{"DbgUiConvertStateChangeStructure", 0x00051EF4, NULL, NULL},
	{"DbgUiDebugActiveProcess", 0x00051EB2, NULL, NULL},
	{"DbgUiGetThreadDebugObject", 0x00051D76, NULL, NULL},
	{"DbgUiIssueRemoteBreakin", 0x00051E71, NULL, NULL},
	{"DbgUiRemoteBreakin", 0x00051E13, NULL, NULL},
	{"DbgUiSetThreadDebugObject", 0x00051D88, NULL, NULL},
	{"DbgUiStopDebugging", 0x00051DF1, NULL, NULL},
	{"DbgUiWaitStateChange", 0x00051DA5, NULL, NULL},
	{"DbgUserBreakPoint", 0x00001212, NULL, NULL},
	{"KiFastSystemCall", 0x0000E510, NULL, NULL},
	{"KiFastSystemCallRet", 0x0000E514, NULL, NULL},
	{"KiIntSystemCall", 0x0000E520, NULL, NULL},
	{"KiRaiseUserExceptionDispatcher", 0x0000E4C8, NULL, NULL},
	{"KiUserApcDispatcher", 0x0000E450, NULL, NULL},
	{"KiUserCallbackDispatcher", 0x0000E460, NULL, NULL},
	{"KiUserExceptionDispatcher", 0x0000E47C, NULL, NULL},
	{"LdrAccessOutOfProcessResource", 0x000209B8, NULL, NULL},
	{"LdrAccessResource", 0x000127A8, NULL, NULL},
	{"LdrAddRefDll", 0x0002CB05, NULL, NULL},
	{"LdrAlternateResourcesEnabled", 0x0004888F, NULL, NULL},
	{"LdrCreateOutOfProcessImage", 0x000201C3, NULL, NULL},
	{"LdrDestroyOutOfProcessImage", 0x000202DD, NULL, NULL},
	{"LdrDisableThreadCalloutsForDll", 0x0001D6FB, NULL, NULL},
	{"LdrEnumResources", 0x0005A110, NULL, NULL},
	{"LdrEnumerateLoadedModules", 0x00021405, NULL, NULL},
	{"LdrFindCreateProcessManifest", 0x0001FE25, NULL, NULL},
	{"LdrFindEntryForAddress", 0x0005A07B, NULL, NULL},
	{"LdrFindResourceDirectory_U", 0x0001C26D, NULL, NULL},
	{"LdrFindResourceEx_U", 0x0005AE3E, NULL, NULL},
	{"LdrFindResource_U", 0x00012787, NULL, NULL},
	{"LdrFlushAlternateResourceModules", 0x0002ED52, NULL, NULL},
	{"LdrGetDllHandle", 0x000166A0, NULL, NULL},
	{"LdrGetDllHandleEx", 0x000166C1, NULL, NULL},
	{"LdrGetProcedureAddress", 0x00017EA8, NULL, NULL},
	{"LdrHotPatchRoutine", 0x000521DE, NULL, NULL},
	{"LdrInitShimEngineDynamic", 0x00052CC2, NULL, NULL},
	{"LdrInitializeThunk", 0x00001166, NULL, NULL},
	{"LdrLoadAlternateResourceModule", 0x00012808, NULL, NULL},
	{"LdrLoadDll", 0x000163C3, NULL, NULL},
	{"LdrLockLoaderLock", 0x00012C63, NULL, NULL},
	{"LdrProcessRelocationBlock", 0x0005B52C, NULL, NULL},
	{"LdrQueryImageFileExecutionOptions", 0x0001CCA3, NULL, NULL},
	{"LdrQueryProcessModuleInformation", 0x00052A31, NULL, NULL},
	{"LdrSetAppCompatDllRedirectionCallback", 0x00052A51, NULL, NULL},
	{"LdrSetDllManifestProber", 0x0002221F, NULL, NULL},
	{"LdrShutdownProcess", 0x00023BD8, NULL, NULL},
	{"LdrShutdownThread", 0x00013956, NULL, NULL},
	{"LdrUnloadAlternateResourceModule", 0x00019951, NULL, NULL},
	{"LdrUnloadDll", 0x0001738B, NULL, NULL},
	{"LdrUnlockLoaderLock", 0x00012D19, NULL, NULL},
	{"LdrVerifyImageMatchesChecksum", 0x00030A3C, NULL, NULL},
	{"NlsAnsiCodePage", 0x0007E098, NULL, NULL},
	{"NlsMbCodePageTag", 0x0007E0A0, NULL, NULL},
	{"NlsMbOemCodePageTag", 0x0007E0A8, NULL, NULL},
	{"NtAcceptConnectPort", 0x0000CE5E, NULL, NULL},
	{"NtAccessCheck", 0x0000CE6E, NULL, NULL},
	{"NtAccessCheckAndAuditAlarm", 0x0000CE7E, NULL, NULL},
	{"NtAccessCheckByType", 0x0000CE8E, NULL, NULL},
	{"NtAccessCheckByTypeAndAuditAlarm", 0x0000CE9E, NULL, NULL},
	{"NtAccessCheckByTypeResultList", 0x0000CEAE, NULL, NULL},
	{"NtAccessCheckByTypeResultListAndAuditAlarm", 0x0000CEBE, NULL, NULL},
	{"NtAccessCheckByTypeResultListAndAuditAlarmByHandle", 0x0000CECE, NULL, NULL},
	{"NtAddAtom", 0x0000CEDE, NULL, NULL},
	{"NtAddBootEntry", 0x0000CEEE, NULL, NULL},
	{"NtAdjustGroupsToken", 0x0000CEFE, NULL, NULL},
	{"NtAdjustPrivilegesToken", 0x0000CF0E, NULL, NULL},
	{"NtAlertResumeThread", 0x0000CF1E, NULL, NULL},
	{"NtAlertThread", 0x0000CF2E, NULL, NULL},
	{"NtAllocateLocallyUniqueId", 0x0000CF3E, NULL, NULL},
	{"NtAllocateUserPhysicalPages", 0x0000CF4E, NULL, NULL},
	{"NtAllocateUuids", 0x0000CF5E, NULL, NULL},
	{"NtAllocateVirtualMemory", 0x0000CF6E, NULL, NULL},
	{"NtAreMappedFilesTheSame", 0x0000CF7E, NULL, NULL},
	{"NtAssignProcessToJobObject", 0x0000CF8E, NULL, NULL},
	{"NtCallbackReturn", 0x0000CF9E, NULL, NULL},
	{"NtCancelDeviceWakeupRequest", 0x0000CFAE, NULL, NULL},
	{"NtCancelIoFile", 0x0000CFBE, NULL, NULL},
	{"NtCancelTimer", 0x0000CFCE, NULL, NULL},
	{"NtClearEvent", 0x0000CFDE, NULL, NULL},
	{"NtClose", 0x0000CFEE, NULL, NULL},
	{"NtCloseObjectAuditAlarm", 0x0000CFFE, NULL, NULL},
	{"NtCompactKeys", 0x0000D00E, NULL, NULL},
	{"NtCompareTokens", 0x0000D01E, NULL, NULL},
	{"NtCompleteConnectPort", 0x0000D02E, NULL, NULL},
	{"NtCompressKey", 0x0000D03E, NULL, NULL},
	{"NtConnectPort", 0x0000D04E, NULL, NULL},
	{"NtContinue", 0x0000D05E, NULL, NULL},
	{"NtCreateDebugObject", 0x0000D06E, NULL, NULL},
	{"NtCreateDirectoryObject", 0x0000D07E, NULL, NULL},
	{"NtCreateEvent", 0x0000D08E, NULL, NULL},
	{"NtCreateEventPair", 0x0000D09E, NULL, NULL},
	{"NtCreateFile", 0x0000D0AE, NULL, NULL},
	{"NtCreateIoCompletion", 0x0000D0BE, NULL, NULL},
	{"NtCreateJobObject", 0x0000D0CE, NULL, NULL},
	{"NtCreateJobSet", 0x0000D0DE, NULL, NULL},
	{"NtCreateKey", 0x0000D0EE, NULL, NULL},
	{"NtCreateKeyedEvent", 0x0000DFCE, NULL, NULL},
	{"NtCreateMailslotFile", 0x0000D0FE, NULL, NULL},
	{"NtCreateMutant", 0x0000D10E, NULL, NULL},
	{"NtCreateNamedPipeFile", 0x0000D11E, NULL, NULL},
	{"NtCreatePagingFile", 0x0000D12E, NULL, NULL},
	{"NtCreatePort", 0x0000D13E, NULL, NULL},
	{"NtCreateProcess", 0x0000D14E, NULL, NULL},
	{"NtCreateProcessEx", 0x0000D15E, NULL, NULL},
	{"NtCreateProfile", 0x0000D16E, NULL, NULL},
	{"NtCreateSection", 0x0000D17E, NULL, NULL},
	{"NtCreateSemaphore", 0x0000D18E, NULL, NULL},
	{"NtCreateSymbolicLinkObject", 0x0000D19E, NULL, NULL},
	{"NtCreateThread", 0x0000D1AE, NULL, NULL},
	{"NtCreateTimer", 0x0000D1BE, NULL, NULL},
	{"NtCreateToken", 0x0000D1CE, NULL, NULL},
	{"NtCreateWaitablePort", 0x0000D1DE, NULL, NULL},
	{"NtCurrentTeb", 0x0000121E, NULL, NULL},
	{"NtDebugActiveProcess", 0x0000D1EE, NULL, NULL},
	{"NtDebugContinue", 0x0000D1FE, NULL, NULL},
	{"NtDelayExecution", 0x0000D20E, NULL, NULL},
	{"NtDeleteAtom", 0x0000D21E, NULL, NULL},
	{"NtDeleteBootEntry", 0x0000D22E, NULL, NULL},
	{"NtDeleteFile", 0x0000D23E, NULL, NULL},
	{"NtDeleteKey", 0x0000D24E, NULL, NULL},
	{"NtDeleteObjectAuditAlarm", 0x0000D25E, NULL, NULL},
	{"NtDeleteValueKey", 0x0000D26E, NULL, NULL},
	{"NtDeviceIoControlFile", 0x0000D27E, NULL, NULL},
	{"NtDisplayString", 0x0000D28E, NULL, NULL},
	{"NtDuplicateObject", 0x0000D29E, NULL, NULL},
	{"NtDuplicateToken", 0x0000D2AE, NULL, NULL},
	{"NtEnumerateBootEntries", 0x0000D2BE, NULL, NULL},
	{"NtEnumerateKey", 0x0000D2CE, NULL, NULL},
	{"NtEnumerateSystemEnvironmentValuesEx", 0x0000D2DE, NULL, NULL},
	{"NtEnumerateValueKey", 0x0000D2EE, NULL, NULL},
	{"NtExtendSection", 0x0000D2FE, NULL, NULL},
	{"NtFilterToken", 0x0000D30E, NULL, NULL},
	{"NtFindAtom", 0x0000D31E, NULL, NULL},
	{"NtFlushBuffersFile", 0x0000D32E, NULL, NULL},
	{"NtFlushInstructionCache", 0x0000D33E, NULL, NULL},
	{"NtFlushKey", 0x0000D34E, NULL, NULL},
	{"NtFlushVirtualMemory", 0x0000D35E, NULL, NULL},
	{"NtFlushWriteBuffer", 0x0000D36E, NULL, NULL},
	{"NtFreeUserPhysicalPages", 0x0000D37E, NULL, NULL},
	{"NtFreeVirtualMemory", 0x0000D38E, NULL, NULL},
	{"NtFsControlFile", 0x0000D39E, NULL, NULL},
	{"NtGetContextThread", 0x0000D3AE, NULL, NULL},
	{"NtGetDevicePowerState", 0x0000D3BE, NULL, NULL},
	{"NtGetPlugPlayEvent", 0x0000D3CE, NULL, NULL},
	{"NtGetWriteWatch", 0x0000D3DE, NULL, NULL},
	{"NtImpersonateAnonymousToken", 0x0000D3EE, NULL, NULL},
	{"NtImpersonateClientOfPort", 0x0000D3FE, NULL, NULL},
	{"NtImpersonateThread", 0x0000D40E, NULL, NULL},
	{"NtInitializeRegistry", 0x0000D41E, NULL, NULL},
	{"NtInitiatePowerAction", 0x0000D42E, NULL, NULL},
	{"NtIsProcessInJob", 0x0000D43E, NULL, NULL},
	{"NtIsSystemResumeAutomatic", 0x0000D44E, NULL, NULL},
	{"NtListenPort", 0x0000D45E, NULL, NULL},
	{"NtLoadDriver", 0x0000D46E, NULL, NULL},
	{"NtLoadKey2", 0x0000D48E, NULL, NULL},
	{"NtLoadKey", 0x0000D47E, NULL, NULL},
	{"NtLockFile", 0x0000D49E, NULL, NULL},
	{"NtLockProductActivationKeys", 0x0000D4AE, NULL, NULL},
	{"NtLockRegistryKey", 0x0000D4BE, NULL, NULL},
	{"NtLockVirtualMemory", 0x0000D4CE, NULL, NULL},
	{"NtMakePermanentObject", 0x0000D4DE, NULL, NULL},
	{"NtMakeTemporaryObject", 0x0000D4EE, NULL, NULL},
	{"NtMapUserPhysicalPages", 0x0000D4FE, NULL, NULL},
	{"NtMapUserPhysicalPagesScatter", 0x0000D50E, NULL, NULL},
	{"NtMapViewOfSection", 0x0000D51E, NULL, NULL},
	{"NtModifyBootEntry", 0x0000D52E, NULL, NULL},
	{"NtNotifyChangeDirectoryFile", 0x0000D53E, NULL, NULL},
	{"NtNotifyChangeKey", 0x0000D54E, NULL, NULL},
	{"NtNotifyChangeMultipleKeys", 0x0000D55E, NULL, NULL},
	{"NtOpenDirectoryObject", 0x0000D56E, NULL, NULL},
	{"NtOpenEvent", 0x0000D57E, NULL, NULL},
	{"NtOpenEventPair", 0x0000D58E, NULL, NULL},
	{"NtOpenFile", 0x0000D59E, NULL, NULL},
	{"NtOpenIoCompletion", 0x0000D5AE, NULL, NULL},
	{"NtOpenJobObject", 0x0000D5BE, NULL, NULL},
	{"NtOpenKey", 0x0000D5CE, NULL, NULL},
	{"NtOpenKeyedEvent", 0x0000DFDE, NULL, NULL},
	{"NtOpenMutant", 0x0000D5DE, NULL, NULL},
	{"NtOpenObjectAuditAlarm", 0x0000D5EE, NULL, NULL},
	{"NtOpenProcess", 0x0000D5FE, NULL, NULL},
	{"NtOpenProcessToken", 0x0000D60E, NULL, NULL},
	{"NtOpenProcessTokenEx", 0x0000D61E, NULL, NULL},
	{"NtOpenSection", 0x0000D62E, NULL, NULL},
	{"NtOpenSemaphore", 0x0000D63E, NULL, NULL},
	{"NtOpenSymbolicLinkObject", 0x0000D64E, NULL, NULL},
	{"NtOpenThread", 0x0000D65E, NULL, NULL},
	{"NtOpenThreadToken", 0x0000D66E, NULL, NULL},
	{"NtOpenThreadTokenEx", 0x0000D67E, NULL, NULL},
	{"NtOpenTimer", 0x0000D68E, NULL, NULL},
	{"NtPlugPlayControl", 0x0000D69E, NULL, NULL},
	{"NtPowerInformation", 0x0000D6AE, NULL, NULL},
	{"NtPrivilegeCheck", 0x0000D6BE, NULL, NULL},
	{"NtPrivilegeObjectAuditAlarm", 0x0000D6CE, NULL, NULL},
	{"NtPrivilegedServiceAuditAlarm", 0x0000D6DE, NULL, NULL},
	{"NtProtectVirtualMemory", 0x0000D6EE, NULL, NULL},
	{"NtPulseEvent", 0x0000D6FE, NULL, NULL},
	{"NtQueryAttributesFile", 0x0000D70E, NULL, NULL},
	{"NtQueryBootEntryOrder", 0x0000D71E, NULL, NULL},
	{"NtQueryBootOptions", 0x0000D72E, NULL, NULL},
	{"NtQueryDebugFilterState", 0x0000D73E, NULL, NULL},
	{"NtQueryDefaultLocale", 0x0000D74E, NULL, NULL},
	{"NtQueryDefaultUILanguage", 0x0000D75E, NULL, NULL},
	{"NtQueryDirectoryFile", 0x0000D76E, NULL, NULL},
	{"NtQueryDirectoryObject", 0x0000D77E, NULL, NULL},
	{"NtQueryEaFile", 0x0000D78E, NULL, NULL},
	{"NtQueryEvent", 0x0000D79E, NULL, NULL},
	{"NtQueryFullAttributesFile", 0x0000D7AE, NULL, NULL},
	{"NtQueryInformationAtom", 0x0000D7BE, NULL, NULL},
	{"NtQueryInformationFile", 0x0000D7CE, NULL, NULL},
	{"NtQueryInformationJobObject", 0x0000D7DE, NULL, NULL},
	{"NtQueryInformationPort", 0x0000D7EE, NULL, NULL},
	{"NtQueryInformationProcess", 0x0000D7FE, NULL, NULL},
	{"NtQueryInformationThread", 0x0000D80E, NULL, NULL},
	{"NtQueryInformationToken", 0x0000D81E, NULL, NULL},
	{"NtQueryInstallUILanguage", 0x0000D82E, NULL, NULL},
	{"NtQueryIntervalProfile", 0x0000D83E, NULL, NULL},
	{"NtQueryIoCompletion", 0x0000D84E, NULL, NULL},
	{"NtQueryKey", 0x0000D85E, NULL, NULL},
	{"NtQueryMultipleValueKey", 0x0000D86E, NULL, NULL},
	{"NtQueryMutant", 0x0000D87E, NULL, NULL},
	{"NtQueryObject", 0x0000D88E, NULL, NULL},
	{"NtQueryOpenSubKeys", 0x0000D89E, NULL, NULL},
	{"NtQueryPerformanceCounter", 0x0000D8AE, NULL, NULL},
	{"NtQueryPortInformationProcess", 0x0000E00E, NULL, NULL},
	{"NtQueryQuotaInformationFile", 0x0000D8BE, NULL, NULL},
	{"NtQuerySection", 0x0000D8CE, NULL, NULL},
	{"NtQuerySecurityObject", 0x0000D8DE, NULL, NULL},
	{"NtQuerySemaphore", 0x0000D8EE, NULL, NULL},
	{"NtQuerySymbolicLinkObject", 0x0000D8FE, NULL, NULL},
	{"NtQuerySystemEnvironmentValue", 0x0000D90E, NULL, NULL},
	{"NtQuerySystemEnvironmentValueEx", 0x0000D91E, NULL, NULL},
	{"NtQuerySystemInformation", 0x0000D92E, NULL, NULL},
	{"NtQuerySystemTime", 0x0000D93E, NULL, NULL},
	{"NtQueryTimer", 0x0000D94E, NULL, NULL},
	{"NtQueryTimerResolution", 0x0000D95E, NULL, NULL},
	{"NtQueryValueKey", 0x0000D96E, NULL, NULL},
	{"NtQueryVirtualMemory", 0x0000D97E, NULL, NULL},
	{"NtQueryVolumeInformationFile", 0x0000D98E, NULL, NULL},
	{"NtQueueApcThread", 0x0000D99E, NULL, NULL},
	{"NtRaiseException", 0x0000D9AE, NULL, NULL},
	{"NtRaiseHardError", 0x0000D9BE, NULL, NULL},
	{"NtReadFile", 0x0000D9CE, NULL, NULL},
	{"NtReadFileScatter", 0x0000D9DE, NULL, NULL},
	{"NtReadRequestData", 0x0000D9EE, NULL, NULL},
	{"NtReadVirtualMemory", 0x0000D9FE, NULL, NULL},
	{"NtRegisterThreadTerminatePort", 0x0000DA0E, NULL, NULL},
	{"NtReleaseKeyedEvent", 0x0000DFEE, NULL, NULL},
	{"NtReleaseMutant", 0x0000DA1E, NULL, NULL},
	{"NtReleaseSemaphore", 0x0000DA2E, NULL, NULL},
	{"NtRemoveIoCompletion", 0x0000DA3E, NULL, NULL},
	{"NtRemoveProcessDebug", 0x0000DA4E, NULL, NULL},
	{"NtRenameKey", 0x0000DA5E, NULL, NULL},
	{"NtReplaceKey", 0x0000DA6E, NULL, NULL},
	{"NtReplyPort", 0x0000DA7E, NULL, NULL},
	{"NtReplyWaitReceivePort", 0x0000DA8E, NULL, NULL},
	{"NtReplyWaitReceivePortEx", 0x0000DA9E, NULL, NULL},
	{"NtReplyWaitReplyPort", 0x0000DAAE, NULL, NULL},
	{"NtRequestDeviceWakeup", 0x0000DABE, NULL, NULL},
	{"NtRequestPort", 0x0000DACE, NULL, NULL},
	{"NtRequestWaitReplyPort", 0x0000DADE, NULL, NULL},
	{"NtRequestWakeupLatency", 0x0000DAEE, NULL, NULL},
	{"NtResetEvent", 0x0000DAFE, NULL, NULL},
	{"NtResetWriteWatch", 0x0000DB0E, NULL, NULL},
	{"NtRestoreKey", 0x0000DB1E, NULL, NULL},
	{"NtResumeProcess", 0x0000DB2E, NULL, NULL},
	{"NtResumeThread", 0x0000DB3E, NULL, NULL},
	{"NtSaveKey", 0x0000DB4E, NULL, NULL},
	{"NtSaveKeyEx", 0x0000DB5E, NULL, NULL},
	{"NtSaveMergedKeys", 0x0000DB6E, NULL, NULL},
	{"NtSecureConnectPort", 0x0000DB7E, NULL, NULL},
	{"NtSetBootEntryOrder", 0x0000DB8E, NULL, NULL},
	{"NtSetBootOptions", 0x0000DB9E, NULL, NULL},
	{"NtSetContextThread", 0x0000DBAE, NULL, NULL},
	{"NtSetDebugFilterState", 0x0000DBBE, NULL, NULL},
	{"NtSetDefaultHardErrorPort", 0x0000DBCE, NULL, NULL},
	{"NtSetDefaultLocale", 0x0000DBDE, NULL, NULL},
	{"NtSetDefaultUILanguage", 0x0000DBEE, NULL, NULL},
	{"NtSetEaFile", 0x0000DBFE, NULL, NULL},
	{"NtSetEvent", 0x0000DC0E, NULL, NULL},
	{"NtSetEventBoostPriority", 0x0000DC1E, NULL, NULL},
	{"NtSetHighEventPair", 0x0000DC2E, NULL, NULL},
	{"NtSetHighWaitLowEventPair", 0x0000DC3E, NULL, NULL},
	{"NtSetInformationDebugObject", 0x0000DC4E, NULL, NULL},
	{"NtSetInformationFile", 0x0000DC5E, NULL, NULL},
	{"NtSetInformationJobObject", 0x0000DC6E, NULL, NULL},
	{"NtSetInformationKey", 0x0000DC7E, NULL, NULL},
	{"NtSetInformationObject", 0x0000DC8E, NULL, NULL},
	{"NtSetInformationProcess", 0x0000DC9E, NULL, NULL},
	{"NtSetInformationThread", 0x0000DCAE, NULL, NULL},
	{"NtSetInformationToken", 0x0000DCBE, NULL, NULL},
	{"NtSetIntervalProfile", 0x0000DCCE, NULL, NULL},
	{"NtSetIoCompletion", 0x0000DCDE, NULL, NULL},
	{"NtSetLdtEntries", 0x0000DCEE, NULL, NULL},
	{"NtSetLowEventPair", 0x0000DCFE, NULL, NULL},
	{"NtSetLowWaitHighEventPair", 0x0000DD0E, NULL, NULL},
	{"NtSetQuotaInformationFile", 0x0000DD1E, NULL, NULL},
	{"NtSetSecurityObject", 0x0000DD2E, NULL, NULL},
	{"NtSetSystemEnvironmentValue", 0x0000DD3E, NULL, NULL},
	{"NtSetSystemEnvironmentValueEx", 0x0000DD4E, NULL, NULL},
	{"NtSetSystemInformation", 0x0000DD5E, NULL, NULL},
	{"NtSetSystemPowerState", 0x0000DD6E, NULL, NULL},
	{"NtSetSystemTime", 0x0000DD7E, NULL, NULL},
	{"NtSetThreadExecutionState", 0x0000DD8E, NULL, NULL},
	{"NtSetTimer", 0x0000DD9E, NULL, NULL},
	{"NtSetTimerResolution", 0x0000DDAE, NULL, NULL},
	{"NtSetUuidSeed", 0x0000DDBE, NULL, NULL},
	{"NtSetValueKey", 0x0000DDCE, NULL, NULL},
	{"NtSetVolumeInformationFile", 0x0000DDDE, NULL, NULL},
	{"NtShutdownSystem", 0x0000DDEE, NULL, NULL},
	{"NtSignalAndWaitForSingleObject", 0x0000DDFE, NULL, NULL},
	{"NtStartProfile", 0x0000DE0E, NULL, NULL},
	{"NtStopProfile", 0x0000DE1E, NULL, NULL},
	{"NtSuspendProcess", 0x0000DE2E, NULL, NULL},
	{"NtSuspendThread", 0x0000DE3E, NULL, NULL},
	{"NtSystemDebugControl", 0x0000DE4E, NULL, NULL},
	{"NtTerminateJobObject", 0x0000DE5E, NULL, NULL},
	{"NtTerminateProcess", 0x0000DE6E, NULL, NULL},
	{"NtTerminateThread", 0x0000DE7E, NULL, NULL},
	{"NtTestAlert", 0x0000DE8E, NULL, NULL},
	{"NtTraceEvent", 0x0000DE9E, NULL, NULL},
	{"NtTranslateFilePath", 0x0000DEAE, NULL, NULL},
	{"NtUnloadDriver", 0x0000DEBE, NULL, NULL},
	{"NtUnloadKey", 0x0000DECE, NULL, NULL},
	{"NtUnloadKeyEx", 0x0000DEDE, NULL, NULL},
	{"NtUnlockFile", 0x0000DEEE, NULL, NULL},
	{"NtUnlockVirtualMemory", 0x0000DEFE, NULL, NULL},
	{"NtUnmapViewOfSection", 0x0000DF0E, NULL, NULL},
	{"NtVdmControl", 0x0000DF1E, NULL, NULL},
	{"NtWaitForDebugEvent", 0x0000DF2E, NULL, NULL},
	{"NtWaitForKeyedEvent", 0x0000DFFE, NULL, NULL},
	{"NtWaitForMultipleObjects", 0x0000DF3E, NULL, NULL},
	{"NtWaitForSingleObject", 0x0000DF4E, NULL, NULL},
	{"NtWaitHighEventPair", 0x0000DF5E, NULL, NULL},
	{"NtWaitLowEventPair", 0x0000DF6E, NULL, NULL},
	{"NtWriteFile", 0x0000DF7E, NULL, NULL},
	{"NtWriteFileGather", 0x0000DF8E, NULL, NULL},
	{"NtWriteRequestData", 0x0000DF9E, NULL, NULL},
	{"NtWriteVirtualMemory", 0x0000DFAE, NULL, NULL},
	{"NtYieldExecution", 0x0000DFBE, NULL, NULL},
	{"PfxFindPrefix", 0x0005C499, NULL, NULL},
	{"PfxInitialize", 0x0005C151, NULL, NULL},
	{"PfxInsertPrefix", 0x0005C3B6, NULL, NULL},
	{"PfxRemovePrefix", 0x0005C16F, NULL, NULL},
	{"RtlAbortRXact", 0x0002B1B1, NULL, NULL},
	{"RtlAbsoluteToSelfRelativeSD", 0x00029A19, NULL, NULL},
	{"RtlAcquirePebLock", 0x0001040D, NULL, NULL},
	{"RtlAcquireResourceExclusive", 0x0002A096, NULL, NULL},
	{"RtlAcquireResourceShared", 0x00029FBF, NULL, NULL},
	{"RtlActivateActivationContext", 0x00017803, NULL, NULL},
	{"RtlActivateActivationContextEx", 0x0001767D, NULL, NULL},
	{"RtlActivateActivationContextUnsafeFast", 0x00001198, NULL, NULL},
	{"RtlAddAccessAllowedAce", 0x0001883B, NULL, NULL},
	{"RtlAddAccessAllowedAceEx", 0x00029A49, NULL, NULL},
	{"RtlAddAccessAllowedObjectAce", 0x0005C8A3, NULL, NULL},
	{"RtlAddAccessDeniedAce", 0x0002DBEB, NULL, NULL},
	{"RtlAddAccessDeniedAceEx", 0x0005C847, NULL, NULL},
	{"RtlAddAccessDeniedObjectAce", 0x0005C8F0, NULL, NULL},
	{"RtlAddAce", 0x0002B580, NULL, NULL},
	{"RtlAddActionToRXact", 0x0002E8BD, NULL, NULL},
	{"RtlAddAtomToAtomTable", 0x0003472A, NULL, NULL},
	{"RtlAddAttributeActionToRXact", 0x0002E65E, NULL, NULL},
	{"RtlAddAuditAccessAce", 0x0003002D, NULL, NULL},
	{"RtlAddAuditAccessAceEx", 0x0005C86B, NULL, NULL},
	{"RtlAddAuditAccessObjectAce", 0x0005C93E, NULL, NULL},
	{"RtlAddCompoundAce", 0x0005C603, NULL, NULL},
	{"RtlAddRange", 0x0005D896, NULL, NULL},
	{"RtlAddRefActivationContext", 0x0000FBD2, NULL, NULL},
	{"RtlAddRefMemoryStream", 0x000205A1, NULL, NULL},
	{"RtlAddVectoredExceptionHandler", 0x00036C2A, NULL, NULL},
	{"RtlAddressInSectionTable", 0x000128A5, NULL, NULL},
	{"RtlAdjustPrivilege", 0x00029A6D, NULL, NULL},
	{"RtlAllocateAndInitializeSid", 0x0001888B, NULL, NULL},
	{"RtlAllocateHandle", 0x00019394, NULL, NULL},
	{"RtlAllocateHeap", 0x000100C4, NULL, NULL},
	{"RtlAnsiCharToUnicodeChar", 0x00018199, NULL, NULL},
	{"RtlAnsiStringToUnicodeSize", 0x0005F4C8, NULL, NULL},
	{"RtlAnsiStringToUnicodeString", 0x0000EB3B, NULL, NULL},
	{"RtlAppendAsciizToString", 0x0005F832, NULL, NULL},
	{"RtlAppendPathElement", 0x0001D4DD, NULL, NULL},
	{"RtlAppendStringToString", 0x0005F88D, NULL, NULL},
	{"RtlAppendUnicodeStringToString", 0x00014FAF, NULL, NULL},
	{"RtlAppendUnicodeToString", 0x00014F3A, NULL, NULL},
	{"RtlApplicationVerifierStop", 0x000566E5, NULL, NULL},
	{"RtlApplyRXact", 0x0002E839, NULL, NULL},
	{"RtlApplyRXactNoFlush", 0x0002EDF0, NULL, NULL},
	{"RtlAreAllAccessesGranted", 0x0002A04B, NULL, NULL},
	{"RtlAreAnyAccessesGranted", 0x00038124, NULL, NULL},
	{"RtlAreBitsClear", 0x0005FEB7, NULL, NULL},
	{"RtlAreBitsSet", 0x00026707, NULL, NULL},
	{"RtlAssert2", 0x0006028B, NULL, NULL},
	{"RtlAssert", 0x00060499, NULL, NULL},
	{"RtlCancelTimer", 0x000606E1, NULL, NULL},
	{"RtlCaptureContext", 0x0000331A, NULL, NULL},
	{"RtlCaptureStackBackTrace", 0x000609A1, NULL, NULL},
	{"RtlCaptureStackContext", 0x000608A1, NULL, NULL},
	{"RtlCharToInteger", 0x00033BC0, NULL, NULL},
	{"RtlCheckForOrphanedCriticalSections", 0x00013AB3, NULL, NULL},
	{"RtlCheckProcessParameters", 0x000301C7, NULL, NULL},
	{"RtlCheckRegistryKey", 0x0002FAB3, NULL, NULL},
	{"RtlClearAllBits", 0x0002C1CB, NULL, NULL},
	{"RtlClearBits", 0x000266C1, NULL, NULL},
	{"RtlCloneMemoryStream", 0x0005370D, NULL, NULL},
	{"RtlCommitMemoryStream", 0x0005370D, NULL, NULL},
	{"RtlCompactHeap", 0x000361D7, NULL, NULL},
	{"RtlCompareMemory", 0x00002B53, NULL, NULL},
	{"RtlCompareMemoryUlong", 0x00002BA3, NULL, NULL},
	{"RtlCompareString", 0x0005F756, NULL, NULL},
	{"RtlCompareUnicodeString", 0x000179A8, NULL, NULL},
	{"RtlCompressBuffer", 0x00062A9D, NULL, NULL},
	{"RtlComputeCrc32", 0x00062CE1, NULL, NULL},
	{"RtlComputeImportTableHash", 0x000596CF, NULL, NULL},
	{"RtlComputePrivatizedDllName_U", 0x000532FB, NULL, NULL},
	{"RtlConsoleMultiByteToUnicodeN", 0x00024EA5, NULL, NULL},
	{"RtlConvertExclusiveToShared", 0x0002CC10, NULL, NULL},
	{"RtlConvertLongToLargeInteger", 0x00003236, NULL, NULL},
	{"RtlConvertSharedToExclusive", 0x0002CBCE, NULL, NULL},
	{"RtlConvertSidToUnicodeString", 0x00014C55, NULL, NULL},
	{"RtlConvertToAutoInheritSecurityObject", 0x00053CC0, NULL, NULL},
	{"RtlConvertUiListToApiList", 0x00053FD2, NULL, NULL},
	{"RtlConvertUlongToLargeInteger", 0x0000323E, NULL, NULL},
	{"RtlCopyLuid", 0x0001314C, NULL, NULL},
	{"RtlCopyLuidAndAttributesArray", 0x0005DDC3, NULL, NULL},
	{"RtlCopyMemoryStreamTo", 0x0005367F, NULL, NULL},
	{"RtlCopyOutOfProcessMemoryStreamTo", 0x00053700, NULL, NULL},
	{"RtlCopyRangeList", 0x0005D0AD, NULL, NULL},
	{"RtlCopySecurityDescriptor", 0x0002C3E4, NULL, NULL},
	{"RtlCopySid", 0x0001316A, NULL, NULL},
	{"RtlCopySidAndAttributesArray", 0x0005DC01, NULL, NULL},
	{"RtlCopyString", 0x0002D1DE, NULL, NULL},
	{"RtlCopyUnicodeString", 0x00014ED9, NULL, NULL},
	{"RtlCreateAcl", 0x000187E9, NULL, NULL},
	{"RtlCreateActivationContext", 0x00020AD5, NULL, NULL},
	{"RtlCreateAndSetSD", 0x0002EEE9, NULL, NULL},
	{"RtlCreateAtomTable", 0x0003491A, NULL, NULL},
	{"RtlCreateBootStatusDataFile", 0x0006311D, NULL, NULL},
	{"RtlCreateEnvironment", 0x0002CA99, NULL, NULL},
	{"RtlCreateHeap", 0x00025C82, NULL, NULL},
	{"RtlCreateProcessParameters", 0x00022E99, NULL, NULL},
	{"RtlCreateQueryDebugBuffer", 0x00054570, NULL, NULL},
	{"RtlCreateRegistryKey", 0x00060EF0, NULL, NULL},
	{"RtlCreateSecurityDescriptor", 0x00018651, NULL, NULL},
	{"RtlCreateServiceSid", 0x0005DC95, NULL, NULL},
	{"RtlCreateSystemVolumeInformationFolder", 0x000638E9, NULL, NULL},
	{"RtlCreateTagHeap", 0x00022254, NULL, NULL},
	{"RtlCreateTimer", 0x0002CD60, NULL, NULL},
	{"RtlCreateTimerQueue", 0x0002DB03, NULL, NULL},
	{"RtlCreateUnicodeString", 0x00013432, NULL, NULL},
	{"RtlCreateUnicodeStringFromAsciiz", 0x00013079, NULL, NULL},
	{"RtlCreateUserProcess", 0x000305AB, NULL, NULL},
	{"RtlCreateUserSecurityObject", 0x0002EE71, NULL, NULL},
	{"RtlCreateUserThread", 0x0002DF9A, NULL, NULL},
	{"RtlCustomCPToUnicodeN", 0x0005B54E, NULL, NULL},
	{"RtlCutoverTimeToSystemTime", 0x00031A7D, NULL, NULL},
	{"RtlDeNormalizeProcessParams", 0x00022DEB, NULL, NULL},
	{"RtlDeactivateActivationContext", 0x000178DF, NULL, NULL},
	{"RtlDeactivateActivationContextUnsafeFast", 0x000011DD, NULL, NULL},
	{"RtlDebugPrintTimes", 0x000604FC, NULL, NULL},
	{"RtlDecodePointer", 0x00013425, NULL, NULL},
	{"RtlDecodeSystemPointer", 0x00018A98, NULL, NULL},
	{"RtlDecompressBuffer", 0x00062B19, NULL, NULL},
	{"RtlDecompressFragment", 0x00062B85, NULL, NULL},
	{"RtlDefaultNpAcl", 0x00053CD0, NULL, NULL},
	{"RtlDelete", 0x00024CE1, NULL, NULL},
	{"RtlDeleteAce", 0x00038151, NULL, NULL},
	{"RtlDeleteAtomFromAtomTable", 0x0003407E, NULL, NULL},
	{"RtlDeleteCriticalSection", 0x0001137A, NULL, NULL},
	{"RtlDeleteElementGenericTable", 0x00024C80, NULL, NULL},
	{"RtlDeleteElementGenericTableAvl", 0x0006423C, NULL, NULL},
	{"RtlDeleteNoSplay", 0x00063C54, NULL, NULL},
	{"RtlDeleteOwnersRanges", 0x0005DA5E, NULL, NULL},
	{"RtlDeleteRange", 0x0005D921, NULL, NULL},
	{"RtlDeleteRegistryValue", 0x00030FFC, NULL, NULL},
	{"RtlDeleteResource", 0x00023CFB, NULL, NULL},
	{"RtlDeleteSecurityObject", 0x0002A1E3, NULL, NULL},
	{"RtlDeleteTimer", 0x00033462, NULL, NULL},
	{"RtlDeleteTimerQueue", 0x000606B9, NULL, NULL},
	{"RtlDeleteTimerQueueEx", 0x000605B1, NULL, NULL},
	{"RtlDeregisterWait", 0x000315DA, NULL, NULL},
	{"RtlDeregisterWaitEx", 0x000312B2, NULL, NULL},
	{"RtlDestroyAtomTable", 0x0005C9D2, NULL, NULL},
	{"RtlDestroyEnvironment", 0x00023962, NULL, NULL},
	{"RtlDestroyHandleTable", 0x00023B45, NULL, NULL},
	{"RtlDestroyHeap", 0x000264EE, NULL, NULL},
	{"RtlDestroyProcessParameters", 0x00022DC4, NULL, NULL},
	{"RtlDestroyQueryDebugBuffer", 0x00054658, NULL, NULL},
	{"RtlDetermineDosPathNameType_U", 0x00013B8A, NULL, NULL},
	{"RtlDllShutdownInProgress", 0x000136D0, NULL, NULL},
	{"RtlDnsHostNameToComputerName", 0x00030ED3, NULL, NULL},
	{"RtlDoesFileExists_U", 0x000199D8, NULL, NULL},
	{"RtlDosApplyFileIsolationRedirection_Ustr", 0x0001599B, NULL, NULL},
	{"RtlDosPathNameToNtPathName_U", 0x000142F5, NULL, NULL},
	{"RtlDosSearchPath_U", 0x00016FF9, NULL, NULL},
	{"RtlDosSearchPath_Ustr", 0x00018C11, NULL, NULL},
	{"RtlDowncaseUnicodeChar", 0x0005F446, NULL, NULL},
	{"RtlDowncaseUnicodeString", 0x00029B1A, NULL, NULL},
	{"RtlDumpResource", 0x00053724, NULL, NULL},
	{"RtlDuplicateUnicodeString", 0x00020F3B, NULL, NULL},
	{"RtlEmptyAtomTable", 0x0005CAA9, NULL, NULL},
	{"RtlEnableEarlyCriticalSectionEventCreation", 0x000537DD, NULL, NULL},
	{"RtlEncodePointer", 0x000133FF, NULL, NULL},
	{"RtlEncodeSystemPointer", 0x00018A98, NULL, NULL},
	{"RtlEnlargedIntegerMultiply", 0x00003016, NULL, NULL},
	{"RtlEnlargedUnsignedDivide", 0x0000302E, NULL, NULL},
	{"RtlEnlargedUnsignedMultiply", 0x00003022, NULL, NULL},
	{"RtlEnterCriticalSection", 0x00001000, NULL, NULL},
	{"RtlEnumProcessHeaps", 0x00061889, NULL, NULL},
	{"RtlEnumerateGenericTable", 0x00063D5D, NULL, NULL},
	{"RtlEnumerateGenericTableAvl", 0x00030064, NULL, NULL},
	{"RtlEnumerateGenericTableLikeADirectory", 0x000642C6, NULL, NULL},
	{"RtlEnumerateGenericTableWithoutSplaying", 0x0001E314, NULL, NULL},
	{"RtlEnumerateGenericTableWithoutSplayingAvl", 0x00030089, NULL, NULL},
	{"RtlEqualComputerName", 0x0005F746, NULL, NULL},
	{"RtlEqualDomainName", 0x0002B466, NULL, NULL},
	{"RtlEqualLuid", 0x0005DD9A, NULL, NULL},
	{"RtlEqualPrefixSid", 0x00032F94, NULL, NULL},
	{"RtlEqualSid", 0x0001824C, NULL, NULL},
	{"RtlEqualString", 0x000135D6, NULL, NULL},
	{"RtlEqualUnicodeString", 0x00012EBB, NULL, NULL},
	{"RtlEraseUnicodeString", 0x0002EE2E, NULL, NULL},
	{"RtlExitUserThread", 0x000633D3, NULL, NULL},
	{"RtlExpandEnvironmentStrings_U", 0x000146CA, NULL, NULL},
	{"RtlExtendHeap", 0x000615C9, NULL, NULL},
	{"RtlExtendedIntegerMultiply", 0x0000313A, NULL, NULL},
	{"RtlExtendedLargeIntegerDivide", 0x0000304E, NULL, NULL},
	{"RtlExtendedMagicDivide", 0x000030AA, NULL, NULL},
	{"RtlFillMemory", 0x00002BD3, NULL, NULL},
	{"RtlFillMemoryUlong", 0x00002C43, NULL, NULL},
	{"RtlFinalReleaseOutOfProcessMemoryStream", 0x00020E3E, NULL, NULL},
	{"RtlFindActivationContextSectionGuid", 0x00028D0E, NULL, NULL},
	{"RtlFindActivationContextSectionString", 0x00015511, NULL, NULL},
	{"RtlFindCharInUnicodeString", 0x00015D61, NULL, NULL},
	{"RtlFindClearBits", 0x0002635D, NULL, NULL},
	{"RtlFindClearBitsAndSet", 0x00026425, NULL, NULL},
	{"RtlFindClearRuns", 0x0005FB92, NULL, NULL},
	{"RtlFindLastBackwardRunClear", 0x00060034, NULL, NULL},
	{"RtlFindLeastSignificantBit", 0x000601AF, NULL, NULL},
	{"RtlFindLongestRunClear", 0x0005FDD9, NULL, NULL},
	{"RtlFindMessage", 0x00035029, NULL, NULL},
	{"RtlFindMostSignificantBit", 0x00060104, NULL, NULL},
	{"RtlFindNextForwardRunClear", 0x0005FF3A, NULL, NULL},
	{"RtlFindRange", 0x0005D200, NULL, NULL},
	{"RtlFindSetBits", 0x0005F8E1, NULL, NULL},
	{"RtlFindSetBitsAndClear", 0x00060258, NULL, NULL},
	{"RtlFirstEntrySList", 0x00002AF8, NULL, NULL},
	{"RtlFirstFreeAce", 0x000186DA, NULL, NULL},
	{"RtlFlushSecureMemoryCache", 0x000643F2, NULL, NULL},
	{"RtlFormatCurrentUserKeyPath", 0x00015019, NULL, NULL},
	{"RtlFormatMessage", 0x000293E4, NULL, NULL},
	{"RtlFreeAnsiString", 0x00010466, NULL, NULL},
	{"RtlFreeHandle", 0x0001333F, NULL, NULL},
	{"RtlFreeHeap", 0x0000FF2D, NULL, NULL},
	{"RtlFreeOemString", 0x0002B4C3, NULL, NULL},
	{"RtlFreeRangeList", 0x0005CE44, NULL, NULL},
	{"RtlFreeSid", 0x0001885E, NULL, NULL},
	{"RtlFreeThreadActivationContextStack", 0x0001392D, NULL, NULL},
	{"RtlFreeUnicodeString", 0x00010466, NULL, NULL},
	{"RtlFreeUserThreadStack", 0x000633FD, NULL, NULL},
	{"RtlGUIDFromString", 0x00026CA0, NULL, NULL},
	{"RtlGenerate8dot3Name", 0x00064860, NULL, NULL},
	{"RtlGetAce", 0x00034EE9, NULL, NULL},
	{"RtlGetActiveActivationContext", 0x0001C5CB, NULL, NULL},
	{"RtlGetCallersAddress", 0x00060A5A, NULL, NULL},
	{"RtlGetCompressionWorkSpaceSize", 0x00062A31, NULL, NULL},
	{"RtlGetControlSecurityDescriptor", 0x0002A1B5, NULL, NULL},
	{"RtlGetCurrentDirectory_U", 0x00014506, NULL, NULL},
	{"RtlGetCurrentPeb", 0x00060EE1, NULL, NULL},
	{"RtlGetDaclSecurityDescriptor", 0x0001379F, NULL, NULL},
	{"RtlGetElementGenericTable", 0x00063CD4, NULL, NULL},
	{"RtlGetElementGenericTableAvl", 0x000640C7, NULL, NULL},
	{"RtlGetFirstRange", 0x0005CE89, NULL, NULL},
	{"RtlGetFrame", 0x000204A1, NULL, NULL},
	{"RtlGetFullPathName_U", 0x000143A9, NULL, NULL},
	{"RtlGetGroupSecurityDescriptor", 0x0002B427, NULL, NULL},
	{"RtlGetLastNtStatus", 0x00064C4D, NULL, NULL},
	{"RtlGetLastWin32Error", 0x0000FE21, NULL, NULL},
	{"RtlGetLengthWithoutLastFullDosOrNtPathElement", 0x00020779, NULL, NULL},
	{"RtlGetLengthWithoutTrailingPathSeperators", 0x0002F30D, NULL, NULL},
	{"RtlGetLongestNtPathLength", 0x000149D9, NULL, NULL},
	{"RtlGetNativeSystemInformation", 0x0000D92E, NULL, NULL},
	{"RtlGetNextRange", 0x0005CF41, NULL, NULL},
	{"RtlGetNtGlobalFlags", 0x0000FF1B, NULL, NULL},
	{"RtlGetNtProductType", 0x00019758, NULL, NULL},
	{"RtlGetNtVersionNumbers", 0x0002132F, NULL, NULL},
	{"RtlGetOwnerSecurityDescriptor", 0x0002B3E5, NULL, NULL},
	{"RtlGetProcessHeaps", 0x000617D1, NULL, NULL},
	{"RtlGetSaclSecurityDescriptor", 0x0005DDF2, NULL, NULL},
	{"RtlGetSecurityDescriptorRMControl", 0x0005E04D, NULL, NULL},
	{"RtlGetSetBootStatusData", 0x00030441, NULL, NULL},
	{"RtlGetUnloadEventTrace", 0x000524CB, NULL, NULL},
	{"RtlGetUserInfoHeap", 0x00013862, NULL, NULL},
	{"RtlGetVersion", 0x0001966B, NULL, NULL},
	{"RtlHashUnicodeString", 0x0001565D, NULL, NULL},
	{"RtlIdentifierAuthoritySid", 0x0002A26C, NULL, NULL},
	{"RtlImageDirectoryEntryToData", 0x00010346, NULL, NULL},
	{"RtlImageNtHeader", 0x00010339, NULL, NULL},
	{"RtlImageRvaToSection", 0x000128D7, NULL, NULL},
	{"RtlImageRvaToVa", 0x00030B6A, NULL, NULL},
	{"RtlImpersonateSelf", 0x00029DA7, NULL, NULL},
	{"RtlInitAnsiString", 0x0000125D, NULL, NULL},
	{"RtlInitCodePageTable", 0x00022676, NULL, NULL},
	{"RtlInitMemoryStream", 0x00021534, NULL, NULL},
	{"RtlInitNlsTables", 0x00022645, NULL, NULL},
	{"RtlInitOutOfProcessMemoryStream", 0x000209F2, NULL, NULL},
	{"RtlInitString", 0x00001225, NULL, NULL},
	{"RtlInitUnicodeString", 0x00001295, NULL, NULL},
	{"RtlInitUnicodeStringEx", 0x0000FE95, NULL, NULL},
	{"RtlInitializeAtomPackage", 0x0002223C, NULL, NULL},
	{"RtlInitializeBitMap", 0x00018A7C, NULL, NULL},
	{"RtlInitializeContext", 0x0002E0D9, NULL, NULL},
	{"RtlInitializeCriticalSection", 0x0001161D, NULL, NULL},
	{"RtlInitializeCriticalSectionAndSpinCount", 0x0001151A, NULL, NULL},
	{"RtlInitializeGenericTable", 0x000214B1, NULL, NULL},
	{"RtlInitializeGenericTableAvl", 0x00030191, NULL, NULL},
	{"RtlInitializeHandleTable", 0x00018B9A, NULL, NULL},
	{"RtlInitializeRXact", 0x0002FE4A, NULL, NULL},
	{"RtlInitializeRangeList", 0x0005CC29, NULL, NULL},
	{"RtlInitializeResource", 0x0001E6FB, NULL, NULL},
	{"RtlInitializeSListHead", 0x00034FC3, NULL, NULL},
	{"RtlInitializeSid", 0x00018295, NULL, NULL},
	{"RtlInitializeStackTraceDataBase", 0x00064ECF, NULL, NULL},
	{"RtlInsertElementGenericTable", 0x00024A3F, NULL, NULL},
	{"RtlInsertElementGenericTableAvl", 0x00064209, NULL, NULL},
	{"RtlInt64ToUnicodeString", 0x00060E71, NULL, NULL},
	{"RtlIntegerToChar", 0x0001AD08, NULL, NULL},
	{"RtlIntegerToUnicodeString", 0x0001AE2E, NULL, NULL},
	{"RtlInterlockedFlushSList", 0x00064DED, NULL, NULL},
	{"RtlInterlockedPopEntrySList", 0x00033CB3, NULL, NULL},
	{"RtlInterlockedPushEntrySList", 0x00033C71, NULL, NULL},
	{"RtlInvertRangeList", 0x0005DB0F, NULL, NULL},
	{"RtlIpv4AddressToStringA", 0x000653B3, NULL, NULL},
	{"RtlIpv4AddressToStringExA", 0x00065401, NULL, NULL},
	{"RtlIpv4AddressToStringExW", 0x0002D982, NULL, NULL},
	{"RtlIpv4AddressToStringW", 0x0002D9FA, NULL, NULL},
	{"RtlIpv4StringToAddressA", 0x0002C981, NULL, NULL},
	{"RtlIpv4StringToAddressExA", 0x00065D5F, NULL, NULL},
	{"RtlIpv4StringToAddressExW", 0x00036B9F, NULL, NULL},
	{"RtlIpv4StringToAddressW", 0x00035A94, NULL, NULL},
	{"RtlIpv6AddressToStringA", 0x000650A1, NULL, NULL},
	{"RtlIpv6AddressToStringExA", 0x000652CD, NULL, NULL},
	{"RtlIpv6AddressToStringExW", 0x0006570F, NULL, NULL},
	{"RtlIpv6AddressToStringW", 0x000654A7, NULL, NULL},
	{"RtlIpv6StringToAddressA", 0x00065803, NULL, NULL},
	{"RtlIpv6StringToAddressExA", 0x00065B22, NULL, NULL},
	{"RtlIpv6StringToAddressExW", 0x000661F6, NULL, NULL},
	{"RtlIpv6StringToAddressW", 0x00065EF8, NULL, NULL},
	{"RtlIsActivationContextActive", 0x000580F6, NULL, NULL},
	{"RtlIsDosDeviceName_U", 0x000130A8, NULL, NULL},
	{"RtlIsGenericTableEmpty", 0x0001E38C, NULL, NULL},
	{"RtlIsGenericTableEmptyAvl", 0x000640AE, NULL, NULL},
	{"RtlIsNameLegalDOS8Dot3", 0x000646DF, NULL, NULL},
	{"RtlIsRangeAvailable", 0x0005D583, NULL, NULL},
	{"RtlIsTextUnicode", 0x0002906B, NULL, NULL},
	{"RtlIsThreadWithinLoaderCallout", 0x00052AC1, NULL, NULL},
	{"RtlIsValidHandle", 0x000132DD, NULL, NULL},
	{"RtlIsValidIndexHandle", 0x000133CE, NULL, NULL},
	{"RtlLargeIntegerAdd", 0x00003002, NULL, NULL},
	{"RtlLargeIntegerArithmeticShift", 0x000031E2, NULL, NULL},
	{"RtlLargeIntegerDivide", 0x00066459, NULL, NULL},
	{"RtlLargeIntegerNegate", 0x0000320E, NULL, NULL},
	{"RtlLargeIntegerShiftLeft", 0x00003192, NULL, NULL},
	{"RtlLargeIntegerShiftRight", 0x000031BA, NULL, NULL},
	{"RtlLargeIntegerSubtract", 0x00003222, NULL, NULL},
	{"RtlLargeIntegerToChar", 0x00060AA4, NULL, NULL},
	{"RtlLeaveCriticalSection", 0x000010E0, NULL, NULL},
	{"RtlLengthRequiredSid", 0x000136B8, NULL, NULL},
	{"RtlLengthSecurityDescriptor", 0x0002B2CB, NULL, NULL},
	{"RtlLengthSid", 0x0001319E, NULL, NULL},
	{"RtlLocalTimeToSystemTime", 0x00063BB8, NULL, NULL},
	{"RtlLockBootStatusData", 0x000302E3, NULL, NULL},
	{"RtlLockHeap", 0x0001320B, NULL, NULL},
	{"RtlLockMemoryStreamRegion", 0x00053700, NULL, NULL},
	{"RtlLogStackBackTrace", 0x000115D4, NULL, NULL},
	{"RtlLookupAtomInAtomTable", 0x000284AA, NULL, NULL},
	{"RtlLookupElementGenericTable", 0x0002102F, NULL, NULL},
	{"RtlLookupElementGenericTableAvl", 0x00064395, NULL, NULL},
	{"RtlMakeSelfRelativeSD", 0x0002994F, NULL, NULL},
	{"RtlMapGenericMask", 0x00029FFD, NULL, NULL},
	{"RtlMapSecurityErrorToNtStatus", 0x0005E0DA, NULL, NULL},
	{"RtlMergeRangeLists", 0x0005D7B6, NULL, NULL},
	{"RtlMoveMemory", 0x00002C94, NULL, NULL},
	{"RtlMultiAppendUnicodeStringBuffer", 0x00016915, NULL, NULL},
	{"RtlMultiByteToUnicodeN", 0x0000ECBA, NULL, NULL},
	{"RtlMultiByteToUnicodeSize", 0x0002939A, NULL, NULL},
	{"RtlNewInstanceSecurityObject", 0x00053AEC, NULL, NULL},
	{"RtlNewSecurityGrantedAccess", 0x00053B62, NULL, NULL},
	{"RtlNewSecurityObject", 0x0002E957, NULL, NULL},
	{"RtlNewSecurityObjectEx", 0x00032720, NULL, NULL},
	{"RtlNewSecurityObjectWithMultipleInheritance", 0x000538B1, NULL, NULL},
	{"RtlNormalizeProcessParams", 0x00022336, NULL, NULL},
	{"RtlNtPathNameToDosPathName", 0x0002441C, NULL, NULL},
	{"RtlNtStatusToDosError", 0x0000F62D, NULL, NULL},
	{"RtlNtStatusToDosErrorNoTeb", 0x0000F679, NULL, NULL},
	{"RtlNumberGenericTableElements", 0x00023B79, NULL, NULL},
	{"RtlNumberGenericTableElementsAvl", 0x0006419C, NULL, NULL},
	{"RtlNumberOfClearBits", 0x0005FE10, NULL, NULL},
	{"RtlNumberOfSetBits", 0x0005FE60, NULL, NULL},
	{"RtlOemStringToUnicodeSize", 0x0005F4C8, NULL, NULL},
	{"RtlOemStringToUnicodeString", 0x00027485, NULL, NULL},
	{"RtlOemToUnicodeN", 0x0002735C, NULL, NULL},
	{"RtlOpenCurrentUser", 0x00018AD9, NULL, NULL},
	{"RtlPcToFileHeader", 0x00034393, NULL, NULL},
	{"RtlPinAtomInAtomTable", 0x0005CB71, NULL, NULL},
	{"RtlPopFrame", 0x00019AE0, NULL, NULL},
	{"RtlPrefixString", 0x0002DC55, NULL, NULL},
	{"RtlPrefixUnicodeString", 0x00014408, NULL, NULL},
	{"RtlProtectHeap", 0x000611B2, NULL, NULL},
	{"RtlPushFrame", 0x00019B00, NULL, NULL},
	{"RtlQueryAtomInAtomTable", 0x000349BD, NULL, NULL},
	{"RtlQueryDepthSList", 0x00033D20, NULL, NULL},
	{"RtlQueryEnvironmentVariable_U", 0x00014599, NULL, NULL},
	{"RtlQueryHeapInformation", 0x0006219B, NULL, NULL},
	{"RtlQueryInformationAcl", 0x0002CED5, NULL, NULL},
	{"RtlQueryInformationActivationContext", 0x0000FCD2, NULL, NULL},
	{"RtlQueryInformationActiveActivationContext", 0x000135B1, NULL, NULL},
	{"RtlQueryInterfaceMemoryStream", 0x000205BD, NULL, NULL},
	{"RtlQueryProcessBackTraceInformation", 0x00054739, NULL, NULL},
	{"RtlQueryProcessDebugInformation", 0x00054F83, NULL, NULL},
	{"RtlQueryProcessHeapInformation", 0x000548E1, NULL, NULL},
	{"RtlQueryProcessLockInformation", 0x00054E0D, NULL, NULL},
	{"RtlQueryRegistryValues", 0x0002F3FE, NULL, NULL},
	{"RtlQuerySecurityObject", 0x000538EA, NULL, NULL},
	{"RtlQueryTagHeap", 0x00061465, NULL, NULL},
	{"RtlQueryTimeZoneInformation", 0x00060F71, NULL, NULL},
	{"RtlQueueApcWow64Thread", 0x00058095, NULL, NULL},
	{"RtlQueueWorkItem", 0x00027C58, NULL, NULL},
	{"RtlRaiseException", 0x0000E528, NULL, NULL},
	{"RtlRaiseStatus", 0x000666A0, NULL, NULL},
	{"RtlRandom", 0x000666CF, NULL, NULL},
	{"RtlRandomEx", 0x00037D38, NULL, NULL},
	{"RtlReAllocateHeap", 0x00019BA0, NULL, NULL},
	{"RtlReadMemoryStream", 0x000214EF, NULL, NULL},
	{"RtlReadOutOfProcessMemoryStream", 0x0002053F, NULL, NULL},
	{"RtlRealPredecessor", 0x00063C17, NULL, NULL},
	{"RtlRealSuccessor", 0x0001E356, NULL, NULL},
	{"RtlRegisterSecureMemoryCacheCallback", 0x000643B6, NULL, NULL},
	{"RtlRegisterWait", 0x00033233, NULL, NULL},
	{"RtlReleaseActivationContext", 0x00010547, NULL, NULL},
	{"RtlReleaseMemoryStream", 0x0002034F, NULL, NULL},
	{"RtlReleasePebLock", 0x00010451, NULL, NULL},
	{"RtlReleaseResource", 0x00029F84, NULL, NULL},
	{"RtlRemoteCall", 0x00064C80, NULL, NULL},
	{"RtlRemoveVectoredExceptionHandler", 0x00036C96, NULL, NULL},
	{"RtlResetRtlTranslations", 0x000224FB, NULL, NULL},
	{"RtlRestoreLastWin32Error", 0x0000FE30, NULL, NULL},
	{"RtlRevertMemoryStream", 0x000536F3, NULL, NULL},
	{"RtlRunDecodeUnicodeString", 0x0002D7E3, NULL, NULL},
	{"RtlRunEncodeUnicodeString", 0x0002D795, NULL, NULL},
	{"RtlSecondsSince1970ToTime", 0x00063B81, NULL, NULL},
	{"RtlSecondsSince1980ToTime", 0x00063B4A, NULL, NULL},
	{"RtlSeekMemoryStream", 0x00053610, NULL, NULL},
	{"RtlSelfRelativeToAbsoluteSD2", 0x0005C538, NULL, NULL},
	{"RtlSelfRelativeToAbsoluteSD", 0x0002CFD7, NULL, NULL},
	{"RtlSetAllBits", 0x0002C1FC, NULL, NULL},
	{"RtlSetAttributesSecurityDescriptor", 0x0005E1C5, NULL, NULL},
	{"RtlSetBits", 0x00026458, NULL, NULL},
	{"RtlSetControlSecurityDescriptor", 0x0002FAE0, NULL, NULL},
	{"RtlSetCriticalSectionSpinCount", 0x0002A067, NULL, NULL},
	{"RtlSetCurrentDirectory_U", 0x0001E7AA, NULL, NULL},
	{"RtlSetCurrentEnvironment", 0x000632F5, NULL, NULL},
	{"RtlSetDaclSecurityDescriptor", 0x0001867F, NULL, NULL},
	{"RtlSetEnvironmentVariable", 0x000277B8, NULL, NULL},
	{"RtlSetGroupSecurityDescriptor", 0x00018A32, NULL, NULL},
	{"RtlSetHeapInformation", 0x00037CE5, NULL, NULL},
	{"RtlSetInformationAcl", 0x0005C5B7, NULL, NULL},
	{"RtlSetIoCompletionCallback", 0x0002DD99, NULL, NULL},
	{"RtlSetLastWin32Error", 0x0000FE30, NULL, NULL},
	{"RtlSetLastWin32ErrorAndNtStatusFromNtStatus", 0x00064C5F, NULL, NULL},
	{"RtlSetMemoryStreamSize", 0x00053672, NULL, NULL},
	{"RtlSetOwnerSecurityDescriptor", 0x000189E8, NULL, NULL},
	{"RtlSetProcessIsCritical", 0x0002EB9C, NULL, NULL},
	{"RtlSetSaclSecurityDescriptor", 0x0002CF46, NULL, NULL},
	{"RtlSetSecurityDescriptorRMControl", 0x0005E0AF, NULL, NULL},
	{"RtlSetSecurityObject", 0x0002C49C, NULL, NULL},
	{"RtlSetSecurityObjectEx", 0x000538C1, NULL, NULL},
	{"RtlSetThreadIsCritical", 0x0002EBF0, NULL, NULL},
	{"RtlSetThreadPoolStartFunc", 0x00022299, NULL, NULL},
	{"RtlSetTimeZoneInformation", 0x00061099, NULL, NULL},
	{"RtlSetTimer", 0x000606D1, NULL, NULL},
	{"RtlSetUnicodeCallouts", 0x00059DC1, NULL, NULL},
	{"RtlSetUserFlagsHeap", 0x00061315, NULL, NULL},
	{"RtlSetUserValueHeap", 0x000193E9, NULL, NULL},
	{"RtlSizeHeap", 0x000104DD, NULL, NULL},
	{"RtlSplay", 0x00020ED8, NULL, NULL},
	{"RtlStartRXact", 0x0002B15E, NULL, NULL},
	{"RtlStatMemoryStream", 0x00020A55, NULL, NULL},
	{"RtlStringFromGUID", 0x00028EB6, NULL, NULL},
	{"RtlSubAuthorityCountSid", 0x000136E0, NULL, NULL},
	{"RtlSubAuthoritySid", 0x00018278, NULL, NULL},
	{"RtlSubtreePredecessor", 0x00024C5D, NULL, NULL},
	{"RtlSubtreeSuccessor", 0x00063BF4, NULL, NULL},
	{"RtlSystemTimeToLocalTime", 0x00035A58, NULL, NULL},
	{"RtlTimeFieldsToTime", 0x0001AB39, NULL, NULL},
	{"RtlTimeToElapsedTimeFields", 0x00063AE3, NULL, NULL},
	{"RtlTimeToSecondsSince1970", 0x0002B1F1, NULL, NULL},
	{"RtlTimeToSecondsSince1980", 0x0002A164, NULL, NULL},
	{"RtlTimeToTimeFields", 0x00011EFD, NULL, NULL},
	{"RtlTraceDatabaseAdd", 0x00066D4F, NULL, NULL},
	{"RtlTraceDatabaseCreate", 0x00066982, NULL, NULL},
	{"RtlTraceDatabaseDestroy", 0x00066A74, NULL, NULL},
	{"RtlTraceDatabaseEnumerate", 0x000668FA, NULL, NULL},
	{"RtlTraceDatabaseFind", 0x00066B5B, NULL, NULL},
	{"RtlTraceDatabaseLock", 0x00066D2F, NULL, NULL},
	{"RtlTraceDatabaseUnlock", 0x00066D3F, NULL, NULL},
	{"RtlTraceDatabaseValidate", 0x00066B11, NULL, NULL},
	{"RtlTryEnterCriticalSection", 0x00001118, NULL, NULL},
	{"RtlUnhandledExceptionFilter2", 0x00066F61, NULL, NULL},
	{"RtlUnhandledExceptionFilter", 0x000678E7, NULL, NULL},
	{"RtlUnicodeStringToAnsiSize", 0x0005F4A3, NULL, NULL},
	{"RtlUnicodeStringToAnsiString", 0x00012BB8, NULL, NULL},
	{"RtlUnicodeStringToCountedOemString", 0x0005F59E, NULL, NULL},
	{"RtlUnicodeStringToInteger", 0x0001AE91, NULL, NULL},
	{"RtlUnicodeStringToOemSize", 0x0005F4A3, NULL, NULL},
	{"RtlUnicodeStringToOemString", 0x0002720A, NULL, NULL},
	{"RtlUnicodeToCustomCPN", 0x0005B732, NULL, NULL},
	{"RtlUnicodeToMultiByteN", 0x00012A8D, NULL, NULL},
	{"RtlUnicodeToMultiByteSize", 0x000131BA, NULL, NULL},
	{"RtlUnicodeToOemN", 0x000270E8, NULL, NULL},
	{"RtlUniform", 0x0002EC31, NULL, NULL},
	{"RtlUnlockBootStatusData", 0x000303FB, NULL, NULL},
	{"RtlUnlockHeap", 0x00013273, NULL, NULL},
	{"RtlUnlockMemoryStreamRegion", 0x00053700, NULL, NULL},
	{"RtlUnwind", 0x0002ABC5, NULL, NULL},
	{"RtlUpcaseUnicodeChar", 0x000103E0, NULL, NULL},
	{"RtlUpcaseUnicodeString", 0x00026B83, NULL, NULL},
	{"RtlUpcaseUnicodeStringToAnsiString", 0x0005F4EF, NULL, NULL},
	{"RtlUpcaseUnicodeStringToCountedOemString", 0x0005F672, NULL, NULL},
	{"RtlUpcaseUnicodeStringToOemString", 0x0002C0C9, NULL, NULL},
	{"RtlUpcaseUnicodeToCustomCPN", 0x0005B8E1, NULL, NULL},
	{"RtlUpcaseUnicodeToMultiByteN", 0x000241DD, NULL, NULL},
	{"RtlUpcaseUnicodeToOemN", 0x0002BDA5, NULL, NULL},
	{"RtlUpdateTimer", 0x0002AF05, NULL, NULL},
	{"RtlUpperChar", 0x000293C2, NULL, NULL},
	{"RtlUpperString", 0x0005F7E9, NULL, NULL},
	{"RtlUsageHeap", 0x000624D8, NULL, NULL},
	{"RtlValidAcl", 0x000185CD, NULL, NULL},
	{"RtlValidRelativeSecurityDescriptor", 0x0002D229, NULL, NULL},
	{"RtlValidSecurityDescriptor", 0x00034E12, NULL, NULL},
	{"RtlValidSid", 0x00012F84, NULL, NULL},
	{"RtlValidateHeap", 0x00062208, NULL, NULL},
	{"RtlValidateProcessHeaps", 0x0006242B, NULL, NULL},
	{"RtlValidateUnicodeString", 0x00015E6A, NULL, NULL},
	{"RtlVerifyVersionInfo", 0x00034AF7, NULL, NULL},
	{"RtlWalkFrameChain", 0x0006072A, NULL, NULL},
	{"RtlWalkHeap", 0x00061911, NULL, NULL},
	{"RtlWriteMemoryStream", 0x00053603, NULL, NULL},
	{"RtlWriteRegistryValue", 0x00030FA0, NULL, NULL},
	{"RtlZeroHeap", 0x0005F193, NULL, NULL},
	{"RtlZeroMemory", 0x00002C64, NULL, NULL},
	{"RtlZombifyActivationContext", 0x000580A5, NULL, NULL},
	{"RtlpApplyLengthFunction", 0x000204D6, NULL, NULL},
	{"RtlpEnsureBufferSize", 0x0001E287, NULL, NULL},
	{"RtlpNotOwnerCriticalSection", 0x000537F0, NULL, NULL},
	{"RtlpNtCreateKey", 0x000679AB, NULL, NULL},
	{"RtlpNtEnumerateSubKey", 0x0002E5A1, NULL, NULL},
	{"RtlpNtMakeTemporaryKey", 0x00067A04, NULL, NULL},
	{"RtlpNtOpenKey", 0x00029867, NULL, NULL},
	{"RtlpNtQueryValueKey", 0x000297A6, NULL, NULL},
	{"RtlpNtSetValueKey", 0x000679D8, NULL, NULL},
	{"RtlpUnWaitCriticalSection", 0x0001B287, NULL, NULL},
	{"RtlpWaitForCriticalSection", 0x0001B1BF, NULL, NULL},
	{"RtlxAnsiStringToUnicodeSize", 0x0005F4C8, NULL, NULL},
	{"RtlxOemStringToUnicodeSize", 0x0005F4C8, NULL, NULL},
	{"RtlxUnicodeStringToAnsiSize", 0x0005F4A3, NULL, NULL},
	{"RtlxUnicodeStringToOemSize", 0x0005F4A3, NULL, NULL},
	{"VerSetConditionMask", 0x00034AB9, NULL, NULL},
	{"ZwAcceptConnectPort", 0x0000CE5E, NULL, NULL},
	{"ZwAccessCheck", 0x0000CE6E, NULL, NULL},
	{"ZwAccessCheckAndAuditAlarm", 0x0000CE7E, NULL, NULL},
	{"ZwAccessCheckByType", 0x0000CE8E, NULL, NULL},
	{"ZwAccessCheckByTypeAndAuditAlarm", 0x0000CE9E, NULL, NULL},
	{"ZwAccessCheckByTypeResultList", 0x0000CEAE, NULL, NULL},
	{"ZwAccessCheckByTypeResultListAndAuditAlarm", 0x0000CEBE, NULL, NULL},
	{"ZwAccessCheckByTypeResultListAndAuditAlarmByHandle", 0x0000CECE, NULL, NULL},
	{"ZwAddAtom", 0x0000CEDE, NULL, NULL},
	{"ZwAddBootEntry", 0x0000CEEE, NULL, NULL},
	{"ZwAdjustGroupsToken", 0x0000CEFE, NULL, NULL},
	{"ZwAdjustPrivilegesToken", 0x0000CF0E, NULL, NULL},
	{"ZwAlertResumeThread", 0x0000CF1E, NULL, NULL},
	{"ZwAlertThread", 0x0000CF2E, NULL, NULL},
	{"ZwAllocateLocallyUniqueId", 0x0000CF3E, NULL, NULL},
	{"ZwAllocateUserPhysicalPages", 0x0000CF4E, NULL, NULL},
	{"ZwAllocateUuids", 0x0000CF5E, NULL, NULL},
	{"ZwAllocateVirtualMemory", 0x0000CF6E, NULL, NULL},
	{"ZwAreMappedFilesTheSame", 0x0000CF7E, NULL, NULL},
	{"ZwAssignProcessToJobObject", 0x0000CF8E, NULL, NULL},
	{"ZwCallbackReturn", 0x0000CF9E, NULL, NULL},
	{"ZwCancelDeviceWakeupRequest", 0x0000CFAE, NULL, NULL},
	{"ZwCancelIoFile", 0x0000CFBE, NULL, NULL},
	{"ZwCancelTimer", 0x0000CFCE, NULL, NULL},
	{"ZwClearEvent", 0x0000CFDE, NULL, NULL},
	{"ZwClose", 0x0000CFEE, NULL, NULL},
	{"ZwCloseObjectAuditAlarm", 0x0000CFFE, NULL, NULL},
	{"ZwCompactKeys", 0x0000D00E, NULL, NULL},
	{"ZwCompareTokens", 0x0000D01E, NULL, NULL},
	{"ZwCompleteConnectPort", 0x0000D02E, NULL, NULL},
	{"ZwCompressKey", 0x0000D03E, NULL, NULL},
	{"ZwConnectPort", 0x0000D04E, NULL, NULL},
	{"ZwContinue", 0x0000D05E, NULL, NULL},
	{"ZwCreateDebugObject", 0x0000D06E, NULL, NULL},
	{"ZwCreateDirectoryObject", 0x0000D07E, NULL, NULL},
	{"ZwCreateEvent", 0x0000D08E, NULL, NULL},
	{"ZwCreateEventPair", 0x0000D09E, NULL, NULL},
	{"ZwCreateFile", 0x0000D0AE, NULL, NULL},
	{"ZwCreateIoCompletion", 0x0000D0BE, NULL, NULL},
	{"ZwCreateJobObject", 0x0000D0CE, NULL, NULL},
	{"ZwCreateJobSet", 0x0000D0DE, NULL, NULL},
	{"ZwCreateKey", 0x0000D0EE, NULL, NULL},
	{"ZwCreateKeyedEvent", 0x0000DFCE, NULL, NULL},
	{"ZwCreateMailslotFile", 0x0000D0FE, NULL, NULL},
	{"ZwCreateMutant", 0x0000D10E, NULL, NULL},
	{"ZwCreateNamedPipeFile", 0x0000D11E, NULL, NULL},
	{"ZwCreatePagingFile", 0x0000D12E, NULL, NULL},
	{"ZwCreatePort", 0x0000D13E, NULL, NULL},
	{"ZwCreateProcess", 0x0000D14E, NULL, NULL},
	{"ZwCreateProcessEx", 0x0000D15E, NULL, NULL},
	{"ZwCreateProfile", 0x0000D16E, NULL, NULL},
	{"ZwCreateSection", 0x0000D17E, NULL, NULL},
	{"ZwCreateSemaphore", 0x0000D18E, NULL, NULL},
	{"ZwCreateSymbolicLinkObject", 0x0000D19E, NULL, NULL},
	{"ZwCreateThread", 0x0000D1AE, NULL, NULL},
	{"ZwCreateTimer", 0x0000D1BE, NULL, NULL},
	{"ZwCreateToken", 0x0000D1CE, NULL, NULL},
	{"ZwCreateWaitablePort", 0x0000D1DE, NULL, NULL},
	{"ZwDebugActiveProcess", 0x0000D1EE, NULL, NULL},
	{"ZwDebugContinue", 0x0000D1FE, NULL, NULL},
	{"ZwDelayExecution", 0x0000D20E, NULL, NULL},
	{"ZwDeleteAtom", 0x0000D21E, NULL, NULL},
	{"ZwDeleteBootEntry", 0x0000D22E, NULL, NULL},
	{"ZwDeleteFile", 0x0000D23E, NULL, NULL},
	{"ZwDeleteKey", 0x0000D24E, NULL, NULL},
	{"ZwDeleteObjectAuditAlarm", 0x0000D25E, NULL, NULL},
	{"ZwDeleteValueKey", 0x0000D26E, NULL, NULL},
	{"ZwDeviceIoControlFile", 0x0000D27E, NULL, NULL},
	{"ZwDisplayString", 0x0000D28E, NULL, NULL},
	{"ZwDuplicateObject", 0x0000D29E, NULL, NULL},
	{"ZwDuplicateToken", 0x0000D2AE, NULL, NULL},
	{"ZwEnumerateBootEntries", 0x0000D2BE, NULL, NULL},
	{"ZwEnumerateKey", 0x0000D2CE, NULL, NULL},
	{"ZwEnumerateSystemEnvironmentValuesEx", 0x0000D2DE, NULL, NULL},
	{"ZwEnumerateValueKey", 0x0000D2EE, NULL, NULL},
	{"ZwExtendSection", 0x0000D2FE, NULL, NULL},
	{"ZwFilterToken", 0x0000D30E, NULL, NULL},
	{"ZwFindAtom", 0x0000D31E, NULL, NULL},
	{"ZwFlushBuffersFile", 0x0000D32E, NULL, NULL},
	{"ZwFlushInstructionCache", 0x0000D33E, NULL, NULL},
	{"ZwFlushKey", 0x0000D34E, NULL, NULL},
	{"ZwFlushVirtualMemory", 0x0000D35E, NULL, NULL},
	{"ZwFlushWriteBuffer", 0x0000D36E, NULL, NULL},
	{"ZwFreeUserPhysicalPages", 0x0000D37E, NULL, NULL},
	{"ZwFreeVirtualMemory", 0x0000D38E, NULL, NULL},
	{"ZwFsControlFile", 0x0000D39E, NULL, NULL},
	{"ZwGetContextThread", 0x0000D3AE, NULL, NULL},
	{"ZwGetDevicePowerState", 0x0000D3BE, NULL, NULL},
	{"ZwGetPlugPlayEvent", 0x0000D3CE, NULL, NULL},
	{"ZwGetWriteWatch", 0x0000D3DE, NULL, NULL},
	{"ZwImpersonateAnonymousToken", 0x0000D3EE, NULL, NULL},
	{"ZwImpersonateClientOfPort", 0x0000D3FE, NULL, NULL},
	{"ZwImpersonateThread", 0x0000D40E, NULL, NULL},
	{"ZwInitializeRegistry", 0x0000D41E, NULL, NULL},
	{"ZwInitiatePowerAction", 0x0000D42E, NULL, NULL},
	{"ZwIsProcessInJob", 0x0000D43E, NULL, NULL},
	{"ZwIsSystemResumeAutomatic", 0x0000D44E, NULL, NULL},
	{"ZwListenPort", 0x0000D45E, NULL, NULL},
	{"ZwLoadDriver", 0x0000D46E, NULL, NULL},
	{"ZwLoadKey2", 0x0000D48E, NULL, NULL},
	{"ZwLoadKey", 0x0000D47E, NULL, NULL},
	{"ZwLockFile", 0x0000D49E, NULL, NULL},
	{"ZwLockProductActivationKeys", 0x0000D4AE, NULL, NULL},
	{"ZwLockRegistryKey", 0x0000D4BE, NULL, NULL},
	{"ZwLockVirtualMemory", 0x0000D4CE, NULL, NULL},
	{"ZwMakePermanentObject", 0x0000D4DE, NULL, NULL},
	{"ZwMakeTemporaryObject", 0x0000D4EE, NULL, NULL},
	{"ZwMapUserPhysicalPages", 0x0000D4FE, NULL, NULL},
	{"ZwMapUserPhysicalPagesScatter", 0x0000D50E, NULL, NULL},
	{"ZwMapViewOfSection", 0x0000D51E, NULL, NULL},
	{"ZwModifyBootEntry", 0x0000D52E, NULL, NULL},
	{"ZwNotifyChangeDirectoryFile", 0x0000D53E, NULL, NULL},
	{"ZwNotifyChangeKey", 0x0000D54E, NULL, NULL},
	{"ZwNotifyChangeMultipleKeys", 0x0000D55E, NULL, NULL},
	{"ZwOpenDirectoryObject", 0x0000D56E, NULL, NULL},
	{"ZwOpenEvent", 0x0000D57E, NULL, NULL},
	{"ZwOpenEventPair", 0x0000D58E, NULL, NULL},
	{"ZwOpenFile", 0x0000D59E, NULL, NULL},
	{"ZwOpenIoCompletion", 0x0000D5AE, NULL, NULL},
	{"ZwOpenJobObject", 0x0000D5BE, NULL, NULL},
	{"ZwOpenKey", 0x0000D5CE, NULL, NULL},
	{"ZwOpenKeyedEvent", 0x0000DFDE, NULL, NULL},
	{"ZwOpenMutant", 0x0000D5DE, NULL, NULL},
	{"ZwOpenObjectAuditAlarm", 0x0000D5EE, NULL, NULL},
	{"ZwOpenProcess", 0x0000D5FE, NULL, NULL},
	{"ZwOpenProcessToken", 0x0000D60E, NULL, NULL},
	{"ZwOpenProcessTokenEx", 0x0000D61E, NULL, NULL},
	{"ZwOpenSection", 0x0000D62E, NULL, NULL},
	{"ZwOpenSemaphore", 0x0000D63E, NULL, NULL},
	{"ZwOpenSymbolicLinkObject", 0x0000D64E, NULL, NULL},
	{"ZwOpenThread", 0x0000D65E, NULL, NULL},
	{"ZwOpenThreadToken", 0x0000D66E, NULL, NULL},
	{"ZwOpenThreadTokenEx", 0x0000D67E, NULL, NULL},
	{"ZwOpenTimer", 0x0000D68E, NULL, NULL},
	{"ZwPlugPlayControl", 0x0000D69E, NULL, NULL},
	{"ZwPowerInformation", 0x0000D6AE, NULL, NULL},
	{"ZwPrivilegeCheck", 0x0000D6BE, NULL, NULL},
	{"ZwPrivilegeObjectAuditAlarm", 0x0000D6CE, NULL, NULL},
	{"ZwPrivilegedServiceAuditAlarm", 0x0000D6DE, NULL, NULL},
	{"ZwProtectVirtualMemory", 0x0000D6EE, NULL, NULL},
	{"ZwPulseEvent", 0x0000D6FE, NULL, NULL},
	{"ZwQueryAttributesFile", 0x0000D70E, NULL, NULL},
	{"ZwQueryBootEntryOrder", 0x0000D71E, NULL, NULL},
	{"ZwQueryBootOptions", 0x0000D72E, NULL, NULL},
	{"ZwQueryDebugFilterState", 0x0000D73E, NULL, NULL},
	{"ZwQueryDefaultLocale", 0x0000D74E, NULL, NULL},
	{"ZwQueryDefaultUILanguage", 0x0000D75E, NULL, NULL},
	{"ZwQueryDirectoryFile", 0x0000D76E, NULL, NULL},
	{"ZwQueryDirectoryObject", 0x0000D77E, NULL, NULL},
	{"ZwQueryEaFile", 0x0000D78E, NULL, NULL},
	{"ZwQueryEvent", 0x0000D79E, NULL, NULL},
	{"ZwQueryFullAttributesFile", 0x0000D7AE, NULL, NULL},
	{"ZwQueryInformationAtom", 0x0000D7BE, NULL, NULL},
	{"ZwQueryInformationFile", 0x0000D7CE, NULL, NULL},
	{"ZwQueryInformationJobObject", 0x0000D7DE, NULL, NULL},
	{"ZwQueryInformationPort", 0x0000D7EE, NULL, NULL},
	{"ZwQueryInformationProcess", 0x0000D7FE, NULL, NULL},
	{"ZwQueryInformationThread", 0x0000D80E, NULL, NULL},
	{"ZwQueryInformationToken", 0x0000D81E, NULL, NULL},
	{"ZwQueryInstallUILanguage", 0x0000D82E, NULL, NULL},
	{"ZwQueryIntervalProfile", 0x0000D83E, NULL, NULL},
	{"ZwQueryIoCompletion", 0x0000D84E, NULL, NULL},
	{"ZwQueryKey", 0x0000D85E, NULL, NULL},
	{"ZwQueryMultipleValueKey", 0x0000D86E, NULL, NULL},
	{"ZwQueryMutant", 0x0000D87E, NULL, NULL},
	{"ZwQueryObject", 0x0000D88E, NULL, NULL},
	{"ZwQueryOpenSubKeys", 0x0000D89E, NULL, NULL},
	{"ZwQueryPerformanceCounter", 0x0000D8AE, NULL, NULL},
	{"ZwQueryPortInformationProcess", 0x0000E00E, NULL, NULL},
	{"ZwQueryQuotaInformationFile", 0x0000D8BE, NULL, NULL},
	{"ZwQuerySection", 0x0000D8CE, NULL, NULL},
	{"ZwQuerySecurityObject", 0x0000D8DE, NULL, NULL},
	{"ZwQuerySemaphore", 0x0000D8EE, NULL, NULL},
	{"ZwQuerySymbolicLinkObject", 0x0000D8FE, NULL, NULL},
	{"ZwQuerySystemEnvironmentValue", 0x0000D90E, NULL, NULL},
	{"ZwQuerySystemEnvironmentValueEx", 0x0000D91E, NULL, NULL},
	{"ZwQuerySystemInformation", 0x0000D92E, NULL, NULL},
	{"ZwQuerySystemTime", 0x0000D93E, NULL, NULL},
	{"ZwQueryTimer", 0x0000D94E, NULL, NULL},
	{"ZwQueryTimerResolution", 0x0000D95E, NULL, NULL},
	{"ZwQueryValueKey", 0x0000D96E, NULL, NULL},
	{"ZwQueryVirtualMemory", 0x0000D97E, NULL, NULL},
	{"ZwQueryVolumeInformationFile", 0x0000D98E, NULL, NULL},
	{"ZwQueueApcThread", 0x0000D99E, NULL, NULL},
	{"ZwRaiseException", 0x0000D9AE, NULL, NULL},
	{"ZwRaiseHardError", 0x0000D9BE, NULL, NULL},
	{"ZwReadFile", 0x0000D9CE, NULL, NULL},
	{"ZwReadFileScatter", 0x0000D9DE, NULL, NULL},
	{"ZwReadRequestData", 0x0000D9EE, NULL, NULL},
	{"ZwReadVirtualMemory", 0x0000D9FE, NULL, NULL},
	{"ZwRegisterThreadTerminatePort", 0x0000DA0E, NULL, NULL},
	{"ZwReleaseKeyedEvent", 0x0000DFEE, NULL, NULL},
	{"ZwReleaseMutant", 0x0000DA1E, NULL, NULL},
	{"ZwReleaseSemaphore", 0x0000DA2E, NULL, NULL},
	{"ZwRemoveIoCompletion", 0x0000DA3E, NULL, NULL},
	{"ZwRemoveProcessDebug", 0x0000DA4E, NULL, NULL},
	{"ZwRenameKey", 0x0000DA5E, NULL, NULL},
	{"ZwReplaceKey", 0x0000DA6E, NULL, NULL},
	{"ZwReplyPort", 0x0000DA7E, NULL, NULL},
	{"ZwReplyWaitReceivePort", 0x0000DA8E, NULL, NULL},
	{"ZwReplyWaitReceivePortEx", 0x0000DA9E, NULL, NULL},
	{"ZwReplyWaitReplyPort", 0x0000DAAE, NULL, NULL},
	{"ZwRequestDeviceWakeup", 0x0000DABE, NULL, NULL},
	{"ZwRequestPort", 0x0000DACE, NULL, NULL},
	{"ZwRequestWaitReplyPort", 0x0000DADE, NULL, NULL},
	{"ZwRequestWakeupLatency", 0x0000DAEE, NULL, NULL},
	{"ZwResetEvent", 0x0000DAFE, NULL, NULL},
	{"ZwResetWriteWatch", 0x0000DB0E, NULL, NULL},
	{"ZwRestoreKey", 0x0000DB1E, NULL, NULL},
	{"ZwResumeProcess", 0x0000DB2E, NULL, NULL},
	{"ZwResumeThread", 0x0000DB3E, NULL, NULL},
	{"ZwSaveKey", 0x0000DB4E, NULL, NULL},
	{"ZwSaveKeyEx", 0x0000DB5E, NULL, NULL},
	{"ZwSaveMergedKeys", 0x0000DB6E, NULL, NULL},
	{"ZwSecureConnectPort", 0x0000DB7E, NULL, NULL},
	{"ZwSetBootEntryOrder", 0x0000DB8E, NULL, NULL},
	{"ZwSetBootOptions", 0x0000DB9E, NULL, NULL},
	{"ZwSetContextThread", 0x0000DBAE, NULL, NULL},
	{"ZwSetDebugFilterState", 0x0000DBBE, NULL, NULL},
	{"ZwSetDefaultHardErrorPort", 0x0000DBCE, NULL, NULL},
	{"ZwSetDefaultLocale", 0x0000DBDE, NULL, NULL},
	{"ZwSetDefaultUILanguage", 0x0000DBEE, NULL, NULL},
	{"ZwSetEaFile", 0x0000DBFE, NULL, NULL},
	{"ZwSetEvent", 0x0000DC0E, NULL, NULL},
	{"ZwSetEventBoostPriority", 0x0000DC1E, NULL, NULL},
	{"ZwSetHighEventPair", 0x0000DC2E, NULL, NULL},
	{"ZwSetHighWaitLowEventPair", 0x0000DC3E, NULL, NULL},
	{"ZwSetInformationDebugObject", 0x0000DC4E, NULL, NULL},
	{"ZwSetInformationFile", 0x0000DC5E, NULL, NULL},
	{"ZwSetInformationJobObject", 0x0000DC6E, NULL, NULL},
	{"ZwSetInformationKey", 0x0000DC7E, NULL, NULL},
	{"ZwSetInformationObject", 0x0000DC8E, NULL, NULL},
	{"ZwSetInformationProcess", 0x0000DC9E, NULL, NULL},
	{"ZwSetInformationThread", 0x0000DCAE, NULL, NULL},
	{"ZwSetInformationToken", 0x0000DCBE, NULL, NULL},
	{"ZwSetIntervalProfile", 0x0000DCCE, NULL, NULL},
	{"ZwSetIoCompletion", 0x0000DCDE, NULL, NULL},
	{"ZwSetLdtEntries", 0x0000DCEE, NULL, NULL},
	{"ZwSetLowEventPair", 0x0000DCFE, NULL, NULL},
	{"ZwSetLowWaitHighEventPair", 0x0000DD0E, NULL, NULL},
	{"ZwSetQuotaInformationFile", 0x0000DD1E, NULL, NULL},
	{"ZwSetSecurityObject", 0x0000DD2E, NULL, NULL},
	{"ZwSetSystemEnvironmentValue", 0x0000DD3E, NULL, NULL},
	{"ZwSetSystemEnvironmentValueEx", 0x0000DD4E, NULL, NULL},
	{"ZwSetSystemInformation", 0x0000DD5E, NULL, NULL},
	{"ZwSetSystemPowerState", 0x0000DD6E, NULL, NULL},
	{"ZwSetSystemTime", 0x0000DD7E, NULL, NULL},
	{"ZwSetThreadExecutionState", 0x0000DD8E, NULL, NULL},
	{"ZwSetTimer", 0x0000DD9E, NULL, NULL},
	{"ZwSetTimerResolution", 0x0000DDAE, NULL, NULL},
	{"ZwSetUuidSeed", 0x0000DDBE, NULL, NULL},
	{"ZwSetValueKey", 0x0000DDCE, NULL, NULL},
	{"ZwSetVolumeInformationFile", 0x0000DDDE, NULL, NULL},
	{"ZwShutdownSystem", 0x0000DDEE, NULL, NULL},
	{"ZwSignalAndWaitForSingleObject", 0x0000DDFE, NULL, NULL},
	{"ZwStartProfile", 0x0000DE0E, NULL, NULL},
	{"ZwStopProfile", 0x0000DE1E, NULL, NULL},
	{"ZwSuspendProcess", 0x0000DE2E, NULL, NULL},
	{"ZwSuspendThread", 0x0000DE3E, NULL, NULL},
	{"ZwSystemDebugControl", 0x0000DE4E, NULL, NULL},
	{"ZwTerminateJobObject", 0x0000DE5E, NULL, NULL},
	{"ZwTerminateProcess", 0x0000DE6E, NULL, NULL},
	{"ZwTerminateThread", 0x0000DE7E, NULL, NULL},
	{"ZwTestAlert", 0x0000DE8E, NULL, NULL},
	{"ZwTraceEvent", 0x0000DE9E, NULL, NULL},
	{"ZwTranslateFilePath", 0x0000DEAE, NULL, NULL},
	{"ZwUnloadDriver", 0x0000DEBE, NULL, NULL},
	{"ZwUnloadKey", 0x0000DECE, NULL, NULL},
	{"ZwUnloadKeyEx", 0x0000DEDE, NULL, NULL},
	{"ZwUnlockFile", 0x0000DEEE, NULL, NULL},
	{"ZwUnlockVirtualMemory", 0x0000DEFE, NULL, NULL},
	{"ZwUnmapViewOfSection", 0x0000DF0E, NULL, NULL},
	{"ZwVdmControl", 0x0000DF1E, NULL, NULL},
	{"ZwWaitForDebugEvent", 0x0000DF2E, NULL, NULL},
	{"ZwWaitForKeyedEvent", 0x0000DFFE, NULL, NULL},
	{"ZwWaitForMultipleObjects", 0x0000DF3E, NULL, NULL},
	{"ZwWaitForSingleObject", 0x0000DF4E, NULL, NULL},
	{"ZwWaitHighEventPair", 0x0000DF5E, NULL, NULL},
	{"ZwWaitLowEventPair", 0x0000DF6E, NULL, NULL},
	{"ZwWriteFile", 0x0000DF7E, NULL, NULL},
	{"ZwWriteFileGather", 0x0000DF8E, NULL, NULL},
	{"ZwWriteRequestData", 0x0000DF9E, NULL, NULL},
	{"ZwWriteVirtualMemory", 0x0000DFAE, NULL, NULL},
	{"ZwYieldExecution", 0x0000DFBE, NULL, NULL},
	{"_CIcos", 0x0000E5E6, NULL, NULL},
	{"_CIlog", 0x0000E6A2, NULL, NULL},
	{"_CIpow", 0x0000E020, NULL, NULL},
	{"_CIsin", 0x000012D1, NULL, NULL},
	{"_CIsqrt", 0x0000137F, NULL, NULL},
	{"__isascii", 0x0002C8D2, NULL, NULL},
	{"__iscsym", 0x00071583, NULL, NULL},
	{"__iscsymf", 0x0007153D, NULL, NULL},
	{"__toascii", 0x0007152B, NULL, NULL},
	{"_alldiv", 0x0000143B, NULL, NULL},
	{"_alldvrm", 0x000014E5, NULL, NULL},
	{"_allmul", 0x000015C4, NULL, NULL},
	{"_alloca_probe", 0x000015F8, NULL, NULL},
	{"_allrem", 0x00001635, NULL, NULL},
	{"_allshl", 0x000016E9, NULL, NULL},
	{"_allshr", 0x00001708, NULL, NULL},
	{"_atoi64", 0x000715C9, NULL, NULL},
	{"_aulldiv", 0x00001729, NULL, NULL},
	{"_aulldvrm", 0x00001791, NULL, NULL},
	{"_aullrem", 0x00001826, NULL, NULL},
	{"_aullshr", 0x0000189B, NULL, NULL},
	{"_chkstk", 0x000015F8, NULL, NULL},
	{"_fltused", 0x0007E048, NULL, NULL},
	{"_ftol", 0x000018BA, NULL, NULL},
	{"_i64toa", 0x00071745, NULL, NULL},
	{"_i64tow", 0x00071867, NULL, NULL},
	{"_itoa", 0x0002E994, NULL, NULL},
	{"_itow", 0x0002DCB1, NULL, NULL},
	{"_lfind", 0x000718C1, NULL, NULL},
	{"_ltoa", 0x00071686, NULL, NULL},
	{"_ltow", 0x0007179F, NULL, NULL},
	{"_memccpy", 0x000018E1, NULL, NULL},
	{"_memicmp", 0x000718FA, NULL, NULL},
	{"_snprintf", 0x0007190A, NULL, NULL},
	{"_snwprintf", 0x0001BBEA, NULL, NULL},
	{"_splitpath", 0x00071968, NULL, NULL},
	{"_strcmpi", 0x00012E64, NULL, NULL},
	{"_stricmp", 0x00012E64, NULL, NULL},
	{"_strlwr", 0x00071AB0, NULL, NULL},
	{"_strnicmp", 0x0001989D, NULL, NULL},
	{"_strupr", 0x00071ADD, NULL, NULL},
	{"_tolower", 0x00071B0A, NULL, NULL},
	{"_toupper", 0x00071B57, NULL, NULL},
	{"_ui64toa", 0x0007177D, NULL, NULL},
	{"_ui64tow", 0x0007189F, NULL, NULL},
	{"_ultoa", 0x000716B2, NULL, NULL},
	{"_ultow", 0x000717CB, NULL, NULL},
	{"_vsnprintf", 0x0002FB97, NULL, NULL},
	{"_vsnwprintf", 0x00071B69, NULL, NULL},
	{"_wcsicmp", 0x00013378, NULL, NULL},
	{"_wcslwr", 0x00024869, NULL, NULL},
	{"_wcsnicmp", 0x000181ED, NULL, NULL},
	{"_wcsupr", 0x00071BDF, NULL, NULL},
	{"_wtoi", 0x00071C15, NULL, NULL},
	{"_wtoi64", 0x00071C25, NULL, NULL},
	{"_wtol", 0x0003687A, NULL, NULL},
	{"abs", 0x00071CC2, NULL, NULL},
	{"atan", 0x00001934, NULL, NULL},
	{"atoi", 0x000248A9, NULL, NULL},
	{"atol", 0x000248B6, NULL, NULL},
	{"bsearch", 0x000151F3, NULL, NULL},
	{"ceil", 0x000019D7, NULL, NULL},
	{"cos", 0x0000E5FA, NULL, NULL},
	{"fabs", 0x00071CD7, NULL, NULL},
	{"floor", 0x00001B18, NULL, NULL},
	{"isalnum", 0x00071450, NULL, NULL},
	{"isalpha", 0x00071314, NULL, NULL},
	{"iscntrl", 0x000714F8, NULL, NULL},
	{"isdigit", 0x0002C8A9, NULL, NULL},
	{"isgraph", 0x000714C0, NULL, NULL},
	{"islower", 0x0007137F, NULL, NULL},
	{"isprint", 0x00071488, NULL, NULL},
	{"ispunct", 0x0007141D, NULL, NULL},
	{"isspace", 0x000713EA, NULL, NULL},
	{"isupper", 0x0007134C, NULL, NULL},
	{"iswalpha", 0x00071D8F, NULL, NULL},
	{"iswctype", 0x000269F1, NULL, NULL},
	{"iswdigit", 0x00026A95, NULL, NULL},
	{"iswlower", 0x00071DAA, NULL, NULL},
	{"iswspace", 0x00071DDD, NULL, NULL},
	{"iswxdigit", 0x00071DC2, NULL, NULL},
	{"isxdigit", 0x000713B2, NULL, NULL},
	{"labs", 0x00071CC2, NULL, NULL},
	{"log", 0x0000E69E, NULL, NULL},
	{"mbstowcs", 0x0002492C, NULL, NULL},
	{"memchr", 0x00001C60, NULL, NULL},
	{"memcmp", 0x00001D07, NULL, NULL},
	{"memcpy", 0x00001DB3, NULL, NULL},
	{"memmove", 0x000020F5, NULL, NULL},
	{"memset", 0x00002435, NULL, NULL},
	{"pow", 0x0000E01B, NULL, NULL},
	{"qsort", 0x000203D8, NULL, NULL},
	{"sin", 0x000012E5, NULL, NULL},
	{"sprintf", 0x00025BC4, NULL, NULL},
	{"sqrt", 0x00001393, NULL, NULL},
	{"sscanf", 0x00071DF5, NULL, NULL},
	{"strcat", 0x0000249D, NULL, NULL},
	{"strchr", 0x0000E80D, NULL, NULL},
	{"strcmp", 0x00002583, NULL, NULL},
	{"strcpy", 0x0000248D, NULL, NULL},
	{"strcspn", 0x00002608, NULL, NULL},
	{"strlen", 0x00002645, NULL, NULL},
	{"strncat", 0x000026C0, NULL, NULL},
	{"strncmp", 0x000027E5, NULL, NULL},
	{"strncpy", 0x0000281D, NULL, NULL},
	{"strpbrk", 0x0000291D, NULL, NULL},
	{"strrchr", 0x00002956, NULL, NULL},
	{"strspn", 0x0000297D, NULL, NULL},
	{"strstr", 0x0000E77E, NULL, NULL},
	{"strtol", 0x00071FEA, NULL, NULL},
	{"strtoul", 0x00072009, NULL, NULL},
	{"swprintf", 0x000184DB, NULL, NULL},
	{"tan", 0x000029CE, NULL, NULL},
	{"tolower", 0x00071B1C, NULL, NULL},
	{"toupper", 0x00023D33, NULL, NULL},
	{"towlower", 0x0002A846, NULL, NULL},
	{"towupper", 0x00072028, NULL, NULL},
	{"vDbgPrintEx", 0x00020324, NULL, NULL},
	{"vDbgPrintExWithPrefix", 0x0001EA7B, NULL, NULL},
	{"vsprintf", 0x0007203C, NULL, NULL},
	{"wcscat", 0x00018132, NULL, NULL},
	{"wcschr", 0x00014982, NULL, NULL},
	{"wcscmp", 0x00035454, NULL, NULL},
	{"wcscpy", 0x00012F60, NULL, NULL},
	{"wcscspn", 0x0003571E, NULL, NULL},
	{"wcslen", 0x0000FE4A, NULL, NULL},
	{"wcsncat", 0x00018B44, NULL, NULL},
	{"wcsncmp", 0x0001E42B, NULL, NULL},
	{"wcsncpy", 0x0001057F, NULL, NULL},
	{"wcspbrk", 0x0007209A, NULL, NULL},
	{"wcsrchr", 0x00014691, NULL, NULL},
	{"wcsspn", 0x000720E3, NULL, NULL},
	{"wcsstr", 0x0002382F, NULL, NULL},
	{"wcstol", 0x00029F23, NULL, NULL},
	{"wcstombs", 0x00072131, NULL, NULL},
	{"wcstoul", 0x00034DC1, NULL, NULL},
	{0,0,NULL},
};


struct emu_env_w32_dll_export shlwapi_exports[] = 
{
	{"SHAllocShared", 0x0000B601, NULL, NULL},
	{"SHLockShared", 0x0001C37B, NULL, NULL},
	{"SHUnlockShared", 0x0000B54E, NULL, NULL},
	{"SHFreeShared", 0x0000B569, NULL, NULL},
	{"GetAcceptLanguagesA", 0x0005DE35, NULL, NULL},
	{"GetAcceptLanguagesW", 0x0002CB22, NULL, NULL},
	{"SHCreateThread", 0x000173E6, NULL, NULL},
	{"IsCharSpaceW", 0x000158E5, NULL, NULL},
	{"StrCmpCA", 0x00022E8E, NULL, NULL},
	{"StrCmpCW", 0x00006929, NULL, NULL},
	{"StrCmpICA", 0x00007000, NULL, NULL},
	{"StrCmpICW", 0x00006FB8, NULL, NULL},
	{"AssocCreate", 0x00009E79, NULL, NULL},
	{"SHLoadIndirectString", 0x0000BEBE, NULL, NULL},
	{"AssocGetPerceivedType", 0x000110E3, NULL, NULL},
	{"AssocIsDangerous", 0x00013CD3, NULL, NULL},
	{"AssocQueryKeyA", 0x0005009D, NULL, NULL},
	{"AssocQueryKeyW", 0x0000A5BE, NULL, NULL},
	{"AssocQueryStringA", 0x0004FE4D, NULL, NULL},
	{"SHGetViewStatePropertyBag", 0x0001B6AE, NULL, NULL},
	{"DelayLoadFailureHook", 0x00066BED, NULL, NULL},
	{"AssocQueryStringByKeyA", 0x0004FF88, NULL, NULL},
	{"AssocQueryStringByKeyW", 0x0000B130, NULL, NULL},
	{"AssocQueryStringW", 0x0001A7CE, NULL, NULL},
	{"ChrCmpIA", 0x0002C465, NULL, NULL},
	{"ChrCmpIW", 0x00007E1A, NULL, NULL},
	{"ColorAdjustLuma", 0x000412B4, NULL, NULL},
	{"ColorHLSToRGB", 0x00018BC2, NULL, NULL},
	{"ColorRGBToHLS", 0x00018B17, NULL, NULL},
	{"DllGetVersion", 0x00065B45, NULL, NULL},
	{"GetMenuPosFromID", 0x000172F9, NULL, NULL},
	{"HashData", 0x00023872, NULL, NULL},
	{"IntlStrEqWorkerA", 0x000448BD, NULL, NULL},
	{"IntlStrEqWorkerW", 0x0000761D, NULL, NULL},
	{"IsCharSpaceA", 0x000460AD, NULL, NULL},
	{"PathAddBackslashA", 0x0001058D, NULL, NULL},
	{"PathAddBackslashW", 0x00006E9D, NULL, NULL},
	{"PathAddExtensionA", 0x00048F33, NULL, NULL},
	{"PathAddExtensionW", 0x0001532B, NULL, NULL},
	{"PathAppendA", 0x0001913C, NULL, NULL},
	{"PathAppendW", 0x00007ADD, NULL, NULL},
	{"PathBuildRootA", 0x00007444, NULL, NULL},
	{"PathBuildRootW", 0x0000404E, NULL, NULL},
	{"PathCanonicalizeA", 0x0001902B, NULL, NULL},
	{"PathCanonicalizeW", 0x00007891, NULL, NULL},
	{"PathCombineA", 0x00019180, NULL, NULL},
	{"PathCombineW", 0x000079D9, NULL, NULL},
	{"PathCommonPrefixA", 0x000471D7, NULL, NULL},
	{"PathCommonPrefixW", 0x0000753A, NULL, NULL},
	{"PathCompactPathA", 0x0004843D, NULL, NULL},
	{"PathCompactPathExA", 0x00049129, NULL, NULL},
	{"PathCompactPathExW", 0x00051B22, NULL, NULL},
	{"PathCompactPathW", 0x00051565, NULL, NULL},
	{"PathCreateFromUrlA", 0x00022FA5, NULL, NULL},
	{"PathCreateFromUrlW", 0x0001D9D7, NULL, NULL},
	{"PathFileExistsA", 0x0004707F, NULL, NULL},
	{"PathFileExistsW", 0x00007D99, NULL, NULL},
	{"PathFindExtensionA", 0x0001F5EE, NULL, NULL},
	{"PathFindExtensionW", 0x00006869, NULL, NULL},
	{"PathFindFileNameA", 0x0000C1AC, NULL, NULL},
	{"PathFindFileNameW", 0x00007087, NULL, NULL},
	{"PathFindNextComponentA", 0x00047750, NULL, NULL},
	{"PathFindNextComponentW", 0x0001BFCD, NULL, NULL},
	{"PathFindOnPathA", 0x00048F18, NULL, NULL},
	{"PathFindOnPathW", 0x0001871F, NULL, NULL},
	{"PathFindSuffixArrayA", 0x000470EB, NULL, NULL},
	{"PathFindSuffixArrayW", 0x0005100D, NULL, NULL},
	{"PathGetArgsA", 0x00047002, NULL, NULL},
	{"PathGetArgsW", 0x00014211, NULL, NULL},
	{"PathGetCharTypeA", 0x00047A7C, NULL, NULL},
	{"PathGetCharTypeW", 0x0001C2DA, NULL, NULL},
	{"PathGetDriveNumberA", 0x00047434, NULL, NULL},
	{"PathGetDriveNumberW", 0x00006BEA, NULL, NULL},
	{"PathIsContentTypeA", 0x000479FC, NULL, NULL},
	{"PathIsContentTypeW", 0x000230D1, NULL, NULL},
	{"PathIsDirectoryA", 0x000475A8, NULL, NULL},
	{"PathIsDirectoryEmptyA", 0x00048374, NULL, NULL},
	{"PathIsDirectoryEmptyW", 0x0005149A, NULL, NULL},
	{"PathIsDirectoryW", 0x0001AE99, NULL, NULL},
	{"PathIsFileSpecA", 0x000473BA, NULL, NULL},
	{"PathIsFileSpecW", 0x0001299E, NULL, NULL},
	{"PathIsLFNFileSpecA", 0x00047CC9, NULL, NULL},
	{"PathIsLFNFileSpecW", 0x000512CA, NULL, NULL},
	{"PathIsNetworkPathA", 0x0004830F, NULL, NULL},
	{"PathIsNetworkPathW", 0x00007DD3, NULL, NULL},
	{"PathIsPrefixA", 0x000472DC, NULL, NULL},
	{"PathIsPrefixW", 0x0001434C, NULL, NULL},
	{"PathIsRelativeA", 0x000192A1, NULL, NULL},
	{"PathIsRelativeW", 0x000067E2, NULL, NULL},
	{"PathIsRootA", 0x00047529, NULL, NULL},
	{"PathIsRootW", 0x00007476, NULL, NULL},
	{"PathIsSameRootA", 0x0004797D, NULL, NULL},
	{"PathIsSameRootW", 0x0005114F, NULL, NULL},
	{"PathIsSystemFolderA", 0x0001C76E, NULL, NULL},
	{"PathIsSystemFolderW", 0x00051290, NULL, NULL},
	{"PathIsUNCA", 0x00018F75, NULL, NULL},
	{"PathIsUNCServerA", 0x00023629, NULL, NULL},
	{"PathIsUNCServerShareA", 0x000473ED, NULL, NULL},
	{"PathIsUNCServerShareW", 0x00007F99, NULL, NULL},
	{"PathIsUNCServerW", 0x00007F73, NULL, NULL},
	{"PathIsUNCW", 0x00006E7F, NULL, NULL},
	{"PathIsURLA", 0x000479C5, NULL, NULL},
	{"PathIsURLW", 0x0000BBA1, NULL, NULL},
	{"PathMakePrettyA", 0x0004808D, NULL, NULL},
	{"PathMakePrettyW", 0x000211BC, NULL, NULL},
	{"PathMakeSystemFolderA", 0x00048842, NULL, NULL},
	{"PathMakeSystemFolderW", 0x00004ABF, NULL, NULL},
	{"PathMatchSpecA", 0x000478C8, NULL, NULL},
	{"PathMatchSpecW", 0x00012866, NULL, NULL},
	{"PathParseIconLocationA", 0x000487CC, NULL, NULL},
	{"PathParseIconLocationW", 0x0000B0AD, NULL, NULL},
	{"PathQuoteSpacesA", 0x000476FC, NULL, NULL},
	{"PathQuoteSpacesW", 0x00051097, NULL, NULL},
	{"PathRelativePathToA", 0x00048FBA, NULL, NULL},
	{"PathRelativePathToW", 0x0001C015, NULL, NULL},
	{"PathRemoveArgsA", 0x00047046, NULL, NULL},
	{"PathRemoveArgsW", 0x0001424B, NULL, NULL},
	{"PathRemoveBackslashA", 0x00048285, NULL, NULL},
	{"PathRemoveBackslashW", 0x000074CF, NULL, NULL},
	{"PathRemoveBlanksA", 0x00048228, NULL, NULL},
	{"PathRemoveBlanksW", 0x0000B02C, NULL, NULL},
	{"PathRemoveExtensionA", 0x0004718E, NULL, NULL},
	{"PathRemoveExtensionW", 0x00006903, NULL, NULL},
	{"PathRemoveFileSpecA", 0x0004733C, NULL, NULL},
	{"PathRemoveFileSpecW", 0x00007C66, NULL, NULL},
	{"PathRenameExtensionA", 0x000481D2, NULL, NULL},
	{"PathRenameExtensionW", 0x00051442, NULL, NULL},
	{"PathSearchAndQualifyA", 0x000474AC, NULL, NULL},
	{"PathSearchAndQualifyW", 0x0001F633, NULL, NULL},
	{"PathSetDlgItemPathA", 0x000486F5, NULL, NULL},
	{"PathSetDlgItemPathW", 0x00051819, NULL, NULL},
	{"PathSkipRootA", 0x00047918, NULL, NULL},
	{"PathSkipRootW", 0x000510F2, NULL, NULL},
	{"PathStripPathA", 0x00048347, NULL, NULL},
	{"PathStripPathW", 0x0001AB2D, NULL, NULL},
	{"PathStripToRootA", 0x000482DD, NULL, NULL},
	{"PathStripToRootW", 0x00008405, NULL, NULL},
	{"PathUnExpandEnvStringsA", 0x000494A7, NULL, NULL},
	{"PathUnExpandEnvStringsW", 0x00051E99, NULL, NULL},
	{"PathUndecorateA", 0x00047D28, NULL, NULL},
	{"PathUndecorateW", 0x0002CF45, NULL, NULL},
	{"PathUnmakeSystemFolderA", 0x00047C6B, NULL, NULL},
	{"PathUnmakeSystemFolderW", 0x00051256, NULL, NULL},
	{"PathUnquoteSpacesA", 0x000476BE, NULL, NULL},
	{"PathUnquoteSpacesW", 0x0000AFCF, NULL, NULL},
	{"SHAutoComplete", 0x000213A7, NULL, NULL},
	{"SHCopyKeyA", 0x00041624, NULL, NULL},
	{"SHCopyKeyW", 0x0004188A, NULL, NULL},
	{"SHCreateShellPalette", 0x00011980, NULL, NULL},
	{"SHCreateStreamOnFileA", 0x00060256, NULL, NULL},
	{"SHCreateStreamOnFileEx", 0x0001A1E6, NULL, NULL},
	{"SHCreateStreamOnFileW", 0x0000B8A9, NULL, NULL},
	{"SHCreateStreamWrapper", 0x0006326C, NULL, NULL},
	{"SHCreateThreadRef", 0x00017D00, NULL, NULL},
	{"SHDeleteEmptyKeyA", 0x00041905, NULL, NULL},
	{"SHDeleteEmptyKeyW", 0x00041915, NULL, NULL},
	{"SHDeleteKeyA", 0x00018551, NULL, NULL},
	{"SHDeleteKeyW", 0x00016FD4, NULL, NULL},
	{"SHDeleteOrphanKeyA", 0x00041905, NULL, NULL},
	{"SHDeleteOrphanKeyW", 0x00041915, NULL, NULL},
	{"SHDeleteValueA", 0x000415E1, NULL, NULL},
	{"SHDeleteValueW", 0x0001C435, NULL, NULL},
	{"SHEnumKeyExA", 0x00041979, NULL, NULL},
	{"SHEnumKeyExW", 0x00015138, NULL, NULL},
	{"SHEnumValueA", 0x0004199F, NULL, NULL},
	{"SHEnumValueW", 0x000212B9, NULL, NULL},
	{"SHGetInverseCMAP", 0x000242A4, NULL, NULL},
	{"SHGetThreadRef", 0x000126D4, NULL, NULL},
	{"SHGetValueA", 0x00010103, NULL, NULL},
	{"SHGetValueW", 0x00004597, NULL, NULL},
	{"SHIsLowMemoryMachine", 0x00056F09, NULL, NULL},
	{"SHOpenRegStream2A", 0x0001B0C4, NULL, NULL},
	{"SHOpenRegStream2W", 0x000124FA, NULL, NULL},
	{"SHOpenRegStreamA", 0x0001BC5C, NULL, NULL},
	{"SHOpenRegStreamW", 0x000623E9, NULL, NULL},
	{"SHQueryInfoKeyA", 0x000419CA, NULL, NULL},
	{"SHQueryInfoKeyW", 0x0001073C, NULL, NULL},
	{"SHQueryValueExA", 0x0001022B, NULL, NULL},
	{"SHQueryValueExW", 0x00006F3E, NULL, NULL},
	{"SHRegCloseUSKey", 0x00008AE8, NULL, NULL},
	{"SHRegCreateUSKeyA", 0x0001772F, NULL, NULL},
	{"SHRegCreateUSKeyW", 0x000176C7, NULL, NULL},
	{"SHRegDeleteEmptyUSKeyA", 0x00041BD3, NULL, NULL},
	{"SHRegDeleteEmptyUSKeyW", 0x00041C7A, NULL, NULL},
	{"SHRegDeleteUSValueA", 0x00041AC7, NULL, NULL},
	{"SHRegDeleteUSValueW", 0x00041B70, NULL, NULL},
	{"SHRegDuplicateHKey", 0x0000A54F, NULL, NULL},
	{"SHRegEnumUSKeyA", 0x00041CDD, NULL, NULL},
	{"SHRegEnumUSKeyW", 0x000150A1, NULL, NULL},
	{"SHRegEnumUSValueA", 0x00041D67, NULL, NULL},
	{"SHRegEnumUSValueW", 0x00041E07, NULL, NULL},
	{"SHRegGetBoolUSValueA", 0x000211F8, NULL, NULL},
	{"SHRegGetBoolUSValueW", 0x00008FA4, NULL, NULL},
	{"SHRegGetPathA", 0x00042304, NULL, NULL},
	{"SHRegGetPathW", 0x00042331, NULL, NULL},
	{"SHRegGetUSValueA", 0x0001A892, NULL, NULL},
	{"SHRegGetUSValueW", 0x00008D02, NULL, NULL},
	{"SHRegGetValueA", 0x0001006A, NULL, NULL},
	{"SHRegGetValueW", 0x0000432F, NULL, NULL},
	{"SHRegOpenUSKeyA", 0x00008B59, NULL, NULL},
	{"SHRegOpenUSKeyW", 0x00008C9A, NULL, NULL},
	{"SHRegQueryInfoUSKeyA", 0x00041EA7, NULL, NULL},
	{"SHRegQueryInfoUSKeyW", 0x0001068D, NULL, NULL},
	{"SHRegQueryUSValueA", 0x000151CE, NULL, NULL},
	{"SHRegQueryUSValueW", 0x00008E85, NULL, NULL},
	{"SHRegSetPathA", 0x00041FBE, NULL, NULL},
	{"SHRegSetPathW", 0x00041F30, NULL, NULL},
	{"SHRegSetUSValueA", 0x0004274F, NULL, NULL},
	{"SHRegSetUSValueW", 0x00018ACB, NULL, NULL},
	{"SHRegWriteUSValueA", 0x0004209D, NULL, NULL},
	{"SHRegWriteUSValueW", 0x00014FBD, NULL, NULL},
	{"SHRegisterValidateTemplate", 0x0005615D, NULL, NULL},
	{"SHReleaseThreadRef", 0x00056EA8, NULL, NULL},
	{"SHSetThreadRef", 0x00017CC6, NULL, NULL},
	{"SHSetValueA", 0x000168DB, NULL, NULL},
	{"SHSetValueW", 0x0000976F, NULL, NULL},
	{"SHSkipJunction", 0x0001EBF0, NULL, NULL},
	{"SHStrDupA", 0x00044BA0, NULL, NULL},
	{"SHStrDupW", 0x00006C73, NULL, NULL},
	{"StrCSpnA", 0x00044724, NULL, NULL},
	{"StrCSpnIA", 0x0004476E, NULL, NULL},
	{"StrCSpnIW", 0x00044CD7, NULL, NULL},
	{"StrCSpnW", 0x000173A3, NULL, NULL},
	{"StrCatBuffA", 0x000232BC, NULL, NULL},
	{"StrCatBuffW", 0x00006B60, NULL, NULL},
	{"StrCatChainW", 0x00044BFC, NULL, NULL},
	{"StrCatW", 0x000104C6, NULL, NULL},
	{"StrChrA", 0x0001AA12, NULL, NULL},
	{"StrChrIA", 0x0002C4AD, NULL, NULL},
	{"StrChrIW", 0x00007E50, NULL, NULL},
	{"StrChrNIW", 0x00044C4B, NULL, NULL},
	{"StrChrNW", 0x000444CC, NULL, NULL},
	{"StrChrW", 0x000066CD, NULL, NULL},
	{"StrCmpIW", 0x00006A9E, NULL, NULL},
	{"StrCmpLogicalW", 0x000084A5, NULL, NULL},
	{"StrCmpNA", 0x00020F99, NULL, NULL},
	{"StrCmpNIA", 0x000107E6, NULL, NULL},
	{"StrCmpNIW", 0x00006F94, NULL, NULL},
	{"StrCmpNW", 0x00006DF8, NULL, NULL},
	{"StrCmpW", 0x00007136, NULL, NULL},
	{"StrCpyNW", 0x00006763, NULL, NULL},
	{"StrCpyW", 0x0000683A, NULL, NULL},
	{"StrDupA", 0x0002CEF4, NULL, NULL},
	{"StrDupW", 0x00006782, NULL, NULL},
	{"StrFormatByteSize64A", 0x00044F9F, NULL, NULL},
	{"StrFormatByteSizeA", 0x00044FE5, NULL, NULL},
	{"StrFormatByteSizeW", 0x0001C9F2, NULL, NULL},
	{"StrFormatKBSizeA", 0x00044961, NULL, NULL},
	{"StrFormatKBSizeW", 0x0001E6D1, NULL, NULL},
	{"StrFromTimeIntervalA", 0x00045280, NULL, NULL},
	{"StrFromTimeIntervalW", 0x000452EB, NULL, NULL},
	{"StrIsIntlEqualA", 0x000448BD, NULL, NULL},
	{"StrIsIntlEqualW", 0x0000761D, NULL, NULL},
	{"StrNCatA", 0x0001C913, NULL, NULL},
	{"StrNCatW", 0x0002CD85, NULL, NULL},
	{"StrPBrkA", 0x00044564, NULL, NULL},
	{"StrPBrkW", 0x0001F699, NULL, NULL},
	{"StrRChrA", 0x00010340, NULL, NULL},
	{"StrRChrIA", 0x000444FF, NULL, NULL},
	{"StrRChrIW", 0x00044C8F, NULL, NULL},
	{"StrRChrW", 0x0000B06E, NULL, NULL},
	{"StrRStrIA", 0x000447B8, NULL, NULL},
	{"StrRStrIW", 0x0001389D, NULL, NULL},
	{"StrRetToBSTR", 0x00044A69, NULL, NULL},
	{"StrRetToBufA", 0x00044B21, NULL, NULL},
	{"StrRetToBufW", 0x00006D3F, NULL, NULL},
	{"StrRetToStrA", 0x00045041, NULL, NULL},
	{"StrRetToStrW", 0x00012653, NULL, NULL},
	{"StrSpnA", 0x00044660, NULL, NULL},
	{"StrSpnW", 0x000446CA, NULL, NULL},
	{"StrStrA", 0x00014F26, NULL, NULL},
	{"StrStrIA", 0x0002C4FE, NULL, NULL},
	{"StrStrIW", 0x00007E8C, NULL, NULL},
	{"StrStrNIW", 0x00044D1D, NULL, NULL},
	{"StrStrNW", 0x0004484C, NULL, NULL},
	{"StrStrW", 0x00006E1C, NULL, NULL},
	{"StrToInt64ExA", 0x000445B4, NULL, NULL},
	{"StrToInt64ExW", 0x0001BB70, NULL, NULL},
	{"StrToIntA", 0x00016A75, NULL, NULL},
	{"StrToIntExA", 0x00044633, NULL, NULL},
	{"StrToIntExW", 0x0001BB43, NULL, NULL},
	{"StrToIntW", 0x0000AF84, NULL, NULL},
	{"StrTrimA", 0x000449B0, NULL, NULL},
	{"StrTrimW", 0x00012F27, NULL, NULL},
	{"UrlApplySchemeA", 0x0005FAEF, NULL, NULL},
	{"UrlApplySchemeW", 0x0005FBCA, NULL, NULL},
	{"UrlCanonicalizeA", 0x00016865, NULL, NULL},
	{"UrlCanonicalizeW", 0x0001E091, NULL, NULL},
	{"UrlCombineA", 0x000166B0, NULL, NULL},
	{"UrlCombineW", 0x0001E199, NULL, NULL},
	{"UrlCompareA", 0x0005EDAD, NULL, NULL},
	{"UrlCompareW", 0x000239FD, NULL, NULL},
	{"UrlCreateFromPathA", 0x0005FA02, NULL, NULL},
	{"UrlCreateFromPathW", 0x0001D8FA, NULL, NULL},
	{"UrlEscapeA", 0x0005F77D, NULL, NULL},
	{"UrlEscapeW", 0x00021A6A, NULL, NULL},
	{"UrlGetLocationA", 0x00021EF2, NULL, NULL},
	{"UrlGetLocationW", 0x000225D7, NULL, NULL},
	{"UrlGetPartA", 0x0005F86A, NULL, NULL},
	{"UrlGetPartW", 0x0000CCBB, NULL, NULL},
	{"UrlHashA", 0x0005EEC2, NULL, NULL},
	{"UrlHashW", 0x0005EEFD, NULL, NULL},
	{"UrlIsA", 0x0005FF49, NULL, NULL},
	{"UrlIsNoHistoryA", 0x00060026, NULL, NULL},
	{"UrlIsNoHistoryW", 0x0001D9B2, NULL, NULL},
	{"UrlIsOpaqueA", 0x0006000E, NULL, NULL},
	{"UrlIsOpaqueW", 0x00023242, NULL, NULL},
	{"UrlIsW", 0x0000BCBC, NULL, NULL},
	{"UrlUnescapeA", 0x0005F970, NULL, NULL},
	{"UrlUnescapeW", 0x0001DF4C, NULL, NULL},
	{"wnsprintfA", 0x0000828C, NULL, NULL},
	{"wnsprintfW", 0x000093F6, NULL, NULL},
	{"wvnsprintfA", 0x00008012, NULL, NULL},
	{"wvnsprintfW", 0x00009201, NULL, NULL},
	{0,0,NULL},
};


struct emu_env_w32_dll_export advapi32_exports[] = 
{
	{"I_ScGetCurrentGroupStateW", 0x00066924, NULL, NULL},
	{"A_SHAFinal", 0x0002B22D, NULL, NULL},
	{"A_SHAInit", 0x0002B17D, NULL, NULL},
	{"A_SHAUpdate", 0x0002B1D1, NULL, NULL},
	{"AbortSystemShutdownA", 0x00064EB8, NULL, NULL},
	{"AbortSystemShutdownW", 0x0002D45B, NULL, NULL},
	{"AccessCheck", 0x000073A0, NULL, NULL},
	{"AccessCheckAndAuditAlarmA", 0x0003CE49, NULL, NULL},
	{"AccessCheckAndAuditAlarmW", 0x0002BC6C, NULL, NULL},
	{"AccessCheckByType", 0x0000F1C9, NULL, NULL},
	{"AccessCheckByTypeAndAuditAlarmA", 0x0003CF2F, NULL, NULL},
	{"AccessCheckByTypeAndAuditAlarmW", 0x0003CC37, NULL, NULL},
	{"AccessCheckByTypeResultList", 0x0003CB61, NULL, NULL},
	{"AccessCheckByTypeResultListAndAuditAlarmA", 0x0003D024, NULL, NULL},
	{"AccessCheckByTypeResultListAndAuditAlarmByHandleA", 0x0003D119, NULL, NULL},
	{"AccessCheckByTypeResultListAndAuditAlarmByHandleW", 0x0003CD94, NULL, NULL},
	{"AccessCheckByTypeResultListAndAuditAlarmW", 0x0003CCE2, NULL, NULL},
	{"AddAccessAllowedAce", 0x00007D31, NULL, NULL},
	{"AddAccessAllowedAceEx", 0x00012ED8, NULL, NULL},
	{"AddAccessAllowedObjectAce", 0x0003D40C, NULL, NULL},
	{"AddAccessDeniedAce", 0x0002814F, NULL, NULL},
	{"AddAccessDeniedAceEx", 0x0003D33F, NULL, NULL},
	{"AddAccessDeniedObjectAce", 0x0003D45A, NULL, NULL},
	{"AddAce", 0x00027EA3, NULL, NULL},
	{"AddAuditAccessAce", 0x0003D387, NULL, NULL},
	{"AddAuditAccessAceEx", 0x0003D3BE, NULL, NULL},
	{"AddAuditAccessObjectAce", 0x0003D4A8, NULL, NULL},
	{"AddUsersToEncryptedFile", 0x00043583, NULL, NULL},
	{"AdjustTokenGroups", 0x0003CC00, NULL, NULL},
	{"AdjustTokenPrivileges", 0x0000F00C, NULL, NULL},
	{"AllocateAndInitializeSid", 0x00007CC9, NULL, NULL},
	{"AllocateLocallyUniqueId", 0x0000748C, NULL, NULL},
	{"AreAllAccessesGranted", 0x0002BD7B, NULL, NULL},
	{"AreAnyAccessesGranted", 0x0002D27D, NULL, NULL},
	{"BackupEventLogA", 0x0003C8E0, NULL, NULL},
	{"BackupEventLogW", 0x0003C384, NULL, NULL},
	{"BuildExplicitAccessWithNameA", 0x00052374, NULL, NULL},
	{"BuildExplicitAccessWithNameW", 0x00052374, NULL, NULL},
	{"BuildImpersonateExplicitAccessWithNameA", 0x000523A4, NULL, NULL},
	{"BuildImpersonateExplicitAccessWithNameW", 0x000523A4, NULL, NULL},
	{"BuildImpersonateTrusteeA", 0x000524FE, NULL, NULL},
	{"BuildImpersonateTrusteeW", 0x000524FE, NULL, NULL},
	{"BuildSecurityDescriptorA", 0x00051EE0, NULL, NULL},
	{"BuildSecurityDescriptorW", 0x00051CA5, NULL, NULL},
	{"BuildTrusteeWithNameA", 0x000524D6, NULL, NULL},
	{"BuildTrusteeWithNameW", 0x000524D6, NULL, NULL},
	{"BuildTrusteeWithObjectsAndNameA", 0x000525DA, NULL, NULL},
	{"BuildTrusteeWithObjectsAndNameW", 0x000525DA, NULL, NULL},
	{"BuildTrusteeWithObjectsAndSidA", 0x0005253F, NULL, NULL},
	{"BuildTrusteeWithObjectsAndSidW", 0x0005253F, NULL, NULL},
	{"BuildTrusteeWithSidA", 0x0005251B, NULL, NULL},
	{"BuildTrusteeWithSidW", 0x0005251B, NULL, NULL},
	{"CancelOverlappedAccess", 0x00053709, NULL, NULL},
	{"ChangeServiceConfig2A", 0x00067101, NULL, NULL},
	{"ChangeServiceConfig2W", 0x00067189, NULL, NULL},
	{"ChangeServiceConfigA", 0x00066E69, NULL, NULL},
	{"ChangeServiceConfigW", 0x00067001, NULL, NULL},
	{"CheckTokenMembership", 0x00007FCA, NULL, NULL},
	{"ClearEventLogA", 0x0003C877, NULL, NULL},
	{"ClearEventLogW", 0x0003C265, NULL, NULL},
	{"CloseCodeAuthzLevel", 0x0000AF98, NULL, NULL},
	{"CloseEncryptedFileRaw", 0x0004349C, NULL, NULL},
	{"CloseEventLog", 0x000254BD, NULL, NULL},
	{"CloseServiceHandle", 0x00016CE5, NULL, NULL},
	{"CloseTrace", 0x00056DD0, NULL, NULL},
	{"CommandLineFromMsiDescriptor", 0x0002BE16, NULL, NULL},
	{"ComputeAccessTokenFromCodeAuthzLevel", 0x0000AB3D, NULL, NULL},
	{"ControlService", 0x00024A09, NULL, NULL},
	{"ControlTraceA", 0x0005A029, NULL, NULL},
	{"ControlTraceW", 0x0002CCED, NULL, NULL},
	{"ConvertAccessToSecurityDescriptorA", 0x00052E01, NULL, NULL},
	{"ConvertAccessToSecurityDescriptorW", 0x00052DC5, NULL, NULL},
	{"ConvertSDToStringSDRootDomainA", 0x00044B5A, NULL, NULL},
	{"ConvertSDToStringSDRootDomainW", 0x00044976, NULL, NULL},
	{"ConvertSecurityDescriptorToAccessA", 0x000530DF, NULL, NULL},
	{"ConvertSecurityDescriptorToAccessNamedA", 0x000530DF, NULL, NULL},
	{"ConvertSecurityDescriptorToAccessNamedW", 0x000530BA, NULL, NULL},
	{"ConvertSecurityDescriptorToAccessW", 0x000530BA, NULL, NULL},
	{"ConvertSecurityDescriptorToStringSecurityDescriptorA", 0x00044DCC, NULL, NULL},
	{"ConvertSecurityDescriptorToStringSecurityDescriptorW", 0x00044A45, NULL, NULL},
	{"ConvertSidToStringSidA", 0x0002C18D, NULL, NULL},
	{"ConvertSidToStringSidW", 0x0000F10F, NULL, NULL},
	{"ConvertStringSDToSDDomainA", 0x00044C38, NULL, NULL},
	{"ConvertStringSDToSDDomainW", 0x000449CE, NULL, NULL},
	{"ConvertStringSDToSDRootDomainA", 0x00044ADC, NULL, NULL},
	{"ConvertStringSDToSDRootDomainW", 0x00044923, NULL, NULL},
	{"ConvertStringSecurityDescriptorToSecurityDescriptorA", 0x00044D51, NULL, NULL},
	{"ConvertStringSecurityDescriptorToSecurityDescriptorW", 0x00012F06, NULL, NULL},
	{"ConvertStringSidToSidA", 0x00044CDC, NULL, NULL},
	{"ConvertStringSidToSidW", 0x00024457, NULL, NULL},
	{"ConvertToAutoInheritPrivateObjectSecurity", 0x0003D5A8, NULL, NULL},
	{"CopySid", 0x0000F0E7, NULL, NULL},
	{"CreateCodeAuthzLevel", 0x0004E9C5, NULL, NULL},
	{"CreatePrivateObjectSecurity", 0x0003D571, NULL, NULL},
	{"CreatePrivateObjectSecurityEx", 0x00014F2E, NULL, NULL},
	{"CreatePrivateObjectSecurityWithMultipleInheritance", 0x0003D5DE, NULL, NULL},
	{"CreateProcessAsUserA", 0x00040CE8, NULL, NULL},
	{"CreateProcessAsUserSecure", 0x00040ADD, NULL, NULL},
	{"CreateProcessAsUserW", 0x0001A8A9, NULL, NULL},
	{"CreateProcessWithLogonW", 0x00045FFD, NULL, NULL},
	{"CreateRestrictedToken", 0x0003DC8C, NULL, NULL},
	{"CreateServiceA", 0x00067211, NULL, NULL},
	{"CreateServiceW", 0x000673A9, NULL, NULL},
	{"CreateTraceInstanceId", 0x0005ADCB, NULL, NULL},
	{"CreateWellKnownSid", 0x0002519D, NULL, NULL},
	{"CredDeleteA", 0x00048509, NULL, NULL},
	{"CredDeleteW", 0x000485B1, NULL, NULL},
	{"CredEnumerateA", 0x00047FA9, NULL, NULL},
	{"CredEnumerateW", 0x00048099, NULL, NULL},
	{"CredFree", 0x0001DF8D, NULL, NULL},
	{"CredGetSessionTypes", 0x000489A9, NULL, NULL},
	{"CredGetTargetInfoA", 0x00048809, NULL, NULL},
	{"CredGetTargetInfoW", 0x000488D9, NULL, NULL},
	{"CredIsMarshaledCredentialA", 0x00048F80, NULL, NULL},
	{"CredIsMarshaledCredentialW", 0x00048E9E, NULL, NULL},
	{"CredMarshalCredentialA", 0x00048ECC, NULL, NULL},
	{"CredMarshalCredentialW", 0x00048DC6, NULL, NULL},
	{"CredProfileLoaded", 0x0001E0F5, NULL, NULL},
	{"CredReadA", 0x00047DF9, NULL, NULL},
	{"CredReadDomainCredentialsA", 0x00048329, NULL, NULL},
	{"CredReadDomainCredentialsW", 0x00048419, NULL, NULL},
	{"CredReadW", 0x00047ED1, NULL, NULL},
	{"CredRenameA", 0x00048659, NULL, NULL},
	{"CredRenameW", 0x00048731, NULL, NULL},
	{"CredUnmarshalCredentialA", 0x00048F17, NULL, NULL},
	{"CredUnmarshalCredentialW", 0x00026EDE, NULL, NULL},
	{"CredWriteA", 0x00047CB9, NULL, NULL},
	{"CredWriteDomainCredentialsA", 0x00048189, NULL, NULL},
	{"CredWriteDomainCredentialsW", 0x00048259, NULL, NULL},
	{"CredWriteW", 0x00047D59, NULL, NULL},
	{"CredpConvertCredential", 0x0004782D, NULL, NULL},
	{"CredpConvertTargetInfo", 0x000478D1, NULL, NULL},
	{"CredpDecodeCredential", 0x00047360, NULL, NULL},
	{"CredpEncodeCredential", 0x000472F8, NULL, NULL},
	{"CryptAcquireContextA", 0x0001793D, NULL, NULL},
	{"CryptAcquireContextW", 0x00017F99, NULL, NULL},
	{"CryptContextAddRef", 0x00041070, NULL, NULL},
	{"CryptCreateHash", 0x00019C71, NULL, NULL},
	{"CryptDecrypt", 0x0001A129, NULL, NULL},
	{"CryptDeriveKey", 0x00019FFD, NULL, NULL},
	{"CryptDestroyHash", 0x00019BCC, NULL, NULL},
	{"CryptDestroyKey", 0x00019EBC, NULL, NULL},
	{"CryptDuplicateHash", 0x00041CF9, NULL, NULL},
	{"CryptDuplicateKey", 0x00041939, NULL, NULL},
	{"CryptEncrypt", 0x0001E360, NULL, NULL},
	{"CryptEnumProviderTypesA", 0x00041201, NULL, NULL},
	{"CryptEnumProviderTypesW", 0x000429A1, NULL, NULL},
	{"CryptEnumProvidersA", 0x00041461, NULL, NULL},
	{"CryptEnumProvidersW", 0x00042B09, NULL, NULL},
	{"CryptExportKey", 0x00041BF9, NULL, NULL},
	{"CryptGenKey", 0x00041849, NULL, NULL},
	{"CryptGenRandom", 0x0002B3F4, NULL, NULL},
	{"CryptGetDefaultProviderA", 0x000426E1, NULL, NULL},
	{"CryptGetDefaultProviderW", 0x00042D89, NULL, NULL},
	{"CryptGetHashParam", 0x00019DB4, NULL, NULL},
	{"CryptGetKeyParam", 0x00021298, NULL, NULL},
	{"CryptGetProvParam", 0x00021339, NULL, NULL},
	{"CryptGetUserKey", 0x00041B21, NULL, NULL},
	{"CryptHashData", 0x00019A9E, NULL, NULL},
	{"CryptHashSessionKey", 0x00041E21, NULL, NULL},
	{"CryptImportKey", 0x0001A1F1, NULL, NULL},
	{"CryptReleaseContext", 0x00017EEE, NULL, NULL},
	{"CryptSetHashParam", 0x00042091, NULL, NULL},
	{"CryptSetKeyParam", 0x00041A51, NULL, NULL},
	{"CryptSetProvParam", 0x000410F1, NULL, NULL},
	{"CryptSetProviderA", 0x00042161, NULL, NULL},
	{"CryptSetProviderExA", 0x00042329, NULL, NULL},
	{"CryptSetProviderExW", 0x00042CF1, NULL, NULL},
	{"CryptSetProviderW", 0x00042C61, NULL, NULL},
	{"CryptSignHashA", 0x00041FE1, NULL, NULL},
	{"CryptSignHashW", 0x00041FD1, NULL, NULL},
	{"CryptVerifySignatureA", 0x0002C841, NULL, NULL},
	{"CryptVerifySignatureW", 0x00023522, NULL, NULL},
	{"DecryptFileA", 0x00043741, NULL, NULL},
	{"DecryptFileW", 0x000433CF, NULL, NULL},
	{"DeleteAce", 0x0002D29A, NULL, NULL},
	{"DeleteService", 0x000674B1, NULL, NULL},
	{"DeregisterEventSource", 0x000279D3, NULL, NULL},
	{"DestroyPrivateObjectSecurity", 0x00014F0C, NULL, NULL},
	{"DuplicateEncryptionInfoFile", 0x000435EA, NULL, NULL},
	{"DuplicateToken", 0x00008211, NULL, NULL},
	{"DuplicateTokenEx", 0x0000819E, NULL, NULL},
	{"ElfBackupEventLogFileA", 0x00068AE1, NULL, NULL},
	{"ElfBackupEventLogFileW", 0x00068899, NULL, NULL},
	{"ElfChangeNotify", 0x00068726, NULL, NULL},
	{"ElfClearEventLogFileA", 0x00068A79, NULL, NULL},
	{"ElfClearEventLogFileW", 0x00068831, NULL, NULL},
	{"ElfCloseEventLog", 0x000254DE, NULL, NULL},
	{"ElfDeregisterEventSource", 0x000279F4, NULL, NULL},
	{"ElfFlushEventLog", 0x00068B81, NULL, NULL},
	{"ElfNumberOfRecords", 0x00025DAF, NULL, NULL},
	{"ElfOldestRecord", 0x00025E44, NULL, NULL},
	{"ElfOpenBackupEventLogA", 0x000689E1, NULL, NULL},
	{"ElfOpenBackupEventLogW", 0x00068799, NULL, NULL},
	{"ElfOpenEventLogA", 0x00025EF7, NULL, NULL},
	{"ElfOpenEventLogW", 0x000210CF, NULL, NULL},
	{"ElfReadEventLogA", 0x00025CD7, NULL, NULL},
	{"ElfReadEventLogW", 0x00068939, NULL, NULL},
	{"ElfRegisterEventSourceA", 0x00027BA7, NULL, NULL},
	{"ElfRegisterEventSourceW", 0x00028083, NULL, NULL},
	{"ElfReportEventA", 0x00027DD5, NULL, NULL},
	{"ElfReportEventW", 0x000237A5, NULL, NULL},
	{"EnableTrace", 0x0005A5D5, NULL, NULL},
	{"EncryptFileA", 0x000436AC, NULL, NULL},
	{"EncryptFileW", 0x00043390, NULL, NULL},
	{"EncryptedFileKeyInfo", 0x00043651, NULL, NULL},
	{"EncryptionDisable", 0x00043625, NULL, NULL},
	{"EnumDependentServicesA", 0x00067529, NULL, NULL},
	{"EnumDependentServicesW", 0x000675E1, NULL, NULL},
	{"EnumServiceGroupW", 0x00066A89, NULL, NULL},
	{"EnumServicesStatusA", 0x00026B47, NULL, NULL},
	{"EnumServicesStatusExA", 0x00066C2F, NULL, NULL},
	{"EnumServicesStatusExW", 0x000669B8, NULL, NULL},
	{"EnumServicesStatusW", 0x00067D61, NULL, NULL},
	{"EnumerateTraceGuids", 0x0005AE81, NULL, NULL},
	{"EqualDomainSid", 0x0003DF09, NULL, NULL},
	{"EqualPrefixSid", 0x0003D2E9, NULL, NULL},
	{"EqualSid", 0x0000F07A, NULL, NULL},
	{"FileEncryptionStatusA", 0x000437D9, NULL, NULL},
	{"FileEncryptionStatusW", 0x00043412, NULL, NULL},
	{"FindFirstFreeAce", 0x0003D4FC, NULL, NULL},
	{"FlushTraceA", 0x0005B0BB, NULL, NULL},
	{"FlushTraceW", 0x0005B0DC, NULL, NULL},
	{"FreeEncryptedFileKeyInfo", 0x0004368C, NULL, NULL},
	{"FreeEncryptionCertificateHashList", 0x000434ED, NULL, NULL},
	{"FreeInheritedFromArray", 0x000524B2, NULL, NULL},
	{"FreeSid", 0x00007CB8, NULL, NULL},
	{"GetAccessPermissionsForObjectA", 0x00053869, NULL, NULL},
	{"GetAccessPermissionsForObjectW", 0x00053781, NULL, NULL},
	{"GetAce", 0x00014C33, NULL, NULL},
	{"GetAclInformation", 0x00027E78, NULL, NULL},
	{"GetAuditedPermissionsFromAclA", 0x00051C5F, NULL, NULL},
	{"GetAuditedPermissionsFromAclW", 0x00051C0E, NULL, NULL},
	{"GetCurrentHwProfileA", 0x0003CA61, NULL, NULL},
	{"GetCurrentHwProfileW", 0x00020A75, NULL, NULL},
	{"GetEffectiveRightsFromAclA", 0x00051B97, NULL, NULL},
	{"GetEffectiveRightsFromAclW", 0x00051B37, NULL, NULL},
	{"GetEventLogInformation", 0x00020FE8, NULL, NULL},
	{"GetExplicitEntriesFromAclA", 0x00051C01, NULL, NULL},
	{"GetExplicitEntriesFromAclW", 0x00051BE3, NULL, NULL},
	{"GetFileSecurityA", 0x0003D723, NULL, NULL},
	{"GetFileSecurityW", 0x0002C003, NULL, NULL},
	{"GetInformationCodeAuthzLevelW", 0x0001FCF0, NULL, NULL},
	{"GetInformationCodeAuthzPolicyW", 0x000299DD, NULL, NULL},
	{"GetInheritanceSourceA", 0x000524A7, NULL, NULL},
	{"GetInheritanceSourceW", 0x0005246C, NULL, NULL},
	{"GetKernelObjectSecurity", 0x00014F65, NULL, NULL},
	{"GetLengthSid", 0x00007D5C, NULL, NULL},
	{"GetLocalManagedApplicationData", 0x0004D48B, NULL, NULL},
	{"GetLocalManagedApplications", 0x0004D25A, NULL, NULL},
	{"GetManagedApplicationCategories", 0x0004D767, NULL, NULL},
	{"GetManagedApplications", 0x0004D6AF, NULL, NULL},
	{"GetMultipleTrusteeA", 0x00052698, NULL, NULL},
	{"GetMultipleTrusteeOperationA", 0x0005267C, NULL, NULL},
	{"GetMultipleTrusteeOperationW", 0x0005267C, NULL, NULL},
	{"GetMultipleTrusteeW", 0x00052698, NULL, NULL},
	{"GetNamedSecurityInfoA", 0x000518E4, NULL, NULL},
	{"GetNamedSecurityInfoExA", 0x00052881, NULL, NULL},
	{"GetNamedSecurityInfoExW", 0x000526B3, NULL, NULL},
	{"GetNamedSecurityInfoW", 0x00014FE6, NULL, NULL},
	{"GetNumberOfEventLogRecords", 0x00025D8B, NULL, NULL},
	{"GetOldestEventLogRecord", 0x00025E20, NULL, NULL},
	{"GetOverlappedAccessResults", 0x000535F1, NULL, NULL},
	{"GetPrivateObjectSecurity", 0x0003D689, NULL, NULL},
	{"GetSecurityDescriptorControl", 0x00014BB9, NULL, NULL},
	{"GetSecurityDescriptorDacl", 0x000073E7, NULL, NULL},
	{"GetSecurityDescriptorGroup", 0x00014B87, NULL, NULL},
	{"GetSecurityDescriptorLength", 0x000074BB, NULL, NULL},
	{"GetSecurityDescriptorOwner", 0x00014B55, NULL, NULL},
	{"GetSecurityDescriptorRMControl", 0x0003DDE0, NULL, NULL},
	{"GetSecurityDescriptorSacl", 0x0003D52C, NULL, NULL},
	{"GetSecurityInfo", 0x00024E48, NULL, NULL},
	{"GetSecurityInfoExA", 0x00052C32, NULL, NULL},
	{"GetSecurityInfoExW", 0x00052A2F, NULL, NULL},
	{"GetServiceDisplayNameA", 0x00067699, NULL, NULL},
	{"GetServiceDisplayNameW", 0x00067739, NULL, NULL},
	{"GetServiceKeyNameA", 0x000677D9, NULL, NULL},
	{"GetServiceKeyNameW", 0x00067879, NULL, NULL},
	{"GetSidIdentifierAuthority", 0x0000F23B, NULL, NULL},
	{"GetSidLengthRequired", 0x00015569, NULL, NULL},
	{"GetSidSubAuthority", 0x00015550, NULL, NULL},
	{"GetSidSubAuthorityCount", 0x00015582, NULL, NULL},
	{"GetTokenInformation", 0x00007305, NULL, NULL},
	{"GetTraceEnableFlags", 0x0005AD86, NULL, NULL},
	{"GetTraceEnableLevel", 0x0005AD41, NULL, NULL},
	{"GetTraceLoggerHandle", 0x0005AC89, NULL, NULL},
	{"GetTrusteeFormA", 0x0005265F, NULL, NULL},
	{"GetTrusteeFormW", 0x0005265F, NULL, NULL},
	{"GetTrusteeNameA", 0x0005262F, NULL, NULL},
	{"GetTrusteeNameW", 0x0005262F, NULL, NULL},
	{"GetTrusteeTypeA", 0x00052643, NULL, NULL},
	{"GetTrusteeTypeW", 0x00052643, NULL, NULL},
	{"GetUserNameA", 0x000154C4, NULL, NULL},
	{"GetUserNameW", 0x0001496D, NULL, NULL},
	{"GetWindowsAccountDomainSid", 0x0003DE21, NULL, NULL},
	{"I_ScIsSecurityProcess", 0x000211E8, NULL, NULL},
	{"I_ScPnPGetServiceName", 0x00026EA0, NULL, NULL},
	{"I_ScSendTSMessage", 0x00024F2B, NULL, NULL},
	{"I_ScSetServiceBitsA", 0x00066B69, NULL, NULL},
	{"I_ScSetServiceBitsW", 0x0001E429, NULL, NULL},
	{"IdentifyCodeAuthzLevelW", 0x00009EC8, NULL, NULL},
	{"ImpersonateAnonymousToken", 0x00014C5B, NULL, NULL},
	{"ImpersonateLoggedOnUser", 0x0000DA49, NULL, NULL},
	{"ImpersonateNamedPipeClient", 0x00007426, NULL, NULL},
	{"ImpersonateSelf", 0x00014EE0, NULL, NULL},
	{"InitializeAcl", 0x00007D09, NULL, NULL},
	{"InitializeSecurityDescriptor", 0x000079C6, NULL, NULL},
	{"InitializeSid", 0x0001568B, NULL, NULL},
	{"InitiateSystemShutdownA", 0x00064D7F, NULL, NULL},
	{"InitiateSystemShutdownExA", 0x00064E1A, NULL, NULL},
	{"InitiateSystemShutdownExW", 0x00064CE5, NULL, NULL},
	{"InitiateSystemShutdownW", 0x00064C51, NULL, NULL},
	{"InstallApplication", 0x0004D7B7, NULL, NULL},
	{"IsTextUnicode", 0x0002BD35, NULL, NULL},
	{"IsTokenRestricted", 0x000148C9, NULL, NULL},
	{"IsTokenUntrusted", 0x0004EC9E, NULL, NULL},
	{"IsValidAcl", 0x00027F17, NULL, NULL},
	{"IsValidSecurityDescriptor", 0x00014C11, NULL, NULL},
	{"IsValidSid", 0x0000F219, NULL, NULL},
	{"IsWellKnownSid", 0x000278AB, NULL, NULL},
	{"LockServiceDatabase", 0x00067919, NULL, NULL},
	{"LogonUserA", 0x0004100E, NULL, NULL},
	{"LogonUserExA", 0x0004103B, NULL, NULL},
	{"LogonUserExExW", 0x0004012A, NULL, NULL},
	{"LogonUserExW", 0x000245A3, NULL, NULL},
	{"LogonUserW", 0x000400FD, NULL, NULL},
	{"LookupAccountNameA", 0x0003D78F, NULL, NULL},
	{"LookupAccountNameW", 0x00015B59, NULL, NULL},
	{"LookupAccountSidA", 0x0003D8EC, NULL, NULL},
	{"LookupAccountSidW", 0x00015707, NULL, NULL},
	{"LookupPrivilegeDisplayNameA", 0x0003E46C, NULL, NULL},
	{"LookupPrivilegeDisplayNameW", 0x0003DB6F, NULL, NULL},
	{"LookupPrivilegeNameA", 0x0003E34E, NULL, NULL},
	{"LookupPrivilegeNameW", 0x0003DA6B, NULL, NULL},
	{"LookupPrivilegeValueA", 0x0002C238, NULL, NULL},
	{"LookupPrivilegeValueW", 0x0002B8DF, NULL, NULL},
	{"LookupSecurityDescriptorPartsA", 0x00052180, NULL, NULL},
	{"LookupSecurityDescriptorPartsW", 0x00051FD1, NULL, NULL},
	{"LsaAddAccountRights", 0x0004ABF1, NULL, NULL},
	{"LsaAddPrivilegesToAccount", 0x0004BB09, NULL, NULL},
	{"LsaClearAuditLog", 0x0004B069, NULL, NULL},
	{"LsaClose", 0x00011EF4, NULL, NULL},
	{"LsaCreateAccount", 0x0004B431, NULL, NULL},
	{"LsaCreateSecret", 0x0004B991, NULL, NULL},
	{"LsaCreateTrustedDomain", 0x0004B539, NULL, NULL},
	{"LsaCreateTrustedDomainEx", 0x0004A1B1, NULL, NULL},
	{"LsaDelete", 0x0004B201, NULL, NULL},
	{"LsaDeleteTrustedDomain", 0x00049965, NULL, NULL},
	{"LsaEnumerateAccountRights", 0x000160AF, NULL, NULL},
	{"LsaEnumerateAccounts", 0x0004B4A1, NULL, NULL},
	{"LsaEnumerateAccountsWithUserRight", 0x0004AB39, NULL, NULL},
	{"LsaEnumeratePrivileges", 0x0004B8F9, NULL, NULL},
	{"LsaEnumeratePrivilegesOfAccount", 0x0004BA99, NULL, NULL},
	{"LsaEnumerateTrustedDomains", 0x0004B855, NULL, NULL},
	{"LsaEnumerateTrustedDomainsEx", 0x0004A10D, NULL, NULL},
	{"LsaFreeMemory", 0x00012DDE, NULL, NULL},
	{"LsaGetQuotasForAccount", 0x0004BBE9, NULL, NULL},
	{"LsaGetRemoteUserName", 0x0004C155, NULL, NULL},
	{"LsaGetSystemAccessAccount", 0x0004BCC9, NULL, NULL},
	{"LsaGetUserName", 0x0001E2D2, NULL, NULL},
	{"LsaICLookupNames", 0x00015D38, NULL, NULL},
	{"LsaICLookupNamesWithCreds", 0x0004C271, NULL, NULL},
	{"LsaICLookupSids", 0x000159C5, NULL, NULL},
	{"LsaICLookupSidsWithCreds", 0x0004C401, NULL, NULL},
	{"LsaLookupNames2", 0x00015CEE, NULL, NULL},
	{"LsaLookupNames", 0x0004C5E9, NULL, NULL},
	{"LsaLookupPrivilegeDisplayName", 0x0004B159, NULL, NULL},
	{"LsaLookupPrivilegeName", 0x0004B0D1, NULL, NULL},
	{"LsaLookupPrivilegeValue", 0x0002B97D, NULL, NULL},
	{"LsaLookupSids", 0x000158BB, NULL, NULL},
	{"LsaNtStatusToWinError", 0x0001E01B, NULL, NULL},
	{"LsaOpenAccount", 0x0004BA29, NULL, NULL},
	{"LsaOpenPolicy", 0x00011E27, NULL, NULL},
	{"LsaOpenPolicySce", 0x0004AEA0, NULL, NULL},
	{"LsaOpenSecret", 0x0004BDB9, NULL, NULL},
	{"LsaOpenTrustedDomain", 0x0004B5B1, NULL, NULL},
	{"LsaOpenTrustedDomainByName", 0x0004A3C1, NULL, NULL},
	{"LsaQueryDomainInformationPolicy", 0x0004A2C5, NULL, NULL},
	{"LsaQueryForestTrustInformation", 0x0004A431, NULL, NULL},
	{"LsaQueryInfoTrustedDomain", 0x0004B621, NULL, NULL},
	{"LsaQueryInformationPolicy", 0x00012E07, NULL, NULL},
	{"LsaQuerySecret", 0x0004BF8D, NULL, NULL},
	{"LsaQuerySecurityObject", 0x0004B2CD, NULL, NULL},
	{"LsaQueryTrustedDomainInfo", 0x00049528, NULL, NULL},
	{"LsaQueryTrustedDomainInfoByName", 0x00049CE7, NULL, NULL},
	{"LsaRemoveAccountRights", 0x0004AC91, NULL, NULL},
	{"LsaRemovePrivilegesFromAccount", 0x0004BB79, NULL, NULL},
	{"LsaRetrievePrivateData", 0x0001DE9E, NULL, NULL},
	{"LsaSetDomainInformationPolicy", 0x0004A341, NULL, NULL},
	{"LsaSetForestTrustInformation", 0x0004A4A1, NULL, NULL},
	{"LsaSetInformationPolicy", 0x0004AFA9, NULL, NULL},
	{"LsaSetInformationTrustedDomain", 0x0004B6C1, NULL, NULL},
	{"LsaSetQuotasForAccount", 0x0004BC59, NULL, NULL},
	{"LsaSetSecret", 0x0004BE29, NULL, NULL},
	{"LsaSetSecurityObject", 0x0004B359, NULL, NULL},
	{"LsaSetSystemAccessAccount", 0x0004BD41, NULL, NULL},
	{"LsaSetTrustedDomainInfoByName", 0x00049F92, NULL, NULL},
	{"LsaSetTrustedDomainInformation", 0x00049795, NULL, NULL},
	{"LsaStorePrivateData", 0x0002D03F, NULL, NULL},
	{"MD4Final", 0x0000879F, NULL, NULL},
	{"MD4Init", 0x0000876B, NULL, NULL},
	{"MD4Update", 0x00008D04, NULL, NULL},
	{"MD5Final", 0x000170B2, NULL, NULL},
	{"MD5Init", 0x00017078, NULL, NULL},
	{"MD5Update", 0x00017152, NULL, NULL},
	{"MSChapSrvChangePassword2", 0x000457E7, NULL, NULL},
	{"MSChapSrvChangePassword", 0x00045603, NULL, NULL},
	{"MakeAbsoluteSD2", 0x0003DDB5, NULL, NULL},
	{"MakeAbsoluteSD", 0x00027ED1, NULL, NULL},
	{"MakeSelfRelativeSD", 0x0000745E, NULL, NULL},
	{"MapGenericMask", 0x0001484B, NULL, NULL},
	{"NotifyBootConfigStatus", 0x00020F79, NULL, NULL},
	{"NotifyChangeEventLog", 0x0003C23B, NULL, NULL},
	{"ObjectCloseAuditAlarmA", 0x0003E21C, NULL, NULL},
	{"ObjectCloseAuditAlarmW", 0x00014813, NULL, NULL},
	{"ObjectDeleteAuditAlarmA", 0x0003E270, NULL, NULL},
	{"ObjectDeleteAuditAlarmW", 0x0003D258, NULL, NULL},
	{"ObjectOpenAuditAlarmA", 0x0003E0D6, NULL, NULL},
	{"ObjectOpenAuditAlarmW", 0x0001485C, NULL, NULL},
	{"ObjectPrivilegeAuditAlarmA", 0x0003E1BF, NULL, NULL},
	{"ObjectPrivilegeAuditAlarmW", 0x0003D211, NULL, NULL},
	{"OpenBackupEventLogA", 0x0003C949, NULL, NULL},
	{"OpenBackupEventLogW", 0x0003C490, NULL, NULL},
	{"OpenEncryptedFileRawA", 0x00043874, NULL, NULL},
	{"OpenEncryptedFileRawW", 0x0004343E, NULL, NULL},
	{"OpenEventLogA", 0x00025EB0, NULL, NULL},
	{"OpenEventLogW", 0x00021088, NULL, NULL},
	{"OpenProcessToken", 0x0000798B, NULL, NULL},
	{"OpenSCManagerA", 0x000269AE, NULL, NULL},
	{"OpenSCManagerW", 0x00016F55, NULL, NULL},
	{"OpenServiceA", 0x00024C66, NULL, NULL},
	{"OpenServiceW", 0x00016FFD, NULL, NULL},
	{"OpenThreadToken", 0x000072CC, NULL, NULL},
	{"OpenTraceA", 0x0005853A, NULL, NULL},
	{"OpenTraceW", 0x00058651, NULL, NULL},
	{"PrivilegeCheck", 0x0002BAB4, NULL, NULL},
	{"PrivilegedServiceAuditAlarmA", 0x0003E2C4, NULL, NULL},
	{"PrivilegedServiceAuditAlarmW", 0x0003D296, NULL, NULL},
	{"ProcessIdleTasks", 0x00046F19, NULL, NULL},
	{"ProcessTrace", 0x00058E84, NULL, NULL},
	{"QueryAllTracesA", 0x0005AB39, NULL, NULL},
	{"QueryAllTracesW", 0x0002CBF1, NULL, NULL},
	{"QueryRecoveryAgentsOnEncryptedFile", 0x0004350D, NULL, NULL},
	{"QueryServiceConfig2A", 0x00067999, NULL, NULL},
	{"QueryServiceConfig2W", 0x00067AB1, NULL, NULL},
	{"QueryServiceConfigA", 0x00021596, NULL, NULL},
	{"QueryServiceConfigW", 0x00026F92, NULL, NULL},
	{"QueryServiceLockStatusA", 0x00067BC9, NULL, NULL},
	{"QueryServiceLockStatusW", 0x00067C59, NULL, NULL},
	{"QueryServiceObjectSecurity", 0x00066D01, NULL, NULL},
	{"QueryServiceStatus", 0x00016D50, NULL, NULL},
	{"QueryServiceStatusEx", 0x0002120A, NULL, NULL},
	{"QueryTraceA", 0x0005AFF5, NULL, NULL},
	{"QueryTraceW", 0x0005B016, NULL, NULL},
	{"QueryUsersOnEncryptedFile", 0x000434B2, NULL, NULL},
	{"QueryWindows31FilesMigration", 0x00021B21, NULL, NULL},
	{"ReadEncryptedFileRaw", 0x00043470, NULL, NULL},
	{"ReadEventLogA", 0x00025C9C, NULL, NULL},
	{"ReadEventLogW", 0x0003C823, NULL, NULL},
	{"RegCloseKey", 0x00006C27, NULL, NULL},
	{"RegConnectRegistryA", 0x0006512A, NULL, NULL},
	{"RegConnectRegistryW", 0x0002817A, NULL, NULL},
	{"RegCreateKeyA", 0x0002BCF3, NULL, NULL},
	{"RegCreateKeyExA", 0x0000E9F4, NULL, NULL},
	{"RegCreateKeyExW", 0x0000776C, NULL, NULL},
	{"RegCreateKeyW", 0x0002BA55, NULL, NULL},
	{"RegDeleteKeyA", 0x000142A0, NULL, NULL},
	{"RegDeleteKeyW", 0x0001559B, NULL, NULL},
	{"RegDeleteValueA", 0x0000ECE5, NULL, NULL},
	{"RegDeleteValueW", 0x0000EDF1, NULL, NULL},
	{"RegDisablePredefinedCache", 0x0002837B, NULL, NULL},
	{"RegDisablePredefinedCacheEx", 0x00064F7D, NULL, NULL},
	{"RegEnumKeyA", 0x000153B8, NULL, NULL},
	{"RegEnumKeyExA", 0x000151B6, NULL, NULL},
	{"RegEnumKeyExW", 0x00007BD9, NULL, NULL},
	{"RegEnumKeyW", 0x0000D5E4, NULL, NULL},
	{"RegEnumValueA", 0x00029BBF, NULL, NULL},
	{"RegEnumValueW", 0x00007EED, NULL, NULL},
	{"RegFlushKey", 0x00024CE0, NULL, NULL},
	{"RegGetKeySecurity", 0x00023918, NULL, NULL},
	{"RegLoadKeyA", 0x00065183, NULL, NULL},
	{"RegLoadKeyW", 0x00020D86, NULL, NULL},
	{"RegNotifyChangeKeyValue", 0x0000D8FE, NULL, NULL},
	{"RegOpenCurrentUser", 0x0000811B, NULL, NULL},
	{"RegOpenKeyA", 0x0000EFC8, env_w32_hook_RegOpenKeyA, NULL}, // Modified by T.OkamotoLab.
	{"RegOpenKeyExA", 0x00007852, NULL, NULL},
	{"RegOpenKeyExW", 0x00006AAF, NULL, NULL},
	{"RegOpenKeyW", 0x00007946, NULL, NULL},
	{"RegOpenUserClassesRoot", 0x0002B461, NULL, NULL},
	{"RegOverridePredefKey", 0x00064F14, NULL, NULL},
	{"RegQueryInfoKeyA", 0x00014332, NULL, NULL},
	{"RegQueryInfoKeyW", 0x000149CE, NULL, NULL},
	{"RegQueryMultipleValuesA", 0x0006568F, NULL, NULL},
	{"RegQueryMultipleValuesW", 0x000659F1, NULL, NULL},
	{"RegQueryValueA", 0x0002BB8D, NULL, NULL},
	{"RegQueryValueExA", 0x00007ABB, NULL, NULL},
	{"RegQueryValueExW", 0x00006FFF, NULL, NULL},
	{"RegQueryValueW", 0x0000D87A, NULL, NULL},
	{"RegReplaceKeyA", 0x000653F7, NULL, NULL},
	{"RegReplaceKeyW", 0x000655C0, NULL, NULL},
	{"RegRestoreKeyA", 0x00065C4D, NULL, NULL},
	{"RegRestoreKeyW", 0x00065CFE, NULL, NULL},
	{"RegSaveKeyA", 0x00065D92, NULL, NULL},
	{"RegSaveKeyExA", 0x00065F51, NULL, NULL},
	{"RegSaveKeyExW", 0x00066046, NULL, NULL},
	{"RegSaveKeyW", 0x00065E84, NULL, NULL},
	{"RegSetKeySecurity", 0x00023AFD, NULL, NULL},
	{"RegSetValueA", 0x0002C79E, NULL, NULL},
	{"RegSetValueExA", 0x0000EAE7, env_w32_hook_RegSetValueExA, NULL}, // Modified by T.OkamotoLab.
	{"RegSetValueExW", 0x0000D767, NULL, NULL},
	{"RegSetValueW", 0x00066116, NULL, NULL},
	{"RegUnLoadKeyA", 0x000652C5, NULL, NULL},
	{"RegUnLoadKeyW", 0x00065366, NULL, NULL},
	{"RegisterEventSourceA", 0x00027B60, NULL, NULL},
	{"RegisterEventSourceW", 0x0002803C, NULL, NULL},
	{"RegisterIdleTask", 0x000208D2, NULL, NULL},
	{"RegisterServiceCtrlHandlerA", 0x00024EC6, NULL, NULL},
	{"RegisterServiceCtrlHandlerExA", 0x0001FEAB, NULL, NULL},
	{"RegisterServiceCtrlHandlerExW", 0x00023E49, NULL, NULL},
	{"RegisterServiceCtrlHandlerW", 0x00023E77, NULL, NULL},
	{"RegisterTraceGuidsA", 0x000295A1, NULL, NULL},
	{"RegisterTraceGuidsW", 0x00029289, NULL, NULL},
	{"RemoveTraceCallback", 0x00056331, NULL, NULL},
	{"RemoveUsersFromEncryptedFile", 0x00043548, NULL, NULL},
	{"ReportEventA", 0x00027CB2, NULL, NULL},
	{"ReportEventW", 0x00023681, NULL, NULL},
	{"RevertToSelf", 0x00007338, NULL, NULL},
	{"SaferCloseLevel", 0x0000AF98, NULL, NULL},
	{"SaferComputeTokenFromLevel", 0x0000AB3D, NULL, NULL},
	{"SaferCreateLevel", 0x0004E9C5, NULL, NULL},
	{"SaferGetLevelInformation", 0x0001FCF0, NULL, NULL},
	{"SaferGetPolicyInformation", 0x000299DD, NULL, NULL},
	{"SaferIdentifyLevel", 0x00009EC8, NULL, NULL},
	{"SaferRecordEventLogEntry", 0x0004F78D, NULL, NULL},
	{"SaferSetLevelInformation", 0x0005054D, NULL, NULL},
	{"SaferSetPolicyInformation", 0x0004F3E0, NULL, NULL},
	{"SaferiChangeRegistryScope", 0x00050985, NULL, NULL},
	{"SaferiCompareTokenLevels", 0x000268C3, NULL, NULL},
	{"SaferiIsExecutableFileType", 0x000298AB, NULL, NULL},
	{"SaferiPopulateDefaultsInRegistry", 0x0001EF84, NULL, NULL},
	{"SaferiRecordEventLogEntry", 0x0004F78D, NULL, NULL},
	{"SaferiReplaceProcessThreadTokens", 0x000405AA, NULL, NULL},
	{"SaferiSearchMatchingHashRules", 0x0002C8B1, NULL, NULL},
	{"SetAclInformation", 0x0003D30E, NULL, NULL},
	{"SetEntriesInAccessListA", 0x000532D4, NULL, NULL},
	{"SetEntriesInAccessListW", 0x0005329B, NULL, NULL},
	{"SetEntriesInAclA", 0x00051979, NULL, NULL},
	{"SetEntriesInAclW", 0x00014EC2, NULL, NULL},
	{"SetEntriesInAuditListA", 0x00053334, NULL, NULL},
	{"SetEntriesInAuditListW", 0x0005330D, NULL, NULL},
	{"SetFileSecurityA", 0x0003D6BD, NULL, NULL},
	{"SetFileSecurityW", 0x0001A3E1, NULL, NULL},
	{"SetInformationCodeAuthzLevelW", 0x0005054D, NULL, NULL},
	{"SetInformationCodeAuthzPolicyW", 0x0004F3E0, NULL, NULL},
	{"SetKernelObjectSecurity", 0x00014E9A, NULL, NULL},
	{"SetNamedSecurityInfoA", 0x00051930, NULL, NULL},
	{"SetNamedSecurityInfoExA", 0x00053B99, NULL, NULL},
	{"SetNamedSecurityInfoExW", 0x0005399E, NULL, NULL},
	{"SetNamedSecurityInfoW", 0x00020CF5, NULL, NULL},
	{"SetPrivateObjectSecurity", 0x0003D61E, NULL, NULL},
	{"SetPrivateObjectSecurityEx", 0x0003D652, NULL, NULL},
	{"SetSecurityDescriptorControl", 0x0001E531, NULL, NULL},
	{"SetSecurityDescriptorDacl", 0x000079EB, NULL, NULL},
	{"SetSecurityDescriptorGroup", 0x00014B2D, NULL, NULL},
	{"SetSecurityDescriptorOwner", 0x00014B05, NULL, NULL},
	{"SetSecurityDescriptorRMControl", 0x0003DE05, NULL, NULL},
	{"SetSecurityDescriptorSacl", 0x00024E8E, NULL, NULL},
	{"SetSecurityInfo", 0x00024DF2, NULL, NULL},
	{"SetSecurityInfoExA", 0x00054059, NULL, NULL},
	{"SetSecurityInfoExW", 0x00053E51, NULL, NULL},
	{"SetServiceBits", 0x00066BF9, NULL, NULL},
	{"SetServiceObjectSecurity", 0x00066D81, NULL, NULL},
	{"SetServiceStatus", 0x00023251, NULL, NULL},
	{"SetThreadToken", 0x0000F193, NULL, NULL},
	{"SetTokenInformation", 0x0003CBCF, NULL, NULL},
	{"SetTraceCallback", 0x000561B4, NULL, NULL},
	{"SetUserFileEncryptionKey", 0x000435BE, NULL, NULL},
	{"StartServiceA", 0x0001FB58, NULL, NULL},
	{"StartServiceCtrlDispatcherA", 0x00067F09, NULL, NULL},
	{"StartServiceCtrlDispatcherW", 0x0002359D, NULL, NULL},
	{"StartServiceW", 0x00023E94, NULL, NULL},
	{"StartTraceA", 0x000594FB, NULL, NULL},
	{"StartTraceW", 0x00059A61, NULL, NULL},
	{"StopTraceA", 0x0005B037, NULL, NULL},
	{"StopTraceW", 0x0005B058, NULL, NULL},
	{"SynchronizeWindows31FilesAndWindowsNTRegistry", 0x0003EEB9, NULL, NULL},
	{"SystemFunction001", 0x0001D7BA, NULL, NULL},
	{"SystemFunction002", 0x0001CF65, NULL, NULL},
	{"SystemFunction003", 0x00025416, NULL, NULL},
	{"SystemFunction004", 0x0001D917, NULL, NULL},
	{"SystemFunction005", 0x0001DC9F, NULL, NULL},
	{"SystemFunction006", 0x00025387, NULL, NULL},
	{"SystemFunction007", 0x000252AE, NULL, NULL},
	{"SystemFunction008", 0x0002554D, NULL, NULL},
	{"SystemFunction009", 0x00025540, NULL, NULL},
	{"SystemFunction010", 0x000255FC, NULL, NULL},
	{"SystemFunction011", 0x000255EF, NULL, NULL},
	{"SystemFunction012", 0x00047091, NULL, NULL},
	{"SystemFunction013", 0x000470CB, NULL, NULL},
	{"SystemFunction014", 0x00047105, NULL, NULL},
	{"SystemFunction015", 0x00047112, NULL, NULL},
	{"SystemFunction016", 0x0004711F, NULL, NULL},
	{"SystemFunction017", 0x00047155, NULL, NULL},
	{"SystemFunction018", 0x0004718B, NULL, NULL},
	{"SystemFunction019", 0x00047198, NULL, NULL},
	{"SystemFunction020", 0x00047105, NULL, NULL},
	{"SystemFunction021", 0x00047112, NULL, NULL},
	{"SystemFunction022", 0x00047105, NULL, NULL},
	{"SystemFunction023", 0x00047112, NULL, NULL},
	{"SystemFunction024", 0x000471A5, NULL, NULL},
	{"SystemFunction025", 0x00024BD4, NULL, NULL},
	{"SystemFunction026", 0x000471FD, NULL, NULL},
	{"SystemFunction027", 0x00024BC7, NULL, NULL},
	{"SystemFunction028", 0x0001DD8D, NULL, NULL},
	{"SystemFunction029", 0x0001DB2C, NULL, NULL},
	{"SystemFunction030", 0x00024BA5, NULL, NULL},
	{"SystemFunction031", 0x00024BA5, NULL, NULL},
	{"SystemFunction032", 0x0004720A, NULL, NULL},
	{"SystemFunction033", 0x0004720A, NULL, NULL},
	{"SystemFunction034", 0x0001DDC6, NULL, NULL},
	{"SystemFunction035", 0x00018185, NULL, NULL},
	{"SystemFunction036", 0x000082A2, NULL, NULL},
	{"SystemFunction040", 0x00027014, NULL, NULL},
	{"SystemFunction041", 0x0001E4D2, NULL, NULL},
	{"TraceEvent", 0x0005A901, NULL, NULL},
	{"TraceEventInstance", 0x0005AA01, NULL, NULL},
	{"TraceMessage", 0x0005B355, NULL, NULL},
	{"TraceMessageVa", 0x0005B3E9, NULL, NULL},
	{"TreeResetNamedSecurityInfoA", 0x00052461, NULL, NULL},
	{"TreeResetNamedSecurityInfoW", 0x000523DF, NULL, NULL},
	{"TrusteeAccessToObjectA", 0x00053439, NULL, NULL},
	{"TrusteeAccessToObjectW", 0x0005335B, NULL, NULL},
	{"UninstallApplication", 0x0004D20C, NULL, NULL},
	{"UnlockServiceDatabase", 0x00067CE9, NULL, NULL},
	{"UnregisterIdleTask", 0x00046FA9, NULL, NULL},
	{"UnregisterTraceGuids", 0x000256DD, NULL, NULL},
	{"UpdateTraceA", 0x0005B079, NULL, NULL},
	{"UpdateTraceW", 0x0005B09A, NULL, NULL},
	{"WdmWmiServiceMain", 0x0005B4DA, NULL, NULL},
	{"WmiCloseBlock", 0x0001FE04, NULL, NULL},
	{"WmiCloseTraceWithCursor", 0x00057871, NULL, NULL},
	{"WmiConvertTimestamp", 0x000578BE, NULL, NULL},
	{"WmiDevInstToInstanceNameA", 0x0005C681, NULL, NULL},
	{"WmiDevInstToInstanceNameW", 0x0005C73D, NULL, NULL},
	{"WmiEnumerateGuids", 0x0005C4C9, NULL, NULL},
	{"WmiExecuteMethodA", 0x0005CA62, NULL, NULL},
	{"WmiExecuteMethodW", 0x0005BFB5, NULL, NULL},
	{"WmiFileHandleToInstanceNameA", 0x0005CAD6, NULL, NULL},
	{"WmiFileHandleToInstanceNameW", 0x0005C2F5, NULL, NULL},
	{"WmiFreeBuffer", 0x000283E3, NULL, NULL},
	{"WmiGetFirstTraceOffset", 0x00056E4A, NULL, NULL},
	{"WmiGetNextEvent", 0x000578E0, NULL, NULL},
	{"WmiGetTraceHeader", 0x00056FB2, NULL, NULL},
	{"WmiMofEnumerateResourcesA", 0x0005CCFC, NULL, NULL},
	{"WmiMofEnumerateResourcesW", 0x0001EC89, NULL, NULL},
	{"WmiNotificationRegistrationA", 0x0005C2CD, NULL, NULL},
	{"WmiNotificationRegistrationW", 0x00028CAC, NULL, NULL},
	{"WmiOpenBlock", 0x00028E63, NULL, NULL},
	{"WmiOpenTraceWithCursor", 0x000589F8, NULL, NULL},
	{"WmiParseTraceEvent", 0x00058818, NULL, NULL},
	{"WmiQueryAllDataA", 0x0005C8A8, NULL, NULL},
	{"WmiQueryAllDataMultipleA", 0x0005C8D0, NULL, NULL},
	{"WmiQueryAllDataMultipleW", 0x0005B55D, NULL, NULL},
	{"WmiQueryAllDataW", 0x0001502C, NULL, NULL},
	{"WmiQueryGuidInformation", 0x0005C7D5, NULL, NULL},
	{"WmiQuerySingleInstanceA", 0x0005C910, NULL, NULL},
	{"WmiQuerySingleInstanceMultipleA", 0x0005BB4D, NULL, NULL},
	{"WmiQuerySingleInstanceMultipleW", 0x0005B985, NULL, NULL},
	{"WmiQuerySingleInstanceW", 0x0005B705, NULL, NULL},
	{"WmiReceiveNotificationsA", 0x0005C881, NULL, NULL},
	{"WmiReceiveNotificationsW", 0x0001FEEA, NULL, NULL},
	{"WmiSetSingleInstanceA", 0x0005C997, NULL, NULL},
	{"WmiSetSingleInstanceW", 0x0005BC77, NULL, NULL},
	{"WmiSetSingleItemA", 0x0005C9FB, NULL, NULL},
	{"WmiSetSingleItemW", 0x0005BE15, NULL, NULL},
	{"Wow64Win32ApiEntry", 0x00068423, NULL, NULL},
	{"WriteEncryptedFileRaw", 0x00043486, NULL, NULL},
	{0,0,NULL},
};

struct emu_env_w32_dll_export shdocvw_exports[] = 
{
	{"AddUrlToFavorites", 0x00044715, NULL, NULL},
	{"DllCanUnloadNow", 0x0002200A, NULL, NULL},
	{"DllGetClassObject", 0x0001531D, NULL, NULL},
	{"DllGetVersion", 0x000CEE32, NULL, NULL},
	{"DllInstall", 0x00056EB8, NULL, NULL},
	{"DllRegisterServer", 0x00056E67, NULL, NULL},
	{"DllRegisterWindowClasses", 0x00097C49, NULL, NULL},
	{"DllUnregisterServer", 0x00056EA6, NULL, NULL},
	{"DoAddToFavDlg", 0x00044580, NULL, NULL},
	{"DoAddToFavDlgW", 0x000445CF, NULL, NULL},
	{"DoFileDownload", 0x000443E5, NULL, NULL},
	{"DoFileDownloadEx", 0x00044434, NULL, NULL},
	{"DoOrganizeFavDlg", 0x00044620, NULL, NULL},
	{"DoOrganizeFavDlgW", 0x00044672, NULL, NULL},
	{"DoPrivacyDlg", 0x00044767, NULL, NULL},
	{"HlinkFindFrame", 0x0004452F, NULL, NULL},
	{"HlinkFrameNavigate", 0x00044486, NULL, NULL},
	{"HlinkFrameNavigateNHL", 0x000444D8, NULL, NULL},
	{"IEWriteErrorLog", 0x000446C3, NULL, NULL},
	{"ImportPrivacySettings", 0x0004480E, NULL, NULL},
	{"SHAddSubscribeFavorite", 0x00044AFA, NULL, NULL},
	{"OpenURL", 0x000442AD, NULL, NULL},
	{"SHGetIDispatchForFolder", 0x000BAA6A, NULL, NULL},
	{"SetQueryNetSessionCount", 0x00044863, NULL, NULL},
	{"SetShellOfflineState", 0x000B98F7, NULL, NULL},
	{"SoftwareUpdateMessageBox", 0x000447B6, NULL, NULL},
	{"URLQualifyA", 0x00044216, NULL, NULL},
	{"URLQualifyW", 0x00044261, NULL, NULL},
	{"IEWinMain", 0x00044262, env_w32_hook_IEWinMain, NULL, NULL, 101},
	{0,0,NULL},
};

// Added by T.OkamotoLab.
struct emu_env_w32_dll_export ole32_exports[] = 
{
	{"BindMoniker", 0x0009CAC6, NULL, NULL},
	{"CLIPFORMAT_UserFree", 0x00052D3C, NULL, NULL},
	{"CLIPFORMAT_UserMarshal", 0x000678AF, NULL, NULL},
	{"CLIPFORMAT_UserSize", 0x00067839, NULL, NULL},
	{"CLIPFORMAT_UserUnmarshal", 0x00067BD8, NULL, NULL},
	{"CLSIDFromOle1Class", 0x000388B9, NULL, NULL},
	{"CLSIDFromProgID", 0x000387F2, NULL, NULL},
	{"CLSIDFromProgIDEx",0x0007620D, NULL, NULL},
	{"CLSIDFromString", 0x0004FCB6, NULL, NULL},
	{"CoAddRefServerProcess", 0x000B682F, NULL, NULL},
	{"CoAllowSetForegroundWindow", 0x000A4D50, NULL, NULL},
	{"CoCancelCall", 0x000A5508, NULL, NULL},
	{"CoCopyProxy",	0x0003E3FE, NULL, NULL},
	{"CoCreateFreeThreadedMarshaler", 0x0003555A, NULL, NULL},
	{"CoCreateGuid", 0x0001EF31, NULL, NULL},
	{"CoCreateInstance", 0x0002057E, env_w32_hook_CoCreateInstance, NULL},
	{"CoCreateInstanceEx", 0x00020526, NULL, NULL},
	{"CoCreateObjectInContext", 0x000A9EB2,	 NULL, NULL},
	{"CoDeactivateObject",0x000A4C45, NULL,	 NULL},
	{"CoDisableCallCancellation",0x000A55C8, NULL, NULL},
	{"CoDisconnectObject",0x0004F9BE,NULL, NULL},
	{"CoDosDateTimeToFileTime",0x000BB7AB, NULL, NULL},
	{"CoEnableCallCancellation",0x000A5581, NULL, NULL},
	{"CoFileTimeNow",0x00052A78,NULL, NULL},
	{"CoFileTimeToDosDateTime",0x000BB72F, NULL, NULL},
	{"CoFreeAllLibraries",0x00023507, NULL, NULL},
	{"CoFreeLibrary",0x000B6959, NULL, NULL},
	{"CoFreeUnusedLibraries",0x000500AC, NULL, NULL},
	{"CoFreeUnusedLibrariesEx",0x0005025D, NULL, NULL},
	{"CoGetApartmentID",0x000AB7FB, NULL, NULL},
	{"CoGetCallContext",0x00035621, NULL, NULL},
	{"CoGetCallerTID",0x000A2438, NULL,NULL},
	{"CoGetCancelObject",0x000A5472, NULL, NULL},
	{"CoGetClassObject",0x000356C5,	NULL, NULL},
	{"CoGetClassVersion",0x000A24A6, NULL, NULL},
	{"CoGetComCatalog",0x00033090, NULL, NULL},
	{"CoGetContextToken",0x000A4E24, NULL, NULL},
	{"CoGetCurrentLogicalThreadId",0x000A246F, NULL, NULL},
	{"CoGetCurrentProcess",	0x0005464F, NULL, NULL},
	{"CoGetDefaultContext",	0x000A4EA9, NULL, NULL},
	{"CoGetInstanceFromFile",0x000601EA, NULL, NULL},
	{"CoGetInstanceFromIStorage",0x000B6914, NULL, NULL},
	{"CoGetInterceptor",0x000C0824,	NULL, NULL},
	{"CoGetInterceptorFromTypeInfo",0x0004179C,NULL, NULL},
	{"CoGetInterfaceAndReleaseStream",0x00076DD6, NULL, NULL},
	{"CoGetMalloc",	0x0001DD08, NULL, NULL},
	{"CoGetMarshalSizeMax",	0x0004D6C0, NULL, NULL},
	{"CoGetObject",	0x00045106, NULL, NULL},
	{"CoGetObjectContext",0x0004F61B, NULL,	NULL},
	{"CoGetProcessIdentifier",0x000A4DF9, NULL, NULL},
	{"CoGetPSClsid",0x000397F0, NULL, NULL},
	{"CoGetStandardMarshal",0x000547D4, NULL, NULL},
	{"CoGetState",0x000A2FD4, NULL, NULL},
	{"CoGetStdMarshalEx",0x000A49C1, NULL, NULL},
	{"CoGetSystemSecurityPermissions",0x000A4E5B, NULL,NULL},
	{"CoGetTreatAsClass",0x000314E1, NULL, NULL},
	{"CoImpersonateClient",0x0003566F, NULL, NULL},
	{"CoInitialize",0x00022A53,env_w32_hook_CoInitialize, NULL},
	{"CoInitializeEx",0x0001EF7B, env_w32_hook_CoInitializeEx, NULL},
	{"CoInitializeSecurity",0x00036B9E, NULL, NULL},
	{"CoInitializeWOW",0x0009992E, NULL, NULL},
	{"CoInstall",0x000B69DE, NULL, NULL},
	{"CoInvalidateRemoteMachineBindings",0x000A4DB1, NULL, NULL},
	{"CoIsHandlerConnected",0x000625AE, NULL,NULL},
	{"CoIsOle1Class",0x000750CD, NULL, NULL},
	{"CoLoadLibrary",0x000B693E, NULL, NULL},
	{"CoLockObjectExternal",0x00053CE4, NULL, NULL},
	{"CoMarshalHresult",0x000A2413, NULL, NULL},
	{"CoMarshalInterface",0x0002EA71, NULL, NULL},
	{"CoMarshalInterThreadInterfaceInStream",0x00076EC6, NULL, NULL},
	{"ComPs_CStdStubBuffer_AddRef",	0x000C0C10, NULL, NULL},
	{"ComPs_CStdStubBuffer_Connect",0x000C0CD5, NULL, NULL},
	{"ComPs_CStdStubBuffer_CountRefs",0x000C0C81, NULL, NULL},
	{"ComPs_CStdStubBuffer_DebugServerQueryI",0x000C0C9B, NULL, NULL},
	{"ComPs_CStdStubBuffer_DebugServerReleas",0x000C0CB8, NULL, NULL},
	{"ComPs_CStdStubBuffer_Disconnect",0x000C0CF2, NULL, NULL},
	{"ComPs_CStdStubBuffer_Invoke",	0x000C0C44, NULL, NULL},
	{"ComPs_CStdStubBuffer_IsIIDSupported",	0x000C0C64, NULL, NULL},
	{"ComPs_CStdStubBuffer_QueryInterface",	0x000C0BF1, NULL, NULL},
	{"ComPs_IUnknown_AddRef_Proxy",	0x000C0FDC, NULL, NULL},
	{"ComPs_IUnknown_QueryInterface_Proxy",	0x000C0FBD, NULL, NULL},
	{"ComPs_IUnknown_Release_Proxy",0x000C0FF6, NULL, NULL},
	{"ComPs_NdrClientCall2",0x000C5155, NULL, NULL},
	{"ComPs_NdrClientCall2_va",0x000C4CAD, NULL, NULL},
	{"ComPs_NdrCStdStubBuffer_Release",0x000C0C2A, NULL, NULL},
	{"ComPs_NdrDllGetClassObject",0x000C5917, NULL, NULL},
	{"ComPs_NdrDllRegisterProxy",0x000C6637, NULL, NULL},
	{"ComPs_NdrDllUnregisterProxy",	0x000C665B, NULL, NULL},
	{"ComPs_NdrStubCall2",0x000C66BF, NULL,	NULL},
	{"ComPs_NdrStubForwardingFunction",0x000C0D0C, NULL, NULL},
	{"CoPopServiceDomain",0x000ACC31, NULL,	NULL},
	{"CoPushServiceDomain",	0x000ACBF6, NULL, NULL},
	{"CoQueryAuthenticationServices",0x000A5C4D, NULL, NULL},
	{"CoQueryClientBlanket",0x00047494, NULL, NULL},
	{"CoQueryProxyBlanket",	0x00040082, NULL, NULL},
	{"CoQueryReleaseObject",0x000A3029, NULL, NULL},
	{"CoReactivateObject",0x000A4CD8, NULL,	NULL},
	{"CoRegisterChannelHook",0x000368D0, NULL, NULL},
	{"CoRegisterClassObject",0x00037E90, NULL, NULL},
	{"CoRegisterInitializeSpy",0x000A2DB4, NULL, NULL},
	{"CoRegisterMallocSpy",	0x000A323F, NULL, NULL},
	{"CoRegisterMessageFilter",0x00075F1F, NULL, NULL},
	{"CoRegisterPSClsid",0x000ACB52, NULL, NULL},
	{"CoRegisterSurrogate",	0x000B6843, NULL, NULL},
	{"CoRegisterSurrogateEx",0x000AE70C, NULL, NULL},
	{"CoReleaseMarshalData",0x0002DF23, NULL, NULL},
	{"CoReleaseServerProcess",0x000B6839, NULL, NULL},
	{"CoResumeClassObjects",0x00046D50, NULL, NULL},
	{"CoRetireServer",0x000A4DD5, NULL, NULL},
	{"CoRevertToSelf",0x0003F845, NULL, NULL},
	{"CoRevokeClassObject",	0x0004A2F3, NULL, NULL},
	{"CoRevokeInitializeSpy",0x000A2F4D, NULL, NULL},
	{"CoRevokeMallocSpy",0x000A330F, NULL, NULL},
	{"CoSetCancelObject",0x000A5A39, NULL, NULL},
	{"CoSetProxyBlanket",0x00039727, NULL, NULL},
	{"CoSetState",0x0001EDF6, NULL, NULL},
	{"CoSuspendClassObjects",0x00046DDB, NULL, NULL},
	{"CoSwitchCallContext",	0x0003F80D, NULL, NULL},
	{"CoTaskMemAlloc",0x0001D060, NULL, NULL},
	{"CoTaskMemFree",0x0001D044, NULL, NULL},
	{"CoTaskMemRealloc",0x00052B04, NULL, NULL},
	{"CoTestCancel",0x000A5548, NULL, NULL},
	{"CoTreatAsClass",0x000A2A9D, NULL, NULL},
	{"CoUninitialize",0x0001EE46, NULL, NULL},
	{"CoUnloadingWOW",0x000999BE, NULL, NULL},
	{"CoUnmarshalHresult",0x0009997B, NULL, NULL},
	{"CoUnmarshalInterface",0x0004D7F4, NULL, NULL},
	{"CoWaitForMultipleHandles",0x00077151, NULL, NULL},
	{"CreateAntiMoniker",0x0009C717, NULL, NULL},
	{"CreateBindCtx",0x0001E54C, NULL, NULL},
	{"CreateClassMoniker",0x00076AAF, NULL, NULL},
	{"CreateDataAdviseHolder",0x00060153, NULL, NULL},
	{"CreateDataCache",0x000EC769, NULL, NULL},
	{"CreateErrorInfo",0x00066B49, NULL, NULL},
	{"CreateFileMoniker",0x00053F99, NULL, NULL},
	{"CreateGenericComposite",0x00049F39, NULL, NULL},
	{"CreateILockBytesOnHGlobal",0x0006562A, NULL, NULL},
	{"CreateItemMoniker",0x00075A31, NULL, NULL},
	{"CreateObjrefMoniker",	0x0009C7C2, NULL, NULL},
	{"CreateOleAdviseHolder",0x0006275C, NULL, NULL},
	{"CreatePointerMoniker"	,0x0009C762, NULL, NULL},
	{"CreateStdProgressIndicator",0x0009ECF8, NULL,	NULL},
	{"CreateStreamOnHGlobal",0x00025E80, NULL, NULL},
	{"DcomChannelSetHResult",0x0004B1B7, NULL, NULL},
	{"DllDebugObjectRPCHook",0x001222E5, NULL, NULL},
	{"DllGetClassObjectWOW",0x0002C307, NULL, NULL},
	{"DllRegisterServer",0x000A2D58, NULL, NULL},
	{"DoDragDrop",0x000F0B6D, NULL, NULL},
	{"EnableHookObject",0x000A3D8C, NULL, NULL},
	{"FmtIdToPropStgName",0x0010428D, NULL, NULL},
	{"FreePropVariantArray",0x0004098C, NULL, NULL},
	{"GetClassFile",0x0009EE1A, NULL, NULL},
	{"GetConvertStg",0x000E93C2, NULL, NULL},
	{"GetDocumentBitStg",0x000E936F, NULL, NULL},
	{"GetErrorInfo",0x0004993A, NULL, NULL},
	{"GetHGlobalFromILockBytes",0x00065200, NULL, NULL},
	{"GetHGlobalFromStream",0x00074D7F, NULL, NULL},
	{"GetHookInterface",0x000A3AE6, NULL, NULL},
	{"GetRunningObjectTable",0x0002BC94, NULL, NULL},
	{"HBITMAP_UserMarshal",	0x000DA111, NULL, NULL},
	{"HBITMAP_UserSize",0x000DA091,	NULL, NULL},
	{"HBITMAP_UserUnmarshal",0x000DA2A1, NULL, NULL},
	{"HENHMETAFILE_UserFree",0x000DA526, NULL, NULL},
	{"HENHMETAFILE_UserMarshal",0x0005EF8B,	NULL, NULL},
	{"HENHMETAFILE_UserSize",0x0005EF45, NULL, NULL},
	{"HENHMETAFILE_UserUnmarshal",	0x000DA4E0, NULL, NULL},
	{"HGLOBAL_UserFree",0x00098F1F, NULL, NULL},
	{"HGLOBAL_UserMarshal",	0x00067F35, NULL, NULL},
	{"HGLOBAL_UserSize",0x00067FCE, NULL, NULL},
	{"HGLOBAL_UserUnmarshal",0x00098F49, NULL, NULL},
	{"HkOleRegisterObject",	0x000A3B05, NULL, NULL},
	{"HMETAFILEPICT_UserFree",0x000DA480, NULL, NULL},
	{"HMETAFILEPICT_UserMarshal",0x000932CD, NULL, NULL},
	{"HMETAFILEPICT_UserSize",0x000933C3, NULL, NULL},
	{"HMETAFILEPICT_UserUnmarshal",	0x00932870, NULL, NULL},
	{"HMETAFILE_UserFree",0x000DA705, NULL, NULL},
	{"HMETAFILE_UserMarshal",0x000DA597, NULL, NULL},
	{"HMETAFILE_UserSize",	0x000DA550, NULL, NULL},
	{"HMETAFILE_UserUnmarshal",0x000DA63F, NULL, NULL},
	{"HPALETTE_UserFree",0x000DA9D2, NULL, NULL},
	{"HPALETTE_UserMarshal",0x000DA777, NULL, NULL},
	{"HPALETTE_UserSize",0x000DA72F, NULL, NULL},
	{"HPALETTE_UserUnmarshal",0x000DA98C, NULL, NULL},
	{"HWND_UserFree",0x001221D2, NULL, NULL},
	{"HWND_UserMarshal",0x0012221D, NULL, NULL},
	{"HWND_UserSize",0x001221DA, NULL, NULL},
	{"HWND_UserUnmarshal",0x0012226D, NULL, NULL},
	{"IIDFromString",0x00039758, NULL, NULL},
	{"IsAccelerator",0x00098840, NULL, NULL},
	{"IsEqualGUID",	0x0009881E, NULL, NULL},
	{"IsValidIid",0x0001CF41, NULL, NULL},
	{"IsValidInterface",0x0001D439, NULL, NULL},
	{"IsValidPtrIn",0x000A4953, NULL, NULL},
	{"IsValidPtrOut",0x000A4987, NULL, NULL},
	{"MkParseDisplayName",0x00043EE9, NULL,	NULL},
	{"MonikerCommonPrefixWith",0x0009E1C0, NULL, NULL},
	{"MonikerRelativePathTo",0x0005E820, NULL, NULL},
	{"OleBuildVersion",0x00097C75, NULL, NULL},
	{"OleConvertIStorageToOLESTREAM",0x000F9DF9, NULL, NULL},
	{"OleConvertIStorageToOLESTREAMEx",0x000F9E54, NULL, NULL},
	{"OleConvertOLESTREAMToIStorage",0x000FA13F, NULL, NULL},
	{"OleConvertOLESTREAMToIStorageEx",0x000FA1E0, NULL, NULL},
	{"OleCreate",0x0009BC94, NULL, NULL},
	{"OleCreateDefaultHandler",0x000F233C, NULL, NULL},
	{"OleCreateEmbeddingHelper",0x000F2244, NULL, NULL},
	{"OleCreateEx",	0x0009BB26, NULL, NULL},
	{"OleCreateFromData",0x0009C267, NULL, NULL},
	{"OleCreateFromDataEx",	0x0009C16B, NULL, NULL},
	{"OleCreateFromFile",0x000EA8F4, NULL, NULL},
	{"OleCreateFromFileEx",	0x000EA53E, NULL, NULL},
	{"OleCreateLink",0x000EA85E, NULL, NULL},
	{"OleCreateLinkEx",0x000EA29C, NULL, NULL},
	{"OleCreateLinkFromData",0x0006049B, NULL, NULL},
	{"OleCreateLinkFromDataEx",0x000604E6, NULL, NULL},
	{"OleCreateLinkToFile",	0x000EA8A9, NULL, NULL},
	{"OleCreateLinkToFileEx",0x000EA37A, NULL, NULL},
	{"OleCreateMenuDescriptor",0x00098CF7, NULL, NULL},
	{"OleCreateStaticFromData",0x000E9E38,NULL, NULL},
	{"OleDestroyMenuDescriptor",0x00098F91, NULL, NULL},
	{"OleDoAutoConvert",0x000977DB, NULL, NULL},
	{"OleDraw",0x000E93EE,NULL, NULL},
	{"OleDuplicateData",0x000E96B0, NULL, NULL},
	{"OleFlushClipboard",0x0009AB71, NULL, NULL},
	{"OleGetAutoConvert",0x0005FA2C, NULL, NULL},
	{"OleGetClipboard",0x00052DAF, NULL, NULL},
	{"OleGetIconOfClass",0x000F3696, NULL, NULL},
	{"OleGetIconOfFile",0x000F33AC, NULL, NULL},
	{"OleInitialize",0x0001F6EA, NULL, NULL},
	{"OleInitializeWOW",0x0009979B, NULL, NULL},
	{"OleIsCurrentClipboard",0x0009A9C1, NULL, NULL},
	{"OleIsRunning",0x0005DED6, NULL, NULL},
	{"OleLoad",0x000982E5, NULL, NULL},
	{"OleLoadFromStream",0x00049C85, NULL, NULL},
	{"OleLockRunning",0x000E8FD4, NULL, NULL},
	{"OleMetafilePictFromIconAndLabel",0x000F2EF4, NULL, NULL},
	{"OleNoteObjectVisible",0x000E907D, NULL, NULL},
	{"OleQueryCreateFromData",0x000533C8, NULL, NULL},
	{"OleQueryLinkFromData",0x00053396, NULL, NULL},
	{"OleRegEnumFormatEtc",0x000F4506, NULL, NULL},
	{"OleRegEnumVerbs",0x00097FA6, NULL, NULL},
	{"OleRegGetMiscStatus",	0x0005EC2D, NULL, NULL},
	{"OleRegGetUserType",0x000960BA, NULL, NULL},
	{"OleRun",0x000761C9, NULL, NULL},
	{"OleSave",0x0001CF41, NULL, NULL},
	{"OleSaveToStream",0x00073300, NULL, NULL},
	{"OleSetAutoConvert",0x000F23AB, NULL, NULL},
	{"OleSetClipboard",0x000677C0,NULL, NULL},
	{"OleSetContainedObject",0x000E902A, NULL, NULL},
	{"OleSetMenuDescriptor",0x00076149, NULL, NULL},
	{"OleTranslateAccelerator",0x000989E9, NULL, NULL},
	{"OleUninitialize",0x000531E7,NULL, NULL}	,
	{"OpenOrCreateStream",0x00063B1F, NULL, NULL},
	{"ProgIDFromCLSID",0x00073F02, NULL, NULL},
	{"PropStgNameToFmtId",0x001042ED, NULL,	NULL},
	{"PropSysAllocString",0x0010486F, NULL, NULL},
	{"PropSysFreeString",0x00104880, NULL, NULL},
	{"PropVariantChangeType",0x001041C7, NULL, NULL},
	{"PropVariantClear",0x00034104,	NULL, NULL},
	{"PropVariantCopy",0x00104AAA, NULL, NULL},
	{"ReadClassStg",0x0005A7AB, NULL, NULL},
	{"ReadClassStm",0x00049D5A, NULL, NULL},
	{"KERNEL32.ReadFile",0x00001354, NULL, NULL},
	{"ReadFmtUserTypeStg",0x00061969, NULL, NULL},
	{"ReadOleStg",0x00097584, NULL,	NULL},
	{"ReadStringStream",0x00095DC3, NULL, NULL},
	{"RegisterDragDrop",0x0001F62A, NULL, NULL},
	{"ReleaseStgMedium",0x0004BB33,	NULL, NULL},
	{"RevokeDragDrop",0x00052B55, NULL, NULL},
	{"SetConvertStg",0x0009A367, NULL, NULL},
	{"SetDocumentBitStg",0x000E9394, NULL, NULL},
	{"SetErrorInfo",0x0001EEAA, NULL, NULL},
	{"SNB_UserFree",0x000DAC43, NULL, NULL},
	{"SNB_UserMarshal",0x000DAA45, NULL, NULL},
	{"SNB_UserSize",0x000DA9FC, NULL, NULL},
	{"SNB_UserUnmarshal",0x000DAAE1, NULL, NULL},
	{"StgConvertPropertyToVariant",	0x001065CB, NULL, NULL},
	{"StgConvertVariantToProperty",0x0010654E, NULL, NULL},
	{"StgCreateDocfile",0x00059A77, NULL, NULL},
	{"StgCreateDocfileOnILockBytes",0x0006575A, NULL, NULL},
	{"StgCreatePropSetStg",0x0010462C, NULL, NULL},
	{"StgCreatePropStg",0x00104349, NULL, NULL},
	{"StgCreateStorageEx",0x0005B9C0, NULL, NULL},
	{"StgGetIFillLockBytesOnFile",0x00110F83, NULL, NULL},
	{"StgGetIFillLockBytesOnILockBytes",0x00110D0F, NULL, NULL},
	{"StgIsStorageFile",0x00096000, NULL, NULL},
	{"StgIsStorageILockBytes",0x000FCB72, NULL, NULL},
	{"STGMEDIUM_UserFree",0x00067A07, NULL, NULL},
	{"STGMEDIUM_UserMarshal",0x00067920, NULL, NULL},
	{"STGMEDIUM_UserSize",0x00067999, NULL, NULL},
	{"STGMEDIUM_UserUnmarshal",0x00067AA7, NULL, NULL},
	{"StgOpenAsyncDocfileOnIFillLockBytes",	0x00110DD6, NULL, NULL},
	{"StgOpenPropStg",0x001044CA, NULL, NULL},
	{"StgOpenStorage",0x00027394, NULL, NULL},
	{"StgOpenStorageEx",0x0006ED80, NULL, NULL},
	{"StgOpenStorageOnHandle",0x00071EE1, NULL, NULL},
	{"StgOpenStorageOnILockBytes",0x000FC81D, NULL,	NULL},
	{"StgPropertyLengthAsVariant",0x000106593, NULL, NULL},
	{"StgSetTimes",	0x00058F6E, NULL, NULL},
	{"StringFromCLSID",0x0002CA98, NULL, NULL},
	{"StringFromGUID",0x0001DE12, NULL, NULL},
	{"StringFromIID",0x0006659B, NULL, NULL},
	{"UpdateDCOMSettings",0x000AFA92, NULL, NULL},
	{"UtConvertDvtd16toDvtd32",0x000FB005, NULL, NULL},
	{"UtConvertDvtd32toDvtd16",0x000FB306, NULL, NULL},
	{"UtGetDvtd16Info",0x000FAEDB, NULL, NULL},
	{"UtGetDvtd32Info",0x000FB1F6,NULL, NULL},
	{"WdtpInterfacePointer_UserFree",0x00124EC2, NULL, NULL},
	{"WdtpInterfacePointer_UserMarshal",0x001225E5, NULL, NULL},
	{"WdtpInterfacePointer_UserSize",0x00122396, NULL, NULL},
	{"WdtpInterfacePointer_UserUnmarshal",0x00124E77,NULL, NULL},
	{"WriteClassStg",0x0005A781, NULL, NULL},
	{"WriteClassStm",0x00073373, NULL, NULL},
	{"WriteFmtUserTypeStg",0x0005BEBC, NULL, NULL},
	{"WriteOleStg",0x000952A5, NULL, NULL},
	{"WriteStringStream",0x0005C15C, NULL, NULL},
	{0, 0, NULL, NULL},
};

// Added by T.OkamotoLab.
struct emu_env_w32_dll_export hnetcfg_exports[] = 
{
	{"fake", 0x0002B7AE, env_w32_hook_fake1, NULL},
	{"fake", 0x00032E61, env_w32_hook_fake2, NULL},
	{"fake", 0x0003493E, env_w32_hook_fake3, NULL},
	{0, 0, NULL, NULL},
};

// Added by T.OkamotoLab.
struct emu_env_w32_dll_export rpcrt4_exports[]=
{
        {"char_array_from_ndr",0x0005FC11, NULL, NULL},
        {"char_from_ndr",0x0005FBDD, NULL, NULL},
        {"CheckVerificationTrailer",0x00009984, NULL, NULL}	,
        {"CreateProxyFromTypeInfo",0x0001EA5D, NULL, NULL},
        {"CreateStubFromTypeInfo",0x0001A0AD, NULL, NULL},
        {"CStdStubBuffer_AddRef",0x00084876, NULL	, NULL},
        {"CStdStubBuffer_Connect",0x0008773B, NULL, NULL},
        {"CStdStubBuffer_CountRefs",0x0008766A, NULL, NULL},
        {"CStdStubBuffer_DebugServerQueryInterfa",0x000876AF, NULL, NULL},
        {"CStdStubBuffer_DebugServerRelease",0x000876D6,NULL,NULL},
        {"CStdStubBuffer_Disconnect",0x00084A65, NULL, NULL},
        {"CStdStubBuffer_Invoke",0x00084B71, NULL,	NULL},
        {"CStdStubBuffer_IsIIDSupported",0x00087864, NULL	, NULL},
        {"CStdStubBuffer_QueryInterface",0x000873EF,	 NULL	, NULL},
        {"data_from_ndr",0x0005FD7A,NULL, NULL},
        {"data_into_ndr",0x000606B9, NULL, NULL},
        {"data_size_ndr",0x000601B6, NULL, NULL},
        {"DceErrorInqTextA",0x000467C1, NULL, NULL},
        {"DceErrorInqTextW",0x00046815, NULL, NULL},
        {"DllGetClassObject",0x00062731	, NULL, NULL},
        {"DllRegisterServer",0x00063159	, NULL, NULL},
        {"double_array_from_ndr",0x00060CF8	, NULL, NULL},
        {"double_from_ndr",0x00060C75	, NULL, NULL},
        {"enum_from_ndr",0x00060F6F,	 NULL	, NULL},
        {"float_array_from_ndr",0x00060BAF, NULL, NULL},
        {"float_from_ndr",0x00060B42, NULL,NULL},
        {"GlobalMutexClearExternal",0x00045A2E, NULL, NULL},
        {"GlobalMutexRequestExternal",0x00045A1D, NULL,	NULL},
        {"IUnknown_AddRef_Proxy",0x00085039, NULL, NULL},
        {"IUnknown_QueryInterface_Proxy",0x00084B52, NULL, NULL},
        {"IUnknown_Release_Proxy",0x00084AD7, NULL, NULL},
        {"I_RpcAllocate",0x0000B4C8, NULL, NULL},
        {"I_RpcAsyncAbortCall",0x0004695C, NULL, NULL},
        {"I_RpcAsyncSetHandle",0x0001AAAF,	NULL	, NULL},
        {"I_RpcBCacheAllocate",0x0001B941, NULL, NULL},
        {"I_RpcBCacheFree",0x00006693,	 NULL	, NULL},
        {"I_RpcBindingCopy",0x0000DD8A, NULL, NULL},
        {"I_RpcBindingHandleToAsyncHandle",0x000470EA, NULL, NULL}	,
        {"I_RpcBindingInqConnId",0x00048D77, NULL, NULL},
        {"I_RpcBindingInqDynamicEndpointA",0x000490EA, NULL, NULL}	,
        {"I_RpcBindingInqDynamicEndpointW",0x00024BA4, NULL, NULL},
        {"I_RpcBindingInqLocalClientPID",0x0001A5B3, NULL, NULL},
        {"I_RpcBindingInqSecurityContext",0x00046A8E, NULL, NULL},
        {"I_RpcBindingInqTransportType",0x0000C90A,	 NULL	, NULL},
        {"I_RpcBindingInqWireIdForSnego",0x000470AA, NULL, NULL},
        {"I_RpcBindingIsClientLocal",0x000173BC, NULL, NULL},
        {"I_RpcBindingToStaticStringBindingW",0x000256E8,	 NULL	, NULL},
        {"I_RpcClearMutex",0x0001D9B6, NULL, NULL},
        {"I_RpcConnectionInqSockBuffSize",0x000468B0, NULL, NULL},
        {"I_RpcConnectionSetSockBuffSize",0x000468EB, NULL, NULL},
        {"I_RpcDeleteMutex",0x0004A8DE, NULL, NULL},
        {"I_RpcEnableWmiTrace",0x0004A8FA, NULL,	 NULL},
        {"I_RpcExceptionFilter",0x00030921, NULL, NULL},
        {"I_RpcFree",0x0000B4B1, NULL	, NULL},
        {"I_RpcFreeBuffer",0x000091A3, NULL	, NULL},
        {"I_RpcFreePipeBuffer",0x0004AAAB,NULL, NULL},
        {"I_RpcGetBuffer",0x00008A29, NULL, NULL},
        {"I_RpcGetBufferWithObject",0x000089B9, NULL, NULL},
        {"I_RpcGetCurrentCallHandle",0x0004AB3A, NULL,NULL},
        {"I_RpcGetExtendedError",0x0004AD17	, NULL, NULL},
        {"I_RpcIfInqTransferSyntaxes",0x00024B60, NULL, NULL},
        {"I_RpcLogEvent",0x00018782, NULL, NULL},
        {"I_RpcMapWin32Status",0x00012957, NULL, NULL},
        {"I_RpcNegotiateTransferSyntax",0x0004AAE6,	 NULL	, NULL},
        {"I_RpcNsBindingSetEntryNameA"	,0x00046A3B, NULL, NULL},
        {"I_RpcNsBindingSetEntryNameW",0x00046A48, NULL, NULL},
        {"I_RpcNsInterfaceExported",0x0004672F, NULL, NULL},
        {"I_RpcNsInterfaceUnexported",0x00046765, NULL, NULL},
        {"I_RpcParseSecurity",0x0000EFDD, NULL, NULL},
        {"I_RpcPauseExecution",0x00046937, NULL, NULL},
        {"I_RpcProxyNewConnection",0x00074203, NULL, NULL},
        {"I_RpcReallocPipeBuffer",	0x0004AB0B, NULL, NULL},
        {"I_RpcReceive",0x0001B115, NULL, NULL},
        {"I_RpcRequestMutex",0x0001D98D, NULL, NULL},
        {"I_RpcSend",0x0001AA4A, NULL, NULL},
        {"I_RpcSendReceive",0x0000A31B, NULL, NULL},
        {"I_RpcServerAllocateIpPort",0x0004BCF2, NULL, NULL},
        {"I_RpcServerCheckClientRestriction",0x00023F0E, NULL, NULL},
        {"I_RpcServerInqAddressChangeFn",0x00029206, NULL, NULL},
        {"I_RpcServerInqLocalConnAddress",0x00049643, NULL, NULL},
        {"I_RpcServerInqTransportType",0x0004AB61, NULL, NULL}	,
        {"I_RpcServerRegisterForwardFunction",0x00028CB3, NULL,	NULL},
        {"I_RpcServerSetAddressChangeFn",0x00028BD9, NULL, NULL},
        {"I_RpcServerUseProtseq2A",0x0002B318, NULL, NULL},
        {"I_RpcServerUseProtseq2W",0x00025879, NULL, NULL},
        {"I_RpcServerUseProtseqEp2A",0x0002790B, NULL, NULL},
        {"I_RpcServerUseProtseqEp2W",0x0001DCEA,	NULL	, NULL},
        {"I_RpcSessionStrictContextHandle",0x000498F5, NULL, NULL},
        {"I_RpcSsDontSerializeContext",0x0005F97D, NULL, NULL},
        {"I_RpcSystemFunction001",0x00028BF1, NULL, NULL},
        {"I_RpcTransConnectionAllocatePacket",0x0001062B, NULL,	 NULL},
        {"I_RpcTransConnectionFreePacket",0x0001876C, NULL, NULL},
        {"I_RpcTransConnectionReallocPacket",0x00033A2A,	 NULL	, NULL},
        {"I_RpcTransDatagramAllocate",0x0002A210, NULL, NULL},
        {"I_RpcTransDatagramAllocate2",0x0004CEA8, NULL,	 NULL},
        {"I_RpcTransDatagramFree",0x0004D89C, NULL, NULL},
        {"I_RpcTransGetThreadEvent",0x00010672, NULL, NULL},
        {"I_RpcTransIoCancelled",0x00047986,	 NULL	, NULL},
        {"I_RpcTransServerNewConnection",0x00015A0A, NULL, NULL},
        {"I_RpcTurnOnEEInfoPropagation",0x00046AD4, NULL, NULL},
        {"I_UuidCreate",0x0004F16E, NULL, NULL},
        {"long_array_from_ndr",0x00060ED2, NULL, NULL},
        {"long_from_ndr",0x00060EA1, NULL, NULL},
        {"long_from_ndr_temp",0x00060F40, NULL, NULL},
        {"MesBufferHandleReset",0x0002035C, NULL, NULL}	,
        {"MesDecodeBufferHandleCreate",	0x0002095B	, NULL, NULL},
        {"MesDecodeIncrementalHandleCreate",0x000641C6,NULL, NULL},
        {"MesEncodeDynBufferHandleCreate",0x00064228, NULL, NULL},
        {"MesEncodeFixedBufferHandleCreate",0x00020534, NULL, NULL},
        {"MesEncodeIncrementalHandleCreate",0x00064163, NULL, NULL},
        {"MesHandleFree",0x00020218, NULL, NULL},
        {"MesIncrementalHandleReset",0x00063642, NULL, NULL},
        {"MesInqProcEncodingId",0x0006428A,	NULL	, NULL},
        {"MIDL_wchar_strcpy",0x0005FBBA, NULL, NULL},
        {"MIDL_wchar_strlen",0x0005FB9A, NULL, NULL},
        {"NdrAllocate",0x0000A23F, NULL, NULL},
        {"NdrAsyncClientCall",0x00085433, NULL, NULL},
        {"NdrAsyncServerCall",0x000863A6, NULL, NULL},
        {"NdrByteCountPointerBufferSize"	,0x0002F606	, NULL, NULL},
        {"NdrByteCountPointerFree",0x0002F648	, NULL, NULL},
        {"NdrByteCountPointerMarshall",0x0002F66E, NULL,	 NULL},
        {"NdrByteCountPointerUnmarshall",0x0002F6B6, NULL, NULL},
        {"NDRCContextBinding",0x0000D833, NULL, NULL},
        {"NDRCContextMarshall",0x0000D48C, NULL, NULL},
        {"NDRCContextUnmarshall",0x0000D92D	, NULL, NULL},
        {"NdrClearOutParameters",	0x00088507, NULL	, NULL},
        {"NdrClientCall",0x000885B5, NULL, NULL},
        {"NdrClientCall2",0x000844D0, NULL, NULL},
        {"NdrClientContextMarshall",0x00065B72, NULL, NULL},
        {"NdrClientContextUnmarshall",0x00066742, NULL, NULL},
        {"NdrClientInitialize",0x00008BA9,	 NULL	, NULL},
        {"NdrClientInitializeNew",0x00008B6F, NULL	, NULL},
        {"NdrComplexArrayBufferSize",0x00019609, NULL,NULL},
        {"NdrComplexArrayFree",0x00018C71, NULL, NULL}	,
        {"NdrComplexArrayMarshall",0x000194BA, NULL, NULL},
        {"NdrComplexArrayMemorySize",0x00019757	, NULL, NULL},
        {"NdrComplexArrayUnmarshall",	0x00019673,	 NULL	, NULL},
        {"NdrComplexStructBufferSize",0x000162A2, NULL, NULL},
        {"NdrComplexStructFree",0x00016BA3, NULL,	NULL},
        {"NdrComplexStructMarshall",0x00016498, NULL, NULL},
        {"NdrComplexStructMemorySize",0x000167B1,	 NULL	, NULL},
        {"NdrComplexStructUnmarshall",0x00016929, NULL, NULL}	,
        {"NdrConformantArrayBufferSize",	0x0000B854,	 NULL	, NULL},
        {"NdrConformantArrayFree",0x0000B9F6	, NULL, NULL},
        {"NdrConformantArrayMarshall",0x0000B880, NULL, NULL},
        {"NdrConformantArrayMemorySize",0x00032D46, NULL, NULL},
        {"NdrConformantArrayUnmarshall",0x0000B976,	 NULL	, NULL},
        {"NdrConformantStringBufferSize"	,0x0000F16D,	 NULL	, NULL},
        {"NdrConformantStringMarshall",	0x0000F210, NULL,	NULL},
        {"NdrConformantStringMemorySize",0x000127C8, NULL, NULL},
        {"NdrConformantStringUnmarshall",0x0000F2F0,	 NULL	, NULL},
        {"NdrConformantStructBufferSize"	,0x0000F529,	 NULL	, NULL},
        {"NdrConformantStructFree",0x000338A4, NULL, NULL},
        {"NdrConformantStructMarshall",	0x0000F59F,	 NULL	, NULL},
        {"NdrConformantStructMemorySize",0x000135BD, NULL, NULL},
        {"NdrConformantStructUnmarshall",0x0000F658,	 NULL	, NULL},
        {"NdrConformantVaryingArrayBufferSize",0x00013061	, NULL, NULL},
        {"NdrConformantVaryingArrayFree",0x00013022, NULL, NULL},
        {"NdrConformantVaryingArrayMarshall",	0x0001312E,	 NULL	, NULL},
        {"NdrConformantVaryingArrayMemorySize",0x00013450, NULL, NULL},
        {"NdrConformantVaryingArrayUnmarshall",0x00013212	, NULL, NULL},
        {"NdrConformantVaryingStructBufferSize",0x000654EC, NULL, NULL},
        {"NdrConformantVaryingStructFree",0x00065919, NULL, NULL},
        {"NdrConformantVaryingStructMarshall",	0x00065C67,	 NULL	, NULL},
        {"NdrConformantVaryingStructMemorySize",0x00066EBB, NULL, NULL},
        {"NdrConformantVaryingStructUnmarshall",0x00066040, NULL, NULL},
        {"NdrContextHandleInitialize",0x0000DD2F, NULL, NULL},
        {"NdrContextHandleSize",0x00065275, NULL, NULL},
        {"NdrConvert",0x00067B88, NULL, NULL},
        {"NdrConvert2",0x00067AEA, NULL, NULL},
        {"NDRcopy",0x0005FD51, NULL, NULL},
        {"NdrCorrelationFree",0x00009123	, NULL, NULL},
        {"NdrCorrelationInitialize",0x0000973A,	 NULL	, NULL},
        {"NdrCorrelationPass",0x00009795	, NULL, NULL},
        {"NdrCreateServerInterfaceFromStub",0x000593D7, NULL, NULL},
        {"NdrCStdStubBuffer2_Release",0x00085C45,NULL, NULL},
        {"NdrCStdStubBuffer_Release",0x00084A2C, NULL, NULL},
        {"NdrDcomAsyncClientCall",0x0008A02A, NULL, NULL},
        {"NdrDcomAsyncStubCall",0x000892D2,	 NULL	, NULL},
        {"NdrDllCanUnloadNow",	0x0008485D, NULL	, NULL},
        {"NdrDllGetClassObject",0x0008475D, NULL,NULL},
        {"NdrDllRegisterProxy",0x00063211, NULL, NULL},
        {"NdrDllUnregisterProxy",0x00063491,	 NULL	, NULL},
        {"NdrEncapsulatedUnionBufferSize",0x00065449, NULL, NULL},
        {"NdrEncapsulatedUnionFree",0x000657B9, NULL, NULL},
        {"NdrEncapsulatedUnionMarshall",0x00065F71,	 NULL	, NULL},
        {"NdrEncapsulatedUnionMemorySize",0x00066E87,NULL, NULL},
        {"NdrEncapsulatedUnionUnmarshall",0x0006682D, NULL, NULL},
        {"NdrFixedArrayBufferSize",0x00034B00	, NULL, NULL},
        {"NdrFixedArrayFree",0x0001E201, NULL, NULL},
        {"NdrFixedArrayMarshall",0x0001E22E, NULL	, NULL},
        {"NdrFixedArrayMemorySize",0x00034B42, NULL, NULL},
        {"NdrFixedArrayUnmarshall",0x0001E297, NULL, NULL},
        {"NdrFreeBuffer",0x000090CC, NULL, NULL},
        {"NdrFullPointerFree",0x000242B5, NULL, NULL},
        {"NdrFullPointerInsertRefId",0x0002432C, NULL, NULL},
        {"NdrFullPointerQueryPointer",0x000233FF, NULL, NULL},
        {"NdrFullPointerQueryRefId",0x00024237, NULL, NULL},
        {"NdrFullPointerXlatFree",0x00009142,	 NULL	, NULL},
        {"NdrFullPointerXlatInit",0x000234BE	, NULL, NULL},
        {"NdrGetBuffer",0x00009045, NULL, NULL},
        {"NdrGetDcomProtocolVersion",0x0002A5F2, NULL,NULL},
        {"NdrGetSimpleTypeBufferAlignment",0x00068A54, NULL, NULL},
        {"NdrGetSimpleTypeBufferSize",0x00068A6C, NULL, NULL}	,
        {"NdrGetSimpleTypeMemorySize",0x00068A84,	 NULL	, NULL},
        {"NdrGetTypeFlags",0x000092F4, NULL, NULL},
        {"NdrGetUserMarshalInfo",	0x0001EC78, NULL, NULL},
        {"NdrInterfacePointerBufferSize",0x0006523D, NULL,	 NULL},
        {"NdrInterfacePointerFree",0x000656B8, NULL, NULL},
        {"NdrInterfacePointerMarshall",0x00065B18, NULL, NULL},
        {"NdrInterfacePointerMemorySize"	,0x00066BD1, NULL, NULL},
        {"NdrInterfacePointerUnmarshall",	0x000666F1,	 NULL	, NULL},
        {"NdrMapCommAndFaultStatus",0x00024A49	, NULL, NULL},
        {"NdrMesProcEncodeDecode",0x00063917, NULL, NULL},
        {"NdrMesProcEncodeDecode2",0x00063C48, NULL, NULL},
        {"NdrMesSimpleTypeAlignSize",0x00063EF0, NULL, NULL},
        {"NdrMesSimpleTypeDecode",0x00063FCE, NULL, NULL},
        {"NdrMesSimpleTypeEncode",0x00063F2C, NULL, NULL},
        {"NdrMesTypeAlignSize",0x0002071B, NULL, NULL},
        {"NdrMesTypeAlignSize2",	0x000206CF,	 NULL	, NULL},
        {"NdrMesTypeDecode",0x000209D4, NULL, NULL},
        {"NdrMesTypeDecode2",0x00020AD0, NULL, NULL},
        {"NdrMesTypeEncode",0x000207D4, NULL, NULL},
        {"NdrMesTypeEncode2",0x00020640, NULL, NULL},
        {"NdrMesTypeFree2",0x00063EA4, NULL, NULL},
        {"NdrNonConformantStringBufferSize",0x00024CA7, NULL, NULL},
        {"NdrNonConformantStringMarshall",0x00024D19, NULL, NULL},
        {"NdrNonConformantStringMemorySize",	0x00024D91	, NULL, NULL},
        {"NdrNonConformantStringUnmarshall",0x00024E2C,	 NULL	, NULL},
        {"NdrNonEncapsulatedUnionBufferSize",	0x00013689,	 NULL	, NULL},
        {"NdrNonEncapsulatedUnionFree",0x000139CC, NULL, NULL},
        {"NdrNonEncapsulatedUnionMarshall",0x0001379B, NULL, NULL},
        {"NdrNonEncapsulatedUnionMemorySize",0x00013C42	, NULL, NULL},
        {"NdrNonEncapsulatedUnionUnmarshall",0x00013A96	, NULL, NULL},
        {"NdrNsGetBuffer",0x000646D6, NULL, NULL},
        {"NdrNsSendReceive",0x00064724, NULL, NULL},
        {"NdrOleAllocate",0x0001A505, NULL, NULL},
        {"NdrOleFree",0x0000B635,	 NULL	, NULL},
        {"NdrOutInit",0x00009FBF,	 NULL	, NULL},
        {"NdrPartialIgnoreClientBufferSize",0x00065295	, NULL, NULL},
        {"NdrPartialIgnoreClientMarshall",0x00065BEE	, NULL, NULL},
        {"NdrPartialIgnoreServerInitialize",0x00068A9C	, NULL, NULL},
        {"NdrPartialIgnoreServerUnmarshall",0x000667E1, NULL, NULL},
        {"NdrpCreateProxy",0x00085F48, NULL, NULL},
        {"NdrpCreateStub",0x00085BBD, NULL, NULL},
        {"NdrpGetProcFormatString",0x0002D918, NULL, NULL},
        {"NdrpGetTypeFormatString",0x0002D897, NULL,NULL},
        {"NdrpGetTypeGenCookie",0x0002D8BB, NULL, NULL},
        {"NdrpMemoryIncrement",	0x0000A5FD,	 NULL	, NULL},
        {"NdrPointerBufferSize",0x0000AD48, NULL, NULL},
        {"NdrPointerFree",0x0000ABDF,	 NULL	, NULL},
        {"NdrPointerMarshall",0x0000AD0D, NULL, NULL},
        {"NdrPointerMemorySize",	0x00066E51,	 NULL	, NULL},
        {"NdrPointerUnmarshall",0x0000AD7A, NULL, NULL},
        {"NdrpReleaseTypeFormatString",0x0002C0B8, NULL,	 NULL},
        {"NdrpReleaseTypeGenCookie",0x0002D99D, NULL, NULL},
        {"NdrProxyErrorHandler",0x000865F6, NULL,	 NULL},
        {"NdrProxyFreeBuffer",0x00084F93, NULL, NULL},
        {"NdrProxyGetBuffer",0x00084F30, NULL, NULL},
        {"NdrProxyInitialize",0x00084ECA, NULL, NULL},
        {"NdrProxySendReceive",0x00084D75, NULL, NULL},
        {"NdrpSetRpcSsDefaults",0x00068ABE, NULL,	 NULL},
        {"NdrpVarVtOfTypeDesc",	0x0002D94D	, NULL, NULL},
        {"NdrRangeUnmarshall",0x00032E59, NULL, NULL},
        {"NdrRpcSmClientAllocate",0x00068D27, NULL, NULL},
        {"NdrRpcSmClientFree",0x00068D63, NULL, NULL},
        {"NdrRpcSmSetClientToOsf",0x0006937F, NULL, NULL},
        {"NdrRpcSsDefaultAllocate",0x000301B5, NULL, NULL},
        {"NdrRpcSsDefaultFree",0x000301A5, NULL, NULL},
        {"NdrRpcSsDisableAllocate",0x00069359	, NULL, NULL},
        {"NdrRpcSsEnableAllocate",0x00069519	, NULL, NULL},
        {"NDRSContextMarshall",	0x0005FB28	, NULL, NULL},
        {"NDRSContextMarshall2",	0x0000DAC8	, NULL, NULL},
        {"NDRSContextMarshallEx",0x0005FB02, NULL, NULL},
        {"NDRSContextUnmarshall",0x0005FB51, NULL, NULL},
        {"NDRSContextUnmarshall2",0x0000D0E9, NULL, NULL},
        {"NDRSContextUnmarshallEx",0x0005FB77, NULL, NULL},
        {"NdrSendReceive",0x0000A347,	 NULL	, NULL},
        {"NdrServerCall",0x0008A364, NULL, NULL},
        {"NdrServerCall2",0x000846D5, NULL, NULL},
        {"NdrServerContextMarshall",0x00065BB4, NULL, NULL},
        {"NdrServerContextNewMarshall",0x0000DA6A	, NULL, NULL},
        {"NdrServerContextNewUnmarshall",0x0000D4F1, NULL, NULL},
        {"NdrServerContextUnmarshall",0x0006678C,NULL, NULL},
        {"NdrServerInitialize",0x00009AED, NULL, NULL},
        {"NdrServerInitializeMarshall",0x00045DE9, NULL, NULL},
        {"NdrServerInitializeNew",0x0000A3A3,	 NULL	, NULL},
        {"NdrServerInitializePartial",0x000645C0	, NULL, NULL},
        {"NdrServerInitializeUnmarshall",	0x00064803,	 NULL	, NULL},
        {"NdrServerMarshall",0x00069989, NULL, NULL},
        {"NdrServerUnmarshall",0x0006953F, NULL, NULL},
        {"NdrSimpleStructBufferSize",0x0000AF2A, NULL, NULL},
        {"NdrSimpleStructFree",0x0000B164, NULL, NULL},
        {"NdrSimpleStructMarshall",0x0000AA2C	, NULL, NULL},
        {"NdrSimpleStructMemorySize",0x000122E3, NULL, NULL},
        {"NdrSimpleStructUnmarshall",0x0000AA8D, NULL, NULL},
        {"NdrSimpleTypeMarshall",	0x0000ADDC	, NULL, NULL},
        {"NdrSimpleTypeUnmarshall",0x00016B2E, NULL, NULL},
        {"NdrStubCall",0x0008A0BC, NULL, NULL},
        {"NdrStubCall2",0x00084005, NULL, NULL},
        {"NdrStubForwardingFunction",0x00087711, NULL, NULL},
        {"NdrStubGetBuffer",0x00084CCA, NULL, NULL},
        {"NdrStubInitialize",0x00084C07	, NULL, NULL},
        {"NdrStubInitializeMarshall",0x000876DE, NULL, NULL},
        {"NdrTypeFlags",0x00005D38, NULL, NULL},
        {"NdrTypeFree",0x0006561C, NULL,NULL},
        {"NdrTypeMarshall",0x00065982,	 NULL	, NULL},
        {"NdrTypeSize",0x0006506C, NULL, NULL},
        {"NdrTypeUnmarshall",0x00066016, NULL, NULL},
        {"NdrUnmarshallBasetypeInline",	0x00084460,	 NULL	, NULL},
        {"NdrUserMarshalBufferSize",0x0001ED39, NULL, NULL},
        {"NdrUserMarshalFree",0x0001EC24, NULL, NULL},
        {"NdrUserMarshalMarshall",0x0001EE20, NULL, NULL},
        {"NdrUserMarshalMemorySize",0x00034A88, NULL, NULL},
        {"NdrUserMarshalSimpleTypeConvert",0x000678F6, NULL, NULL},
        {"NdrUserMarshalUnmarshall",0x0001EF32, NULL, NULL},
        {"NdrVaryingArrayBufferSize",0x00033F52, NULL, NULL},
        {"NdrVaryingArrayFree",0x00033F17, NULL, NULL},
        {"NdrVaryingArrayMarshall",0x00033FF3, NULL, NULL},
        {"NdrVaryingArrayMemorySize",0x00034240, NULL, NULL},
        {"NdrVaryingArrayUnmarshall",0x000340A5, NULL, NULL},
        {"NdrXmitOrRepAsBufferSize",0x00065105, NULL, NULL},
        {"NdrXmitOrRepAsFree",0x00065681, NULL, NULL},
        {"NdrXmitOrRepAsMarshall",0x000659E5, NULL, NULL},
        {"NdrXmitOrRepAsMemorySize",0x00066965,	 NULL	, NULL},
        {"NdrXmitOrRepAsUnmarshall",0x000664C5, NULL, NULL},
        {"pfnFreeRoutines",0x0008B2A0, NULL, NULL},
        {"pfnMarshallRoutines",0x0008B2A4, NULL, NULL},
        {"pfnSizeRoutines",0x0008B29C, NULL, NULL},
        {"pfnUnmarshallRoutines",0x0008B2A8	, NULL, NULL},
        {"RpcAsyncAbortCall",0x000884C4, NULL, NULL},
        {"RpcAsyncCancelCall",0x0004F29D, NULL, NULL},
        {"RpcAsyncCompleteCall",	0x000852A3	, NULL, NULL},
        {"RpcAsyncGetCallStatus",0x0004F231,	 NULL	, NULL},
        {"RpcAsyncInitializeHandle",0x00084D16,NULL, NULL},
        {"RpcAsyncRegisterInfo",0x0004F227, NULL, NULL},
        {"RpcBindingCopy",0x0002EC68, NULL, NULL},
        {"RpcBindingFree",0x0000B3D8, NULL, NULL},
        {"RpcBindingFromStringBindingA",0x0002A898, NULL, NULL},
        {"RpcBindingFromStringBindingW",0x0000EAC5, NULL, NULL},
        {"RpcBindingInqAuthClientA",0x0002EF6C, NULL, NULL},
        {"RpcBindingInqAuthClientExA",0x0002EF93	, NULL, NULL},
        {"RpcBindingInqAuthClientExW",0x0001A906	, NULL, NULL},
        {"RpcBindingInqAuthClientW",0x0001A9A4, NULL, NULL},
        {"RpcBindingInqAuthInfoA",0x0004C51A, NULL, NULL},
        {"RpcBindingInqAuthInfoExA",0x0004C114, NULL, NULL},
        {"RpcBindingInqAuthInfoExW",0x0002EBB5, NULL, NULL},
        {"RpcBindingInqAuthInfoW",0x00046B25, NULL, NULL},
        {"RpcBindingInqObject",0x0001A52C, NULL, NULL},
        {"RpcBindingInqOption",0x00048D20, NULL, NULL},
        {"RpcBindingReset",0x00046AE6, NULL, NULL},
        {"RpcBindingServerFromClient",0x0001207C, NULL, NULL},
        {"RpcBindingSetAuthInfoA",0x0004C543, NULL, NULL},
        {"RpcBindingSetAuthInfoExA",0x0004C196, NULL, NULL},
        {"RpcBindingSetAuthInfoExW",0x00017A7E, NULL, NULL},
        {"RpcBindingSetAuthInfoW",0x0002F525, NULL, NULL},
        {"RpcBindingSetObject",0x0001A7EE, NULL, NULL},
        {"RpcBindingSetOption",0x0001FB67, NULL, NULL},
        {"RpcBindingToStringBindingA",0x00024BE8, NULL, NULL}	,
        {"RpcBindingToStringBindingW",0x0000E968,	 NULL	, NULL},
        {"RpcBindingVectorFree",0x00024912, NULL, NULL},
        {"RpcCancelThread",0x0004AD6C, NULL, NULL},
        {"RpcCancelThreadEx",0x0004AD94, NULL, NULL},
        {"RpcCertGeneratePrincipalNameA",0x0004C39B, NULL, NULL},
        {"RpcCertGeneratePrincipalNameW",0x0004FD1F, NULL, NULL},
        {"RpcEpRegisterA",0x00024F26, NULL, NULL},
        {"RpcEpRegisterNoReplaceA",0x00050115, NULL, NULL},
        {"RpcEpRegisterNoReplaceW",0x000501BF, NULL, NULL},
        {"RpcEpRegisterW",0x000269D6, NULL, NULL},
        {"RpcEpResolveBinding",0x000469AF, NULL, NULL},
        {"RpcEpUnregister",0x00050217, NULL	, NULL},
        {"RpcErrorAddRecord",0x00051717, NULL, NULL},
        {"RpcErrorClearInformation",0x000517A3, NULL, NULL},
        {"RpcErrorEndEnumeration",0x000511B2, NULL, NULL},
        {"RpcErrorGetNextRecord",0x00050AEF, NULL, NULL},
        {"RpcErrorGetNumberOfRecords",0x00050B5A	, NULL, NULL},
        {"RpcErrorLoadErrorInfo",0x000511E6, NULL, NULL},
        {"RpcErrorResetEnumeration",0x00050B34, NULL, NULL},
        {"RpcErrorSaveErrorInfo",0x00050B8D, NULL, NULL},
        {"RpcErrorStartEnumeration",0x00034D55, NULL, NULL},
        {"RpcFreeAuthorizationContext",0x00049469, NULL, NULL},
        {"RpcGetAuthorizationContextForClient",0x000493A4, NULL, NULL},
        {"RpcIfIdVectorFree",0x000494E2	, NULL, NULL},
        {"RpcIfInqId",0x00024B1A, NULL, NULL},
        {"RpcImpersonateClient",0x0000A436, NULL, NULL},
        {"RpcMgmtEnableIdleCleanup",0x000280AB, NULL, NULL},
        {"RpcMgmtEpEltInqBegin",	0x00051A20	, NULL, NULL},
        {"RpcMgmtEpEltInqDone",	0x00051C12	, NULL, NULL},
        {"RpcMgmtEpEltInqNextA",0x00051C5E, NULL, NULL},
        {"RpcMgmtEpEltInqNextW",0x00052149	, NULL, NULL},
        {"RpcMgmtEpUnregister",0x00051EF9, NULL,NULL},
        {"RpcMgmtInqComTimeout",0x0004686A, NULL, NULL},
        {"RpcMgmtInqDefaultProtectLevel",0x00048CAF, NULL, NULL},
        {"RpcMgmtInqIfIds",0x00049495, NULL, NULL},
        {"RpcMgmtInqServerPrincNameA",0x0004C336, NULL	, NULL},
        {"RpcMgmtInqServerPrincNameW",0x0004953A, NULL, NULL},
        {"RpcMgmtInqStats",0x0004903A, NULL, NULL},
        {"RpcMgmtIsServerListening",0x0002810F, NULL, NULL},
        {"RpcMgmtSetAuthorizationFn",0x000521B6, NULL, NULL},
        {"RpcMgmtSetCancelTimeout",0x00012776, NULL, NULL},
        {"RpcMgmtSetComTimeout",0x00023DFC, NULL, NULL},
        {"RpcMgmtSetServerStackSize",0x00020FC7, NULL, NULL},
        {"RpcMgmtStopServerListening",0x000348E7,NULL, NULL},
        {"RpcMgmtWaitServerListen",0x00034892,NULL,NULL},
        {"RpcNetworkInqProtseqsA",0x0004C400,NULL, NULL},
        {"RpcNetworkInqProtseqsW",0x00048E9D, NULL, NULL},
        {"RpcNetworkIsProtseqValidA",0x0004BDAB, NULL, NULL}	,
        {"RpcNetworkIsProtseqValidW",0x0004679B, NULL, NULL},
        {"RpcNsBindingInqEntryNameA",0x0004BEAF,	 NULL	, NULL},
        {"RpcNsBindingInqEntryNameW",0x000469F5, NULL	, NULL},
        {"RpcObjectInqType",0x00048EC7, NULL, NULL},
        {"RpcObjectSetInqFn",0x00048F15, NULL, NULL},
        {"RpcObjectSetType",0x00048F3B, NULL, NULL},
        {"RpcProtseqVectorFreeA",0x0004BDF4, NULL, NULL},
        {"RpcProtseqVectorFreeW",0x00048F61, NULL, NULL},
        {"RpcRaiseException",0x0003042E, NULL, NULL},
        {"RpcRevertToSelf",0x0000B487, NULL, NULL},
        {"RpcRevertToSelfEx",0x0000A4BE, NULL, NULL},
        {"RpcServerInqBindings",0x0002477D, NULL, NULL},
        {"RpcServerInqCallAttributesA",0x0004BFA1, NULL, NULL},
        {"RpcServerInqCallAttributesW",0x00049860, NULL, NULL},
        {"RpcServerInqDefaultPrincNameA",0x000495E1, NULL, NULL},
        {"RpcServerInqDefaultPrincNameW",0x0002626C, NULL, NULL},
        {"RpcServerInqIf",0x00048FB5, NULL, NULL},
        {"RpcServerListen",0x0002F7BD, NULL, NULL},
        {"RpcServerRegisterAuthInfoA",0x00025F12, NULL, NULL},
        {"RpcServerRegisterAuthInfoW",0x00024640, NULL, NULL},
        {"RpcServerRegisterIf",0x0002F8AE, NULL, NULL},
        {"RpcServerRegisterIf2",0x0001D53A, NULL, NULL},
        {"RpcServerRegisterIfEx",0x0001E05B, NULL, NULL},
        {"RpcServerTestCancel",0x0004ACB0, NULL, NULL},
        {"RpcServerUnregisterIf",0x00031752, NULL, NULL},
        {"RpcServerUnregisterIfEx",0x00048FE1	, NULL, NULL},
        {"RpcServerUseAllProtseqs",0x00049831	, NULL, NULL},
        {"RpcServerUseAllProtseqsEx",0x000496BD, NULL, NULL},
        {"RpcServerUseAllProtseqsIf",0x000281A5, NULL, NULL},
        {"RpcServerUseAllProtseqsIfEx",0x000281D7, NULL, NULL}	,
        {"RpcServerUseProtseqA",0x0002B2E5, NULL,	 NULL},
        {"RpcServerUseProtseqEpA",0x00027A43, NULL, NULL},
        {"RpcServerUseProtseqEpExA",0x000278E7,NULL, NULL},
        {"RpcServerUseProtseqEpExW",0x0001DD59, NULL,	 NULL},
        {"RpcServerUseProtseqEpW",0x0001DD7D, NULL, NULL},
        {"RpcServerUseProtseqExA",0x0004BE04, NULL, NULL},
        {"RpcServerUseProtseqExW",0x00026A86, NULL, NULL},
        {"RpcServerUseProtseqIfA",0x0004BE7A, NULL, NULL},
        {"RpcServerUseProtseqIfExA",0x0004BE25, NULL, NULL},
        {"RpcServerUseProtseqIfExW",0x00027B27,NULL, NULL},
        {"RpcServerUseProtseqIfW",0x00027AF2, NULL, NULL},
        {"RpcServerUseProtseqW",0x00026A2E, NULL, NULL},
        {"RpcServerYield",0x0004AC70, NULL, NULL},
        {"RpcSmAllocate",0x0006905E, NULL, NULL},
        {"RpcSmClientFree",0x000690C9, NULL, NULL},
        {"RpcSmDestroyClientContext",0x000318BF, NULL, NULL},
        {"RpcSmDisableAllocate",0x00069121, NULL	, NULL},
        {"RpcSmEnableAllocate",0x000694C2, NULL, NULL},
        {"RpcSmFree",0x00069179, NULL, NULL},
        {"RpcSmGetThreadHandle",0x000691D1, NULL	, NULL},
        {"RpcSmSetClientAllocFree",0x00069239, NULL, NULL},
        {"RpcSmSetThreadHandle",0x00069299, NULL	, NULL},
        {"RpcSmSwapClientAllocFree",0x000692F1, NULL, NULL},
        {"RpcSsAllocate",0x00068E25, NULL, NULL},
        {"RpcSsContextLockExclusive",0x00030C41, NULL, NULL},
        {"RpcSsContextLockShared",0x0005F98D, NULL, NULL},
        {"RpcSsDestroyClientContext",0x000318F9, NULL, NULL},
        {"RpcSsDisableAllocate",0x00068F0E, NULL, NULL},
        {"RpcSsEnableAllocate",0x000694B5, NULL, NULL},
        {"RpcSsFree",0x00068F1B, NULL, NULL},
        {"RpcSsGetContextBinding",0x0005FC77, NULL, NULL},
        {"RpcSsGetThreadHandle",0x00068F28,	 NULL	, NULL},
        {"RpcSsSetClientAllocFree",0x00068F5E, NULL,NULL},
        {"RpcSsSetThreadHandle",0x00068F93,	 NULL	, NULL},
        {"RpcSsSwapClientAllocFree",0x0006901A, NULL, NULL},
        {"RpcStringBindingComposeA",0x0002A8E4,NULL, NULL},
        {"RpcStringBindingComposeW",0x0000ED21, NULL, NULL},
        {"RpcStringBindingParseA",0x00025418, NULL, NULL},
        {"RpcStringBindingParseW",0x0000E9B6, NULL, NULL},
        {"RpcStringFreeA",0x00025408, NULL, NULL}	,
        {"RpcStringFreeW",0x0000E75E, NULL, NULL},
        {"RpcTestCancel",0x0004AD0A, NULL	, NULL},
        {"RpcUserFree",0x00064881, NULL, NULL},
        {"short_array_from_ndr",0x00060DFA, NULL, NULL},
        {"short_from_ndr",0x00060DBF, NULL, NULL}	,
        {"short_from_ndr_temp",0x00060E68, NULL, NULL},
        {"SimpleTypeAlignment",0x00001658, NULL, NULL},
        {"SimpleTypeBufferSize",0x00001718, NULL, NULL},
        {"SimpleTypeMemorySize",	0x000017D8,	 NULL	, NULL},
        {"TowerConstruct",0x00023C28,	 NULL	, NULL},
        {"TowerExplode",0x00023FEB, NULL, NULL},
        {"tree_into_ndr",0x000608ED, NULL, NULL},
        {"tree_peek_ndr",0x00060508, NULL, NULL},
        {"tree_size_ndr",0x0006036F, NULL, NULL},
        {"UuidCompare",0x0004F191, NULL, NULL},
        {"UuidCreate",0x00006254,	NULL,	 NULL},
        {"UuidCreateNil",0x0004F10C, NULL, NULL},
        {"UuidCreateSequential",0x000226CB, NULL, NULL},
        {"UuidEqual",0x00031460	, NULL, NULL},
        {"UuidFromStringA",0x0004C461	, NULL, NULL},
        {"UuidFromStringW",0x00031413	, NULL, NULL},
        {"UuidHash",0x0004F124, NULL	, NULL},
        {"UuidIsNil",0x0004F149, NULL, NULL},
        {"UuidToStringA",0x0004BF4A,	NULL,	 NULL},
        {"UuidToStringW",0x000279C6, NULL, NULL},
       	{0, 0, NULL, NULL},
};

// Added by T.OkamotoLab.
struct emu_env_w32_dll_export secur32_exports[]=
{
        {"char_array_from_ndr",	0x00175369,	 NULL,	 NULL},
        {"char_from_ndr",	0x0017A7C0,	 NULL,	 NULL},
        {"CheckVerificationTrailer",	0x00173113,	 NULL,	 NULL},	
        {"CreateProxyFromTypeInfo"	,0x0017A2DF	, NULL,	 NULL},
        {"CreateStubFromTypeInfo",	0x0017A28A,	 NULL	, NULL},
        {"CStdStubBuffer_AddRef"	,0x00178BC4,	 NULL	,	 NULL},
        {"CStdStubBuffer_Connect"	,0x00178B85,	 NULL	, NULL},
        {"CStdStubBuffer_CountRefs"	,0x0017A334,	 NULL	, NULL},
        {"CStdStubBuffer_DebugServerQueryInterfa"	,0x0017A3C8,	 NULL	, NULL},
        {"CStdStubBuffer_DebugServerRelease",	0x00171EFA,	NULL	,NULL},
        {"CStdStubBuffer_Disconnect"	,0x0017852C,	 NULL, NULL},
        {"CStdStubBuffer_Invoke"	,0x00172D1D	, NULL		,NULL},
        {"CStdStubBuffer_IsIIDSupported",	0x00178C1C,	 NULL	,	 NULL},
        {"CStdStubBuffer_QueryInterface"	,0x0017A37B		, NULL	,	 NULL},
        {"data_from_ndr"	,0x00172A26,	NULL,	 NULL},
        {"data_into_ndr"	,0x0017A66D,	 NULL	, NULL},
        {"data_size_ndr"	,0x0017288E	, NULL	, NULL},
        {"DceErrorInqTextA"	,0x00172BA1,	 NULL	, NULL},
        {"DceErrorInqTextW"	,0x0017C07A	, NULL	, NULL},
        {"DllGetClassObject"	,0x0017BEA8	, NULL	 ,NULL},
        {"DllRegisterServer",	0x00178ABF	, NULL	 ,NULL},
        {"double_array_from_ndr",	0x00171DD4,	 NULL	, NULL},
        {"double_from_ndr"	,0x00171C7A	, NULL	, NULL},
        {"enum_from_ndr"	,0x00175537,		 NULL	,	 NULL},
        {"float_array_from_ndr",	0x0017A745,	 NULL,	 NULL},
        {"float_from_ndr"	,0x0017A6CA	, NULL	,NULL},
        {"GlobalMutexClearExternal",	0x0017A7F0	, NULL	, NULL},
        {"GlobalMutexRequestExternal"	,0x00175BEA,	 NULL	,	NULL},
        {"IUnknown_AddRef_Proxy"	,0x0017396D,	 NULL	, NULL},
        {"IUnknown_QueryInterface_Proxy",	0x00172883,	 NULL,	 NULL},
        {"IUnknown_Release_Proxy",	0x00172193,	 NULL	, NULL},
        {"I_RpcAllocate"	,0x00174EAB	, NULL,	 NULL},
        {"I_RpcAsyncAbortCall",	0x00177C5D	, NULL	, NULL},
        {"I_RpcAsyncSetHandle",	0x0017A1F3	,	NULL	,	 NULL},
        {"I_RpcBCacheAllocate"	,0x0017216B	, NULL	, NULL},
        {"I_RpcBCacheFree"	,0x0017A212		, NULL	,	 NULL},
        {"I_RpcBindingCopy"	,0x001733E8	, NULL,	 NULL},
        {"I_RpcBindingHandleToAsyncHandle",	0x00174BB2	, NULL	, NULL}	,
        {"I_RpcBindingInqConnId"	,0x00174D27	, NULL,	 NULL},
        {"I_RpcBindingInqDynamicEndpointA"	,0x00174AD5	, NULL,	 NULL}	,
        {"I_RpcBindingInqDynamicEndpointW"	,0x0017A1CB,	 NULL	, NULL},
        {"I_RpcBindingInqLocalClientPID"	,0x001732E7	, NULL	, NULL},
        {"I_RpcBindingInqSecurityContext"	,0x0017A467	, NULL	 ,NULL},
        {"I_RpcBindingInqTransportType"	,0x00175457		, NULL		, NULL},
        {"I_RpcBindingInqWireIdForSnego",	0x0017A575,	 NULL,	 NULL},
        {"I_RpcBindingIsClientLocal",	0x001734D8,	 NULL,	 NULL},
        {"I_RpcBindingToStaticStringBindingW",	0x0017A40F,		 NULL,		 NULL},
        {"I_RpcClearMutex"	,0x0017A3A9	, NULL,	 NULL},
        {"I_RpcConnectionInqSockBuffSize"	,0x00173875,	 NULL	, NULL},
        {"I_RpcConnectionSetSockBuffSize"	,0x0017557B	, NULL,	 NULL},
        {"I_RpcDeleteMutex"	,0x0017B4CC,	 NULL,	 NULL},
        {"I_RpcEnableWmiTrace",	0x0017ADCC,	 NULL	,	 NULL},
        {"I_RpcExceptionFilter",	0x0017ADDC	, NULL	, NULL},
        {"I_RpcFree",	0x0017ADEC,	 NULL		, NULL},
        {"I_RpcFreeBuffer",	0x0017AE18,	 NULL	,	 NULL},
        {"I_RpcFreePipeBuffer"	,0x0017B113,	NULL	, NULL},
        {"I_RpcGetBuffer"	,0x0017B141,	 NULL	, NULL},
        {"I_RpcGetBufferWithObject",	0x0017B3C3,	 NULL,	 NULL},
        {"I_RpcGetCurrentCallHandle",	0x0017B2BA,	 NULL	,NULL},
        {"I_RpcGetExtendedError"	,0x0017A5CF	, NULL,	 NULL},
        {"I_RpcIfInqTransferSyntaxes"	,0x00175F6B	, NULL	, NULL},
        {"I_RpcLogEvent"	,0x00179FA8,	 NULL,	 NULL},
        {"I_RpcMapWin32Status",	0x00178ACF,	 NULL	, NULL},
        {"I_RpcNegotiateTransferSyntax"	,0x00179F5B	,	 NULL	,	 NULL},
        {"I_RpcNsBindingSetEntryNameA"	,	0x0017B75B,	 NULL	, NULL},
        {"I_RpcNsBindingSetEntryNameW",	0x0017BB39	, NULL	, NULL},
        {"I_RpcNsInterfaceExported"	,0x0017BAE2	, NULL	, NULL},
        {"I_RpcNsInterfaceUnexported"	,0x0017A513	, NULL	, NULL},
        {"I_RpcParseSecurity"	,0x0017A4B1,	 NULL	 ,NULL},
        {"I_RpcPauseExecution",	0x0017C12C	, NULL,	 NULL},
        {"I_RpcProxyNewConnection"	,0x0017C03F,	 NULL	, NULL},
        {"I_RpcReallocPipeBuffer"	,0x0017A61E,	 NULL,	 NULL},
        {"I_RpcReceive"	,0x0017339B	, NULL,	 NULL},
       	{0, 0, NULL, NULL},
};

// Added by T.OkamotoLab.
struct emu_env_w32_dll_export ws2help_exports[]=
{
        {"WahReferenceContextByHandle",0x000014A0, NULL, NULL},
        {"WahCloseThread",0x00001523, NULL, NULL},
        {"WahOpenCurrentThread",0x0000157D, NULL, NULL},	
        {"WahInsertHandleContext",0x00001704, NULL, NULL},
        {"WahRemoveHandleContext",0x000018C0, NULL, NULL},
        {"WahCreateHandleContextTable",0x00001950, NULL	, NULL},
        {"WahOpenApcHelper",0x00001A23, NULL, NULL},
        {"WahOpenNotificationHandleHelper",0x00001BF7, NULL, NULL},
        {"WahWaitForNotification",0x00001CF7,NULL,NULL},
        {"WahCreateNotificationHandle",0x00002093, NULL, NULL},
        {"WahEnumerateHandleContexts",0x000022C9, NULL,NULL},
        {"WahCloseApcHelper",0x0000235B, NULL, NULL},
        {"WahQueueUserApc",0x00002A95, NULL, NULL},
        {"WahCloseHandleHelper",0x000030A5,NULL, NULL},
        {"WahCreateSocketHandle",0x000030EA, NULL, NULL},
        {"WahCloseSocketHandle",0x00003269, NULL, NULL},
        {"WahCompleteRequest",0x000032B8, NULL, NULL},
        {"WahEnableNonIFSHandleSupport",0x00003343, NULL, NULL},
        {"WahDisableNonIFSHandleSupport",0x00003541, NULL ,NULL},
        {"WahOpenHandleHelper",	0x0000385B, NULL ,NULL},
        {"WahDestroyHandleContextTable",0x00003C62, NULL, NULL},
        {"WahCloseNotificationHandleHelper",0x00003CAF, NULL, NULL},
        {"WahNotifyAllProcesses",0x00003CDE, NULL, NULL},
       	{0, 0, NULL, NULL},
};
