/********************************************************************************
 *                               libemu
 *
 *                    - x86 shellcode emulation -
 *
 *
 * Copyright (C) 2007  Paul Baecher & Markus Koetter
 *
 * This file is written by T.OkamotoLab.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * 
 *             contact take4@nw.kanagawa-it.ac.jp
 *
 *******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include "../../../config.h"
#include "emu/emu.h"
#include "emu/emu_log.h"
#include "emu/emu_memory.h"
#include "emu/emu_cpu.h"
#include "emu/emu_cpu_data.h"
#include "emu/emu_cpu_stack.h"
#include "emu/emu_hashtable.h"
#include "emu/emu_string.h"
#include "emu/environment/emu_env.h"
#include "emu/environment/emu_profile.h"
#include "emu/environment/win32/emu_env_w32.h"
#include "emu/environment/win32/emu_env_w32_dll.h"
#include "emu/environment/win32/emu_env_w32_dll_export.h"
#include "emu/environment/win32/env_w32_dll_export_advapi32_hooks.h"

int32_t	env_w32_hook_RegOpenKeyA(struct emu_env *env, struct emu_env_hook *hook)
{
	struct emu_cpu *c = emu_cpu_get(env->emu);

	uint32_t eip_save;

	POP_DWORD(c, &eip_save);

/*
LONG WINAPI RegOpenKey(
  __in      HKEY hKey,
  __in_opt  LPCTSTR lpSubKey,
  __out     PHKEY phkResult
);
*/
	
	uint32_t hkey;
	POP_DWORD(c, &hkey);

	uint32_t p_subkey;
	POP_DWORD(c, &p_subkey);

	uint32_t phkresult;
	POP_DWORD(c, &phkresult);

	uint32_t returnvalue=0;

	if (env->profile != NULL)
	{
		emu_profile_function_add(env->profile, "RegOpenKeyA");
		emu_profile_argument_add_int(env->profile, "HKEY", "hkey", hkey);
		emu_profile_argument_add_ptr(env->profile, "LPCTSTR", "lpsubkey", p_subkey);
		emu_profile_argument_add_none(env->profile);
		emu_profile_argument_add_int(env->profile, "PHKEY", "phkResult", phkresult);
		emu_profile_function_returnvalue_int_set(env->profile, "LONG", returnvalue);
	}
	
	emu_cpu_reg32_set(c, eax, returnvalue);

	emu_cpu_eip_set(c, eip_save);
	return 0;
}

int32_t	env_w32_hook_RegSetValueExA(struct emu_env *env, struct emu_env_hook *hook)
{
	struct emu_cpu *c = emu_cpu_get(env->emu);

	uint32_t eip_save;

	POP_DWORD(c, &eip_save);

/*
LONG RegSetValueExA(
    HKEY    hKey,
    PCTSTR  pValueName,
    DWORD   Reserved,
    DWORD   dwType,
    CONST BYTE *pData,
    DWORD   cbData
);
*/
	
	uint32_t hkey;
	POP_DWORD(c, &hkey);

	uint32_t p_valuename;
	POP_DWORD(c, &p_valuename);

	uint32_t reserved;
	POP_DWORD(c, &reserved);

	uint32_t dwtype;
	POP_DWORD(c, &dwtype);

	uint32_t p_data;
	POP_DWORD(c, &p_data);

	uint32_t cbdata;
	POP_DWORD(c, &cbdata);

	uint32_t returnvalue=0;

	if (env->profile != NULL)
	{
		emu_profile_function_add(env->profile, "RegSetValueExA");
		emu_profile_argument_add_int(env->profile, "HKEY", "hkey", hkey);
		emu_profile_argument_add_ptr(env->profile, "PCTSTR", "pValueName", p_valuename);
		emu_profile_argument_add_none(env->profile);
		emu_profile_argument_add_int(env->profile, "DWORD", "Reserved", reserved);
		emu_profile_argument_add_int(env->profile, "DWORD", "dwType", dwtype);
		emu_profile_argument_add_ptr(env->profile, "CONST BYTE", "*pData", p_data);
		emu_profile_argument_add_none(env->profile);
		emu_profile_argument_add_int(env->profile, "DWORD", "cbData", cbdata);
		emu_profile_function_returnvalue_int_set(env->profile, "LONG", returnvalue);
	}
	
	emu_cpu_reg32_set(c, eax, returnvalue);

	emu_cpu_eip_set(c, eip_save);
	return 0;
}

