/********************************************************************************
 *                               libemu
 *
 *                    - x86 shellcode emulation -
 *
 *
 * Copyright (C) 2007  Paul Baecher & Markus Koetter
 *
 * This file is written by T.OkamotoLab.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * 
 *             contact take4@nw.kanagawa-it.ac.jp
 *
 *******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include "../../../config.h"
#include "emu/emu.h"
#include "emu/emu_log.h"
#include "emu/emu_memory.h"
#include "emu/emu_cpu.h"
#include "emu/emu_cpu_data.h"
#include "emu/emu_cpu_stack.h"
#include "emu/emu_hashtable.h"
#include "emu/emu_string.h"
#include "emu/environment/emu_env.h"
#include "emu/environment/emu_profile.h"
#include "emu/environment/win32/emu_env_w32.h"
#include "emu/environment/win32/emu_env_w32_dll.h"
#include "emu/environment/win32/emu_env_w32_dll_export.h"
#include "emu/environment/win32/env_w32_dll_export_hnetcfg_hooks.h"

int32_t	env_w32_hook_fake1(struct emu_env *env, struct emu_env_hook *hook)
{
	//printf("fake1 - call 0x607EB7AE(hnetcfg.dll)\n");

	struct emu_cpu *c = emu_cpu_get(env->emu);
	struct emu_memory *m = emu_memory_get(env->emu);

	uint32_t eip_save;

	POP_DWORD(c, &eip_save);

	uint32_t parameter1;
	POP_DWORD(c, &parameter1);

	uint32_t parameter2;
	POP_DWORD(c, &parameter2);

	uint32_t returnvalue=0;

	if (env->profile != NULL)
	{
		emu_profile_function_add(env->profile, "fake1");
		emu_profile_argument_add_ptr(env->profile, "PVOID", "parameter1", parameter1);
		emu_profile_argument_add_none(env->profile);
		emu_profile_argument_add_ptr(env->profile, "PVOID", "parameter2", parameter2);
		emu_profile_argument_add_none(env->profile);
		emu_profile_function_returnvalue_int_set(env->profile, "INT", returnvalue);
	}
	
	emu_memory_write_dword(m, parameter2, 0x003E6D40);

	emu_cpu_reg32_set(c, eax, returnvalue);

	emu_cpu_eip_set(c, eip_save);
	return 0;
}

int32_t	env_w32_hook_fake2(struct emu_env *env, struct emu_env_hook *hook)
{
	//printf("fake2 - call 0x607F2E61(hnetcfg.dll)\n");

	struct emu_cpu *c = emu_cpu_get(env->emu);
	struct emu_memory *m = emu_memory_get(env->emu);

	uint32_t eip_save;

	POP_DWORD(c, &eip_save);

	uint32_t parameter1;
	POP_DWORD(c, &parameter1);

	uint32_t parameter2;
	POP_DWORD(c, &parameter2);

	uint32_t returnvalue=0;

	if (env->profile != NULL)
	{
		emu_profile_function_add(env->profile, "fake2");
		emu_profile_argument_add_ptr(env->profile, "PVOID", "parameter1", parameter1);
		emu_profile_argument_add_none(env->profile);
		emu_profile_argument_add_ptr(env->profile, "PVOID", "parameter2", parameter2);
		emu_profile_argument_add_none(env->profile);
		emu_profile_function_returnvalue_int_set(env->profile, "INT", returnvalue);
	}
	
	emu_memory_write_dword(m, parameter2, 0x003E6E90);

	emu_cpu_reg32_set(c, eax, returnvalue);

	emu_cpu_eip_set(c, eip_save);
	return 0;
}

int32_t	env_w32_hook_fake3(struct emu_env *env, struct emu_env_hook *hook)
{
	//printf("fake3 - call 0x607F493E(hnetcfg.dll)\n");

	struct emu_cpu *c = emu_cpu_get(env->emu);

	uint32_t eip_save;

	POP_DWORD(c, &eip_save);

	uint32_t parameter1;
	POP_DWORD(c, &parameter1);

	uint32_t returnvalue=0;

	if (env->profile != NULL)
	{
		emu_profile_function_add(env->profile, "fake3");
		emu_profile_argument_add_ptr(env->profile, "PVOID", "parameter1", parameter1);
		emu_profile_argument_add_none(env->profile);
		emu_profile_function_returnvalue_int_set(env->profile, "INT", returnvalue);
	}
	
	emu_cpu_reg32_set(c, eax, returnvalue);

	emu_cpu_eip_set(c, eip_save);
	return 0;
}
