/********************************************************************************
 *                               libemu
 *
 *                    - x86 shellcode emulation -
 *
 *
 * Copyright (C) 2007  Paul Baecher & Markus Koetter
 *
 * This file is written by T.OkamotoLab.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * 
 *             contact take4@nw.kanagawa-it.ac.jp
 *
 *******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include "../../../config.h"
#include "emu/emu.h"
#include "emu/emu_log.h"
#include "emu/emu_memory.h"
#include "emu/emu_cpu.h"
#include "emu/emu_cpu_data.h"
#include "emu/emu_cpu_stack.h"
#include "emu/emu_hashtable.h"
#include "emu/emu_string.h"
#include "emu/environment/emu_env.h"
#include "emu/environment/emu_profile.h"
#include "emu/environment/win32/emu_env_w32.h"
#include "emu/environment/win32/emu_env_w32_dll.h"
#include "emu/environment/win32/emu_env_w32_dll_export.h"
#include "emu/environment/win32/env_w32_dll_export_ole32_hooks.h"

int32_t	env_w32_hook_CoInitialize(struct emu_env *env, struct emu_env_hook *hook)
{
	struct emu_cpu *c = emu_cpu_get(env->emu);

	uint32_t eip_save;

	POP_DWORD(c, &eip_save);

/*
HRESULT CoInitializeEx(
  __in_opt  LPVOID pvReserved,
  __in      DWORD dwCoInit
);
*/
	
	uint32_t p_reserved;
	POP_DWORD(c, &p_reserved);

	uint32_t returnvalue=0;

	if (env->profile != NULL)
	{
		emu_profile_function_add(env->profile, "CoInitialize");
		emu_profile_argument_add_ptr(env->profile, "LPVOID", "pvReserved", p_reserved);
		emu_profile_argument_add_none(env->profile);
		emu_profile_function_returnvalue_int_set(env->profile, "LONG", returnvalue);
	}
	
	emu_cpu_reg32_set(c, eax, returnvalue);

	emu_cpu_eip_set(c, eip_save);
	return 0;
}

int32_t	env_w32_hook_CoInitializeEx(struct emu_env *env, struct emu_env_hook *hook)
{
	struct emu_cpu *c = emu_cpu_get(env->emu);

	uint32_t eip_save;

	POP_DWORD(c, &eip_save);

/*
HRESULT CoInitializeEx(
  __in_opt  LPVOID pvReserved,
  __in      DWORD dwCoInit
);
*/
	
	uint32_t p_reserved;
	POP_DWORD(c, &p_reserved);

	uint32_t dwcoinit;
	POP_DWORD(c, &dwcoinit);

	uint32_t returnvalue=0;

	if (env->profile != NULL)
	{
		emu_profile_function_add(env->profile, "CoInitializeEx");
		emu_profile_argument_add_ptr(env->profile, "LPVOID", "pvReserved", p_reserved);
		emu_profile_argument_add_none(env->profile);
		emu_profile_argument_add_int(env->profile, "DWORD", "dwCoInit", dwcoinit);
		emu_profile_function_returnvalue_int_set(env->profile, "LONG", returnvalue);
	}
	
	emu_cpu_reg32_set(c, eax, returnvalue);

	emu_cpu_eip_set(c, eip_save);
	return 0;
}

int32_t	env_w32_hook_CoCreateInstance(struct emu_env *env, struct emu_env_hook *hook)
{
	struct emu_cpu *c = emu_cpu_get(env->emu);
	struct emu_memory *m = emu_memory_get(env->emu);

	uint32_t eip_save;

	POP_DWORD(c, &eip_save);


//STDAPI CoCreateInstance(
//    REFCLSID  rclsid,
//    LPUNKNOWN pUnkOuter
//    DWORD   dwClsContext,
//    REFIID  riid,
//    PVOID   *ppv
//);
	
	uint32_t rclsid;
	POP_DWORD(c, &rclsid);

	uint32_t punkouter;
	POP_DWORD(c, &punkouter);

	uint32_t dwclscontext;
	POP_DWORD(c, &dwclscontext);

	uint32_t riid;
	POP_DWORD(c, &riid);

	uint32_t p_ppv;
	POP_DWORD(c, &p_ppv);

	uint32_t returnvalue=0;

	if (env->profile != NULL)
	{
		emu_profile_function_add(env->profile, "CoCreateInstance");
		emu_profile_argument_add_ptr(env->profile, "DREFCLSID", "rclsid", rclsid);
		emu_profile_argument_add_none(env->profile);
		emu_profile_argument_add_int(env->profile, "LPUNKNOWN", "pUnkOuter", punkouter);
		emu_profile_argument_add_int(env->profile, "DWORD", "dwClsContext", dwclscontext);
		emu_profile_argument_add_ptr(env->profile, "REFIID", "riid", riid);
		emu_profile_argument_add_none(env->profile);
		emu_profile_argument_add_ptr(env->profile, "PVOID", "*ppv", p_ppv);
		emu_profile_argument_add_none(env->profile);
		emu_profile_function_returnvalue_int_set(env->profile, "LONG", returnvalue);
	}

	emu_memory_write_dword(m, p_ppv, 0x003E3DC8);
	emu_env_w32_load_dll(env->env.win,"hnetcfg.dll");

	emu_cpu_reg32_set(c, eax, returnvalue);

	emu_cpu_eip_set(c, eip_save);
	return 0;
}
