/********************************************************************************
 *                               libemu
 *
 *                    - x86 shellcode emulation -
 *
 *
 * Copyright (C) 2007  Paul Baecher & Markus Koetter
 *
 * This file is written by T.OkamotoLab.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * 
 *             contact take4@nw.kanagawa-it.ac.jp
 *
 *******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include "../../../config.h"
#include "emu/emu.h"
#include "emu/emu_log.h"
#include "emu/emu_memory.h"
#include "emu/emu_cpu.h"
#include "emu/emu_cpu_data.h"
#include "emu/emu_cpu_stack.h"
#include "emu/emu_hashtable.h"
#include "emu/emu_string.h"
#include "emu/environment/emu_env.h"
#include "emu/environment/emu_profile.h"
#include "emu/environment/win32/emu_env_w32.h"
#include "emu/environment/win32/emu_env_w32_dll.h"
#include "emu/environment/win32/emu_env_w32_dll_export.h"
#include "emu/environment/win32/env_w32_dll_export_user32_hooks.h"

int32_t	env_hook_MessageBoxA(struct emu_env *env, struct emu_env_hook *hook)
{
    
    //logDebug(env->emu, "Hook me Captain Cook!\n");
    //logDebug(env->emu, "%s:%i %s\n",__FILE__,__LINE__,__FUNCTION__);

    struct emu_cpu *c = emu_cpu_get(env->emu);

    uint32_t eip_save;

    POP_DWORD(c, &eip_save);
    
//   
//   int MessageBoxA(
//    HWND hWnd,
//    LPCTSTR lpText,
//    LPCTSTR lpCaption,
//    UINT uType
//    );
//   
    
    uint32_t hWnd;
    POP_DWORD(c,&hWnd);
    
    uint32_t Text;
    POP_DWORD(c, &Text);
    
    uint32_t Caption;
    POP_DWORD(c, &Caption);
    
    uint32_t uType;
    POP_DWORD(c, &uType);
    
    if (env->profile != NULL)
    {
	emu_profile_function_add(env->profile, "MessageBoxA");
        emu_profile_argument_add_string(env->profile,"HWND","hWnd",NULL);
	emu_profile_argument_add_ptr(env->profile, "LPCTSTR", "lpText", Text);
        emu_profile_argument_add_ptr(env->profile, "LPCTSTR", "lpCaption", Caption);
        emu_profile_argument_add_string(env->profile, "UINT", "uType", NULL);
        emu_profile_function_returnvalue_ptr_set(env->profile, "int WINAPI", 0x0);
    }
    emu_cpu_eip_set(c, eip_save);
    return 0;
}
